/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.transport;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.notifications.core.client.DestinationClientPool;
import org.opensearch.notifications.core.client.DestinationSnsClient;
import org.opensearch.notifications.core.transport.DestinationTransport;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.OpenForTesting;
import org.opensearch.notifications.spi.model.DestinationMessageResponse;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.SnsDestination;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/notifications/core/transport/SnsDestinationTransport;", "Lorg/opensearch/notifications/core/transport/DestinationTransport;", "Lorg/opensearch/notifications/spi/model/destination/SnsDestination;", "<init>", "()V", "destinationSnsClient", "Lorg/opensearch/notifications/core/client/DestinationSnsClient;", "(Lorg/opensearch/notifications/core/client/DestinationSnsClient;)V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "destinationSNSClient", "sendMessage", "Lorg/opensearch/notifications/spi/model/DestinationMessageResponse;", "destination", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "referenceId", "", "opensearch-notifications-core"})
public final class SnsDestinationTransport
implements DestinationTransport<SnsDestination> {
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final DestinationSnsClient destinationSNSClient;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public SnsDestinationTransport() {
        this.log$delegate = HelpersKt.logger(SnsDestinationTransport.class);
        this.destinationSNSClient = DestinationClientPool.INSTANCE.getSnsClient();
    }

    @OpenForTesting
    public SnsDestinationTransport(@NotNull DestinationSnsClient destinationSnsClient) {
        Intrinsics.checkNotNullParameter((Object)destinationSnsClient, (String)"destinationSnsClient");
        this.log$delegate = HelpersKt.logger(SnsDestinationTransport.class);
        this.destinationSNSClient = destinationSnsClient;
    }

    @Override
    @NotNull
    public DestinationMessageResponse sendMessage(@NotNull SnsDestination destination, @NotNull MessageContent message, @NotNull String referenceId) {
        DestinationMessageResponse destinationMessageResponse;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        try {
            destinationMessageResponse = this.destinationSNSClient.execute(destination, message, referenceId);
        }
        catch (IOException exception) {
            this.getLog().error("Exception sending message id " + referenceId, (Throwable)exception);
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Failed to send SNS message " + exception.getMessage());
        }
        return destinationMessageResponse;
    }
}

