/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateRandomResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GenerateRandomResponse> {
    private static final SdkField<SdkBytes> PLAINTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Plaintext").getter(GenerateRandomResponse.getter(GenerateRandomResponse::plaintext)).setter(GenerateRandomResponse.setter(Builder::plaintext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Plaintext").build()}).build();
    private static final SdkField<SdkBytes> CIPHERTEXT_FOR_RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CiphertextForRecipient").getter(GenerateRandomResponse.getter(GenerateRandomResponse::ciphertextForRecipient)).setter(GenerateRandomResponse.setter(Builder::ciphertextForRecipient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CiphertextForRecipient").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAINTEXT_FIELD, CIPHERTEXT_FOR_RECIPIENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateRandomResponse.memberNameToFieldInitializer();
    private final SdkBytes plaintext;
    private final SdkBytes ciphertextForRecipient;

    private GenerateRandomResponse(BuilderImpl builder) {
        super(builder);
        this.plaintext = builder.plaintext;
        this.ciphertextForRecipient = builder.ciphertextForRecipient;
    }

    public final SdkBytes plaintext() {
        return this.plaintext;
    }

    public final SdkBytes ciphertextForRecipient() {
        return this.ciphertextForRecipient;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.plaintext());
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextForRecipient());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRandomResponse)) {
            return false;
        }
        GenerateRandomResponse other = (GenerateRandomResponse)((Object)obj);
        return Objects.equals(this.plaintext(), other.plaintext()) && Objects.equals(this.ciphertextForRecipient(), other.ciphertextForRecipient());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateRandomResponse").add("Plaintext", (Object)(this.plaintext() == null ? null : "*** Sensitive Data Redacted ***")).add("CiphertextForRecipient", (Object)this.ciphertextForRecipient()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Plaintext": {
                return Optional.ofNullable(clazz.cast(this.plaintext()));
            }
            case "CiphertextForRecipient": {
                return Optional.ofNullable(clazz.cast(this.ciphertextForRecipient()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkBytes>> map = new HashMap<String, SdkField<SdkBytes>>();
        map.put("Plaintext", PLAINTEXT_FIELD);
        map.put("CiphertextForRecipient", CIPHERTEXT_FOR_RECIPIENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateRandomResponse, T> g) {
        return obj -> g.apply((GenerateRandomResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private SdkBytes plaintext;
        private SdkBytes ciphertextForRecipient;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRandomResponse model) {
            super(model);
            this.plaintext(model.plaintext);
            this.ciphertextForRecipient(model.ciphertextForRecipient);
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext == null ? null : this.plaintext.asByteBuffer();
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext(plaintext == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)plaintext));
        }

        @Override
        public final Builder plaintext(SdkBytes plaintext) {
            this.plaintext = plaintext;
            return this;
        }

        public final ByteBuffer getCiphertextForRecipient() {
            return this.ciphertextForRecipient == null ? null : this.ciphertextForRecipient.asByteBuffer();
        }

        public final void setCiphertextForRecipient(ByteBuffer ciphertextForRecipient) {
            this.ciphertextForRecipient(ciphertextForRecipient == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextForRecipient));
        }

        @Override
        public final Builder ciphertextForRecipient(SdkBytes ciphertextForRecipient) {
            this.ciphertextForRecipient = ciphertextForRecipient;
            return this;
        }

        @Override
        public GenerateRandomResponse build() {
            return new GenerateRandomResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateRandomResponse> {
        public Builder plaintext(SdkBytes var1);

        public Builder ciphertextForRecipient(SdkBytes var1);
    }
}

