/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.application.ActionsKt;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.ui.LearningUiHighlightingManager;
import training.ui.RepaintHighlighting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\u0013\u001a\u00020\u0014J,\u0010\u0015\u001a\u00020\u00112\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000eJ(\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u000eJO\u0010\u001f\u001a\u00020\u0011\"\b\b\u0000\u0010 *\u00020\t2\u0006\u0010!\u001a\u0002H 2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0010\b\u0002\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u0002H \u0012\u0006\u0012\u0004\u0018\u00010%0$\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020\u0011J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0010\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000eH\u0002J\u0019\u0010+\u001a\u00020\u00112\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0000\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010\u0012\u001a\u00020\tR\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR+\u0010\f\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e0\r0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u00060"}, d2={"Ltraining/ui/LearningUiHighlightingManager;", "", "<init>", "()V", "highlights", "", "Ltraining/ui/RepaintHighlighting;", "highlightingComponents", "", "Ljava/awt/Component;", "getHighlightingComponents", "()Ljava/util/List;", "highlightingComponentsWithInfo", "Lkotlin/Pair;", "Lkotlin/Function0;", "getHighlightingComponentsWithInfo", "highlightComponent", "", "original", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "highlightJListItem", "list", "Ljavax/swing/JList;", "index", "", "highlightJTreeItem", "tree", "Ljavax/swing/JTree;", "path", "Ljavax/swing/tree/TreePath;", "highlightPartOfComponent", "T", "component", "partInfo", "rectangle", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "clearHighlights", "clearPreviousHighlights", "", "init", "removeIt", "core", "removeIt$intellij_featuresTrainer", "getRectangle", "HighlightingOptions", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLearningUiHighlightingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LearningUiHighlightingManager.kt\ntraining/ui/LearningUiHighlightingManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1563#2:253\n1634#2,3:254\n1563#2:257\n1634#2,3:258\n1#3:261\n*S KotlinDebug\n*F\n+ 1 LearningUiHighlightingManager.kt\ntraining/ui/LearningUiHighlightingManager\n*L\n37#1:253\n37#1:254,3\n39#1:257\n39#1:258,3\n*E\n"})
public final class LearningUiHighlightingManager {
    @NotNull
    public static final LearningUiHighlightingManager INSTANCE = new LearningUiHighlightingManager();
    @NotNull
    private static final List<RepaintHighlighting<?>> highlights = new ArrayList();

    private LearningUiHighlightingManager() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> getHighlightingComponents() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = highlights;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RepaintHighlighting repaintHighlighting = (RepaintHighlighting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOriginal());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Component, Function0<Object>>> getHighlightingComponentsWithInfo() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = highlights;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RepaintHighlighting repaintHighlighting = (RepaintHighlighting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getOriginal(), it.getPartInfo()));
        }
        return (List)destination$iv$iv;
    }

    public final void highlightComponent(@NotNull Component original, @NotNull HighlightingOptions options) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        LearningUiHighlightingManager.highlightPartOfComponent$default(this, original, options, null, LearningUiHighlightingManager::highlightComponent$lambda$0, 4, null);
    }

    public static /* synthetic */ void highlightComponent$default(LearningUiHighlightingManager learningUiHighlightingManager, Component component2, HighlightingOptions highlightingOptions, int n, Object object) {
        if ((n & 2) != 0) {
            highlightingOptions = new HighlightingOptions(false, false, false, false, false, false, 0, 127, null);
        }
        learningUiHighlightingManager.highlightComponent(component2, highlightingOptions);
    }

    public final void highlightJListItem(@NotNull JList<?> list, @NotNull HighlightingOptions options, @NotNull Function0<Integer> index) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(index, (String)"index");
        this.highlightPartOfComponent((Component)list, options, (Function0<? extends Object>)((Function0)() -> LearningUiHighlightingManager.highlightJListItem$lambda$0(index)), arg_0 -> LearningUiHighlightingManager.highlightJListItem$lambda$1(index, list, arg_0));
    }

    public static /* synthetic */ void highlightJListItem$default(LearningUiHighlightingManager learningUiHighlightingManager, JList jList, HighlightingOptions highlightingOptions, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            highlightingOptions = new HighlightingOptions(false, false, false, false, false, false, 0, 127, null);
        }
        learningUiHighlightingManager.highlightJListItem(jList, highlightingOptions, (Function0<Integer>)function0);
    }

    public final void highlightJTreeItem(@NotNull JTree tree, @NotNull HighlightingOptions options, @NotNull Function0<? extends TreePath> path) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        LearningUiHighlightingManager.highlightPartOfComponent$default(this, tree, options, null, arg_0 -> LearningUiHighlightingManager.highlightJTreeItem$lambda$0(path, tree, arg_0), 4, null);
    }

    public static /* synthetic */ void highlightJTreeItem$default(LearningUiHighlightingManager learningUiHighlightingManager, JTree jTree2, HighlightingOptions highlightingOptions, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            highlightingOptions = new HighlightingOptions(false, false, false, false, false, false, 0, 127, null);
        }
        learningUiHighlightingManager.highlightJTreeItem(jTree2, highlightingOptions, (Function0<? extends TreePath>)function0);
    }

    public final <T extends Component> void highlightPartOfComponent(@NotNull T component2, @NotNull HighlightingOptions options, @NotNull Function0<? extends Object> partInfo, @NotNull Function1<? super T, ? extends Rectangle> rectangle) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(partInfo, (String)"partInfo");
        Intrinsics.checkNotNullParameter(rectangle, (String)"rectangle");
        this.highlightComponent(component2, options.getClearPreviousHighlights(), () -> LearningUiHighlightingManager.highlightPartOfComponent$lambda$0(component2, options, partInfo, rectangle));
    }

    public static /* synthetic */ void highlightPartOfComponent$default(LearningUiHighlightingManager learningUiHighlightingManager, Component component2, HighlightingOptions highlightingOptions, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            highlightingOptions = new HighlightingOptions(false, false, false, false, false, false, 0, 127, null);
        }
        if ((n & 4) != 0) {
            function0 = highlightPartOfComponent.1.INSTANCE;
        }
        learningUiHighlightingManager.highlightPartOfComponent(component2, highlightingOptions, (Function0<? extends Object>)function0, function1);
    }

    public final void clearHighlights() {
        ActionsKt.runInEdt$default(null, LearningUiHighlightingManager::clearHighlights$lambda$0, (int)1, null);
    }

    private final void highlightComponent(Component original, boolean clearPreviousHighlights, Function0<? extends RepaintHighlighting<?>> init) {
        ActionsKt.runInEdt$default(null, () -> LearningUiHighlightingManager.highlightComponent$lambda$1(clearPreviousHighlights, original, init), (int)1, null);
    }

    public final void removeIt$intellij_featuresTrainer(@NotNull RepaintHighlighting<?> core) {
        Intrinsics.checkNotNullParameter(core, (String)"core");
        core.setRemoved(true);
        core.cleanup();
    }

    @Nullable
    public final Rectangle getRectangle(@NotNull Component original) {
        Function0<Rectangle> function0;
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Iterable iterable = highlights;
            for (Object t : iterable) {
                RepaintHighlighting it = (RepaintHighlighting)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getOriginal(), (Object)original)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return (function0 = (Function0<Rectangle>)v0) != null && (function0 = function0.getRectangle()) != null ? (Rectangle)function0.invoke() : null;
    }

    private static final Rectangle highlightComponent$lambda$0(Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Rectangle(new Point(0, 0), it.getSize());
    }

    private static final Object highlightJListItem$lambda$0(Function0 $index) {
        return $index.invoke();
    }

    private static final Rectangle highlightJListItem$lambda$1(Function0 $index, JList $list, JList it) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = (Integer)$index.invoke();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            rectangle = (0 <= it2 ? it2 < $list.getModel().getSize() : false) ? $list.getCellBounds(it2, it2) : null;
        } else {
            rectangle = null;
        }
        return rectangle;
    }

    private static final Rectangle highlightJTreeItem$lambda$0(Function0 $path, JTree $tree, JTree it) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TreePath treePath = (TreePath)$path.invoke();
        if (treePath != null) {
            TreePath it2 = treePath;
            boolean bl = false;
            rectangle = $tree.getPathBounds(it2);
        } else {
            rectangle = null;
        }
        return rectangle;
    }

    private static final RepaintHighlighting highlightPartOfComponent$lambda$0(Component $component, HighlightingOptions $options, Function0 $partInfo, Function1 $rectangle) {
        return new RepaintHighlighting<Component>($component, $options, (Function0<? extends Object>)$partInfo, (Function0<? extends Rectangle>)((Function0)() -> LearningUiHighlightingManager.highlightPartOfComponent$lambda$0$0($rectangle, $component, $options)));
    }

    private static final Rectangle highlightPartOfComponent$lambda$0$0(Function1 $rectangle, Component $component, HighlightingOptions $options) {
        Rectangle rectangle = (Rectangle)$rectangle.invoke((Object)$component);
        if (rectangle == null) {
            return null;
        }
        Rectangle rect = rectangle;
        if (!($component instanceof JComponent)) {
            return rect;
        }
        Rectangle intersection = ((JComponent)$component).getVisibleRect().intersection(rect);
        return intersection.isEmpty() ? null : (!$options.getLimitByVisibleRect() ? rect : intersection);
    }

    private static final Unit clearHighlights$lambda$0() {
        for (RepaintHighlighting<?> core : highlights) {
            INSTANCE.removeIt$intellij_featuresTrainer(core);
        }
        highlights.clear();
        return Unit.INSTANCE;
    }

    private static final Unit highlightComponent$lambda$1(boolean $clearPreviousHighlights, Component $original, Function0 $init) {
        if ($clearPreviousHighlights) {
            INSTANCE.clearHighlights();
        }
        if (!$original.isShowing()) {
            return Unit.INSTANCE;
        }
        RepaintHighlighting repaintByTimer = (RepaintHighlighting)$init.invoke();
        repaintByTimer.reinitHighlightComponent();
        repaintByTimer.initTimer();
        highlights.add(repaintByTimer);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "", "highlightBorder", "", "highlightInside", "usePulsation", "clearPreviousHighlights", "limitByVisibleRect", "isRoundedCorners", "thickness", "", "<init>", "(ZZZZZZI)V", "getHighlightBorder", "()Z", "getHighlightInside", "getUsePulsation", "getClearPreviousHighlights", "getLimitByVisibleRect", "getThickness", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    public static final class HighlightingOptions {
        private final boolean highlightBorder;
        private final boolean highlightInside;
        private final boolean usePulsation;
        private final boolean clearPreviousHighlights;
        private final boolean limitByVisibleRect;
        private final boolean isRoundedCorners;
        private final int thickness;

        public HighlightingOptions(boolean highlightBorder, boolean highlightInside, boolean usePulsation, boolean clearPreviousHighlights, boolean limitByVisibleRect, boolean isRoundedCorners, int thickness) {
            this.highlightBorder = highlightBorder;
            this.highlightInside = highlightInside;
            this.usePulsation = usePulsation;
            this.clearPreviousHighlights = clearPreviousHighlights;
            this.limitByVisibleRect = limitByVisibleRect;
            this.isRoundedCorners = isRoundedCorners;
            this.thickness = thickness;
        }

        public /* synthetic */ HighlightingOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = true;
            }
            if ((n2 & 4) != 0) {
                bl3 = false;
            }
            if ((n2 & 8) != 0) {
                bl4 = true;
            }
            if ((n2 & 0x10) != 0) {
                bl5 = true;
            }
            if ((n2 & 0x20) != 0) {
                bl6 = false;
            }
            if ((n2 & 0x40) != 0) {
                n = 1;
            }
            this(bl, bl2, bl3, bl4, bl5, bl6, n);
        }

        public final boolean getHighlightBorder() {
            return this.highlightBorder;
        }

        public final boolean getHighlightInside() {
            return this.highlightInside;
        }

        public final boolean getUsePulsation() {
            return this.usePulsation;
        }

        public final boolean getClearPreviousHighlights() {
            return this.clearPreviousHighlights;
        }

        public final boolean getLimitByVisibleRect() {
            return this.limitByVisibleRect;
        }

        public final boolean isRoundedCorners() {
            return this.isRoundedCorners;
        }

        public final int getThickness() {
            return this.thickness;
        }

        public final boolean component1() {
            return this.highlightBorder;
        }

        public final boolean component2() {
            return this.highlightInside;
        }

        public final boolean component3() {
            return this.usePulsation;
        }

        public final boolean component4() {
            return this.clearPreviousHighlights;
        }

        public final boolean component5() {
            return this.limitByVisibleRect;
        }

        public final boolean component6() {
            return this.isRoundedCorners;
        }

        public final int component7() {
            return this.thickness;
        }

        @NotNull
        public final HighlightingOptions copy(boolean highlightBorder, boolean highlightInside, boolean usePulsation, boolean clearPreviousHighlights, boolean limitByVisibleRect, boolean isRoundedCorners, int thickness) {
            return new HighlightingOptions(highlightBorder, highlightInside, usePulsation, clearPreviousHighlights, limitByVisibleRect, isRoundedCorners, thickness);
        }

        public static /* synthetic */ HighlightingOptions copy$default(HighlightingOptions highlightingOptions, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = highlightingOptions.highlightBorder;
            }
            if ((n2 & 2) != 0) {
                bl2 = highlightingOptions.highlightInside;
            }
            if ((n2 & 4) != 0) {
                bl3 = highlightingOptions.usePulsation;
            }
            if ((n2 & 8) != 0) {
                bl4 = highlightingOptions.clearPreviousHighlights;
            }
            if ((n2 & 0x10) != 0) {
                bl5 = highlightingOptions.limitByVisibleRect;
            }
            if ((n2 & 0x20) != 0) {
                bl6 = highlightingOptions.isRoundedCorners;
            }
            if ((n2 & 0x40) != 0) {
                n = highlightingOptions.thickness;
            }
            return highlightingOptions.copy(bl, bl2, bl3, bl4, bl5, bl6, n);
        }

        @NotNull
        public String toString() {
            return "HighlightingOptions(highlightBorder=" + this.highlightBorder + ", highlightInside=" + this.highlightInside + ", usePulsation=" + this.usePulsation + ", clearPreviousHighlights=" + this.clearPreviousHighlights + ", limitByVisibleRect=" + this.limitByVisibleRect + ", isRoundedCorners=" + this.isRoundedCorners + ", thickness=" + this.thickness + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.highlightBorder);
            result = result * 31 + Boolean.hashCode(this.highlightInside);
            result = result * 31 + Boolean.hashCode(this.usePulsation);
            result = result * 31 + Boolean.hashCode(this.clearPreviousHighlights);
            result = result * 31 + Boolean.hashCode(this.limitByVisibleRect);
            result = result * 31 + Boolean.hashCode(this.isRoundedCorners);
            result = result * 31 + Integer.hashCode(this.thickness);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HighlightingOptions)) {
                return false;
            }
            HighlightingOptions highlightingOptions = (HighlightingOptions)other;
            if (this.highlightBorder != highlightingOptions.highlightBorder) {
                return false;
            }
            if (this.highlightInside != highlightingOptions.highlightInside) {
                return false;
            }
            if (this.usePulsation != highlightingOptions.usePulsation) {
                return false;
            }
            if (this.clearPreviousHighlights != highlightingOptions.clearPreviousHighlights) {
                return false;
            }
            if (this.limitByVisibleRect != highlightingOptions.limitByVisibleRect) {
                return false;
            }
            if (this.isRoundedCorners != highlightingOptions.isRoundedCorners) {
                return false;
            }
            return this.thickness == highlightingOptions.thickness;
        }

        public HighlightingOptions() {
            this(false, false, false, false, false, false, 0, 127, null);
        }
    }
}

