/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.AdverbAdjectiveConfusion;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.util.CharUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.IntPredicate;

class ComparativeSuperlative {
    ComparativeSuperlative() {
    }

    static NodePattern pattern() {
        return NodePattern.or(ComparativeSuperlative.duplication(), ComparativeSuperlative.unnecessarySynthetic(), ComparativeSuperlative.confusion());
    }

    private static NodePattern duplication() {
        return NodePattern.N.form("more|most").directlyBefore(NodePattern.N.form("much|many").markAs("Next")).withNeighbor(2, NodePattern.N.pos("JJ")).and((moreMost, match) -> {
            boolean comparative = moreMost.hasForm("more");
            String maybeMuch = comparative ? "much " : "";
            Node adj = moreMost.neighbor(2);
            List<String> syntheticForms = ComparativeSuperlative.syntheticForms(moreMost, adj);
            if (!syntheticForms.isEmpty()) {
                for (String form : syntheticForms) {
                    match = match.withCorrector(NodeCorrector.replaceNodes(moreMost, adj, maybeMuch + form).join(comparative ? null : Articles.fixArticle(moreMost, form)));
                }
                return match;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(moreMost, moreMost.neighbor(1), maybeMuch + moreMost.form()));
        }).message("'$Next' is not used after '$_'");
    }

    private static NodePattern confusion() {
        return NodePattern.or(NodePattern.N.potentialPos("JJS"), NodePattern.N.potentialPos("JJ").noDependents("advmod|amod")).noPotentialPos("JJR|RBR").noForm("back|outside|inside|home|right|left|even").andOr(NodePattern.N.withHeadRelation("amod|advmod"), NodePattern.N.withHeadRelation("advcl").beforeHead(), NodePattern.ROOT.withDependent("cop")).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("way").directlyBeforeHead().withHead("advmod|obl:npmod", NodePattern.N.noForm("a?round")).noDependents().message("'$_' is normally followed by a comparative")), NodePattern.N.directlyBefore(NodePattern.N.form("than").andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("case"))).message("A comparative is normally used before '$_'"))).correct(NodeCorrector.inflect("JJ.*", "JJR")).onlyWithSuggestions();
    }

    private static NodePattern unnecessarySynthetic() {
        NodePattern adj = NodePattern.N.pos("JJ.*").noDependents("conj").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("than")).andOr(NodePattern.N.form("anything"), NodePattern.N.pos("JJ"))).andNot(NodePattern.N.withDependent("advmod", NodePattern.N).withDependent("cop", NodePattern.N.form("be|been"))).andNot(NodePattern.N.withHead("amod", NodePattern.N.pos("NNS"))).andNot(NodePattern.N.withHead("advmod", NodePattern.N.pos("JJ"))).andNot(NodePattern.N.withHead("amod|advmod", NodePattern.N.lemma("key|end|level|income|cost"))).noForm("upper|lower|prone|real|apt|true").andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.form("merrier|better").withDependent("det"));
        return NodePattern.N.form("more|less|most|least").includeIntoReport().withHead("advmod", CommonPatterns.skipUp("obl:npmod", adj.markAs("Adj"))).andOr(NodePattern.N.beforeHead().andNot(NodePattern.N.withNextSibling(NodePattern.N.beforeHead())), NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("Adj"))).andNot(NodePattern.N.form("more|less").directlyAfter(EnglishTreePatterns.number)).andOr(ComparativeSuperlative.moreBetter(), ComparativeSuperlative.moreOld());
    }

    private static NodePattern moreOld() {
        NodePattern excludeAfterCopulaLike = NodePattern.or(NodePattern.N.withHeadRelation("xcomp"), NodePattern.N.withDependent("cop")).noDependents("obl", NodePattern.N.afterHead().pos("NNS"));
        return NodePattern.N.form("more|most").directlyBeforeHead().noDependents("det").withHead(NodePattern.N.pos("JJ").includeIntoReport().andNot(NodePattern.N.withHead("amod", NodePattern.or(NodePattern.N.pos("NNS"), Semantics.possiblyUncountableLemma, NodePattern.N.withDependent("compound")))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("than").withHead(NodePattern.N.pos("JJ.*")))).andNot(NodePattern.N.withDependent("cop").and(Semantics.possiblyUncountableLemma)).andNot(NodePattern.N.withHead("xcomp", NodePattern.not(AdverbAdjectiveConfusion.adjRequiringVerbs).noDependents("i?obj")).trace("behave more rude"))).andNot(NodePattern.N.form("most").withHead(excludeAfterCopulaLike)).andNot(NodePattern.N.directlyAfter(NodePattern.N.pos("DT").withHeadRelation("fixed"))).and((moreMost, match) -> {
            Node adj = Objects.requireNonNull(moreMost.head());
            List<String> syntheticForms = ComparativeSuperlative.syntheticForms(moreMost, adj);
            if (!syntheticForms.isEmpty()) {
                for (String form : syntheticForms) {
                    match = match.withCorrector(NodeCorrector.replaceNodes(moreMost, adj, form).join(Articles.fixArticle(moreMost, form)));
                }
                String adjKind = moreMost.hasForm("more") ? "comparative" : "superlative";
                return match.withMessage("Did you mean the short " + adjKind + " form '" + syntheticForms.get(0) + "'?");
            }
            return null;
        });
    }

    private static List<String> syntheticForms(Node moreMost, Node adj) {
        return ComparativeSuperlative.hasSingleSyllable(adj.lowForm()) ? adj.tree().treeSupport().inflectNode(adj, "JJ", moreMost.hasForm("more") ? "JJR" : "JJS") : List.of();
    }

    static boolean hasSingleSyllable(String form) {
        IntPredicate isVowel = c -> CharUtil.isAnyOf("aeiouy", (char)c);
        IntPredicate isConsonant = isVowel.negate();
        long afterFirstSyllable = form.chars().dropWhile(isConsonant).dropWhile(isVowel).dropWhile(isConsonant).count();
        return afterFirstSyllable == 0L || afterFirstSyllable == 1L && form.endsWith("e") && !form.endsWith("le");
    }

    private static NodePattern moreBetter() {
        NodePattern withAdvmod = NodePattern.or(NodePattern.N.withDependent("advmod"), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("advmod")));
        return NodePattern.or(NodePattern.N.withHead(NodePattern.N.pos("JJ[RS]")), NodePattern.N.directlyAfter(NodePattern.N.pos("JJ[RS]"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("JJ"))).and((node, match) -> {
            Node head = Objects.requireNonNull(node.head());
            boolean comparative = head.hasPos("JJR");
            if (!head.hasPos("JJ[RS]")) {
                head = node.neighbor(-1);
                comparative = node.neighbor(-1).hasPos("JJR");
            }
            if (node.hasForm("more|most")) {
                NodeCorrector remove = NodeCorrector.replace(node, "");
                Node next = node.nextNode();
                if (next != null) {
                    remove = remove.join(Articles.fixArticle(node, next.form()));
                }
                match = match.withCorrector(remove);
            } else {
                match = match.withCorrector(NodeCorrector.inflect(head, "JJ.*", "JJ"));
            }
            if (comparative && !withAdvmod.matches(node) && node.isBefore(head)) {
                match = node.hasForm("more|most") ? match.withCorrector(NodeCorrector.replace(node, "much")) : match.withCorrector(NodeCorrector.replace(node, "little"));
            }
            String adjKind = comparative ? "comparative" : "superlative";
            return match.withMessage("'" + node.lowForm() + "' should not be used with a " + adjKind + " adjective");
        });
    }
}

