/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import java.util.List;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.en.EnglishTagger;

class GermanTreePatterns {
    static final NodePattern verbalClause = NodePattern.or(NodePattern.N.pos("VER.*").andOr(NodePattern.N.noPos("SUB.*(MAS|SIN|NEU)"), CommonPatterns.firstToken.withDependent("nsubj(:pass)?")), NodePattern.N.form("wei\u00df").withDependent("nsubj", NodePattern.N.pos(".*SIN.*")).noDependents("cop"));
    static final NodePattern clause = NodePattern.or(verbalClause, NodePattern.N.withDependent("cop|aux.*"));
    static final NodePattern dashes = NodePattern.N.form("[-\u2013\u2014]");
    static final NodePattern entsprechend = NodePattern.N.form("entsprechend");
    static final NodePattern germanLoanWord = NodePattern.N.form("verboten");
    static final NodePattern englishWord = NodePattern.custom(node -> {
        List readings = EnglishTagger.INSTANCE.tag(List.of(node.lowForm()));
        return readings.size() == 1 && ((AnalyzedTokenReadings)readings.get(0)).getReadings().stream().anyMatch(t -> t.getPOSTag() != null);
    }).andNot(germanLoanWord);
    static final NodePattern nonLatinLetterWord = NodePattern.N.form(".*[\\p{L}&&\\P{IsLatin}].*");
    static final NodePattern englishCompoundEmbeddingToHyphenate = NodePattern.N.withHeadRelation("obl|amod|root|nsubj.*").noPos("ADJ.*").withNeighbor(1, NodePattern.N.noSpaceAfter().markAs("Word2")).withNeighbor(2, CommonPatterns.HYPHEN_NODE.directlyBefore(NodePattern.N.pos("SUB.*"))).withNeighbor(3, NodePattern.not(NodePattern.N.withHead("flat", NodePattern.N.alreadyMarkedAs("Word2"))).noHeadRelation("i?obj|nsubj.*")).and(englishWord).and(NodePattern.markedNodeMatches("Word2", englishWord));
    static final NodePattern finiteVerb = NodePattern.or(NodePattern.N.pos("VER.*:[123].*").andOr(NodePattern.not(CommonPatterns.capitalized), NodePattern.N.noDependents("det|amod")), CommonPatterns.capitalized.andOr(NodePattern.N.noPos(), NodePattern.N.pos("EIG.*")).and(n -> n.tagIndependentlyLowForm().hasPos("VER.*:[123].*")));
    static final NodePattern grobVorstellung = GermanTreePatterns.lemmaAfterForm("Vorstellung", "grob");
    static final NodePattern freiTag = GermanTreePatterns.lemmaAfterForm("Tag", "frei");
    static final NodePattern grossRolle = GermanTreePatterns.lemmaAfterForm("Rolle", "gro\u00df");
    static final NodePattern positivProzess = GermanTreePatterns.lemmaAfterForm("Prozess", "positiv");
    static final NodePattern zuEnde = NodePattern.N.form("zuende").andOr(NodePattern.N.withDependent("cop"), NodePattern.N.withHead("mark", NodePattern.N));
    static final NodePattern misspelledFiniteVerb = NodePattern.N.pos("VER:IMP:SIN.*").and(GermanTreePatterns.hasSubject()).andNot(NodePattern.markedNodeMatches("Subj", NodePattern.N.form("ich").noDependents("conj")));
    static final NodePattern infinitive = NodePattern.N.pos("VER(:MOD)?:INF.*");
    static final NodePattern noPosNeutralAdj = NodePattern.N.form(".+es").noPos().and(CommonPatterns.lowercasedHasPos("ADJ.*")).noDependents();
    static final NodePattern possiblyProperName = NodePattern.or(NodePattern.N.label("PERSON").withDependent("compound", NodePattern.N.lemma("Herr|Frau")), NodePattern.N.withHeadRelation("flat:name"), CommonPatterns.possiblySkipDown("appos", NodePattern.N.withDependent("flat:name")), CommonPatterns.upperCase.withDependent("nummod"), englishWord.andOr(NodePattern.N.label(".*").withDependent("flat", englishWord.label(".*")), CommonPatterns.capitalizedMiddle.withDependent("compound", englishWord.and(CommonPatterns.capitalized)).andOr(NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("compound")), NodePattern.N.label(".*"))), NodePattern.N.label("PRODUCT").withDependent("appos", NodePattern.N.label("PRODUCT").directlyAfterHead()), CommonPatterns.upperCase.label("ORGANIZATION|EVENT").noDependents("flat|appos", NodePattern.N.noLabel(".*").noDependents("punct", NodePattern.not(CommonPatterns.HYPHEN_LIKE_NODE))), NodePattern.N.withDependent("amod", CommonPatterns.capitalizedMiddle.noPos().andNot(CommonPatterns.lowercasedHasPos("(PA2|ADJ):PRD.*").andNot(englishWord.directlyBefore(englishWord)))), NodePattern.N.pos("EIG.*").noDependents("amod", NodePattern.N.noPos("ADJ:PRD.*")), CommonPatterns.capitalized.noPos().andNot(noPosNeutralAdj).noDependents("flat", NodePattern.N.afterHead()).noForm("wehrmacht|vaterland").andNot(CommonPatterns.lowercasedHasPos("ADJ.*").withDependent("case").directlyAfter(NodePattern.N.form("etwas"))), NodePattern.N.potentialPos("SUB:NOM:PLU.*").withDependent("appos", CommonPatterns.capitalized.noPos()), NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(1, ".*familie", "von")), NodePattern.N.form("Flores").noDependents("det|amod"), NodePattern.N.form("Kicker|Interregio").noDependents("amod"));
    static final NodePattern possessiveLikePronounForm = NodePattern.N.lemma("[kmds]?ein|keinerlei");
    static final NodePattern definitelyOpeningQuotation = NodePattern.N.form("[\u201e\u201a]");
    static final NodePattern definitelyClosingQuotation = NodePattern.N.form("[\u201c\u2019]");
    static final NodePattern ambiguousQuotation = NodePattern.N.form("[\"\u00ab\u00bb\u2039\u203a'`\u2018\u201d\u00b4]|[\u2019'][\u2019']");
    static final NodePattern anyQuotation = NodePattern.or(ambiguousQuotation, definitelyOpeningQuotation, definitelyClosingQuotation);
    static final NodePattern closingQuotation = NodePattern.or(ambiguousQuotation, definitelyClosingQuotation);
    static final NodePattern openingQuotation = NodePattern.or(ambiguousQuotation, definitelyOpeningQuotation);
    static final NodePattern headInQuotes = NodePattern.N.withDependent("punct", anyQuotation.beforeHead()).withDependent("punct", anyQuotation.afterHead());
    static final NodePattern firstInPhraseAfterCommasOrConj = NodePattern.or(CommonPatterns.firstChildPhrase, NodePattern.N.beforeHead().withPrevSibling(NodePattern.N.withHeadRelation("cc").andOr(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("punct")), CommonPatterns.firstChildPhrase)), NodePattern.N.beforeHead().withPrevSibling(CommonPatterns.firstChildPhrase.withHeadRelation("punct"))).noHeadRelation("punct|cc");
    static final String clausalRelations = "advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis";
    private static final NodePattern intro = NodePattern.or(NodePattern.or(NodePattern.N.pos("KON:NEB"), NodePattern.N.directlyAfter(openingQuotation).potentialPos("KON:NEB")), NodePattern.N.pos("ABK:Beispiel.*").withDependent("case", NodePattern.N.pos("ABK:wort=zum.*")), NodePattern.N.form("voran").withDependent("advmod"), NodePattern.N.inFormSequence(0, "nach", "wie", "vor"), NodePattern.N.inFormSequence(1, "im", "gegenteil"), NodePattern.N.inFormSequence(1, "vor", "allem"), NodePattern.N.inFormSequence(2, "sehr", "geehrt.*", ".*"), NodePattern.N.form("also|bitte|lediglich|bzw"), NodePattern.or(NodePattern.N.withHeadRelation("advcl"), NodePattern.N.withHead("ccomp", NodePattern.N.withDependent("obj"))).withPhraseStart(NodePattern.N.withHeadRelation("mark").form("ob")), NodePattern.N.withHeadRelation("acl").withDependent(".*", firstInPhraseAfterCommasOrConj.andOr(NodePattern.N.inFormSequence(0, "w.*", "immer"), NodePattern.N.inFormSequence(0, "w.*", "auch", "immer"))), NodePattern.N.withHeadRelation("vocative"), NodePattern.N.withHeadRelation("acl").inFormSequence(1, "ehrlich", "gesagt"), NodePattern.N.withHeadRelation("acl|advcl").withDependent("advmod", NodePattern.N.form("egal|wie")), NodePattern.N.withHeadRelation("advcl").andOr(NodePattern.or(NodePattern.N.pos(".*KJ2.*"), NodePattern.N.withDependent("aux", NodePattern.N.pos(".*KJ2.*"))).withDependent("mark", NodePattern.N.form("wenn")).withDependent("advmod", NodePattern.N.form("nur")), NodePattern.or(NodePattern.N.lemma("sein").pos(".*KJ1.*"), NodePattern.N.withDependent("cop", NodePattern.N.pos(".*KJ1.*"))), NodePattern.N.withHead(NodePattern.or(NodePattern.N.pos(".*KJ2.*"), NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.pos(".*KJ2.*")))).pos(".*KJ2.*").withPhraseStart(NodePattern.N.withHeadRelation("mark").form("ob|wenn"))), NodePattern.N.withPhraseStart(NodePattern.or(NodePattern.N.withHeadRelation("advmod").form("sosehr"), NodePattern.N.inFormSequence(0, "so", "sehr"))).withHeadRelation("xcomp|advcl"), NodePattern.N.form("schon").directlyBefore(NodePattern.N.withHeadRelation("amod")), NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").withPhraseEnd(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.form("nicht"))), NodePattern.N.withDependent("appos", CommonPatterns.phraseStartsWithComma.and(CommonPatterns.phraseEndsWithComma)));
    static final NodePattern firstPlaceClauseConstituent = NodePattern.or(CommonPatterns.firstChildPhrase, NodePattern.N.withPrevSibling(intro.and(CommonPatterns.firstChildPhrase))).andNot(intro);
    private static final NodePattern nachWieVor = NodePattern.N.inFormSequence(0, "nach", "wie", "vor");
    static final String APOSTROPHES = "'`\u00b4\u2019";
    static final NodePattern apos = NodePattern.N.form("['`\u00b4\u2019]");
    static final NodePattern afterOpeningApos = NodePattern.custom(node -> ((StreamEx)node.back().skip(2L)).anyMatch(apos.noSpaceAfter().andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.PUNCT, NodePattern.N.form("n(e[mnr]?)?|m|s"))))::matches));
    static final String nominalHeads = "nsubj(:pass)?|i?obj|obl|nmod|compound";
    static final NodePattern onlySingular = NodePattern.or(NodePattern.N.form("anklang|anstrengung|aufmerksamkeit|aufregung|aufwand|charme|eigenst(\u00e4|ae)ndigkeit|(sprach)?erwerb|essen|funk|geld|gem(\u00fc|ue)tlichkeit|gewicht|glas|gl(\u00fc|ue)ck|gold|gr(\u00fc|ue)n|holz|korruption|kriminalit\u00e4t|lust|luft|l(\u00e4|ae)rm|mitte|mu(\u00df|ss)e|m(\u00fc|ue)he|m(\u00fc|ue)ll|n(\u00e4|ae)ssepopularit(\u00e4|ae)t|prominenz|regen|reklame|respekt|schaum|schlamms?|schnee|sonne|unklarheit|unsicherheit|unterst(\u00fc|ue)tzung|vergangenheit|vergn(\u00fc|ue)gen|verst(\u00e4|ae)ndnis|verwirrung|wasser|wert|widerstand|wirbel|w(\u00e4|ae)rme|zubeh(\u00f6|oe)r|(\u00fc|ue)bereinkommen|(\u00f6|oe)l|obst|methan"), NodePattern.N.form(".+leben"));
    static final NodePattern uncountableNoun = NodePattern.or(onlySingular, NodePattern.N.form("ger(\u00e4|ae)t|genu(\u00df|ss)|glanz|herz|spott|st(\u00fc|ue)ck|text|tradition|wassers?|wurst|zeit|entfernung|zustimmung|abstand|fracht|alkohol|breite|l\u00e4nge|h\u00f6he|tiefe|gewicht|radius|(\u00fc|ue)bel"), NodePattern.N.formSuffix("arbeit|bedarf|belichtung|besitz|bier|energie|erfahrung|erfolg|fisch|fl\u00e4che|freiheit|freude|gef(\u00fc|ue)hl|initiative|inspiration|interesse|ironie|irritation|komfort|kompetenz|kritik|kraft|kunst|leid|leistung|licht|liebe|literatur|milch|musik|mut|rabatt|sicht|stoff|oxid|pflege|platz|potential|power|praxis|ruhe|spa(\u00df|ss)|spannung|spruch|stil|strom|schaft|wanderung|wei\u00df|witz"), NodePattern.N.pos("SUB:.*:NEU:INF").noPos("SUB.*PLU.*"));
    static final NodePattern whWord = NodePattern.or(CommonPatterns.lowercasedHasPos("(ADV|PRO):.*(INR|RIN).*"), NodePattern.N.form("wo(durch|her|hin|f(\u00fc|ue)r|mit|ran|rauf|von|nach)?"));
    static final NodePattern whPhrase = NodePattern.or(whWord, NodePattern.N.withDependent("det", whWord), NodePattern.N.withDependent("amod", NodePattern.N.inFormSequence(1, "wie", "viel")), NodePattern.N.pos("(ADJ|SUB).*").withDependent("advmod", NodePattern.N.form("wie").beforeHead()));
    private static final NodePattern hasMisparsedPrepAsPrevSibling = NodePattern.N.withPrevSibling(NodePattern.or(NodePattern.N.form("zu").withHeadRelation("advmod").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("bis|da|her|hier|hin|vor|wo|zur(\u00fc|ue)ck"))), NodePattern.N.form("mit").withHeadRelation("mark")));
    private static final NodePattern hasMisparsedPrepAsDependentOfDependent = NodePattern.N.withDependent("amod", CommonPatterns.letterWord.withDependent("case", NodePattern.N.markAs("Prep"))).withPhraseStart(NodePattern.N.alreadyMarkedAs("Prep")).andNot(NodePattern.markedNodeMatches("Prep", NodePattern.N.form("am").withHead(NodePattern.or(NodePattern.N.pos(".*SUP.*"), NodePattern.N.form(".+sten")))));
    private static final NodePattern looksLikePreposition = NodePattern.N.withHeadRelation("case").andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("mark"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det").lemma("ein"))).andNot(NodePattern.N.inFormSequence(1, "bis", "zu(mr)?")).andNot(NodePattern.N.form("zu|bis").withHead("case", NodePattern.N.withHeadRelation("amod")));
    static final String toProhibitInDictionary = "Strassenverkehr|best";

    GermanTreePatterns() {
    }

    static NodePattern hasSubject() {
        NodePattern looksLikeVocative = NodePattern.or(NodePattern.N.withDependent("punct", CommonPatterns.comma.directlyAfterHead()), NodePattern.N.form("du"));
        return CommonPatterns.skipUp("aux(:pass)?|cop", NodePattern.or(NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.not(looksLikeVocative).markAs("Subj")), NodePattern.N.withHead("conj", NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.not(looksLikeVocative).markAs("Subj")).noDependents("aux(:pass)?|cop"))));
    }

    @Nullable
    static Node findPreposition(Node node) {
        List<Node> cases = node.allDependents().stream().takeWhile(n -> n.isBefore(node)).filter(looksLikePreposition::matches).toList();
        if (!cases.isEmpty()) {
            Node caze = cases.get(cases.size() - 1);
            if (NodePattern.PUNCT.matches(caze.nextNode()) || nachWieVor.matches(caze)) {
                return null;
            }
            return caze;
        }
        if (hasMisparsedPrepAsPrevSibling.matches(node)) {
            return node.phraseStart().prevNode();
        }
        if (hasMisparsedPrepAsDependentOfDependent.matches(node)) {
            return node.phraseStart();
        }
        return StreamEx.of(node.findDependents("advmod")).findFirst(entsprechend::matches).orElse(null);
    }

    static NodePattern lemmaAfterForm(String lemma, String form) {
        return NodePattern.N.lemma(lemma).directlyAfter(NodePattern.N.form(form).markAs("Form"));
    }

    static Pair<Character, Character> primaryQuotes(Node node) {
        String variant = GermanParameters.VARIANT.getValue(node.tree());
        if (variant.matches("DE")) {
            return new Pair((Object)Character.valueOf('\u201e'), (Object)Character.valueOf('\u201c'));
        }
        if (variant.matches("CH")) {
            return new Pair((Object)Character.valueOf('\u00ab'), (Object)Character.valueOf('\u00bb'));
        }
        return new Pair((Object)Character.valueOf('\u201e'), (Object)Character.valueOf('\u201c'));
    }
}

