/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization.impl;

import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleRepositoryData;
import com.intellij.platform.runtime.repository.serialization.impl.CachedClasspathComputation;
import com.intellij.platform.runtime.repository.serialization.impl.ModuleXmlSerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JarFileSerializer {
    public static final String SPECIFICATION_VERSION = "0.1";
    public static final String SPECIFICATION_TITLE = "IntelliJ Runtime Module Repository";
    private static final Attributes.Name MAIN_PLUGIN_MODULE_ATTRIBUTE_NAME = new Attributes.Name("Main-Plugin-Module-Id");
    private static final Attributes.Name BOOTSTRAP_MODULE_ATTRIBUTE_NAME = new Attributes.Name("Bootstrap-Module-Name");
    private static final Attributes.Name BOOTSTRAP_CLASSPATH_ATTRIBUTE_NAME = new Attributes.Name("Bootstrap-Class-Path");

    @NotNull
    public static RawRuntimeModuleRepositoryData loadFromJar(@NotNull Path jarPath) throws IOException, XMLStreamException {
        String mainPluginModuleId;
        if (jarPath == null) {
            JarFileSerializer.$$$reportNull$$$0(0);
        }
        HashMap<String, RawRuntimeModuleDescriptor> rawData = new HashMap<String, RawRuntimeModuleDescriptor>();
        try (JarInputStream input = new JarInputStream(new BufferedInputStream(Files.newInputStream(jarPath, new OpenOption[0])));){
            JarEntry entry;
            Manifest manifest = input.getManifest();
            if (manifest == null) {
                throw new IOException("Manifest not found in " + String.valueOf(jarPath));
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String version = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            if (version == null) {
                throw new IOException("'" + Attributes.Name.SPECIFICATION_VERSION.toString() + "' attribute is not specified in " + String.valueOf(jarPath));
            }
            if (!version.equals(SPECIFICATION_VERSION)) {
                throw new IOException("'" + String.valueOf(jarPath) + "' has unsupported version '" + version + "' ('0.1' is expected)");
            }
            mainPluginModuleId = mainAttributes.getValue(MAIN_PLUGIN_MODULE_ATTRIBUTE_NAME);
            XMLInputFactory factory = XMLInputFactory.newDefaultFactory();
            while ((entry = input.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".xml")) continue;
                RawRuntimeModuleDescriptor data = ModuleXmlSerializer.parseModuleXml(factory, input);
                rawData.put(data.getId(), data);
            }
        }
        return new RawRuntimeModuleRepositoryData(rawData, jarPath.getParent(), mainPluginModuleId);
    }

    public static @NotNull String @Nullable [] loadBootstrapClasspath(@NotNull Path jarPath, @NotNull String bootstrapModuleName) throws IOException {
        if (jarPath == null) {
            JarFileSerializer.$$$reportNull$$$0(1);
        }
        if (bootstrapModuleName == null) {
            JarFileSerializer.$$$reportNull$$$0(2);
        }
        try (JarInputStream input = new JarInputStream(new BufferedInputStream(Files.newInputStream(jarPath, new OpenOption[0])));){
            Manifest manifest = input.getManifest();
            if (manifest == null) {
                String[] stringArray = null;
                return stringArray;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (!SPECIFICATION_VERSION.equals(attributes.getValue(Attributes.Name.SPECIFICATION_VERSION))) {
                String[] stringArray = null;
                return stringArray;
            }
            if (!bootstrapModuleName.equals(attributes.getValue(BOOTSTRAP_MODULE_ATTRIBUTE_NAME))) {
                String[] stringArray = null;
                return stringArray;
            }
            String classpathValue = attributes.getValue(BOOTSTRAP_CLASSPATH_ATTRIBUTE_NAME);
            if (classpathValue == null) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = classpathValue.split(" ");
            return stringArray;
        }
    }

    public static void saveToJar(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path jarFile, @Nullable String mainPluginModuleId, int generatorVersion) throws IOException, XMLStreamException {
        if (descriptors == null) {
            JarFileSerializer.$$$reportNull$$$0(3);
        }
        if (jarFile == null) {
            JarFileSerializer.$$$reportNull$$$0(4);
        }
        Files.createDirectories(jarFile.getParent(), new FileAttribute[0]);
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(Attributes.Name.SPECIFICATION_TITLE, SPECIFICATION_TITLE);
        attributes.put(Attributes.Name.SPECIFICATION_VERSION, SPECIFICATION_VERSION);
        attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, "0.1." + generatorVersion);
        if (bootstrapModuleName != null) {
            attributes.put(BOOTSTRAP_MODULE_ATTRIBUTE_NAME, bootstrapModuleName);
            Collection<String> bootstrapClasspath = CachedClasspathComputation.computeClasspath(descriptors, bootstrapModuleName);
            attributes.put(BOOTSTRAP_CLASSPATH_ATTRIBUTE_NAME, String.join((CharSequence)" ", bootstrapClasspath));
        }
        if (mainPluginModuleId != null) {
            attributes.put(MAIN_PLUGIN_MODULE_ATTRIBUTE_NAME, mainPluginModuleId);
        }
        try (JarOutputStream jarOutput = new JarOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(jarFile, new OpenOption[0])), manifest);){
            XMLOutputFactory factory = XMLOutputFactory.newDefaultFactory();
            for (RawRuntimeModuleDescriptor descriptor : descriptors) {
                String id = descriptor.getId();
                jarOutput.putNextEntry(new JarEntry(id + ".xml"));
                PrintWriter output = new PrintWriter(jarOutput, false, StandardCharsets.UTF_8);
                ModuleXmlSerializer.writeModuleXml(descriptor, output, factory);
                jarOutput.closeEntry();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootstrapModuleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/runtime/repository/serialization/impl/JarFileSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadFromJar";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadBootstrapClasspath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "saveToJar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

