/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;

public class LoggingGraph
implements Graph {
    private final Graph myDelegate;
    private final Consumer<String> myLogger;

    public LoggingGraph(Graph delegate, Consumer<String> logger) {
        this.myDelegate = delegate;
        this.myLogger = logger;
    }

    public Graph getDelegate() {
        return this.myDelegate;
    }

    protected void debug(String message, Object ... details) {
        StringBuilder msg = new StringBuilder(message);
        for (Object detail : details) {
            msg.append(detail);
        }
        this.debug(msg.toString());
    }

    protected void debug(String message) {
        this.myLogger.accept(message);
    }

    @Override
    public Iterable<BackDependencyIndex> getIndices() {
        return this.myDelegate.getIndices();
    }

    @Override
    @Nullable
    public BackDependencyIndex getIndex(String name) {
        return this.myDelegate.getIndex(name);
    }

    @Override
    @NotNull
    public Iterable<ReferenceID> getDependingNodes(@NotNull ReferenceID id) {
        if (id == null) {
            LoggingGraph.$$$reportNull$$$0(0);
        }
        Iterable<ReferenceID> iterable = this.myDelegate.getDependingNodes(id);
        if (iterable == null) {
            LoggingGraph.$$$reportNull$$$0(1);
        }
        return iterable;
    }

    @Override
    public Iterable<NodeSource> getSources(@NotNull ReferenceID id) {
        if (id == null) {
            LoggingGraph.$$$reportNull$$$0(2);
        }
        return this.myDelegate.getSources(id);
    }

    @Override
    public Iterable<ReferenceID> getRegisteredNodes() {
        return this.myDelegate.getRegisteredNodes();
    }

    @Override
    public Iterable<NodeSource> getSources() {
        return this.myDelegate.getSources();
    }

    @Override
    public Iterable<Node<?, ?>> getNodes(@NotNull NodeSource source) {
        if (source == null) {
            LoggingGraph.$$$reportNull$$$0(3);
        }
        return this.myDelegate.getNodes(source);
    }

    @Override
    public <T extends Node<T, ?>> Iterable<T> getNodes(NodeSource src, Class<T> nodeSelector) {
        return this.myDelegate.getNodes(src, nodeSelector);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/LoggingGraph";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/LoggingGraph";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependingNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDependingNodes";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

