/*
 * Decompiled with CFR 0.152.
 */
package training.ui.views;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;
import training.ui.LessonMessagePane;
import training.ui.MessageFactory;
import training.ui.OnboardingFeedbackFormKt;
import training.ui.StepAnimator;
import training.ui.UISettings;
import training.ui.views.LearnPanelKt;
import training.ui.views.LinkLabelWithBackArrow;
import training.util.OnboardingFeedbackData;
import training.util.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010(\u001a\u00020\u001c2\b\b\u0001\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010+\u001a\u00020,J\u0006\u00100\u001a\u00020\u001cJ\u0012\u00101\u001a\u00020\u001c2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0006\u00104\u001a\u00020\u001cJ\u000e\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020!J\u000e\u00107\u001a\u00020\u001c2\u0006\u00106\u001a\u00020!J\u0006\u00108\u001a\u00020!J\u0006\u00109\u001a\u00020\u001cJ\b\u0010:\u001a\u00020\u001cH\u0002J\b\u0010;\u001a\u00020\u0001H\u0002J\u0018\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u0016H\u0002J\u0006\u0010?\u001a\u00020\u001cJ\u0006\u0010@\u001a\u00020\u001cJ\u000e\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020!J\b\u0010C\u001a\u00020!H\u0002J\b\u0010D\u001a\u00020\u001cH\u0002J\u0006\u0010E\u001a\u00020\u001cJ\u0010\u0010F\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020!H\u0002J\b\u0010H\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006I"}, d2={"Ltraining/ui/views/LearnPanel;", "Ljavax/swing/JPanel;", "learnToolWindow", "Ltraining/ui/LearnToolWindow;", "<init>", "(Ltraining/ui/LearnToolWindow;)V", "getLearnToolWindow", "()Ltraining/ui/LearnToolWindow;", "lessonPanel", "lessonMessagePane", "Ltraining/ui/LessonMessagePane;", "getLessonMessagePane", "()Ltraining/ui/LessonMessagePane;", "nextButton", "Ljavax/swing/JButton;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "stepAnimator", "Ltraining/ui/StepAnimator;", "lessonPanelBoxLayout", "Ljavax/swing/BoxLayout;", "scrollToNewMessages", "", "getScrollToNewMessages$intellij_featuresTrainer", "()Z", "setScrollToNewMessages$intellij_featuresTrainer", "(Z)V", "reinitMe", "", "lesson", "Ltraining/learn/course/Lesson;", "updatePanelSize", "viewAreaWidth", "", "createFooterPanel", "initLessonPanel", "createLessonNameLabel", "Ljavax/swing/JLabel;", "createHeaderPanel", "Lcom/intellij/ui/components/panels/VerticalBox;", "addMessage", "text", "", "properties", "Ltraining/ui/LessonMessagePane$MessageProperties;", "addMessages", "message", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "focusCurrentMessage", "scrollToMessage", "needToShow", "Ljava/awt/Rectangle;", "adjustMessagesArea", "resetMessagesNumber", "number", "removeInactiveMessages", "messagesNumber", "setPreviousMessagesPassed", "clearMessages", "createButtonsPanel", "createNavigationButton", "targetLesson", "isNext", "makeNextButtonSelected", "clearRestoreMessage", "removeMessage", "index", "getVisibleAreaWidth", "scrollToTheEnd", "scrollToTheStart", "scrollTo", "needTo", "useAnimation", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLearnPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LearnPanel.kt\ntraining/ui/views/LearnPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1#2:429\n*E\n"})
public final class LearnPanel
extends JPanel {
    @NotNull
    private final LearnToolWindow learnToolWindow;
    @NotNull
    private final JPanel lessonPanel;
    @NotNull
    private final LessonMessagePane lessonMessagePane;
    @Nullable
    private JButton nextButton;
    @NotNull
    private final JBScrollPane scrollPane;
    @NotNull
    private final StepAnimator stepAnimator;
    @NotNull
    private final BoxLayout lessonPanelBoxLayout;
    private boolean scrollToNewMessages;

    public LearnPanel(@NotNull LearnToolWindow learnToolWindow) {
        Intrinsics.checkNotNullParameter((Object)((Object)learnToolWindow), (String)"learnToolWindow");
        this.learnToolWindow = learnToolWindow;
        this.lessonPanel = new JPanel();
        this.lessonMessagePane = new LessonMessagePane(false, 1, null);
        this.scrollPane = new JBScrollPane((Component)this.lessonPanel);
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"getVerticalScrollBar(...)");
        this.stepAnimator = new StepAnimator(jScrollBar, this.lessonMessagePane);
        this.lessonPanelBoxLayout = new BoxLayout(this.lessonPanel, 1);
        this.scrollToNewMessages = true;
        Disposer.register((Disposable)this.learnToolWindow.getParentDisposable$intellij_featuresTrainer(), (Disposable)((Disposable)this.lessonMessagePane));
        this.setFocusable(false);
        this.setBackground(UISettings.Companion.getInstance().getBackgroundColor());
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(true);
        this.scrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.updatePanelSize(this.getVisibleAreaWidth());
            }
        });
    }

    @NotNull
    public final LearnToolWindow getLearnToolWindow() {
        return this.learnToolWindow;
    }

    @NotNull
    public final LessonMessagePane getLessonMessagePane() {
        return this.lessonMessagePane;
    }

    public final boolean getScrollToNewMessages$intellij_featuresTrainer() {
        return this.scrollToNewMessages;
    }

    public final void setScrollToNewMessages$intellij_featuresTrainer(boolean bl) {
        this.scrollToNewMessages = bl;
    }

    public final void reinitMe(@NotNull Lesson lesson) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        UISettings $this$reinitMe_u24lambda_u240 = UISettings.Companion.getInstance();
        boolean bl = false;
        this.setBorder(new EmptyBorder($this$reinitMe_u24lambda_u240.getNorthInset(), 0, $this$reinitMe_u24lambda_u240.getSouthInset(), 0));
        this.scrollToNewMessages = true;
        this.clearMessages();
        this.lessonPanel.removeAll();
        this.removeAll();
        this.add((Component)this.createHeaderPanel(lesson));
        this.add(LearnPanelKt.access$createSmallSeparator());
        this.add(UtilsKt.scaledRigid(UISettings.Companion.getInstance().getPanelWidth(), JBUI.scale((int)4)));
        this.initLessonPanel(lesson);
        this.scrollPane.setAlignmentX(0.0f);
        this.add((Component)this.scrollPane);
    }

    public final void updatePanelSize(int viewAreaWidth) {
        int width = Math.max(UISettings.Companion.getInstance().getPanelWidth(), viewAreaWidth) - 2 * UISettings.Companion.getInstance().getLearnPanelSideOffset();
        this.lessonMessagePane.setPreferredSize(null);
        this.lessonMessagePane.setBounds(0, 0, width, 10000);
        this.lessonMessagePane.revalidate();
        this.lessonMessagePane.repaint();
        this.lessonMessagePane.setPreferredSize(new Dimension(width, this.lessonMessagePane.getPreferredSize().height));
        this.lessonPanel.revalidate();
        this.lessonPanel.doLayout();
        this.lessonPanel.repaint();
    }

    private final JPanel createFooterPanel(Lesson lesson) {
        JPanel shiftedFooter = new JPanel();
        shiftedFooter.setName("footerLessonPanel");
        shiftedFooter.setLayout(new BoxLayout(shiftedFooter, 1));
        shiftedFooter.setFocusable(false);
        shiftedFooter.setOpaque(false);
        shiftedFooter.setBorder(new MatteBorder(JBUI.scale((int)1), 0, 0, 0, UISettings.Companion.getInstance().getSeparatorColor()));
        JPanel footerContent = new JPanel();
        footerContent.setOpaque(false);
        footerContent.setLayout(new BoxLayout(footerContent, 1));
        footerContent.add(UtilsKt.rigid(0, 16));
        JLabel jLabel = new JLabel(IdeBundle.message((String)"welcome.screen.learnIde.help.and.resources.text", (Object[])new Object[0]));
        JLabel jLabel2 = jLabel;
        JPanel jPanel = footerContent;
        boolean bl = false;
        jLabel2.setFont(UISettings.Companion.getInstance().getFont(1).deriveFont(1));
        jPanel.add(jLabel);
        for (Map.Entry entry : lesson.getHelpLinks().entrySet()) {
            String text = (String)entry.getKey();
            String link = (String)entry.getValue();
            LinkLabel linkLabel = new LinkLabel(text, null, (arg_0, arg_1) -> LearnPanel.createFooterPanel$lambda$1(link, lesson, arg_0, arg_1));
            footerContent.add(UtilsKt.rigid(0, 5));
            footerContent.add(UtilsKt.wrapWithUrlPanel((LinkLabel<Object>)linkLabel));
        }
        shiftedFooter.add(footerContent);
        shiftedFooter.add(Box.createHorizontalGlue());
        JPanel footer = new JPanel();
        footer.add(shiftedFooter);
        footer.setAlignmentX(0.0f);
        footer.setOpaque(false);
        footer.setLayout(new BoxLayout(footer, 1));
        footer.setBorder(UISettings.Companion.getInstance().getLessonHeaderBorder());
        return footer;
    }

    private final void initLessonPanel(Lesson lesson) {
        this.lessonPanel.setName("lessonPanel");
        this.lessonPanel.setLayout(this.lessonPanelBoxLayout);
        this.lessonPanel.setFocusable(false);
        this.lessonPanel.setOpaque(true);
        UISettings $this$initLessonPanel_u24lambda_u240 = UISettings.Companion.getInstance();
        boolean bl = false;
        this.lessonPanel.setBackground($this$initLessonPanel_u24lambda_u240.getBackgroundColor());
        this.lessonPanel.setBorder(new EmptyBorder(0, $this$initLessonPanel_u24lambda_u240.getLearnPanelSideOffset(), 0, $this$initLessonPanel_u24lambda_u240.getLearnPanelSideOffset()));
        this.lessonMessagePane.setName("lessonMessagePane");
        this.lessonMessagePane.setFocusable(false);
        this.lessonMessagePane.setOpaque(false);
        this.lessonMessagePane.setAlignmentX(0.0f);
        this.lessonMessagePane.setMargin((Insets)JBInsets.emptyInsets());
        this.lessonMessagePane.setBorder(new EmptyBorder(0, 0, JBUI.scale((int)20), JBUI.scale((int)14)));
        this.lessonPanel.add(UtilsKt.scaledRigid(UISettings.Companion.getInstance().getPanelWidth() - 2 * UISettings.Companion.getInstance().getLearnPanelSideOffset(), JBUI.scale((int)19)));
        this.lessonPanel.add(this.createLessonNameLabel(lesson));
        this.lessonPanel.add((Component)((Object)this.lessonMessagePane));
        this.lessonPanel.add(this.createButtonsPanel());
        this.lessonPanel.add(Box.createVerticalGlue());
        if (!lesson.getHelpLinks().isEmpty() && Registry.Companion.is("ift.help.links", false)) {
            this.lessonPanel.add(UtilsKt.rigid(0, 16));
            this.lessonPanel.add(this.createFooterPanel(lesson));
        }
    }

    private final JLabel createLessonNameLabel(Lesson lesson) {
        JLabel lessonNameLabel2 = new JLabel(){

            public void updateUI() {
                super.updateUI();
                this.setBorder(UISettings.Companion.getInstance().getLessonHeaderBorder());
                this.setFont(UISettings.Companion.getInstance().getFont(5).deriveFont(1));
            }
        };
        lessonNameLabel2.setName("lessonNameLabel");
        lessonNameLabel2.setAlignmentX(0.0f);
        lessonNameLabel2.setFocusable(false);
        lessonNameLabel2.setText(lesson.getName());
        lessonNameLabel2.setForeground(UISettings.Companion.getInstance().getDefaultTextColor());
        return lessonNameLabel2;
    }

    private final VerticalBox createHeaderPanel(Lesson lesson) {
        JLabel moduleNameLabel = (JLabel)((Object)new LinkLabelWithBackArrow(LearnPanel::createHeaderPanel$lambda$0));
        moduleNameLabel.setName("moduleNameLabel");
        moduleNameLabel.setFont(UISettings.Companion.getInstance().getFont(1));
        moduleNameLabel.setText("    " + lesson.getModule().getName());
        moduleNameLabel.setForeground(UISettings.Companion.getInstance().getDefaultTextColor());
        moduleNameLabel.setFocusable(false);
        JPanel linksPanel = new JPanel();
        linksPanel.setOpaque(false);
        linksPanel.setLayout(new BoxLayout(linksPanel, 0));
        linksPanel.setAlignmentX(0.0f);
        linksPanel.setBorder(new EmptyBorder(0, 0, JBUI.scale((int)12), 0));
        linksPanel.add(moduleNameLabel);
        linksPanel.add(Box.createHorizontalGlue());
        JLabel exitLink = new JLabel(LearnBundle.INSTANCE.message("exit.learning.link", new Object[0]), AllIcons.Actions.Exit, 10);
        exitLink.setCursor(Cursor.getPredefinedCursor(12));
        exitLink.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ LearnPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                block3: {
                    Project project;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (!StatisticBase.INSTANCE.isLearnProjectCloseLogged()) {
                            StatisticBase.INSTANCE.logLessonStopped(StatisticBase.LessonStopReason.EXIT_LINK);
                        }
                        LessonManager.Companion.getInstance().stopLesson();
                        LangSupport langSupport = LangManager.Companion.getInstance().getLangSupport();
                        project = this.this$0.getLearnToolWindow().getProject();
                        Object object = langSupport;
                        if (object != null && (object = object.getOnboardingFeedbackData()) != null) {
                            Object it = object;
                            boolean bl = false;
                            OnboardingFeedbackFormKt.showOnboardingLessonFeedbackForm(project, (OnboardingFeedbackData)it, false);
                            langSupport.setOnboardingFeedbackData(null);
                        }
                        if (langSupport == null || !UtilsKt.isLearningProject(project, langSupport.getPrimaryLanguage())) break block2;
                        new CloseProjectWindowHelper().windowClosing(project);
                        break block3;
                    }
                    LearningUiManager.INSTANCE.resetModulesView();
                    ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Learn");
                    if (toolWindow == null) break block3;
                    toolWindow.hide();
                }
            }
        });
        linksPanel.add(exitLink);
        VerticalBox headerPanel = new VerticalBox();
        headerPanel.setOpaque(false);
        headerPanel.setAlignmentX(0.0f);
        headerPanel.setBorder(UISettings.Companion.getInstance().getLessonHeaderBorder());
        headerPanel.add((Component)linksPanel);
        return headerPanel;
    }

    public final void addMessage(@Language(value="HTML") @NotNull String text, @NotNull LessonMessagePane.MessageProperties properties) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        List<TextParagraph> paragraphs = MessageFactory.INSTANCE.convert(text);
        TextParagraph firstParagraph = (TextParagraph)CollectionsKt.first(paragraphs);
        this.addMessages(firstParagraph, properties);
        for (TextParagraph paragraph : paragraphs.subList(1, paragraphs.size())) {
            this.addMessages(paragraph, LessonMessagePane.MessageProperties.copy$default(properties, null, null, true, null, 11, null));
        }
    }

    public static /* synthetic */ void addMessage$default(LearnPanel learnPanel, String string, LessonMessagePane.MessageProperties messageProperties, int n, Object object) {
        if ((n & 2) != 0) {
            messageProperties = new LessonMessagePane.MessageProperties(null, null, false, null, 15, null);
        }
        learnPanel.addMessage(string, messageProperties);
    }

    public final void addMessages(@NotNull TextParagraph message, @NotNull LessonMessagePane.MessageProperties properties) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Function0<Rectangle> needToShow = this.lessonMessagePane.addMessage(message, properties);
        this.adjustMessagesArea();
        if (properties.getState() != LessonMessagePane.MessageState.INACTIVE) {
            this.scrollToMessage((Rectangle)needToShow.invoke());
        }
    }

    public static /* synthetic */ void addMessages$default(LearnPanel learnPanel, TextParagraph textParagraph, LessonMessagePane.MessageProperties messageProperties, int n, Object object) {
        if ((n & 2) != 0) {
            messageProperties = new LessonMessagePane.MessageProperties(null, null, false, null, 15, null);
        }
        learnPanel.addMessages(textParagraph, messageProperties);
    }

    public final void focusCurrentMessage() {
        this.scrollToMessage(this.lessonMessagePane.getCurrentMessageRectangle());
    }

    private final void scrollToMessage(Rectangle needToShow) {
        if (needToShow == null) {
            return;
        }
        if (this.scrollToNewMessages) {
            this.adjustMessagesArea();
            Dimension visibleSize = this.lessonPanel.getVisibleRect().getSize();
            int needToScroll = Math.max(0, needToShow.y + this.lessonMessagePane.getLocation().y - visibleSize.height / 2 + needToShow.height / 2);
            this.scrollTo(needToScroll);
        }
    }

    public final void adjustMessagesArea() {
        this.updatePanelSize(this.getVisibleAreaWidth());
        this.revalidate();
        this.repaint();
    }

    public final void resetMessagesNumber(int number) {
        Function0<Rectangle> needToShow = this.lessonMessagePane.resetMessagesNumber(number);
        this.adjustMessagesArea();
        this.scrollToMessage((Rectangle)needToShow.invoke());
    }

    public final void removeInactiveMessages(int number) {
        this.lessonMessagePane.removeInactiveMessages(number);
        this.adjustMessagesArea();
    }

    public final int messagesNumber() {
        return this.lessonMessagePane.messagesNumber();
    }

    public final void setPreviousMessagesPassed() {
        this.lessonMessagePane.passPreviousMessages();
        this.adjustMessagesArea();
    }

    private final void clearMessages() {
        this.lessonMessagePane.clearMessages();
    }

    private final JPanel createButtonsPanel() {
        JButton jButton;
        JButton jButton2;
        Lesson previousLesson;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setName("buttonPanel");
        buttonPanel.setBorder(new EmptyBorder(0, UISettings.Companion.getInstance().getCheckIndent() - new JButton().getInsets().left, 0, 0));
        buttonPanel.setOpaque(false);
        buttonPanel.setFocusable(false);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setAlignmentX(0.0f);
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(null);
        }
        Lesson lesson = previousLesson = UtilsKt.getPreviousLessonForCurrent();
        if (lesson != null) {
            Lesson it = lesson;
            boolean bl = false;
            jButton2 = this.createNavigationButton(previousLesson, false);
        } else {
            jButton2 = null;
        }
        JButton prevButton = jButton2;
        Lesson nextLesson = UtilsKt.getNextLessonForCurrent();
        LearnPanel learnPanel = this;
        Lesson lesson2 = nextLesson;
        if (lesson2 != null) {
            Lesson bl = lesson2;
            LearnPanel learnPanel2 = learnPanel;
            boolean bl2 = false;
            jButton = this.createNavigationButton(nextLesson, true);
            learnPanel = learnPanel2;
        } else {
            jButton = null;
        }
        learnPanel.nextButton = jButton;
        Object[] it = new JButton[]{prevButton, this.nextButton};
        for (JButton button2 : CollectionsKt.listOfNotNull((Object[])it)) {
            button2.setMargin((Insets)JBInsets.emptyInsets());
            button2.setFocusable(false);
            button2.setEnabled(true);
            button2.setOpaque(false);
            buttonPanel.add(button2);
        }
        return buttonPanel;
    }

    private final JButton createNavigationButton(Lesson targetLesson, boolean isNext) {
        String string;
        JButton button2 = new JButton();
        button2.setAction(new AbstractAction(isNext, this, targetLesson){
            final /* synthetic */ boolean $isNext;
            final /* synthetic */ LearnPanel this$0;
            final /* synthetic */ Lesson $targetLesson;
            {
                this.$isNext = $isNext;
                this.this$0 = $receiver;
                this.$targetLesson = $targetLesson;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
                StatisticBase.INSTANCE.logLessonStopped(StatisticBase.LessonStopReason.OPEN_NEXT_OR_PREV_LESSON);
                LessonStartingWay startingWay = this.$isNext ? LessonStartingWay.NEXT_BUTTON : LessonStartingWay.PREV_BUTTON;
                CourseManager.openLesson$default(CourseManager.Companion.getInstance(), this.this$0.getLearnToolWindow().getProject(), this.$targetLesson, startingWay, false, false, 24, null);
            }
        });
        if (isNext) {
            Object[] objectArray = new Object[]{targetLesson.getName()};
            string = LearnBundle.INSTANCE.message("learn.new.ui.button.next", objectArray);
        } else {
            string = LearnBundle.INSTANCE.message("learn.new.ui.button.back", new Object[0]);
        }
        button2.setText(string);
        button2.updateUI();
        button2.setSelected(true);
        if (!targetLesson.getPassed$intellij_featuresTrainer() && !targetLesson.getProperties().getCanStartInDumbMode() && DumbService.Companion.getInstance(this.learnToolWindow.getProject()).isDumb()) {
            button2.setEnabled(false);
            button2.setToolTipText(LearnBundle.INSTANCE.message("indexing.message", new Object[0]));
            button2.setSelected(false);
            DumbService.Companion.getInstance(this.learnToolWindow.getProject()).runWhenSmart(() -> LearnPanel.createNavigationButton$lambda$0(button2));
        }
        return button2;
    }

    public final void makeNextButtonSelected() {
        JButton jButton = this.nextButton;
        if (jButton != null) {
            JButton it = jButton;
            boolean bl = false;
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                jRootPane.setDefaultButton(it);
            }
            it.setSelected(true);
            it.setFocusable(true);
            it.requestFocus();
        }
        if (this.scrollToNewMessages) {
            this.adjustMessagesArea();
            this.scrollToTheEnd();
        }
    }

    public final void clearRestoreMessage() {
        Function0<Rectangle> needToShow = this.lessonMessagePane.clearRestoreMessages();
        this.scrollToMessage((Rectangle)needToShow.invoke());
    }

    public final void removeMessage(int index) {
        this.lessonMessagePane.removeMessage(index);
    }

    private final int getVisibleAreaWidth() {
        Serializable serializable = this.scrollPane.getVerticalScrollBar();
        int scrollWidth = serializable != null && (serializable = serializable.getSize()) != null ? ((Dimension)serializable).width : 0;
        return this.scrollPane.getViewport().getExtentSize().width - scrollWidth;
    }

    private final void scrollToTheEnd() {
        JScrollBar vertical = this.scrollPane.getVerticalScrollBar();
        if (this.useAnimation()) {
            this.stepAnimator.startAnimation(vertical.getMaximum());
        } else {
            vertical.setValue(vertical.getMaximum());
        }
    }

    public final void scrollToTheStart() {
        this.scrollPane.getVerticalScrollBar().setValue(0);
    }

    private final void scrollTo(int needTo) {
        if (this.useAnimation()) {
            this.stepAnimator.startAnimation(needTo);
        } else {
            this.scrollPane.getVerticalScrollBar().setValue(needTo);
        }
    }

    private final boolean useAnimation() {
        return Registry.Companion.is("ift.use.scroll.animation", false);
    }

    private static final void createFooterPanel$lambda$1(String $link, Lesson $lesson, LinkLabel linkLabel, Object object) {
        UtilsKt.openLinkInBrowser($link);
        StatisticBase.INSTANCE.logHelpLinkClicked($lesson.getId());
    }

    private static final void createHeaderPanel$lambda$0(LinkLabel linkLabel, Object object) {
        StatisticBase.INSTANCE.logLessonStopped(StatisticBase.LessonStopReason.OPEN_MODULES);
        LessonManager.Companion.getInstance().stopLesson();
        LearningUiManager.INSTANCE.resetModulesView();
    }

    private static final void createNavigationButton$lambda$0(JButton $button) {
        $button.setEnabled(true);
        $button.setToolTipText("");
        $button.setSelected(true);
    }
}

