/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.packagesearch.packageversionutils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \n2\u00020\u0001:\u0003\b\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher;", "", "<init>", "()V", "matches", "", "value", "", "SubstringMatcher", "RegexMatcher", "Companion", "Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher$RegexMatcher;", "Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher$SubstringMatcher;", "version-utils"})
public abstract class VersionTokenMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private VersionTokenMatcher() {
    }

    public abstract boolean matches(@NotNull String var1);

    public /* synthetic */ VersionTokenMatcher(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher$Companion;", "", "<init>", "()V", "substring", "Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher$SubstringMatcher;", "toMatch", "", "regex", "Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher$RegexMatcher;", "Lkotlin/text/Regex;", "unstableTokens", "", "Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher;", "getUnstableTokens", "()Ljava/util/List;", "version-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SubstringMatcher substring(@NotNull String toMatch) {
            Intrinsics.checkNotNullParameter((Object)toMatch, (String)"toMatch");
            return new SubstringMatcher(toMatch);
        }

        @NotNull
        public final RegexMatcher regex(@NotNull Regex regex) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            return new RegexMatcher(regex);
        }

        @NotNull
        public final List<VersionTokenMatcher> getUnstableTokens() {
            Object[] objectArray = new VersionTokenMatcher[]{this.substring("alpha"), this.substring("beta"), this.substring("bate"), this.substring("commit"), this.substring("unofficial"), this.substring("exp"), this.substring("experiment"), this.substring("experimental"), this.substring("milestone"), this.substring("deprecated"), this.substring("rc"), this.substring("rctest"), this.substring("cr"), this.substring("draft"), this.substring("ignored"), this.substring("test"), this.substring("placeholder"), this.substring("incubating"), this.substring("nightly"), this.substring("weekly"), this.substring("master"), this.substring("main"), this.regex(new Regex("\\b(rel(ease)?[.\\-_]?)?candidate\\b", RegexOption.IGNORE_CASE)), this.regex(new Regex("\\br?dev(elop(ment)?)?\\b", RegexOption.IGNORE_CASE)), this.regex(new Regex("\\beap?\\b", RegexOption.IGNORE_CASE)), this.regex(new Regex("pre(view)?\\b", RegexOption.IGNORE_CASE)), this.regex(new Regex("\\bsnap(s?shot)?\\b", RegexOption.IGNORE_CASE))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher$RegexMatcher;", "Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher;", "regex", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "getRegex", "()Lkotlin/text/Regex;", "matches", "", "value", "", "version-utils"})
    public static final class RegexMatcher
    extends VersionTokenMatcher {
        @NotNull
        private final Regex regex;

        public RegexMatcher(@NotNull Regex regex) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            super(null);
            this.regex = regex;
        }

        @NotNull
        public final Regex getRegex() {
            return this.regex;
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.regex.containsMatchIn((CharSequence)value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher$SubstringMatcher;", "Lorg/jetbrains/packagesearch/packageversionutils/VersionTokenMatcher;", "toMatch", "", "<init>", "(Ljava/lang/String;)V", "getToMatch", "()Ljava/lang/String;", "toMatchLength", "", "matches", "", "value", "version-utils"})
    public static final class SubstringMatcher
    extends VersionTokenMatcher {
        @NotNull
        private final String toMatch;
        private final int toMatchLength;

        public SubstringMatcher(@NotNull String toMatch) {
            Intrinsics.checkNotNullParameter((Object)toMatch, (String)"toMatch");
            super(null);
            this.toMatch = toMatch;
            this.toMatchLength = this.toMatch.length();
        }

        @NotNull
        public final String getToMatch() {
            return this.toMatch;
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int substringIndex = StringsKt.indexOf$default((CharSequence)value, (String)this.toMatch, (int)0, (boolean)true, (int)2, null);
            if (substringIndex < 0) {
                return false;
            }
            int afterSubstringIndex = substringIndex + this.toMatchLength;
            int valueLength = value.length();
            if (substringIndex == 0 && afterSubstringIndex == valueLength) {
                return true;
            }
            if (substringIndex == 0) {
                char nextLetter = value.charAt(afterSubstringIndex);
                return !Character.isLetter(nextLetter);
            }
            if (afterSubstringIndex == valueLength) {
                char previousLetter = value.charAt(substringIndex - 1);
                return !Character.isLetterOrDigit(previousLetter) && previousLetter != '_';
            }
            char previousLetter = value.charAt(substringIndex - 1);
            boolean startsAtWordBoundary = !Character.isLetterOrDigit(previousLetter) && previousLetter != '_';
            char nextLetter = value.charAt(afterSubstringIndex);
            boolean endsAtWordBoundary = !Character.isLetter(nextLetter);
            return startsAtWordBoundary && endsAtWordBoundary;
        }
    }
}

