/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.gradle.api.internal.file.DefaultFileLookup;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.internal.ClientExecHandleBuilder;
import org.gradle.process.internal.ClientExecHandleBuilderFactory;
import org.gradle.process.internal.DefaultClientExecHandleBuilder;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DefaultClientExecHandleBuilderFactory
implements ClientExecHandleBuilderFactory {
    private final PathToFileResolver fileResolver;
    private final Executor executor;
    private final BuildCancellationToken buildCancellationToken;

    private DefaultClientExecHandleBuilderFactory(PathToFileResolver fileResolver, Executor executor, BuildCancellationToken buildCancellationToken) {
        this.fileResolver = fileResolver;
        this.executor = executor;
        this.buildCancellationToken = buildCancellationToken;
    }

    public ClientExecHandleBuilder newExecHandleBuilder() {
        return new DefaultClientExecHandleBuilder(this.fileResolver, this.executor, this.buildCancellationToken);
    }

    public static DefaultClientExecHandleBuilderFactory of(PathToFileResolver fileResolver, ExecutorFactory executorFactory, BuildCancellationToken buildCancellationToken) {
        ManagedExecutor executor = executorFactory.create("Exec process");
        return new DefaultClientExecHandleBuilderFactory(fileResolver, (Executor)executor, buildCancellationToken);
    }

    public static DefaultClientExecHandleBuilderFactory of(PathToFileResolver fileResolver, Executor executor, BuildCancellationToken buildCancellationToken) {
        return new DefaultClientExecHandleBuilderFactory(fileResolver, executor, buildCancellationToken);
    }

    @NullMarked
    public static class RootClientExecHandleBuilderFactory
    implements ClientExecHandleBuilderFactory,
    Stoppable {
        private final DefaultClientExecHandleBuilderFactory delegate;

        private RootClientExecHandleBuilderFactory(DefaultClientExecHandleBuilderFactory delegate) {
            this.delegate = delegate;
        }

        public ClientExecHandleBuilder newExecHandleBuilder() {
            return this.delegate.newExecHandleBuilder();
        }

        public void stop() {
            CompositeStoppable.stoppable((Object[])new Object[]{this.delegate.executor}).stop();
        }

        public static RootClientExecHandleBuilderFactory of(File gradleUserHome) {
            Objects.requireNonNull(gradleUserHome, "gradleUserHome");
            DefaultClientExecHandleBuilderFactory clientExecHandleBuilderFactory = DefaultClientExecHandleBuilderFactory.of((PathToFileResolver)new DefaultFileLookup().getFileResolver(), (ExecutorFactory)new DefaultExecutorFactory(), (BuildCancellationToken)new DefaultBuildCancellationToken());
            return new RootClientExecHandleBuilderFactory(clientExecHandleBuilderFactory);
        }
    }
}

