# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "lab wait",
)
class Wait(AAZWaitCommand):
    """Place the CLI in a waiting state until a condition is met.
    """

    _aaz_info = {
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.devtestlab/labs/{}", "2018-09-15"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["--name"],
            help="The name of the lab.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            help="Name of resource group. You can configure the default group using `az configure --defaults group=<name>`.",
            required=True,
        )
        _args_schema.expand = AAZStrArg(
            options=["--expand"],
            help="Specify the $expand query. Example: 'properties($select=defaultStorageAccount)'",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.LabsGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=False)
        return result

    class LabsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expand", self.ctx.args.expand,
                ),
                **self.serialize_query_param(
                    "api-version", "2018-09-15",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType()
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.announcement = AAZObjectType()
            properties.artifacts_storage_account = AAZStrType(
                serialized_name="artifactsStorageAccount",
                flags={"read_only": True},
            )
            properties.created_date = AAZStrType(
                serialized_name="createdDate",
                flags={"read_only": True},
            )
            properties.default_premium_storage_account = AAZStrType(
                serialized_name="defaultPremiumStorageAccount",
                flags={"read_only": True},
            )
            properties.default_storage_account = AAZStrType(
                serialized_name="defaultStorageAccount",
                flags={"read_only": True},
            )
            properties.environment_permission = AAZStrType(
                serialized_name="environmentPermission",
            )
            properties.extended_properties = AAZDictType(
                serialized_name="extendedProperties",
            )
            properties.lab_storage_type = AAZStrType(
                serialized_name="labStorageType",
            )
            properties.load_balancer_id = AAZStrType(
                serialized_name="loadBalancerId",
                flags={"read_only": True},
            )
            properties.mandatory_artifacts_resource_ids_linux = AAZListType(
                serialized_name="mandatoryArtifactsResourceIdsLinux",
            )
            properties.mandatory_artifacts_resource_ids_windows = AAZListType(
                serialized_name="mandatoryArtifactsResourceIdsWindows",
            )
            properties.network_security_group_id = AAZStrType(
                serialized_name="networkSecurityGroupId",
                flags={"read_only": True},
            )
            properties.premium_data_disk_storage_account = AAZStrType(
                serialized_name="premiumDataDiskStorageAccount",
                flags={"read_only": True},
            )
            properties.premium_data_disks = AAZStrType(
                serialized_name="premiumDataDisks",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.public_ip_id = AAZStrType(
                serialized_name="publicIpId",
                flags={"read_only": True},
            )
            properties.support = AAZObjectType()
            properties.unique_identifier = AAZStrType(
                serialized_name="uniqueIdentifier",
                flags={"read_only": True},
            )
            properties.vault_name = AAZStrType(
                serialized_name="vaultName",
                flags={"read_only": True},
            )
            properties.vm_creation_resource_group = AAZStrType(
                serialized_name="vmCreationResourceGroup",
                flags={"read_only": True},
            )

            announcement = cls._schema_on_200.properties.announcement
            announcement.enabled = AAZStrType()
            announcement.expiration_date = AAZStrType(
                serialized_name="expirationDate",
            )
            announcement.expired = AAZBoolType()
            announcement.markdown = AAZStrType()
            announcement.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            announcement.title = AAZStrType()
            announcement.unique_identifier = AAZStrType(
                serialized_name="uniqueIdentifier",
                flags={"read_only": True},
            )

            extended_properties = cls._schema_on_200.properties.extended_properties
            extended_properties.Element = AAZStrType()

            mandatory_artifacts_resource_ids_linux = cls._schema_on_200.properties.mandatory_artifacts_resource_ids_linux
            mandatory_artifacts_resource_ids_linux.Element = AAZStrType()

            mandatory_artifacts_resource_ids_windows = cls._schema_on_200.properties.mandatory_artifacts_resource_ids_windows
            mandatory_artifacts_resource_ids_windows.Element = AAZStrType()

            support = cls._schema_on_200.properties.support
            support.enabled = AAZStrType()
            support.markdown = AAZStrType()

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _WaitHelper:
    """Helper class for Wait"""


__all__ = ["Wait"]
