# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ...operations._operations import (
    build_template_spec_versions_create_or_update_request,
    build_template_spec_versions_delete_request,
    build_template_spec_versions_get_request,
    build_template_spec_versions_list_request,
    build_template_spec_versions_update_request,
    build_template_specs_create_or_update_request,
    build_template_specs_delete_request,
    build_template_specs_get_request,
    build_template_specs_list_by_resource_group_request,
    build_template_specs_list_by_subscription_request,
    build_template_specs_update_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class TemplateSpecsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.resource.templatespecs.v2021_03_01_preview.aio.TemplateSpecsClient`'s
        :attr:`template_specs` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec: _models.TemplateSpec,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TemplateSpec:
        """Creates or updates a Template Spec.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec: Template Spec supplied to the operation. Required.
        :type template_spec: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TemplateSpec or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TemplateSpec:
        """Creates or updates a Template Spec.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec: Template Spec supplied to the operation. Required.
        :type template_spec: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TemplateSpec or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec: Union[_models.TemplateSpec, IO[bytes]],
        **kwargs: Any
    ) -> _models.TemplateSpec:
        """Creates or updates a Template Spec.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec: Template Spec supplied to the operation. Is either a TemplateSpec type or
         a IO[bytes] type. Required.
        :type template_spec: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
         or IO[bytes]
        :return: TemplateSpec or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TemplateSpec] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(template_spec, (IOBase, bytes)):
            _content = template_spec
        else:
            _json = self._serialize.body(template_spec, "TemplateSpec")

        _request = build_template_specs_create_or_update_request(
            resource_group_name=resource_group_name,
            template_spec_name=template_spec_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TemplateSpec", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec: Optional[_models.TemplateSpecUpdateModel] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TemplateSpec:
        """Updates Template Spec tags with specified values.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec: Template Spec resource with the tags to be updated. Default value is
         None.
        :type template_spec:
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecUpdateModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TemplateSpec or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TemplateSpec:
        """Updates Template Spec tags with specified values.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec: Template Spec resource with the tags to be updated. Default value is
         None.
        :type template_spec: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TemplateSpec or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec: Optional[Union[_models.TemplateSpecUpdateModel, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.TemplateSpec:
        """Updates Template Spec tags with specified values.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec: Template Spec resource with the tags to be updated. Is either a
         TemplateSpecUpdateModel type or a IO[bytes] type. Default value is None.
        :type template_spec:
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecUpdateModel or
         IO[bytes]
        :return: TemplateSpec or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TemplateSpec] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(template_spec, (IOBase, bytes)):
            _content = template_spec
        else:
            if template_spec is not None:
                _json = self._serialize.body(template_spec, "TemplateSpecUpdateModel")
            else:
                _json = None

        _request = build_template_specs_update_request(
            resource_group_name=resource_group_name,
            template_spec_name=template_spec_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TemplateSpec", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        template_spec_name: str,
        expand: Optional[Union[str, _models.TemplateSpecExpandKind]] = None,
        **kwargs: Any
    ) -> _models.TemplateSpec:
        """Gets a Template Spec with a given name.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param expand: Allows for expansion of additional Template Spec details in the response.
         Optional. "versions" Default value is None.
        :type expand: str or
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecExpandKind
        :return: TemplateSpec or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        cls: ClsType[_models.TemplateSpec] = kwargs.pop("cls", None)

        _request = build_template_specs_get_request(
            resource_group_name=resource_group_name,
            template_spec_name=template_spec_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TemplateSpec", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, resource_group_name: str, template_spec_name: str, **kwargs: Any) -> None:
        """Deletes a Template Spec by name. When operation completes, status code 200 returned without
        content.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_template_specs_delete_request(
            resource_group_name=resource_group_name,
            template_spec_name=template_spec_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_by_subscription(
        self, expand: Optional[Union[str, _models.TemplateSpecExpandKind]] = None, **kwargs: Any
    ) -> AsyncIterable["_models.TemplateSpec"]:
        # pylint: disable=line-too-long
        """Lists all the Template Specs within the specified subscriptions.

        :param expand: Allows for expansion of additional Template Spec details in the response.
         Optional. "versions" Default value is None.
        :type expand: str or
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecExpandKind
        :return: An iterator like instance of either TemplateSpec or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        cls: ClsType[_models.TemplateSpecsListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_template_specs_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    expand=expand,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("TemplateSpecsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_resource_group(
        self,
        resource_group_name: str,
        expand: Optional[Union[str, _models.TemplateSpecExpandKind]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.TemplateSpec"]:
        # pylint: disable=line-too-long
        """Lists all the Template Specs within the specified resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param expand: Allows for expansion of additional Template Spec details in the response.
         Optional. "versions" Default value is None.
        :type expand: str or
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecExpandKind
        :return: An iterator like instance of either TemplateSpec or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpec]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        cls: ClsType[_models.TemplateSpecsListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_template_specs_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    expand=expand,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("TemplateSpecsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class TemplateSpecVersionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.resource.templatespecs.v2021_03_01_preview.aio.TemplateSpecsClient`'s
        :attr:`template_spec_versions` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec_version: str,
        template_spec_version_model: _models.TemplateSpecVersion,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TemplateSpecVersion:
        """Creates or updates a Template Spec version.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec_version: The version of the Template Spec. Required.
        :type template_spec_version: str
        :param template_spec_version_model: Template Spec Version supplied to the operation. Required.
        :type template_spec_version_model:
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TemplateSpecVersion or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec_version: str,
        template_spec_version_model: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TemplateSpecVersion:
        """Creates or updates a Template Spec version.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec_version: The version of the Template Spec. Required.
        :type template_spec_version: str
        :param template_spec_version_model: Template Spec Version supplied to the operation. Required.
        :type template_spec_version_model: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TemplateSpecVersion or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec_version: str,
        template_spec_version_model: Union[_models.TemplateSpecVersion, IO[bytes]],
        **kwargs: Any
    ) -> _models.TemplateSpecVersion:
        """Creates or updates a Template Spec version.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec_version: The version of the Template Spec. Required.
        :type template_spec_version: str
        :param template_spec_version_model: Template Spec Version supplied to the operation. Is either
         a TemplateSpecVersion type or a IO[bytes] type. Required.
        :type template_spec_version_model:
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion or IO[bytes]
        :return: TemplateSpecVersion or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TemplateSpecVersion] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(template_spec_version_model, (IOBase, bytes)):
            _content = template_spec_version_model
        else:
            _json = self._serialize.body(template_spec_version_model, "TemplateSpecVersion")

        _request = build_template_spec_versions_create_or_update_request(
            resource_group_name=resource_group_name,
            template_spec_name=template_spec_name,
            template_spec_version=template_spec_version,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TemplateSpecVersion", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec_version: str,
        template_spec_version_update_model: Optional[_models.TemplateSpecVersionUpdateModel] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TemplateSpecVersion:
        """Updates Template Spec Version tags with specified values.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec_version: The version of the Template Spec. Required.
        :type template_spec_version: str
        :param template_spec_version_update_model: Template Spec Version resource with the tags to be
         updated. Default value is None.
        :type template_spec_version_update_model:
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersionUpdateModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TemplateSpecVersion or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec_version: str,
        template_spec_version_update_model: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TemplateSpecVersion:
        """Updates Template Spec Version tags with specified values.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec_version: The version of the Template Spec. Required.
        :type template_spec_version: str
        :param template_spec_version_update_model: Template Spec Version resource with the tags to be
         updated. Default value is None.
        :type template_spec_version_update_model: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TemplateSpecVersion or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        template_spec_name: str,
        template_spec_version: str,
        template_spec_version_update_model: Optional[Union[_models.TemplateSpecVersionUpdateModel, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.TemplateSpecVersion:
        """Updates Template Spec Version tags with specified values.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec_version: The version of the Template Spec. Required.
        :type template_spec_version: str
        :param template_spec_version_update_model: Template Spec Version resource with the tags to be
         updated. Is either a TemplateSpecVersionUpdateModel type or a IO[bytes] type. Default value is
         None.
        :type template_spec_version_update_model:
         ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersionUpdateModel or
         IO[bytes]
        :return: TemplateSpecVersion or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TemplateSpecVersion] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(template_spec_version_update_model, (IOBase, bytes)):
            _content = template_spec_version_update_model
        else:
            if template_spec_version_update_model is not None:
                _json = self._serialize.body(template_spec_version_update_model, "TemplateSpecVersionUpdateModel")
            else:
                _json = None

        _request = build_template_spec_versions_update_request(
            resource_group_name=resource_group_name,
            template_spec_name=template_spec_name,
            template_spec_version=template_spec_version,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TemplateSpecVersion", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, template_spec_name: str, template_spec_version: str, **kwargs: Any
    ) -> _models.TemplateSpecVersion:
        """Gets a Template Spec version from a specific Template Spec.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec_version: The version of the Template Spec. Required.
        :type template_spec_version: str
        :return: TemplateSpecVersion or the result of cls(response)
        :rtype: ~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        cls: ClsType[_models.TemplateSpecVersion] = kwargs.pop("cls", None)

        _request = build_template_spec_versions_get_request(
            resource_group_name=resource_group_name,
            template_spec_name=template_spec_name,
            template_spec_version=template_spec_version,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TemplateSpecVersion", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(
        self, resource_group_name: str, template_spec_name: str, template_spec_version: str, **kwargs: Any
    ) -> None:
        """Deletes a specific version from a Template Spec. When operation completes, status code 200
        returned without content.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :param template_spec_version: The version of the Template Spec. Required.
        :type template_spec_version: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_template_spec_versions_delete_request(
            resource_group_name=resource_group_name,
            template_spec_name=template_spec_name,
            template_spec_version=template_spec_version,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list(
        self, resource_group_name: str, template_spec_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.TemplateSpecVersion"]:
        # pylint: disable=line-too-long
        """Lists all the Template Spec versions in the specified Template Spec.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param template_spec_name: Name of the Template Spec. Required.
        :type template_spec_name: str
        :return: An iterator like instance of either TemplateSpecVersion or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.templatespecs.v2021_03_01_preview.models.TemplateSpecVersion]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2021-03-01-preview")
        )
        cls: ClsType[_models.TemplateSpecVersionsListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_template_spec_versions_list_request(
                    resource_group_name=resource_group_name,
                    template_spec_name=template_spec_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("TemplateSpecVersionsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.TemplateSpecsError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
