﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-idp/CognitoIdentityProvider_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace CognitoIdentityProvider {
namespace Model {
enum class LogLevel { NOT_SET, ERROR_, INFO };

namespace LogLevelMapper {
AWS_COGNITOIDENTITYPROVIDER_API LogLevel GetLogLevelForName(const Aws::String& name);

AWS_COGNITOIDENTITYPROVIDER_API Aws::String GetNameForLogLevel(LogLevel value);
}  // namespace LogLevelMapper
}  // namespace Model
}  // namespace CognitoIdentityProvider
}  // namespace Aws
