﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iotwireless/IoTWireless_EXPORTS.h>
#include <aws/iotwireless/model/LoRaWANMulticastMetadata.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTWireless {
namespace Model {

/**
 * <p>Wireless metadata that is to be sent to multicast group.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/MulticastWirelessMetadata">AWS
 * API Reference</a></p>
 */
class MulticastWirelessMetadata {
 public:
  AWS_IOTWIRELESS_API MulticastWirelessMetadata() = default;
  AWS_IOTWIRELESS_API MulticastWirelessMetadata(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTWIRELESS_API MulticastWirelessMetadata& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTWIRELESS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const LoRaWANMulticastMetadata& GetLoRaWAN() const { return m_loRaWAN; }
  inline bool LoRaWANHasBeenSet() const { return m_loRaWANHasBeenSet; }
  template <typename LoRaWANT = LoRaWANMulticastMetadata>
  void SetLoRaWAN(LoRaWANT&& value) {
    m_loRaWANHasBeenSet = true;
    m_loRaWAN = std::forward<LoRaWANT>(value);
  }
  template <typename LoRaWANT = LoRaWANMulticastMetadata>
  MulticastWirelessMetadata& WithLoRaWAN(LoRaWANT&& value) {
    SetLoRaWAN(std::forward<LoRaWANT>(value));
    return *this;
  }
  ///@}
 private:
  LoRaWANMulticastMetadata m_loRaWAN;
  bool m_loRaWANHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTWireless
}  // namespace Aws
