/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// ListenerApplyConfiguration represents a declarative configuration of the Listener type for use
// with apply.
type ListenerApplyConfiguration struct {
	Name          *apisv1.SectionName                 `json:"name,omitempty"`
	Hostname      *apisv1.Hostname                    `json:"hostname,omitempty"`
	Port          *apisv1.PortNumber                  `json:"port,omitempty"`
	Protocol      *apisv1.ProtocolType                `json:"protocol,omitempty"`
	TLS           *GatewayTLSConfigApplyConfiguration `json:"tls,omitempty"`
	AllowedRoutes *AllowedRoutesApplyConfiguration    `json:"allowedRoutes,omitempty"`
}

// ListenerApplyConfiguration constructs a declarative configuration of the Listener type for use with
// apply.
func Listener() *ListenerApplyConfiguration {
	return &ListenerApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ListenerApplyConfiguration) WithName(value apisv1.SectionName) *ListenerApplyConfiguration {
	b.Name = &value
	return b
}

// WithHostname sets the Hostname field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Hostname field is set to the value of the last call.
func (b *ListenerApplyConfiguration) WithHostname(value apisv1.Hostname) *ListenerApplyConfiguration {
	b.Hostname = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *ListenerApplyConfiguration) WithPort(value apisv1.PortNumber) *ListenerApplyConfiguration {
	b.Port = &value
	return b
}

// WithProtocol sets the Protocol field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Protocol field is set to the value of the last call.
func (b *ListenerApplyConfiguration) WithProtocol(value apisv1.ProtocolType) *ListenerApplyConfiguration {
	b.Protocol = &value
	return b
}

// WithTLS sets the TLS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLS field is set to the value of the last call.
func (b *ListenerApplyConfiguration) WithTLS(value *GatewayTLSConfigApplyConfiguration) *ListenerApplyConfiguration {
	b.TLS = value
	return b
}

// WithAllowedRoutes sets the AllowedRoutes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllowedRoutes field is set to the value of the last call.
func (b *ListenerApplyConfiguration) WithAllowedRoutes(value *AllowedRoutesApplyConfiguration) *ListenerApplyConfiguration {
	b.AllowedRoutes = value
	return b
}
