// Copyright Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: telemetry/v1alpha1/telemetry.proto

// $schema: istio.telemetry.v1alpha1.Telemetry
// $title: Telemetry
// $description: Telemetry configuration for workloads.
// $location: https://istio.io/docs/reference/config/telemetry.html
// $aliases: [/docs/reference/config/telemetry/v1alpha1/telemetry]
// $weight: 45

// `Telemetry` defines how telemetry (metrics, logs and traces)
// is generated for workloads within a mesh.
//
// The hierarchy of Telemetry configuration is as follows:
//
// 1. Workload-specific configuration
// 2. Namespace-specific configuration
// 3. Root namespace configuration
//
// For mesh level configuration, put a resource in the root configuration
// namespace for your Istio installation *without* a workload selector.
//
// For any namespace, including the root configuration namespace, it is only
// valid to have a single workload selector-less Telemetry resource.
//
// For resources with a workload selector, it is only valid to have one resource
// selecting any given workload.
//
// Gateways and waypoints are targeted for telemetry configuration
// using the `targetRefs` field.
//
// Examples:
//
// Enable random sampling for 10% of traffic:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: mesh-default
//   namespace: istio-system
// spec:
//   # no selector specified, applies to all workloads
//   tracing:
//   - randomSamplingPercentage: 10.00
// ```
//
// Disable trace reporting for the `foo` workload
// (note: tracing context will still be propagated):
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: foo-tracing
//   namespace: bar
// spec:
//   selector:
//     matchLabels:
//       service.istio.io/canonical-name: foo
//   tracing:
//   - disableSpanReporting: true
// ```
//
// Select a named tracing provider for trace reporting:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: foo-tracing-alternate
//   namespace: baz
// spec:
//   selector:
//     matchLabels:
//       service.istio.io/canonical-name: foo
//   tracing:
//   - providers:
//     - name: "zipkin-alternate"
//     randomSamplingPercentage: 10.00
// ```
//
// Tailor the "zipkin" provider to sample traces from client workloads only:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: mesh-default
//   namespace: istio-system
// spec:
//   # no selector specified, applies to all workloads
//   tracing:
//   - match: CLIENT
//   - providers:
//     - name: "zipkin"
// ```
//
// Add a custom tag from a literal value:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: mesh-default
//   namespace: istio-system
// spec:
//   # no selector specified, applies to all workloads
//   tracing:
//   - randomSamplingPercentage: 10.00
//     customTags:
//       my_new_foo_tag:
//         literal:
//           value: "foo"
// ```
//
// Disable server-side metrics for Prometheus for an entire mesh:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: mesh-default
//   namespace: istio-system
// spec:
//   # no selector specified, applies to all workloads
//   metrics:
//   - providers:
//     - name: prometheus
//     overrides:
//     - match:
//         metric: ALL_METRICS
//         mode: SERVER
//       disabled: true
// ```
//
// Add dimensions to all Prometheus metrics for the `foo` namespace:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: namespace-metrics
//   namespace: foo
// spec:
//   # no selector specified, applies to all workloads in the namespace
//   metrics:
//   - providers:
//     - name: prometheus
//     overrides:
//     # match clause left off matches all istio metrics, client and server
//     - tagOverrides:
//         request_method:
//           value: "request.method"
//         request_host:
//           value: "request.host"
// ```
//
// Remove the `response_code` dimension on some Prometheus metrics for
// the `bar.foo` workload:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: remove-response-code
//   namespace: foo
// spec:
//   selector:
//     matchLabels:
//       service.istio.io/canonical-name: bar
//   metrics:
//   - providers:
//     - name: prometheus
//     overrides:
//     - match:
//         metric: REQUEST_COUNT
//       tagOverrides:
//         response_code:
//           operation: REMOVE
//     - match:
//         metric: REQUEST_DURATION
//       tagOverrides:
//         response_code:
//           operation: REMOVE
//     - match:
//         metric: REQUEST_SIZE
//       tagOverrides:
//         response_code:
//           operation: REMOVE
//     - match:
//         metric: RESPONSE_SIZE
//       tagOverrides:
//         response_code:
//           operation: REMOVE
// ```
//
// Enable access logging for the entire mesh:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: mesh-default
//   namespace: istio-system
// spec:
//   # no selector specified, applies to all workloads
//   accessLogging:
//   - providers:
//     - name: envoy
//     # By default, this turns on access logging (no need to set `disabled: false`).
//     # Unspecified `disabled` will be treated as `disabled: false`, except in
//     # cases where a parent configuration has marked as `disabled: true`. In
//     # those cases, `disabled: false` must be set explicitly to override.
// ```
//
// Disable access logging for the `foo` namespace:
// ```yaml
// apiVersion: telemetry.istio.io/v1
// kind: Telemetry
// metadata:
//   name: namespace-no-log
//   namespace: foo
// spec:
//   # no selector specified, applies to all workloads in the namespace
//   accessLogging:
//   - disabled: true
// ```
//

package v1alpha1

import (
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1beta1 "istio.io/api/type/v1beta1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// WorkloadMode allows selection of the role of the underlying workload in
// network traffic. A workload is considered as acting as a `SERVER` if it is
// the destination of the traffic (that is, traffic direction, from the
// perspective of the workload is *inbound*). If the workload is the source of
// the network traffic, it is considered to be in `CLIENT` mode (traffic is
// *outbound* from the workload).
type WorkloadMode int32

const (
	// Selects for scenarios when the workload is either the
	// source or destination of the network traffic.
	WorkloadMode_CLIENT_AND_SERVER WorkloadMode = 0
	// Selects for scenarios when the workload is the
	// source of the network traffic.
	WorkloadMode_CLIENT WorkloadMode = 1
	// Selects for scenarios when the workload is the
	// destination of the network traffic.
	WorkloadMode_SERVER WorkloadMode = 2
)

// Enum value maps for WorkloadMode.
var (
	WorkloadMode_name = map[int32]string{
		0: "CLIENT_AND_SERVER",
		1: "CLIENT",
		2: "SERVER",
	}
	WorkloadMode_value = map[string]int32{
		"CLIENT_AND_SERVER": 0,
		"CLIENT":            1,
		"SERVER":            2,
	}
)

func (x WorkloadMode) Enum() *WorkloadMode {
	p := new(WorkloadMode)
	*p = x
	return p
}

func (x WorkloadMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadMode) Descriptor() protoreflect.EnumDescriptor {
	return file_telemetry_v1alpha1_telemetry_proto_enumTypes[0].Descriptor()
}

func (WorkloadMode) Type() protoreflect.EnumType {
	return &file_telemetry_v1alpha1_telemetry_proto_enumTypes[0]
}

func (x WorkloadMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadMode.Descriptor instead.
func (WorkloadMode) EnumDescriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{0}
}

// Curated list of known metric types that is supported by Istio metric
// providers. See also:
// https://istio.io/latest/docs/reference/config/metrics/#metrics
type MetricSelector_IstioMetric int32

const (
	// Use of this enum indicates that the override should apply to all Istio
	// default metrics.
	MetricSelector_ALL_METRICS MetricSelector_IstioMetric = 0
	// Counter of requests to/from an application, generated for HTTP, HTTP/2,
	// and GRPC traffic.
	//
	// The Prometheus provider exports this metric as: `istio_requests_total`.
	//
	// The Stackdriver provider exports this metric as:
	//
	// - `istio.io/service/server/request_count` (SERVER mode)
	// - `istio.io/service/client/request_count` (CLIENT mode)
	MetricSelector_REQUEST_COUNT MetricSelector_IstioMetric = 1
	// Histogram of request durations, generated for HTTP, HTTP/2, and GRPC
	// traffic.
	//
	// The Prometheus provider exports this metric as:
	// `istio_request_duration_milliseconds`.
	//
	// The Stackdriver provider exports this metric as:
	//
	// - `istio.io/service/server/response_latencies` (SERVER mode)
	// - `istio.io/service/client/roundtrip_latencies` (CLIENT mode)
	MetricSelector_REQUEST_DURATION MetricSelector_IstioMetric = 2
	// Histogram of request body sizes, generated for HTTP, HTTP/2, and GRPC
	// traffic.
	//
	// The Prometheus provider exports this metric as: `istio_request_bytes`.
	//
	// The Stackdriver provider exports this metric as:
	//
	// - `istio.io/service/server/request_bytes` (SERVER mode)
	// - `istio.io/service/client/request_bytes` (CLIENT mode)
	MetricSelector_REQUEST_SIZE MetricSelector_IstioMetric = 3
	// Histogram of response body sizes, generated for HTTP, HTTP/2, and GRPC
	// traffic.
	//
	// The Prometheus provider exports this metric as: `istio_response_bytes`.
	//
	// The Stackdriver provider exports this metric as:
	//
	// - `istio.io/service/server/response_bytes` (SERVER mode)
	// - `istio.io/service/client/response_bytes` (CLIENT mode)
	MetricSelector_RESPONSE_SIZE MetricSelector_IstioMetric = 4
	// Counter of TCP connections opened over lifetime of workload.
	//
	// The Prometheus provider exports this metric as:
	// `istio_tcp_connections_opened_total`.
	//
	// The Stackdriver provider exports this metric as:
	//
	// - `istio.io/service/server/connection_open_count` (SERVER mode)
	// - `istio.io/service/client/connection_open_count` (CLIENT mode)
	MetricSelector_TCP_OPENED_CONNECTIONS MetricSelector_IstioMetric = 5
	// Counter of TCP connections closed over lifetime of workload.
	//
	// The Prometheus provider exports this metric as:
	// `istio_tcp_connections_closed_total`.
	//
	// The Stackdriver provider exports this metric as:
	//
	// - `istio.io/service/server/connection_close_count` (SERVER mode)
	// - `istio.io/service/client/connection_close_count` (CLIENT mode)
	MetricSelector_TCP_CLOSED_CONNECTIONS MetricSelector_IstioMetric = 6
	// Counter of bytes sent during a response over a TCP connection.
	//
	// The Prometheus provider exports this metric as:
	// `istio_tcp_sent_bytes_total`.
	//
	// The Stackdriver provider exports this metric as:
	//
	// - `istio.io/service/server/sent_bytes_count` (SERVER mode)
	// - `istio.io/service/client/sent_bytes_count` (CLIENT mode)
	MetricSelector_TCP_SENT_BYTES MetricSelector_IstioMetric = 7
	// Counter of bytes received during a request over a TCP connection.
	//
	// The Prometheus provider exports this metric as:
	// `istio_tcp_received_bytes_total`.
	//
	// The Stackdriver provider exports this metric as:
	//
	// - `istio.io/service/server/received_bytes_count` (SERVER mode)
	// - `istio.io/service/client/received_bytes_count` (CLIENT mode)
	MetricSelector_TCP_RECEIVED_BYTES MetricSelector_IstioMetric = 8
	// Counter incremented for every gRPC messages sent from a client.
	//
	// The Prometheus provider exports this metric as:
	// `istio_request_messages_total`
	MetricSelector_GRPC_REQUEST_MESSAGES MetricSelector_IstioMetric = 9
	// Counter incremented for every gRPC messages sent from a server.
	//
	// The Prometheus provider exports this metric as:
	// `istio_response_messages_total`
	MetricSelector_GRPC_RESPONSE_MESSAGES MetricSelector_IstioMetric = 10
)

// Enum value maps for MetricSelector_IstioMetric.
var (
	MetricSelector_IstioMetric_name = map[int32]string{
		0:  "ALL_METRICS",
		1:  "REQUEST_COUNT",
		2:  "REQUEST_DURATION",
		3:  "REQUEST_SIZE",
		4:  "RESPONSE_SIZE",
		5:  "TCP_OPENED_CONNECTIONS",
		6:  "TCP_CLOSED_CONNECTIONS",
		7:  "TCP_SENT_BYTES",
		8:  "TCP_RECEIVED_BYTES",
		9:  "GRPC_REQUEST_MESSAGES",
		10: "GRPC_RESPONSE_MESSAGES",
	}
	MetricSelector_IstioMetric_value = map[string]int32{
		"ALL_METRICS":            0,
		"REQUEST_COUNT":          1,
		"REQUEST_DURATION":       2,
		"REQUEST_SIZE":           3,
		"RESPONSE_SIZE":          4,
		"TCP_OPENED_CONNECTIONS": 5,
		"TCP_CLOSED_CONNECTIONS": 6,
		"TCP_SENT_BYTES":         7,
		"TCP_RECEIVED_BYTES":     8,
		"GRPC_REQUEST_MESSAGES":  9,
		"GRPC_RESPONSE_MESSAGES": 10,
	}
)

func (x MetricSelector_IstioMetric) Enum() *MetricSelector_IstioMetric {
	p := new(MetricSelector_IstioMetric)
	*p = x
	return p
}

func (x MetricSelector_IstioMetric) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricSelector_IstioMetric) Descriptor() protoreflect.EnumDescriptor {
	return file_telemetry_v1alpha1_telemetry_proto_enumTypes[1].Descriptor()
}

func (MetricSelector_IstioMetric) Type() protoreflect.EnumType {
	return &file_telemetry_v1alpha1_telemetry_proto_enumTypes[1]
}

func (x MetricSelector_IstioMetric) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricSelector_IstioMetric.Descriptor instead.
func (MetricSelector_IstioMetric) EnumDescriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{4, 0}
}

type MetricsOverrides_TagOverride_Operation int32

const (
	// Insert or Update the tag with the provided value expression. The
	// `value` field MUST be specified if `UPSERT` is used as the operation.
	MetricsOverrides_TagOverride_UPSERT MetricsOverrides_TagOverride_Operation = 0
	// Specifies that the tag should not be included in the metric when
	// generated.
	MetricsOverrides_TagOverride_REMOVE MetricsOverrides_TagOverride_Operation = 1
)

// Enum value maps for MetricsOverrides_TagOverride_Operation.
var (
	MetricsOverrides_TagOverride_Operation_name = map[int32]string{
		0: "UPSERT",
		1: "REMOVE",
	}
	MetricsOverrides_TagOverride_Operation_value = map[string]int32{
		"UPSERT": 0,
		"REMOVE": 1,
	}
)

func (x MetricsOverrides_TagOverride_Operation) Enum() *MetricsOverrides_TagOverride_Operation {
	p := new(MetricsOverrides_TagOverride_Operation)
	*p = x
	return p
}

func (x MetricsOverrides_TagOverride_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricsOverrides_TagOverride_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_telemetry_v1alpha1_telemetry_proto_enumTypes[2].Descriptor()
}

func (MetricsOverrides_TagOverride_Operation) Type() protoreflect.EnumType {
	return &file_telemetry_v1alpha1_telemetry_proto_enumTypes[2]
}

func (x MetricsOverrides_TagOverride_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricsOverrides_TagOverride_Operation.Descriptor instead.
func (MetricsOverrides_TagOverride_Operation) EnumDescriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{5, 0, 0}
}

// <!-- crd generation tags
// +cue-gen:Telemetry:groupName:telemetry.istio.io
// +cue-gen:Telemetry:versions:v1alpha1,v1
// +cue-gen:Telemetry:storageVersion
// +cue-gen:Telemetry:annotations:helm.sh/resource-policy=keep
// +cue-gen:Telemetry:labels:app=istio-pilot,chart=istio,istio=telemetry,heritage=Tiller,release=istio
// +cue-gen:Telemetry:subresource:status
// +cue-gen:Telemetry:scope:Namespaced
// +cue-gen:Telemetry:resource:categories=istio-io,telemetry-istio-io,shortNames=telemetry,plural=telemetries
// +cue-gen:Telemetry:preserveUnknownFields:false
// +cue-gen:Telemetry:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp
// is a timestamp representing the server time when this object was created. It
// is not guaranteed to be set in happens-before order across separate
// operations. Clients may not set this value. It is represented in RFC3339 form
// and is in UTC. Populated by the system. Read-only. Null for lists. More info:
// https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=telemetry.istio.io/v1alpha1
// +genclient
// +k8s:deepcopy-gen=true
// -->
// +kubebuilder:validation:XValidation:message="only one of targetRefs or selector can be set",rule="oneof(self.selector, self.targetRef, self.targetRefs)"
type Telemetry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional. The selector decides where to apply the policy.
	// If not set, the policy will be applied to all workloads in the
	// same namespace as the policy.
	//
	// At most one of `selector` or `targetRefs` can be set for a given policy.
	Selector *v1beta1.WorkloadSelector `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// $hide_from_docs
	TargetRef *v1beta1.PolicyTargetReference `protobuf:"bytes,5,opt,name=targetRef,proto3" json:"targetRef,omitempty"`
	// Optional. The targetRefs specifies a list of resources the policy should be
	// applied to. The targeted resources specified will determine which workloads
	// the policy applies to.
	//
	// Currently, the following resource attachment types are supported:
	// * `kind: Gateway` with `group: gateway.networking.k8s.io` in the same namespace.
	// * `kind: GatewayClass` with `group: gateway.networking.k8s.io` in the root namespace.
	// * `kind: Service` with `group: ""` or `group: "core"` in the same namespace. This type is only supported for waypoints.
	// * `kind: ServiceEntry` with `group: networking.istio.io` in the same namespace.
	//
	// If not set, the policy is applied as defined by the selector.
	// At most one of the selector and targetRefs can be set.
	//
	// NOTE: If you are using the `targetRefs` field in a multi-revision environment with Istio versions prior to 1.22,
	// it is highly recommended that you pin the policy to a revision running 1.22+ via the `istio.io/rev` label.
	// This is to prevent proxies connected to older control planes (that don't know about the `targetRefs` field)
	// from misinterpreting the policy as namespace-wide during the upgrade process.
	//
	// NOTE: Waypoint proxies are required to use this field for policies to apply; `selector` policies will be ignored.
	// +kubebuilder:validation:MaxItems=16
	TargetRefs []*v1beta1.PolicyTargetReference `protobuf:"bytes,6,rep,name=targetRefs,proto3" json:"targetRefs,omitempty"`
	// Optional. Tracing configures the tracing behavior for all
	// selected workloads.
	Tracing []*Tracing `protobuf:"bytes,2,rep,name=tracing,proto3" json:"tracing,omitempty"`
	// Optional. Metrics configures the metrics behavior for all
	// selected workloads.
	Metrics []*Metrics `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Optional. Access logging configures the access logging behavior for all
	// selected workloads.
	AccessLogging []*AccessLogging `protobuf:"bytes,4,rep,name=access_logging,json=accessLogging,proto3" json:"access_logging,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Telemetry) Reset() {
	*x = Telemetry{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Telemetry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Telemetry) ProtoMessage() {}

func (x *Telemetry) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Telemetry.ProtoReflect.Descriptor instead.
func (*Telemetry) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{0}
}

func (x *Telemetry) GetSelector() *v1beta1.WorkloadSelector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *Telemetry) GetTargetRef() *v1beta1.PolicyTargetReference {
	if x != nil {
		return x.TargetRef
	}
	return nil
}

func (x *Telemetry) GetTargetRefs() []*v1beta1.PolicyTargetReference {
	if x != nil {
		return x.TargetRefs
	}
	return nil
}

func (x *Telemetry) GetTracing() []*Tracing {
	if x != nil {
		return x.Tracing
	}
	return nil
}

func (x *Telemetry) GetMetrics() []*Metrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *Telemetry) GetAccessLogging() []*AccessLogging {
	if x != nil {
		return x.AccessLogging
	}
	return nil
}

// Tracing configures tracing behavior for workloads within a mesh.
// It can be used to enable/disable tracing, as well as to set sampling
// rates and custom tag extraction.
//
// Tracing configuration support overrides of the fields `providers`,
// `random_sampling_percentage`, `disable_span_reporting`, and `custom_tags` at
// each level in the configuration hierarchy, with missing values filled in
// from parent resources. However, when specified, `custom_tags` will
// fully replace any values provided by parent configuration.
type Tracing struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Allows tailoring of behavior to specific conditions.
	Match *Tracing_TracingSelector `protobuf:"bytes,7,opt,name=match,proto3" json:"match,omitempty"`
	// Optional. Name of provider(s) to use for span reporting. If a provider is
	// not specified, the [default tracing
	// provider](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig-DefaultProviders) will be
	// used. NOTE: At the moment, only a single provider can be specified in a
	// given Tracing rule.
	Providers []*ProviderRef `protobuf:"bytes,2,rep,name=providers,proto3" json:"providers,omitempty"`
	// Controls the rate at which traffic will be selected for tracing if no
	// prior sampling decision has been made. If a prior sampling decision has
	// been made, that decision will be respected. However, if no sampling
	// decision has been made (example: no `x-b3-sampled` tracing header was
	// present in the requests), the traffic will be selected for telemetry
	// generation at the percentage specified.
	//
	// Defaults to 0%. Valid values [0.00-100.00]. Can be specified in 0.01%
	// increments.
	// +kubebuilder:validation:Minimum=0
	// +kubebuilder:validation:Maximum=100
	RandomSamplingPercentage *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=random_sampling_percentage,json=randomSamplingPercentage,proto3" json:"random_sampling_percentage,omitempty"`
	// Controls span reporting. If set to true, no spans will be reported for
	// impacted workloads. This does NOT impact context propagation or trace
	// sampling behavior.
	DisableSpanReporting *wrappers.BoolValue `protobuf:"bytes,4,opt,name=disable_span_reporting,json=disableSpanReporting,proto3" json:"disable_span_reporting,omitempty"`
	// Optional. Configures additional custom tags to the generated trace spans.
	CustomTags map[string]*Tracing_CustomTag `protobuf:"bytes,5,rep,name=custom_tags,json=customTags,proto3" json:"custom_tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// This value is true by default; Envoy decides whether or not to sample based
	// on the value of the Request ID generated by Ingress in distributed tracing.
	// The format of this Request ID is specific to Envoy, and if the Request ID
	// generated by the proxy that receives user traffic first is not specific to
	// Envoy, Envoy will break the trace because it cannot interpret the Request
	// ID. By setting this value to false, we can prevent Envoy from sampling
	// based on the Request ID. As a result, the trace will not be broken even if
	// the Request ID is not in the Envoy format. [Trace Context
	// Propagation](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/observability/tracing#trace-context-propagation)
	// provides more information on Request ID handling.
	// $hide_from_docs
	// +cue-gen:Telemetry:releaseChannel:extended
	UseRequestIdForTraceSampling *wrappers.BoolValue `protobuf:"bytes,6,opt,name=use_request_id_for_trace_sampling,json=useRequestIdForTraceSampling,proto3" json:"use_request_id_for_trace_sampling,omitempty"`
	// Determines whether or not trace spans generated by Envoy will include Istio specific tags.
	// By default Istio specific tags are included in the trace spans.
	EnableIstioTags *wrappers.BoolValue `protobuf:"bytes,8,opt,name=enable_istio_tags,json=enableIstioTags,proto3" json:"enable_istio_tags,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Tracing) Reset() {
	*x = Tracing{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing) ProtoMessage() {}

func (x *Tracing) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing.ProtoReflect.Descriptor instead.
func (*Tracing) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{1}
}

func (x *Tracing) GetMatch() *Tracing_TracingSelector {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *Tracing) GetProviders() []*ProviderRef {
	if x != nil {
		return x.Providers
	}
	return nil
}

func (x *Tracing) GetRandomSamplingPercentage() *wrappers.DoubleValue {
	if x != nil {
		return x.RandomSamplingPercentage
	}
	return nil
}

func (x *Tracing) GetDisableSpanReporting() *wrappers.BoolValue {
	if x != nil {
		return x.DisableSpanReporting
	}
	return nil
}

func (x *Tracing) GetCustomTags() map[string]*Tracing_CustomTag {
	if x != nil {
		return x.CustomTags
	}
	return nil
}

func (x *Tracing) GetUseRequestIdForTraceSampling() *wrappers.BoolValue {
	if x != nil {
		return x.UseRequestIdForTraceSampling
	}
	return nil
}

func (x *Tracing) GetEnableIstioTags() *wrappers.BoolValue {
	if x != nil {
		return x.EnableIstioTags
	}
	return nil
}

// Used to bind Telemetry configuration to specific providers for
// targeted customization.
type ProviderRef struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required. Name of Telemetry provider in [MeshConfig](https://istio.io/latest/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig-ExtensionProvider).
	// +kubebuilder:validation:MinLength=1
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProviderRef) Reset() {
	*x = ProviderRef{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProviderRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProviderRef) ProtoMessage() {}

func (x *ProviderRef) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProviderRef.ProtoReflect.Descriptor instead.
func (*ProviderRef) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{2}
}

func (x *ProviderRef) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metrics defines the workload-level overrides for metrics generation behavior
// within a mesh. It can be used to enable/disable metrics generation, as well
// as to customize the dimensions of the generated metrics.
type Metrics struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional. Name of providers to which this configuration should apply.
	// If a provider is not specified, the [default metrics
	// provider](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig-DefaultProviders) will be
	// used.
	Providers []*ProviderRef `protobuf:"bytes,1,rep,name=providers,proto3" json:"providers,omitempty"`
	// Optional. Ordered list of overrides to metrics generation behavior.
	//
	// Specified overrides will be applied in order. They will be applied on
	// top of inherited overrides from other resources in the hierarchy in the
	// following order:
	// 1. Mesh-scoped overrides
	// 2. Namespace-scoped overrides
	// 3. Workload-scoped overrides
	//
	// Because overrides are applied in order, users are advised to order their
	// overrides from least specific to most specific matches. That is, it is
	// a best practice to list any universal overrides first, with tailored
	// overrides following them.
	Overrides []*MetricsOverrides `protobuf:"bytes,2,rep,name=overrides,proto3" json:"overrides,omitempty"`
	// Optional. Reporting interval allows configuration of the time between calls out to for metrics reporting.
	// This currently only supports TCP metrics but we may use this for long duration HTTP streams in the future.
	// The default duration is `5s`.
	// +cue-gen:Telemetry:releaseChannel:extended
	ReportingInterval *duration.Duration `protobuf:"bytes,3,opt,name=reporting_interval,json=reportingInterval,proto3" json:"reporting_interval,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *Metrics) Reset() {
	*x = Metrics{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metrics) ProtoMessage() {}

func (x *Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metrics.ProtoReflect.Descriptor instead.
func (*Metrics) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{3}
}

func (x *Metrics) GetProviders() []*ProviderRef {
	if x != nil {
		return x.Providers
	}
	return nil
}

func (x *Metrics) GetOverrides() []*MetricsOverrides {
	if x != nil {
		return x.Overrides
	}
	return nil
}

func (x *Metrics) GetReportingInterval() *duration.Duration {
	if x != nil {
		return x.ReportingInterval
	}
	return nil
}

// Provides a mechanism for matching metrics for the application of override
// behaviors.
type MetricSelector struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls which metric(s) are selected by the selector.
	//
	// Types that are valid to be assigned to MetricMatch:
	//
	//	*MetricSelector_Metric
	//	*MetricSelector_CustomMetric
	MetricMatch isMetricSelector_MetricMatch `protobuf_oneof:"metric_match"`
	// Controls which mode of metrics generation is selected: `CLIENT`, `SERVER`,
	// or `CLIENT_AND_SERVER`.
	Mode          WorkloadMode `protobuf:"varint,3,opt,name=mode,proto3,enum=istio.telemetry.v1alpha1.WorkloadMode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetricSelector) Reset() {
	*x = MetricSelector{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricSelector) ProtoMessage() {}

func (x *MetricSelector) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricSelector.ProtoReflect.Descriptor instead.
func (*MetricSelector) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{4}
}

func (x *MetricSelector) GetMetricMatch() isMetricSelector_MetricMatch {
	if x != nil {
		return x.MetricMatch
	}
	return nil
}

func (x *MetricSelector) GetMetric() MetricSelector_IstioMetric {
	if x != nil {
		if x, ok := x.MetricMatch.(*MetricSelector_Metric); ok {
			return x.Metric
		}
	}
	return MetricSelector_ALL_METRICS
}

func (x *MetricSelector) GetCustomMetric() string {
	if x != nil {
		if x, ok := x.MetricMatch.(*MetricSelector_CustomMetric); ok {
			return x.CustomMetric
		}
	}
	return ""
}

func (x *MetricSelector) GetMode() WorkloadMode {
	if x != nil {
		return x.Mode
	}
	return WorkloadMode_CLIENT_AND_SERVER
}

type isMetricSelector_MetricMatch interface {
	isMetricSelector_MetricMatch()
}

type MetricSelector_Metric struct {
	// One of the well-known [Istio Standard Metrics](https://istio.io/latest/docs/reference/config/metrics/).
	Metric MetricSelector_IstioMetric `protobuf:"varint,1,opt,name=metric,proto3,enum=istio.telemetry.v1alpha1.MetricSelector_IstioMetric,oneof"`
}

type MetricSelector_CustomMetric struct {
	// Allows free-form specification of a metric. No validation of custom
	// metrics is provided.
	// +kubebuilder:validation:MinLength=1
	CustomMetric string `protobuf:"bytes,2,opt,name=custom_metric,json=customMetric,proto3,oneof"`
}

func (*MetricSelector_Metric) isMetricSelector_MetricMatch() {}

func (*MetricSelector_CustomMetric) isMetricSelector_MetricMatch() {}

// MetricsOverrides defines custom metric generation behavior for an individual
// metric or the set of all standard metrics.
type MetricsOverrides struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Match allows providing the scope of the override. It can be used to select
	// individual metrics, as well as the workload modes (server, client, or both)
	// in which the metrics will be generated.
	//
	// If match is not specified, the overrides will apply to *all* metrics for
	// *both* modes of operation (client and server).
	Match *MetricSelector `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// Optional. Must explicitly set this to `true` to turn off metrics reporting
	// for the listed metrics. If disabled has been set to `true` in a parent
	// configuration, it must explicitly be set to `false` to turn metrics
	// reporting on in the workloads selected by the Telemetry resource.
	Disabled *wrappers.BoolValue `protobuf:"bytes,2,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Optional. Collection of tag names and tag expressions to override in the
	// selected metric(s).
	// The key in the map is the name of the tag.
	// The value in the map is the operation to perform on the the tag.
	// WARNING: some providers may not support adding/removing tags.
	// See also: https://istio.io/latest/docs/reference/config/metrics/#labels
	TagOverrides  map[string]*MetricsOverrides_TagOverride `protobuf:"bytes,3,rep,name=tag_overrides,json=tagOverrides,proto3" json:"tag_overrides,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetricsOverrides) Reset() {
	*x = MetricsOverrides{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricsOverrides) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricsOverrides) ProtoMessage() {}

func (x *MetricsOverrides) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricsOverrides.ProtoReflect.Descriptor instead.
func (*MetricsOverrides) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{5}
}

func (x *MetricsOverrides) GetMatch() *MetricSelector {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *MetricsOverrides) GetDisabled() *wrappers.BoolValue {
	if x != nil {
		return x.Disabled
	}
	return nil
}

func (x *MetricsOverrides) GetTagOverrides() map[string]*MetricsOverrides_TagOverride {
	if x != nil {
		return x.TagOverrides
	}
	return nil
}

// Access logging defines the workload-level overrides for access log
// generation. It can be used to select provider or enable/disable access log
// generation for a workload.
type AccessLogging struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Allows tailoring of logging behavior to specific conditions.
	Match *AccessLogging_LogSelector `protobuf:"bytes,4,opt,name=match,proto3" json:"match,omitempty"`
	// Optional. Name of providers to which this configuration should apply.
	// If a provider is not specified, the [default logging
	// provider](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig-DefaultProviders) will be used.
	Providers []*ProviderRef `protobuf:"bytes,1,rep,name=providers,proto3" json:"providers,omitempty"`
	// Controls logging. If set to true, no access logs will be generated for
	// impacted workloads (for the specified providers).
	// NOTE: currently default behavior will be controlled by the provider(s)
	// selected above. Customization controls will be added to this API in
	// future releases.
	Disabled *wrappers.BoolValue `protobuf:"bytes,2,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Optional. If specified, this filter will be used to select specific
	// requests/connections for logging.
	// +cue-gen:Telemetry:releaseChannel:extended
	Filter        *AccessLogging_Filter `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AccessLogging) Reset() {
	*x = AccessLogging{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessLogging) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessLogging) ProtoMessage() {}

func (x *AccessLogging) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessLogging.ProtoReflect.Descriptor instead.
func (*AccessLogging) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{6}
}

func (x *AccessLogging) GetMatch() *AccessLogging_LogSelector {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *AccessLogging) GetProviders() []*ProviderRef {
	if x != nil {
		return x.Providers
	}
	return nil
}

func (x *AccessLogging) GetDisabled() *wrappers.BoolValue {
	if x != nil {
		return x.Disabled
	}
	return nil
}

func (x *AccessLogging) GetFilter() *AccessLogging_Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// TracingSelector provides a coarse-grained ability to configure tracing
// behavior based on certain traffic metadata (such as traffic direction).
type Tracing_TracingSelector struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This determines whether or not to apply the tracing configuration
	// based on the direction of traffic relative to the proxied workload.
	Mode          WorkloadMode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.telemetry.v1alpha1.WorkloadMode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_TracingSelector) Reset() {
	*x = Tracing_TracingSelector{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_TracingSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_TracingSelector) ProtoMessage() {}

func (x *Tracing_TracingSelector) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_TracingSelector.ProtoReflect.Descriptor instead.
func (*Tracing_TracingSelector) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Tracing_TracingSelector) GetMode() WorkloadMode {
	if x != nil {
		return x.Mode
	}
	return WorkloadMode_CLIENT_AND_SERVER
}

// CustomTag defines a tag to be added to a trace span that is based on
// an operator-supplied value. This value can either be a hard-coded value,
// a value taken from an environment variable known to the sidecar proxy, or
// from a request header.
//
// NOTE: when specified, `custom_tags` will fully replace any values provided
// by parent configuration.
type Tracing_CustomTag struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Type:
	//
	//	*Tracing_CustomTag_Literal
	//	*Tracing_CustomTag_Environment
	//	*Tracing_CustomTag_Header
	Type          isTracing_CustomTag_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_CustomTag) Reset() {
	*x = Tracing_CustomTag{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_CustomTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_CustomTag) ProtoMessage() {}

func (x *Tracing_CustomTag) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_CustomTag.ProtoReflect.Descriptor instead.
func (*Tracing_CustomTag) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Tracing_CustomTag) GetType() isTracing_CustomTag_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Tracing_CustomTag) GetLiteral() *Tracing_Literal {
	if x != nil {
		if x, ok := x.Type.(*Tracing_CustomTag_Literal); ok {
			return x.Literal
		}
	}
	return nil
}

func (x *Tracing_CustomTag) GetEnvironment() *Tracing_Environment {
	if x != nil {
		if x, ok := x.Type.(*Tracing_CustomTag_Environment); ok {
			return x.Environment
		}
	}
	return nil
}

func (x *Tracing_CustomTag) GetHeader() *Tracing_RequestHeader {
	if x != nil {
		if x, ok := x.Type.(*Tracing_CustomTag_Header); ok {
			return x.Header
		}
	}
	return nil
}

type isTracing_CustomTag_Type interface {
	isTracing_CustomTag_Type()
}

type Tracing_CustomTag_Literal struct {
	// Literal adds the same, hard-coded value to each span.
	Literal *Tracing_Literal `protobuf:"bytes,1,opt,name=literal,proto3,oneof"`
}

type Tracing_CustomTag_Environment struct {
	// Environment adds the value of an environment variable to each span.
	Environment *Tracing_Environment `protobuf:"bytes,2,opt,name=environment,proto3,oneof"`
}

type Tracing_CustomTag_Header struct {
	// RequestHeader adds the value of an header from the request to each
	// span.
	Header *Tracing_RequestHeader `protobuf:"bytes,3,opt,name=header,proto3,oneof"` // TODO: add support for Metadata tags
}

func (*Tracing_CustomTag_Literal) isTracing_CustomTag_Type() {}

func (*Tracing_CustomTag_Environment) isTracing_CustomTag_Type() {}

func (*Tracing_CustomTag_Header) isTracing_CustomTag_Type() {}

type Tracing_Literal struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The tag value to use.
	// +kubebuilder:validation:MinLength=1
	Value         string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_Literal) Reset() {
	*x = Tracing_Literal{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_Literal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_Literal) ProtoMessage() {}

func (x *Tracing_Literal) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_Literal.ProtoReflect.Descriptor instead.
func (*Tracing_Literal) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{1, 2}
}

func (x *Tracing_Literal) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type Tracing_Environment struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the environment variable from which to extract the tag value.
	// +kubebuilder:validation:MinLength=1
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the environment variable is not found, this value will be
	// used instead.
	DefaultValue  string `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_Environment) Reset() {
	*x = Tracing_Environment{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_Environment) ProtoMessage() {}

func (x *Tracing_Environment) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_Environment.ProtoReflect.Descriptor instead.
func (*Tracing_Environment) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{1, 3}
}

func (x *Tracing_Environment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tracing_Environment) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

type Tracing_RequestHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the header from which to extract the tag value.
	// +kubebuilder:validation:MinLength=1
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the header is not found, this value will be
	// used instead.
	DefaultValue  string `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_RequestHeader) Reset() {
	*x = Tracing_RequestHeader{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_RequestHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_RequestHeader) ProtoMessage() {}

func (x *Tracing_RequestHeader) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_RequestHeader.ProtoReflect.Descriptor instead.
func (*Tracing_RequestHeader) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{1, 4}
}

func (x *Tracing_RequestHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tracing_RequestHeader) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

// TagOverride specifies an operation to perform on a metric dimension (also
// known as a `label`). Tags may be added, removed, or have their default
// values overridden.
// +kubebuilder:validation:XValidation:message="value must be set when operation is UPSERT",rule="default(self.operation, ”) == 'UPSERT' ? self.value != ” : true"
// +kubebuilder:validation:XValidation:message="value must not be set when operation is REMOVE",rule="default(self.operation, ”) == 'REMOVE' ? !has(self.value) : true"
type MetricsOverrides_TagOverride struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Operation controls whether or not to update/add a tag, or to remove it.
	Operation MetricsOverrides_TagOverride_Operation `protobuf:"varint,1,opt,name=operation,proto3,enum=istio.telemetry.v1alpha1.MetricsOverrides_TagOverride_Operation" json:"operation,omitempty"`
	// Value is only considered if the operation is `UPSERT`.
	// Values are [CEL expressions](https://opensource.google/projects/cel) over
	// attributes. Examples include: `string(destination.port)` and
	// `request.host`. Istio exposes all standard [Envoy
	// attributes](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/advanced/attributes).
	// Additionally, Istio exposes node metadata as attributes.
	// More information is provided in the [customization
	// docs](https://istio.io/latest/docs/tasks/observability/metrics/customize-metrics/#use-expressions-for-values).
	Value         string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetricsOverrides_TagOverride) Reset() {
	*x = MetricsOverrides_TagOverride{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricsOverrides_TagOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricsOverrides_TagOverride) ProtoMessage() {}

func (x *MetricsOverrides_TagOverride) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricsOverrides_TagOverride.ProtoReflect.Descriptor instead.
func (*MetricsOverrides_TagOverride) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{5, 0}
}

func (x *MetricsOverrides_TagOverride) GetOperation() MetricsOverrides_TagOverride_Operation {
	if x != nil {
		return x.Operation
	}
	return MetricsOverrides_TagOverride_UPSERT
}

func (x *MetricsOverrides_TagOverride) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// LogSelector provides a coarse-grained ability to configure logging behavior
// based on certain traffic metadata (such as traffic direction). LogSelector
// applies to traffic metadata which is not represented in the attribute set
// currently supported by [filters](https://istio.io/latest/docs/reference/config/telemetry/#AccessLogging-Filter).
// It allows control planes to limit the configuration sent to individual workloads.
// Finer-grained logging behavior can be further configured via `filter`.
type AccessLogging_LogSelector struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This determines whether or not to apply the access logging configuration
	// based on the direction of traffic relative to the proxied workload.
	Mode          WorkloadMode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.telemetry.v1alpha1.WorkloadMode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AccessLogging_LogSelector) Reset() {
	*x = AccessLogging_LogSelector{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessLogging_LogSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessLogging_LogSelector) ProtoMessage() {}

func (x *AccessLogging_LogSelector) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessLogging_LogSelector.ProtoReflect.Descriptor instead.
func (*AccessLogging_LogSelector) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{6, 0}
}

func (x *AccessLogging_LogSelector) GetMode() WorkloadMode {
	if x != nil {
		return x.Mode
	}
	return WorkloadMode_CLIENT_AND_SERVER
}

// Allows specification of an access log filter.
type AccessLogging_Filter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// CEL expression for selecting when requests/connections should be logged.
	//
	// Examples:
	//
	// - `response.code >= 400`
	// - `connection.mtls && request.url_path.contains('v1beta3')`
	// - `!has(request.useragent) || !(request.useragent.startsWith("Amazon-Route53-Health-Check-Service"))`
	Expression    string `protobuf:"bytes,1,opt,name=expression,proto3" json:"expression,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AccessLogging_Filter) Reset() {
	*x = AccessLogging_Filter{}
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessLogging_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessLogging_Filter) ProtoMessage() {}

func (x *AccessLogging_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_telemetry_v1alpha1_telemetry_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessLogging_Filter.ProtoReflect.Descriptor instead.
func (*AccessLogging_Filter) Descriptor() ([]byte, []int) {
	return file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP(), []int{6, 1}
}

func (x *AccessLogging_Filter) GetExpression() string {
	if x != nil {
		return x.Expression
	}
	return ""
}

var File_telemetry_v1alpha1_telemetry_proto protoreflect.FileDescriptor

const file_telemetry_v1alpha1_telemetry_proto_rawDesc = "" +
	"\n" +
	"\"telemetry/v1alpha1/telemetry.proto\x12\x18istio.telemetry.v1alpha1\x1a\x1fgoogle/api/field_behavior.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1btype/v1beta1/selector.proto\"\xab\x03\n" +
	"\tTelemetry\x12@\n" +
	"\bselector\x18\x01 \x01(\v2$.istio.type.v1beta1.WorkloadSelectorR\bselector\x12G\n" +
	"\ttargetRef\x18\x05 \x01(\v2).istio.type.v1beta1.PolicyTargetReferenceR\ttargetRef\x12I\n" +
	"\n" +
	"targetRefs\x18\x06 \x03(\v2).istio.type.v1beta1.PolicyTargetReferenceR\n" +
	"targetRefs\x12;\n" +
	"\atracing\x18\x02 \x03(\v2!.istio.telemetry.v1alpha1.TracingR\atracing\x12;\n" +
	"\ametrics\x18\x03 \x03(\v2!.istio.telemetry.v1alpha1.MetricsR\ametrics\x12N\n" +
	"\x0eaccess_logging\x18\x04 \x03(\v2'.istio.telemetry.v1alpha1.AccessLoggingR\raccessLogging\"\xc1\t\n" +
	"\aTracing\x12G\n" +
	"\x05match\x18\a \x01(\v21.istio.telemetry.v1alpha1.Tracing.TracingSelectorR\x05match\x12C\n" +
	"\tproviders\x18\x02 \x03(\v2%.istio.telemetry.v1alpha1.ProviderRefR\tproviders\x12Z\n" +
	"\x1arandom_sampling_percentage\x18\x03 \x01(\v2\x1c.google.protobuf.DoubleValueR\x18randomSamplingPercentage\x12P\n" +
	"\x16disable_span_reporting\x18\x04 \x01(\v2\x1a.google.protobuf.BoolValueR\x14disableSpanReporting\x12R\n" +
	"\vcustom_tags\x18\x05 \x03(\v21.istio.telemetry.v1alpha1.Tracing.CustomTagsEntryR\n" +
	"customTags\x12c\n" +
	"!use_request_id_for_trace_sampling\x18\x06 \x01(\v2\x1a.google.protobuf.BoolValueR\x1cuseRequestIdForTraceSampling\x12F\n" +
	"\x11enable_istio_tags\x18\b \x01(\v2\x1a.google.protobuf.BoolValueR\x0fenableIstioTags\x1aM\n" +
	"\x0fTracingSelector\x12:\n" +
	"\x04mode\x18\x01 \x01(\x0e2&.istio.telemetry.v1alpha1.WorkloadModeR\x04mode\x1a\xf8\x01\n" +
	"\tCustomTag\x12E\n" +
	"\aliteral\x18\x01 \x01(\v2).istio.telemetry.v1alpha1.Tracing.LiteralH\x00R\aliteral\x12Q\n" +
	"\venvironment\x18\x02 \x01(\v2-.istio.telemetry.v1alpha1.Tracing.EnvironmentH\x00R\venvironment\x12I\n" +
	"\x06header\x18\x03 \x01(\v2/.istio.telemetry.v1alpha1.Tracing.RequestHeaderH\x00R\x06headerB\x06\n" +
	"\x04type\x1a%\n" +
	"\aLiteral\x12\x1a\n" +
	"\x05value\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x05value\x1aL\n" +
	"\vEnvironment\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04name\x12#\n" +
	"\rdefault_value\x18\x02 \x01(\tR\fdefaultValue\x1aN\n" +
	"\rRequestHeader\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04name\x12#\n" +
	"\rdefault_value\x18\x02 \x01(\tR\fdefaultValue\x1aj\n" +
	"\x0fCustomTagsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12A\n" +
	"\x05value\x18\x02 \x01(\v2+.istio.telemetry.v1alpha1.Tracing.CustomTagR\x05value:\x028\x01\"'\n" +
	"\vProviderRef\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04name\"\xe2\x01\n" +
	"\aMetrics\x12C\n" +
	"\tproviders\x18\x01 \x03(\v2%.istio.telemetry.v1alpha1.ProviderRefR\tproviders\x12H\n" +
	"\toverrides\x18\x02 \x03(\v2*.istio.telemetry.v1alpha1.MetricsOverridesR\toverrides\x12H\n" +
	"\x12reporting_interval\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\x11reportingInterval\"\xdd\x03\n" +
	"\x0eMetricSelector\x12N\n" +
	"\x06metric\x18\x01 \x01(\x0e24.istio.telemetry.v1alpha1.MetricSelector.IstioMetricH\x00R\x06metric\x12%\n" +
	"\rcustom_metric\x18\x02 \x01(\tH\x00R\fcustomMetric\x12:\n" +
	"\x04mode\x18\x03 \x01(\x0e2&.istio.telemetry.v1alpha1.WorkloadModeR\x04mode\"\x87\x02\n" +
	"\vIstioMetric\x12\x0f\n" +
	"\vALL_METRICS\x10\x00\x12\x11\n" +
	"\rREQUEST_COUNT\x10\x01\x12\x14\n" +
	"\x10REQUEST_DURATION\x10\x02\x12\x10\n" +
	"\fREQUEST_SIZE\x10\x03\x12\x11\n" +
	"\rRESPONSE_SIZE\x10\x04\x12\x1a\n" +
	"\x16TCP_OPENED_CONNECTIONS\x10\x05\x12\x1a\n" +
	"\x16TCP_CLOSED_CONNECTIONS\x10\x06\x12\x12\n" +
	"\x0eTCP_SENT_BYTES\x10\a\x12\x16\n" +
	"\x12TCP_RECEIVED_BYTES\x10\b\x12\x19\n" +
	"\x15GRPC_REQUEST_MESSAGES\x10\t\x12\x1a\n" +
	"\x16GRPC_RESPONSE_MESSAGES\x10\n" +
	"B\x0e\n" +
	"\fmetric_match\"\x91\x04\n" +
	"\x10MetricsOverrides\x12>\n" +
	"\x05match\x18\x01 \x01(\v2(.istio.telemetry.v1alpha1.MetricSelectorR\x05match\x126\n" +
	"\bdisabled\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\bdisabled\x12a\n" +
	"\rtag_overrides\x18\x03 \x03(\v2<.istio.telemetry.v1alpha1.MetricsOverrides.TagOverridesEntryR\ftagOverrides\x1a\xa8\x01\n" +
	"\vTagOverride\x12^\n" +
	"\toperation\x18\x01 \x01(\x0e2@.istio.telemetry.v1alpha1.MetricsOverrides.TagOverride.OperationR\toperation\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\"#\n" +
	"\tOperation\x12\n" +
	"\n" +
	"\x06UPSERT\x10\x00\x12\n" +
	"\n" +
	"\x06REMOVE\x10\x01\x1aw\n" +
	"\x11TagOverridesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12L\n" +
	"\x05value\x18\x02 \x01(\v26.istio.telemetry.v1alpha1.MetricsOverrides.TagOverrideR\x05value:\x028\x01\"\x94\x03\n" +
	"\rAccessLogging\x12I\n" +
	"\x05match\x18\x04 \x01(\v23.istio.telemetry.v1alpha1.AccessLogging.LogSelectorR\x05match\x12C\n" +
	"\tproviders\x18\x01 \x03(\v2%.istio.telemetry.v1alpha1.ProviderRefR\tproviders\x126\n" +
	"\bdisabled\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\bdisabled\x12F\n" +
	"\x06filter\x18\x03 \x01(\v2..istio.telemetry.v1alpha1.AccessLogging.FilterR\x06filter\x1aI\n" +
	"\vLogSelector\x12:\n" +
	"\x04mode\x18\x01 \x01(\x0e2&.istio.telemetry.v1alpha1.WorkloadModeR\x04mode\x1a(\n" +
	"\x06Filter\x12\x1e\n" +
	"\n" +
	"expression\x18\x01 \x01(\tR\n" +
	"expression*=\n" +
	"\fWorkloadMode\x12\x15\n" +
	"\x11CLIENT_AND_SERVER\x10\x00\x12\n" +
	"\n" +
	"\x06CLIENT\x10\x01\x12\n" +
	"\n" +
	"\x06SERVER\x10\x02B!Z\x1fistio.io/api/telemetry/v1alpha1b\x06proto3"

var (
	file_telemetry_v1alpha1_telemetry_proto_rawDescOnce sync.Once
	file_telemetry_v1alpha1_telemetry_proto_rawDescData []byte
)

func file_telemetry_v1alpha1_telemetry_proto_rawDescGZIP() []byte {
	file_telemetry_v1alpha1_telemetry_proto_rawDescOnce.Do(func() {
		file_telemetry_v1alpha1_telemetry_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_telemetry_v1alpha1_telemetry_proto_rawDesc), len(file_telemetry_v1alpha1_telemetry_proto_rawDesc)))
	})
	return file_telemetry_v1alpha1_telemetry_proto_rawDescData
}

var file_telemetry_v1alpha1_telemetry_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_telemetry_v1alpha1_telemetry_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_telemetry_v1alpha1_telemetry_proto_goTypes = []any{
	(WorkloadMode)(0),                           // 0: istio.telemetry.v1alpha1.WorkloadMode
	(MetricSelector_IstioMetric)(0),             // 1: istio.telemetry.v1alpha1.MetricSelector.IstioMetric
	(MetricsOverrides_TagOverride_Operation)(0), // 2: istio.telemetry.v1alpha1.MetricsOverrides.TagOverride.Operation
	(*Telemetry)(nil),                           // 3: istio.telemetry.v1alpha1.Telemetry
	(*Tracing)(nil),                             // 4: istio.telemetry.v1alpha1.Tracing
	(*ProviderRef)(nil),                         // 5: istio.telemetry.v1alpha1.ProviderRef
	(*Metrics)(nil),                             // 6: istio.telemetry.v1alpha1.Metrics
	(*MetricSelector)(nil),                      // 7: istio.telemetry.v1alpha1.MetricSelector
	(*MetricsOverrides)(nil),                    // 8: istio.telemetry.v1alpha1.MetricsOverrides
	(*AccessLogging)(nil),                       // 9: istio.telemetry.v1alpha1.AccessLogging
	(*Tracing_TracingSelector)(nil),             // 10: istio.telemetry.v1alpha1.Tracing.TracingSelector
	(*Tracing_CustomTag)(nil),                   // 11: istio.telemetry.v1alpha1.Tracing.CustomTag
	(*Tracing_Literal)(nil),                     // 12: istio.telemetry.v1alpha1.Tracing.Literal
	(*Tracing_Environment)(nil),                 // 13: istio.telemetry.v1alpha1.Tracing.Environment
	(*Tracing_RequestHeader)(nil),               // 14: istio.telemetry.v1alpha1.Tracing.RequestHeader
	nil,                                         // 15: istio.telemetry.v1alpha1.Tracing.CustomTagsEntry
	(*MetricsOverrides_TagOverride)(nil),        // 16: istio.telemetry.v1alpha1.MetricsOverrides.TagOverride
	nil,                                         // 17: istio.telemetry.v1alpha1.MetricsOverrides.TagOverridesEntry
	(*AccessLogging_LogSelector)(nil),           // 18: istio.telemetry.v1alpha1.AccessLogging.LogSelector
	(*AccessLogging_Filter)(nil),                // 19: istio.telemetry.v1alpha1.AccessLogging.Filter
	(*v1beta1.WorkloadSelector)(nil),            // 20: istio.type.v1beta1.WorkloadSelector
	(*v1beta1.PolicyTargetReference)(nil),       // 21: istio.type.v1beta1.PolicyTargetReference
	(*wrappers.DoubleValue)(nil),                // 22: google.protobuf.DoubleValue
	(*wrappers.BoolValue)(nil),                  // 23: google.protobuf.BoolValue
	(*duration.Duration)(nil),                   // 24: google.protobuf.Duration
}
var file_telemetry_v1alpha1_telemetry_proto_depIdxs = []int32{
	20, // 0: istio.telemetry.v1alpha1.Telemetry.selector:type_name -> istio.type.v1beta1.WorkloadSelector
	21, // 1: istio.telemetry.v1alpha1.Telemetry.targetRef:type_name -> istio.type.v1beta1.PolicyTargetReference
	21, // 2: istio.telemetry.v1alpha1.Telemetry.targetRefs:type_name -> istio.type.v1beta1.PolicyTargetReference
	4,  // 3: istio.telemetry.v1alpha1.Telemetry.tracing:type_name -> istio.telemetry.v1alpha1.Tracing
	6,  // 4: istio.telemetry.v1alpha1.Telemetry.metrics:type_name -> istio.telemetry.v1alpha1.Metrics
	9,  // 5: istio.telemetry.v1alpha1.Telemetry.access_logging:type_name -> istio.telemetry.v1alpha1.AccessLogging
	10, // 6: istio.telemetry.v1alpha1.Tracing.match:type_name -> istio.telemetry.v1alpha1.Tracing.TracingSelector
	5,  // 7: istio.telemetry.v1alpha1.Tracing.providers:type_name -> istio.telemetry.v1alpha1.ProviderRef
	22, // 8: istio.telemetry.v1alpha1.Tracing.random_sampling_percentage:type_name -> google.protobuf.DoubleValue
	23, // 9: istio.telemetry.v1alpha1.Tracing.disable_span_reporting:type_name -> google.protobuf.BoolValue
	15, // 10: istio.telemetry.v1alpha1.Tracing.custom_tags:type_name -> istio.telemetry.v1alpha1.Tracing.CustomTagsEntry
	23, // 11: istio.telemetry.v1alpha1.Tracing.use_request_id_for_trace_sampling:type_name -> google.protobuf.BoolValue
	23, // 12: istio.telemetry.v1alpha1.Tracing.enable_istio_tags:type_name -> google.protobuf.BoolValue
	5,  // 13: istio.telemetry.v1alpha1.Metrics.providers:type_name -> istio.telemetry.v1alpha1.ProviderRef
	8,  // 14: istio.telemetry.v1alpha1.Metrics.overrides:type_name -> istio.telemetry.v1alpha1.MetricsOverrides
	24, // 15: istio.telemetry.v1alpha1.Metrics.reporting_interval:type_name -> google.protobuf.Duration
	1,  // 16: istio.telemetry.v1alpha1.MetricSelector.metric:type_name -> istio.telemetry.v1alpha1.MetricSelector.IstioMetric
	0,  // 17: istio.telemetry.v1alpha1.MetricSelector.mode:type_name -> istio.telemetry.v1alpha1.WorkloadMode
	7,  // 18: istio.telemetry.v1alpha1.MetricsOverrides.match:type_name -> istio.telemetry.v1alpha1.MetricSelector
	23, // 19: istio.telemetry.v1alpha1.MetricsOverrides.disabled:type_name -> google.protobuf.BoolValue
	17, // 20: istio.telemetry.v1alpha1.MetricsOverrides.tag_overrides:type_name -> istio.telemetry.v1alpha1.MetricsOverrides.TagOverridesEntry
	18, // 21: istio.telemetry.v1alpha1.AccessLogging.match:type_name -> istio.telemetry.v1alpha1.AccessLogging.LogSelector
	5,  // 22: istio.telemetry.v1alpha1.AccessLogging.providers:type_name -> istio.telemetry.v1alpha1.ProviderRef
	23, // 23: istio.telemetry.v1alpha1.AccessLogging.disabled:type_name -> google.protobuf.BoolValue
	19, // 24: istio.telemetry.v1alpha1.AccessLogging.filter:type_name -> istio.telemetry.v1alpha1.AccessLogging.Filter
	0,  // 25: istio.telemetry.v1alpha1.Tracing.TracingSelector.mode:type_name -> istio.telemetry.v1alpha1.WorkloadMode
	12, // 26: istio.telemetry.v1alpha1.Tracing.CustomTag.literal:type_name -> istio.telemetry.v1alpha1.Tracing.Literal
	13, // 27: istio.telemetry.v1alpha1.Tracing.CustomTag.environment:type_name -> istio.telemetry.v1alpha1.Tracing.Environment
	14, // 28: istio.telemetry.v1alpha1.Tracing.CustomTag.header:type_name -> istio.telemetry.v1alpha1.Tracing.RequestHeader
	11, // 29: istio.telemetry.v1alpha1.Tracing.CustomTagsEntry.value:type_name -> istio.telemetry.v1alpha1.Tracing.CustomTag
	2,  // 30: istio.telemetry.v1alpha1.MetricsOverrides.TagOverride.operation:type_name -> istio.telemetry.v1alpha1.MetricsOverrides.TagOverride.Operation
	16, // 31: istio.telemetry.v1alpha1.MetricsOverrides.TagOverridesEntry.value:type_name -> istio.telemetry.v1alpha1.MetricsOverrides.TagOverride
	0,  // 32: istio.telemetry.v1alpha1.AccessLogging.LogSelector.mode:type_name -> istio.telemetry.v1alpha1.WorkloadMode
	33, // [33:33] is the sub-list for method output_type
	33, // [33:33] is the sub-list for method input_type
	33, // [33:33] is the sub-list for extension type_name
	33, // [33:33] is the sub-list for extension extendee
	0,  // [0:33] is the sub-list for field type_name
}

func init() { file_telemetry_v1alpha1_telemetry_proto_init() }
func file_telemetry_v1alpha1_telemetry_proto_init() {
	if File_telemetry_v1alpha1_telemetry_proto != nil {
		return
	}
	file_telemetry_v1alpha1_telemetry_proto_msgTypes[4].OneofWrappers = []any{
		(*MetricSelector_Metric)(nil),
		(*MetricSelector_CustomMetric)(nil),
	}
	file_telemetry_v1alpha1_telemetry_proto_msgTypes[8].OneofWrappers = []any{
		(*Tracing_CustomTag_Literal)(nil),
		(*Tracing_CustomTag_Environment)(nil),
		(*Tracing_CustomTag_Header)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_telemetry_v1alpha1_telemetry_proto_rawDesc), len(file_telemetry_v1alpha1_telemetry_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_telemetry_v1alpha1_telemetry_proto_goTypes,
		DependencyIndexes: file_telemetry_v1alpha1_telemetry_proto_depIdxs,
		EnumInfos:         file_telemetry_v1alpha1_telemetry_proto_enumTypes,
		MessageInfos:      file_telemetry_v1alpha1_telemetry_proto_msgTypes,
	}.Build()
	File_telemetry_v1alpha1_telemetry_proto = out.File
	file_telemetry_v1alpha1_telemetry_proto_goTypes = nil
	file_telemetry_v1alpha1_telemetry_proto_depIdxs = nil
}
