-- | This module provides the input abstraction for Vty.
module Graphics.Vty.Input
  ( Input(..)
  , module Graphics.Vty.Input.Events
  )
where

import Graphics.Vty.Input.Events
import Control.Concurrent.STM (TChan)

-- | The library's input-processing abstraction. Platform-specific
-- implementations must implement an 'Input' and provide it to
-- 'Graphics.Vty.mkVtyFromPair'.
data Input =
    Input { eventChannel :: TChan InternalEvent
          -- ^ A channel of events generated by input processing. The
          -- input implementation must write its input events to this
          -- channel; the Vty event loop will read from this channel
          -- and provide the events to the user's application via
          -- 'nextEvent'.
          , shutdownInput :: IO ()
          -- ^ Shut down the input processing. As part of shutting down
          -- the input, this should also restore the input state if
          -- appropriate.
          , restoreInputState :: IO ()
          -- ^ Restore the terminal's input state to what it was prior
          -- to configuring the input for Vty. This should be done as
          -- part of 'shutdownInput' but is exposed in case it needs to
          -- be used directly.
          , inputLogMsg :: String -> IO ()
          -- ^ Log the specified message.
          }
