{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Opens a color chooser dialog to select a color.
-- 
-- \<picture>
--   \<source srcset=\"color-button-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkColorDialogButton\" src=\"color-button.png\">
-- \<\/picture>
-- 
-- It is suitable widget for selecting a color in a preference dialog.
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >colorbutton
-- >╰── button.color
-- >    ╰── [content]
-- 
-- 
-- @GtkColorDialogButton@ has a single CSS node with name colorbutton which
-- contains a button node. To differentiate it from a plain @GtkButton@,
-- it gets the .color style class.
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ColorDialogButton
    ( 

-- * Exported types
    ColorDialogButton(..)                   ,
    IsColorDialogButton                     ,
    toColorDialogButton                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDialog]("GI.Gtk.Objects.ColorDialogButton#g:method:getDialog"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRgba]("GI.Gtk.Objects.ColorDialogButton#g:method:getRgba"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDialog]("GI.Gtk.Objects.ColorDialogButton#g:method:setDialog"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRgba]("GI.Gtk.Objects.ColorDialogButton#g:method:setRgba"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveColorDialogButtonMethod          ,
#endif

-- ** getDialog #method:getDialog#

#if defined(ENABLE_OVERLOADING)
    ColorDialogButtonGetDialogMethodInfo    ,
#endif
    colorDialogButtonGetDialog              ,


-- ** getRgba #method:getRgba#

#if defined(ENABLE_OVERLOADING)
    ColorDialogButtonGetRgbaMethodInfo      ,
#endif
    colorDialogButtonGetRgba                ,


-- ** new #method:new#

    colorDialogButtonNew                    ,


-- ** setDialog #method:setDialog#

#if defined(ENABLE_OVERLOADING)
    ColorDialogButtonSetDialogMethodInfo    ,
#endif
    colorDialogButtonSetDialog              ,


-- ** setRgba #method:setRgba#

#if defined(ENABLE_OVERLOADING)
    ColorDialogButtonSetRgbaMethodInfo      ,
#endif
    colorDialogButtonSetRgba                ,




 -- * Properties


-- ** dialog #attr:dialog#
-- | The @GtkColorDialog@ that contains parameters for
-- the color chooser dialog.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    ColorDialogButtonDialogPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    colorDialogButtonDialog                 ,
#endif
    constructColorDialogButtonDialog        ,
    getColorDialogButtonDialog              ,
    setColorDialogButtonDialog              ,


-- ** rgba #attr:rgba#
-- | The selected color.
-- 
-- This property can be set to give the button its initial
-- color, and it will be updated to reflect the users choice
-- in the color chooser dialog.
-- 
-- Listen to @notify::rgba@ to get informed about changes
-- to the buttons color.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    ColorDialogButtonRgbaPropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    colorDialogButtonRgba                   ,
#endif
    constructColorDialogButtonRgba          ,
    getColorDialogButtonRgba                ,
    setColorDialogButtonRgba                ,




 -- * Signals


-- ** activate #signal:activate#

    ColorDialogButtonActivateCallback       ,
#if defined(ENABLE_OVERLOADING)
    ColorDialogButtonActivateSignalInfo     ,
#endif
    afterColorDialogButtonActivate          ,
    onColorDialogButtonActivate             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.ColorDialog as Gtk.ColorDialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.ColorDialog as Gtk.ColorDialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ColorDialogButton = ColorDialogButton (SP.ManagedPtr ColorDialogButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColorDialogButton where
    toManagedPtr (ColorDialogButton p) = p

foreign import ccall "gtk_color_dialog_button_get_type"
    c_gtk_color_dialog_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject ColorDialogButton where
    glibType = c_gtk_color_dialog_button_get_type

instance B.Types.GObject ColorDialogButton

-- | Type class for types which can be safely cast to t'ColorDialogButton', for instance with `toColorDialogButton`.
class (SP.GObject o, O.IsDescendantOf ColorDialogButton o) => IsColorDialogButton o
instance (SP.GObject o, O.IsDescendantOf ColorDialogButton o) => IsColorDialogButton o

instance O.HasParentTypes ColorDialogButton
type instance O.ParentTypes ColorDialogButton = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'ColorDialogButton', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toColorDialogButton :: (MIO.MonadIO m, IsColorDialogButton o) => o -> m ColorDialogButton
toColorDialogButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo ColorDialogButton

-- | Convert t'ColorDialogButton' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ColorDialogButton) where
    gvalueGType_ = c_gtk_color_dialog_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ColorDialogButton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ColorDialogButton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ColorDialogButton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveColorDialogButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorDialogButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveColorDialogButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveColorDialogButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveColorDialogButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveColorDialogButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveColorDialogButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveColorDialogButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveColorDialogButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveColorDialogButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveColorDialogButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveColorDialogButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveColorDialogButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveColorDialogButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveColorDialogButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveColorDialogButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveColorDialogButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveColorDialogButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveColorDialogButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveColorDialogButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveColorDialogButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveColorDialogButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveColorDialogButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveColorDialogButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveColorDialogButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveColorDialogButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveColorDialogButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveColorDialogButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveColorDialogButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveColorDialogButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveColorDialogButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveColorDialogButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveColorDialogButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveColorDialogButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveColorDialogButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveColorDialogButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveColorDialogButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveColorDialogButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveColorDialogButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveColorDialogButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveColorDialogButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveColorDialogButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveColorDialogButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveColorDialogButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveColorDialogButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveColorDialogButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveColorDialogButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveColorDialogButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveColorDialogButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveColorDialogButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveColorDialogButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveColorDialogButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveColorDialogButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveColorDialogButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveColorDialogButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveColorDialogButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveColorDialogButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveColorDialogButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveColorDialogButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveColorDialogButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveColorDialogButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveColorDialogButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveColorDialogButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveColorDialogButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveColorDialogButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveColorDialogButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveColorDialogButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveColorDialogButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveColorDialogButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveColorDialogButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveColorDialogButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveColorDialogButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveColorDialogButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveColorDialogButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveColorDialogButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveColorDialogButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveColorDialogButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveColorDialogButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveColorDialogButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveColorDialogButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveColorDialogButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveColorDialogButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveColorDialogButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveColorDialogButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveColorDialogButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveColorDialogButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveColorDialogButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveColorDialogButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveColorDialogButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveColorDialogButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveColorDialogButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveColorDialogButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveColorDialogButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveColorDialogButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveColorDialogButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveColorDialogButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveColorDialogButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveColorDialogButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveColorDialogButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveColorDialogButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveColorDialogButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveColorDialogButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveColorDialogButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveColorDialogButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveColorDialogButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveColorDialogButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveColorDialogButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveColorDialogButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveColorDialogButtonMethod "getDialog" o = ColorDialogButtonGetDialogMethodInfo
    ResolveColorDialogButtonMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveColorDialogButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveColorDialogButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveColorDialogButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveColorDialogButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveColorDialogButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveColorDialogButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveColorDialogButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveColorDialogButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveColorDialogButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveColorDialogButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveColorDialogButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveColorDialogButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveColorDialogButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveColorDialogButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveColorDialogButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveColorDialogButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveColorDialogButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveColorDialogButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveColorDialogButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveColorDialogButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveColorDialogButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveColorDialogButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveColorDialogButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveColorDialogButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveColorDialogButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveColorDialogButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveColorDialogButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveColorDialogButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveColorDialogButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveColorDialogButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveColorDialogButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveColorDialogButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveColorDialogButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveColorDialogButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveColorDialogButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveColorDialogButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveColorDialogButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveColorDialogButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveColorDialogButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveColorDialogButtonMethod "getRgba" o = ColorDialogButtonGetRgbaMethodInfo
    ResolveColorDialogButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveColorDialogButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveColorDialogButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveColorDialogButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveColorDialogButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveColorDialogButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveColorDialogButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveColorDialogButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveColorDialogButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveColorDialogButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveColorDialogButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveColorDialogButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveColorDialogButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveColorDialogButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveColorDialogButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveColorDialogButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveColorDialogButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveColorDialogButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveColorDialogButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveColorDialogButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveColorDialogButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveColorDialogButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveColorDialogButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveColorDialogButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveColorDialogButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveColorDialogButtonMethod "setDialog" o = ColorDialogButtonSetDialogMethodInfo
    ResolveColorDialogButtonMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveColorDialogButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveColorDialogButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveColorDialogButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveColorDialogButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveColorDialogButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveColorDialogButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveColorDialogButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveColorDialogButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveColorDialogButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveColorDialogButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveColorDialogButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveColorDialogButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveColorDialogButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveColorDialogButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveColorDialogButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveColorDialogButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveColorDialogButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveColorDialogButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveColorDialogButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveColorDialogButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveColorDialogButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveColorDialogButtonMethod "setRgba" o = ColorDialogButtonSetRgbaMethodInfo
    ResolveColorDialogButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveColorDialogButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveColorDialogButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveColorDialogButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveColorDialogButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveColorDialogButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveColorDialogButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveColorDialogButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveColorDialogButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveColorDialogButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorDialogButtonMethod t ColorDialogButton, O.OverloadedMethod info ColorDialogButton p) => OL.IsLabel t (ColorDialogButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorDialogButtonMethod t ColorDialogButton, O.OverloadedMethod info ColorDialogButton p, R.HasField t ColorDialogButton p) => R.HasField t ColorDialogButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorDialogButtonMethod t ColorDialogButton, O.OverloadedMethodInfo info ColorDialogButton) => OL.IsLabel t (O.MethodProxy info ColorDialogButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ColorDialogButton::activate
-- | Emitted when the color dialog button is activated.
-- 
-- The @::activate@ signal on @GtkColorDialogButton@ is an action signal
-- and emitting it causes the button to pop up its dialog.
-- 
-- /Since: 4.14/
type ColorDialogButtonActivateCallback =
    IO ()

type C_ColorDialogButtonActivateCallback =
    Ptr ColorDialogButton ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ColorDialogButtonActivateCallback`.
foreign import ccall "wrapper"
    mk_ColorDialogButtonActivateCallback :: C_ColorDialogButtonActivateCallback -> IO (FunPtr C_ColorDialogButtonActivateCallback)

wrap_ColorDialogButtonActivateCallback :: 
    GObject a => (a -> ColorDialogButtonActivateCallback) ->
    C_ColorDialogButtonActivateCallback
wrap_ColorDialogButtonActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' colorDialogButton #activate callback
-- @
-- 
-- 
onColorDialogButtonActivate :: (IsColorDialogButton a, MonadIO m) => a -> ((?self :: a) => ColorDialogButtonActivateCallback) -> m SignalHandlerId
onColorDialogButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ColorDialogButtonActivateCallback wrapped
    wrapped'' <- mk_ColorDialogButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' colorDialogButton #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterColorDialogButtonActivate :: (IsColorDialogButton a, MonadIO m) => a -> ((?self :: a) => ColorDialogButtonActivateCallback) -> m SignalHandlerId
afterColorDialogButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ColorDialogButtonActivateCallback wrapped
    wrapped'' <- mk_ColorDialogButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ColorDialogButtonActivateSignalInfo
instance SignalInfo ColorDialogButtonActivateSignalInfo where
    type HaskellCallbackType ColorDialogButtonActivateSignalInfo = ColorDialogButtonActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ColorDialogButtonActivateCallback cb
        cb'' <- mk_ColorDialogButtonActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialogButton::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColorDialogButton.html#g:signal:activate"})

#endif

-- VVV Prop "dialog"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@dialog@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorDialogButton #dialog
-- @
getColorDialogButtonDialog :: (MonadIO m, IsColorDialogButton o) => o -> m (Maybe Gtk.ColorDialog.ColorDialog)
getColorDialogButtonDialog obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "dialog" Gtk.ColorDialog.ColorDialog

-- | Set the value of the “@dialog@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorDialogButton [ #dialog 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorDialogButtonDialog :: (MonadIO m, IsColorDialogButton o, Gtk.ColorDialog.IsColorDialog a) => o -> a -> m ()
setColorDialogButtonDialog obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "dialog" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@dialog@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColorDialogButtonDialog :: (IsColorDialogButton o, MIO.MonadIO m, Gtk.ColorDialog.IsColorDialog a) => a -> m (GValueConstruct o)
constructColorDialogButtonDialog val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "dialog" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ColorDialogButtonDialogPropertyInfo
instance AttrInfo ColorDialogButtonDialogPropertyInfo where
    type AttrAllowedOps ColorDialogButtonDialogPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ColorDialogButtonDialogPropertyInfo = IsColorDialogButton
    type AttrSetTypeConstraint ColorDialogButtonDialogPropertyInfo = Gtk.ColorDialog.IsColorDialog
    type AttrTransferTypeConstraint ColorDialogButtonDialogPropertyInfo = Gtk.ColorDialog.IsColorDialog
    type AttrTransferType ColorDialogButtonDialogPropertyInfo = Gtk.ColorDialog.ColorDialog
    type AttrGetType ColorDialogButtonDialogPropertyInfo = (Maybe Gtk.ColorDialog.ColorDialog)
    type AttrLabel ColorDialogButtonDialogPropertyInfo = "dialog"
    type AttrOrigin ColorDialogButtonDialogPropertyInfo = ColorDialogButton
    attrGet = getColorDialogButtonDialog
    attrSet = setColorDialogButtonDialog
    attrTransfer _ v = do
        unsafeCastTo Gtk.ColorDialog.ColorDialog v
    attrConstruct = constructColorDialogButtonDialog
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialogButton.dialog"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColorDialogButton.html#g:attr:dialog"
        })
#endif

-- VVV Prop "rgba"
   -- Type: TInterface (Name {namespace = "Gdk", name = "RGBA"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@rgba@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorDialogButton #rgba
-- @
getColorDialogButtonRgba :: (MonadIO m, IsColorDialogButton o) => o -> m Gdk.RGBA.RGBA
getColorDialogButtonRgba obj = MIO.liftIO $ checkUnexpectedNothing "getColorDialogButtonRgba" $ B.Properties.getObjectPropertyBoxed obj "rgba" Gdk.RGBA.RGBA

-- | Set the value of the “@rgba@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorDialogButton [ #rgba 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorDialogButtonRgba :: (MonadIO m, IsColorDialogButton o) => o -> Gdk.RGBA.RGBA -> m ()
setColorDialogButtonRgba obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "rgba" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@rgba@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColorDialogButtonRgba :: (IsColorDialogButton o, MIO.MonadIO m) => Gdk.RGBA.RGBA -> m (GValueConstruct o)
constructColorDialogButtonRgba val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "rgba" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ColorDialogButtonRgbaPropertyInfo
instance AttrInfo ColorDialogButtonRgbaPropertyInfo where
    type AttrAllowedOps ColorDialogButtonRgbaPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ColorDialogButtonRgbaPropertyInfo = IsColorDialogButton
    type AttrSetTypeConstraint ColorDialogButtonRgbaPropertyInfo = (~) Gdk.RGBA.RGBA
    type AttrTransferTypeConstraint ColorDialogButtonRgbaPropertyInfo = (~) Gdk.RGBA.RGBA
    type AttrTransferType ColorDialogButtonRgbaPropertyInfo = Gdk.RGBA.RGBA
    type AttrGetType ColorDialogButtonRgbaPropertyInfo = Gdk.RGBA.RGBA
    type AttrLabel ColorDialogButtonRgbaPropertyInfo = "rgba"
    type AttrOrigin ColorDialogButtonRgbaPropertyInfo = ColorDialogButton
    attrGet = getColorDialogButtonRgba
    attrSet = setColorDialogButtonRgba
    attrTransfer _ v = do
        return v
    attrConstruct = constructColorDialogButtonRgba
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialogButton.rgba"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColorDialogButton.html#g:attr:rgba"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ColorDialogButton
type instance O.AttributeList ColorDialogButton = ColorDialogButtonAttributeList
type ColorDialogButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("dialog", ColorDialogButtonDialogPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("rgba", ColorDialogButtonRgbaPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
colorDialogButtonDialog :: AttrLabelProxy "dialog"
colorDialogButtonDialog = AttrLabelProxy

colorDialogButtonRgba :: AttrLabelProxy "rgba"
colorDialogButtonRgba = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ColorDialogButton = ColorDialogButtonSignalList
type ColorDialogButtonSignalList = ('[ '("activate", ColorDialogButtonActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ColorDialogButton::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkColorDialog` to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "ColorDialogButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_button_new" gtk_color_dialog_button_new :: 
    Ptr Gtk.ColorDialog.ColorDialog ->      -- dialog : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    IO (Ptr ColorDialogButton)

-- | Creates a new @GtkColorDialogButton@ with the
-- given @GtkColorDialog@.
-- 
-- You can pass @NULL@ to this function and set a @GtkColorDialog@
-- later. The button will be insensitive until that happens.
-- 
-- /Since: 4.10/
colorDialogButtonNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.ColorDialog.IsColorDialog a) =>
    Maybe (a)
    -- ^ /@dialog@/: the @GtkColorDialog@ to use
    -> m ColorDialogButton
    -- ^ __Returns:__ the new @GtkColorDialogButton@
colorDialogButtonNew dialog = liftIO $ do
    maybeDialog <- case dialog of
        Nothing -> return FP.nullPtr
        Just jDialog -> do
            jDialog' <- B.ManagedPtr.disownObject jDialog
            return jDialog'
    result <- gtk_color_dialog_button_new maybeDialog
    checkUnexpectedReturnNULL "colorDialogButtonNew" result
    result' <- (newObject ColorDialogButton) result
    whenJust dialog touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorDialogButton::get_dialog
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkColorDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ColorDialog" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_button_get_dialog" gtk_color_dialog_button_get_dialog :: 
    Ptr ColorDialogButton ->                -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialogButton"})
    IO (Ptr Gtk.ColorDialog.ColorDialog)

-- | Returns the @GtkColorDialog@ of /@self@/.
-- 
-- /Since: 4.10/
colorDialogButtonGetDialog ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkColorDialogButton@
    -> m (Maybe Gtk.ColorDialog.ColorDialog)
    -- ^ __Returns:__ the @GtkColorDialog@
colorDialogButtonGetDialog self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_color_dialog_button_get_dialog self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ColorDialog.ColorDialog) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ColorDialogButtonGetDialogMethodInfo
instance (signature ~ (m (Maybe Gtk.ColorDialog.ColorDialog)), MonadIO m, IsColorDialogButton a) => O.OverloadedMethod ColorDialogButtonGetDialogMethodInfo a signature where
    overloadedMethod = colorDialogButtonGetDialog

instance O.OverloadedMethodInfo ColorDialogButtonGetDialogMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialogButton.colorDialogButtonGetDialog",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColorDialogButton.html#v:colorDialogButtonGetDialog"
        })


#endif

-- method ColorDialogButton::get_rgba
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkColorDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "RGBA" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_button_get_rgba" gtk_color_dialog_button_get_rgba :: 
    Ptr ColorDialogButton ->                -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialogButton"})
    IO (Ptr Gdk.RGBA.RGBA)

-- | Returns the color of the button.
-- 
-- This function is what should be used to obtain
-- the color that was chosen by the user. To get
-- informed about changes, listen to \"notify[rgba](#g:signal:rgba)\".
-- 
-- /Since: 4.10/
colorDialogButtonGetRgba ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkColorDialogButton@
    -> m Gdk.RGBA.RGBA
    -- ^ __Returns:__ the color
colorDialogButtonGetRgba self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_color_dialog_button_get_rgba self'
    checkUnexpectedReturnNULL "colorDialogButtonGetRgba" result
    result' <- (newBoxed Gdk.RGBA.RGBA) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorDialogButtonGetRgbaMethodInfo
instance (signature ~ (m Gdk.RGBA.RGBA), MonadIO m, IsColorDialogButton a) => O.OverloadedMethod ColorDialogButtonGetRgbaMethodInfo a signature where
    overloadedMethod = colorDialogButtonGetRgba

instance O.OverloadedMethodInfo ColorDialogButtonGetRgbaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialogButton.colorDialogButtonGetRgba",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColorDialogButton.html#v:colorDialogButtonGetRgba"
        })


#endif

-- method ColorDialogButton::set_dialog
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkColorDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new `GtkColorDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_button_set_dialog" gtk_color_dialog_button_set_dialog :: 
    Ptr ColorDialogButton ->                -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialogButton"})
    Ptr Gtk.ColorDialog.ColorDialog ->      -- dialog : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    IO ()

-- | Sets a @GtkColorDialog@ object to use for
-- creating the color chooser dialog that is
-- presented when the user clicks the button.
-- 
-- /Since: 4.10/
colorDialogButtonSetDialog ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialogButton a, Gtk.ColorDialog.IsColorDialog b) =>
    a
    -- ^ /@self@/: a @GtkColorDialogButton@
    -> b
    -- ^ /@dialog@/: the new @GtkColorDialog@
    -> m ()
colorDialogButtonSetDialog self dialog = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    dialog' <- unsafeManagedPtrCastPtr dialog
    gtk_color_dialog_button_set_dialog self' dialog'
    touchManagedPtr self
    touchManagedPtr dialog
    return ()

#if defined(ENABLE_OVERLOADING)
data ColorDialogButtonSetDialogMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsColorDialogButton a, Gtk.ColorDialog.IsColorDialog b) => O.OverloadedMethod ColorDialogButtonSetDialogMethodInfo a signature where
    overloadedMethod = colorDialogButtonSetDialog

instance O.OverloadedMethodInfo ColorDialogButtonSetDialogMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialogButton.colorDialogButtonSetDialog",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColorDialogButton.html#v:colorDialogButtonSetDialog"
        })


#endif

-- method ColorDialogButton::set_rgba
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkColorDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new color" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_button_set_rgba" gtk_color_dialog_button_set_rgba :: 
    Ptr ColorDialogButton ->                -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialogButton"})
    Ptr Gdk.RGBA.RGBA ->                    -- color : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    IO ()

-- | Sets the color of the button.
-- 
-- /Since: 4.10/
colorDialogButtonSetRgba ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkColorDialogButton@
    -> Gdk.RGBA.RGBA
    -- ^ /@color@/: the new color
    -> m ()
colorDialogButtonSetRgba self color = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    color' <- unsafeManagedPtrGetPtr color
    gtk_color_dialog_button_set_rgba self' color'
    touchManagedPtr self
    touchManagedPtr color
    return ()

#if defined(ENABLE_OVERLOADING)
data ColorDialogButtonSetRgbaMethodInfo
instance (signature ~ (Gdk.RGBA.RGBA -> m ()), MonadIO m, IsColorDialogButton a) => O.OverloadedMethod ColorDialogButtonSetRgbaMethodInfo a signature where
    overloadedMethod = colorDialogButtonSetRgba

instance O.OverloadedMethodInfo ColorDialogButtonSetRgbaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialogButton.colorDialogButtonSetRgba",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColorDialogButton.html#v:colorDialogButtonSetRgba"
        })


#endif


