{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Places a label next to an indicator.
-- 
-- \<picture>
--   \<source srcset=\"check-button-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"Example GtkCheckButtons\" src=\"check-button.png\">
-- \<\/picture>
-- 
-- A @GtkCheckButton@ is created by calling either 'GI.Gtk.Objects.CheckButton.checkButtonNew'
-- or 'GI.Gtk.Objects.CheckButton.checkButtonNewWithLabel'.
-- 
-- The state of a @GtkCheckButton@ can be set specifically using
-- 'GI.Gtk.Objects.CheckButton.checkButtonSetActive', and retrieved using
-- 'GI.Gtk.Objects.CheckButton.checkButtonGetActive'.
-- 
-- = Inconsistent state
-- 
-- In addition to \"on\" and \"off\", check buttons can be an
-- \"in between\" state that is neither on nor off. This can be used
-- e.g. when the user has selected a range of elements (such as some
-- text or spreadsheet cells) that are affected by a check button,
-- and the current values in that range are inconsistent.
-- 
-- To set a @GtkCheckButton@ to inconsistent state, use
-- 'GI.Gtk.Objects.CheckButton.checkButtonSetInconsistent'.
-- 
-- = Grouping
-- 
-- Check buttons can be grouped together, to form mutually exclusive
-- groups - only one of the buttons can be toggled at a time, and toggling
-- another one will switch the currently toggled one off.
-- 
-- Grouped check buttons use a different indicator, and are commonly referred
-- to as *radio buttons*.
-- 
-- \<picture>
--   \<source srcset=\"radio-button-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"Example GtkRadioButtons\" src=\"radio-button.png\">
-- \<\/picture>
-- 
-- To add a @GtkCheckButton@ to a group, use 'GI.Gtk.Objects.CheckButton.checkButtonSetGroup'.
-- 
-- When the code must keep track of the state of a group of radio buttons, it
-- is recommended to keep track of such state through a stateful
-- @GAction@ with a target for each button. Using the @toggled@ signals to keep
-- track of the group changes and state is discouraged.
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkCheckButton@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>␣\<\/kbd> or \<kbd>Enter\<\/kbd> activates the button.
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >checkbutton[.text-button][.grouped]
-- >├── check
-- >╰── [label]
-- 
-- 
-- A @GtkCheckButton@ has a main node with name checkbutton. If the
-- [CheckButton:label]("GI.Gtk.Objects.CheckButton#g:attr:label") or [CheckButton:child]("GI.Gtk.Objects.CheckButton#g:attr:child")
-- properties are set, it contains a child widget. The indicator node
-- is named check when no group is set, and radio if the checkbutton
-- is grouped together with other checkbuttons.
-- 
-- = Accessibility
-- 
-- @GtkCheckButton@ uses the 'GI.Gtk.Enums.AccessibleRoleCheckbox' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CheckButton
    ( 

-- * Exported types
    CheckButton(..)                         ,
    IsCheckButton                           ,
    toCheckButton                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActionName]("GI.Gtk.Interfaces.Actionable#g:method:getActionName"), [getActionTargetValue]("GI.Gtk.Interfaces.Actionable#g:method:getActionTargetValue"), [getActive]("GI.Gtk.Objects.CheckButton#g:method:getActive"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.CheckButton#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getInconsistent]("GI.Gtk.Objects.CheckButton#g:method:getInconsistent"), [getLabel]("GI.Gtk.Objects.CheckButton#g:method:getLabel"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUseUnderline]("GI.Gtk.Objects.CheckButton#g:method:getUseUnderline"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActionName]("GI.Gtk.Interfaces.Actionable#g:method:setActionName"), [setActionTargetValue]("GI.Gtk.Interfaces.Actionable#g:method:setActionTargetValue"), [setActive]("GI.Gtk.Objects.CheckButton#g:method:setActive"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.CheckButton#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDetailedActionName]("GI.Gtk.Interfaces.Actionable#g:method:setDetailedActionName"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setGroup]("GI.Gtk.Objects.CheckButton#g:method:setGroup"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setInconsistent]("GI.Gtk.Objects.CheckButton#g:method:setInconsistent"), [setLabel]("GI.Gtk.Objects.CheckButton#g:method:setLabel"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUseUnderline]("GI.Gtk.Objects.CheckButton#g:method:setUseUnderline"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveCheckButtonMethod                ,
#endif

-- ** getActive #method:getActive#

#if defined(ENABLE_OVERLOADING)
    CheckButtonGetActiveMethodInfo          ,
#endif
    checkButtonGetActive                    ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    CheckButtonGetChildMethodInfo           ,
#endif
    checkButtonGetChild                     ,


-- ** getInconsistent #method:getInconsistent#

#if defined(ENABLE_OVERLOADING)
    CheckButtonGetInconsistentMethodInfo    ,
#endif
    checkButtonGetInconsistent              ,


-- ** getLabel #method:getLabel#

#if defined(ENABLE_OVERLOADING)
    CheckButtonGetLabelMethodInfo           ,
#endif
    checkButtonGetLabel                     ,


-- ** getUseUnderline #method:getUseUnderline#

#if defined(ENABLE_OVERLOADING)
    CheckButtonGetUseUnderlineMethodInfo    ,
#endif
    checkButtonGetUseUnderline              ,


-- ** new #method:new#

    checkButtonNew                          ,


-- ** newWithLabel #method:newWithLabel#

    checkButtonNewWithLabel                 ,


-- ** newWithMnemonic #method:newWithMnemonic#

    checkButtonNewWithMnemonic              ,


-- ** setActive #method:setActive#

#if defined(ENABLE_OVERLOADING)
    CheckButtonSetActiveMethodInfo          ,
#endif
    checkButtonSetActive                    ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    CheckButtonSetChildMethodInfo           ,
#endif
    checkButtonSetChild                     ,


-- ** setGroup #method:setGroup#

#if defined(ENABLE_OVERLOADING)
    CheckButtonSetGroupMethodInfo           ,
#endif
    checkButtonSetGroup                     ,


-- ** setInconsistent #method:setInconsistent#

#if defined(ENABLE_OVERLOADING)
    CheckButtonSetInconsistentMethodInfo    ,
#endif
    checkButtonSetInconsistent              ,


-- ** setLabel #method:setLabel#

#if defined(ENABLE_OVERLOADING)
    CheckButtonSetLabelMethodInfo           ,
#endif
    checkButtonSetLabel                     ,


-- ** setUseUnderline #method:setUseUnderline#

#if defined(ENABLE_OVERLOADING)
    CheckButtonSetUseUnderlineMethodInfo    ,
#endif
    checkButtonSetUseUnderline              ,




 -- * Properties


-- ** active #attr:active#
-- | If the check button is active.
-- 
-- Setting @active@ to 'P.True' will add the @:checked:@ state to both
-- the check button and the indicator CSS node.

#if defined(ENABLE_OVERLOADING)
    CheckButtonActivePropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    checkButtonActive                       ,
#endif
    constructCheckButtonActive              ,
    getCheckButtonActive                    ,
    setCheckButtonActive                    ,


-- ** child #attr:child#
-- | The child widget.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    CheckButtonChildPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    checkButtonChild                        ,
#endif
    clearCheckButtonChild                   ,
    constructCheckButtonChild               ,
    getCheckButtonChild                     ,
    setCheckButtonChild                     ,


-- ** group #attr:group#
-- | The check button whose group this widget belongs to.

#if defined(ENABLE_OVERLOADING)
    CheckButtonGroupPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    checkButtonGroup                        ,
#endif
    clearCheckButtonGroup                   ,
    constructCheckButtonGroup               ,
    setCheckButtonGroup                     ,


-- ** inconsistent #attr:inconsistent#
-- | If the check button is in an “in between” state.
-- 
-- The inconsistent state only affects visual appearance,
-- not the semantics of the button.

#if defined(ENABLE_OVERLOADING)
    CheckButtonInconsistentPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    checkButtonInconsistent                 ,
#endif
    constructCheckButtonInconsistent        ,
    getCheckButtonInconsistent              ,
    setCheckButtonInconsistent              ,


-- ** label #attr:label#
-- | Text of the label inside the check button, if it contains a label widget.

#if defined(ENABLE_OVERLOADING)
    CheckButtonLabelPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    checkButtonLabel                        ,
#endif
    clearCheckButtonLabel                   ,
    constructCheckButtonLabel               ,
    getCheckButtonLabel                     ,
    setCheckButtonLabel                     ,


-- ** useUnderline #attr:useUnderline#
-- | If set, an underline in the text indicates that the following
-- character is to be used as mnemonic.

#if defined(ENABLE_OVERLOADING)
    CheckButtonUseUnderlinePropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    checkButtonUseUnderline                 ,
#endif
    constructCheckButtonUseUnderline        ,
    getCheckButtonUseUnderline              ,
    setCheckButtonUseUnderline              ,




 -- * Signals


-- ** activate #signal:activate#

    CheckButtonActivateCallback             ,
#if defined(ENABLE_OVERLOADING)
    CheckButtonActivateSignalInfo           ,
#endif
    afterCheckButtonActivate                ,
    onCheckButtonActivate                   ,


-- ** toggled #signal:toggled#

    CheckButtonToggledCallback              ,
#if defined(ENABLE_OVERLOADING)
    CheckButtonToggledSignalInfo            ,
#endif
    afterCheckButtonToggled                 ,
    onCheckButtonToggled                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype CheckButton = CheckButton (SP.ManagedPtr CheckButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype CheckButton where
    toManagedPtr (CheckButton p) = p

foreign import ccall "gtk_check_button_get_type"
    c_gtk_check_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject CheckButton where
    glibType = c_gtk_check_button_get_type

instance B.Types.GObject CheckButton

-- | Type class for types which can be safely cast to t'CheckButton', for instance with `toCheckButton`.
class (SP.GObject o, O.IsDescendantOf CheckButton o) => IsCheckButton o
instance (SP.GObject o, O.IsDescendantOf CheckButton o) => IsCheckButton o

instance O.HasParentTypes CheckButton
type instance O.ParentTypes CheckButton = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Actionable.Actionable, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'CheckButton', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCheckButton :: (MIO.MonadIO m, IsCheckButton o) => o -> m CheckButton
toCheckButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo CheckButton

-- | Convert t'CheckButton' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CheckButton) where
    gvalueGType_ = c_gtk_check_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CheckButton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CheckButton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CheckButton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCheckButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCheckButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveCheckButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveCheckButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveCheckButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveCheckButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveCheckButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveCheckButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveCheckButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveCheckButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveCheckButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveCheckButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCheckButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCheckButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveCheckButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveCheckButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveCheckButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveCheckButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveCheckButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveCheckButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveCheckButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveCheckButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveCheckButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveCheckButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveCheckButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCheckButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCheckButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCheckButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveCheckButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveCheckButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveCheckButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveCheckButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveCheckButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveCheckButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveCheckButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveCheckButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveCheckButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveCheckButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveCheckButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveCheckButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveCheckButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCheckButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveCheckButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveCheckButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveCheckButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveCheckButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveCheckButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveCheckButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveCheckButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveCheckButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCheckButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCheckButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveCheckButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveCheckButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveCheckButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveCheckButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveCheckButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveCheckButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveCheckButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCheckButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCheckButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveCheckButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveCheckButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveCheckButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveCheckButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveCheckButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveCheckButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveCheckButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCheckButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveCheckButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveCheckButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveCheckButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveCheckButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCheckButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCheckButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCheckButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveCheckButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveCheckButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveCheckButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveCheckButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveCheckButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCheckButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveCheckButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveCheckButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveCheckButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveCheckButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveCheckButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveCheckButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCheckButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveCheckButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveCheckButtonMethod "getActionName" o = Gtk.Actionable.ActionableGetActionNameMethodInfo
    ResolveCheckButtonMethod "getActionTargetValue" o = Gtk.Actionable.ActionableGetActionTargetValueMethodInfo
    ResolveCheckButtonMethod "getActive" o = CheckButtonGetActiveMethodInfo
    ResolveCheckButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveCheckButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveCheckButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveCheckButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveCheckButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveCheckButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveCheckButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveCheckButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveCheckButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveCheckButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveCheckButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveCheckButtonMethod "getChild" o = CheckButtonGetChildMethodInfo
    ResolveCheckButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveCheckButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveCheckButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveCheckButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveCheckButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveCheckButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveCheckButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCheckButtonMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveCheckButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveCheckButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveCheckButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveCheckButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveCheckButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveCheckButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveCheckButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveCheckButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveCheckButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveCheckButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveCheckButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveCheckButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveCheckButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveCheckButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveCheckButtonMethod "getInconsistent" o = CheckButtonGetInconsistentMethodInfo
    ResolveCheckButtonMethod "getLabel" o = CheckButtonGetLabelMethodInfo
    ResolveCheckButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveCheckButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveCheckButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveCheckButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveCheckButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveCheckButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveCheckButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveCheckButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveCheckButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveCheckButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveCheckButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveCheckButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveCheckButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveCheckButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveCheckButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveCheckButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveCheckButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveCheckButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveCheckButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveCheckButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveCheckButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCheckButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCheckButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveCheckButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveCheckButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveCheckButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveCheckButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveCheckButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveCheckButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveCheckButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveCheckButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveCheckButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveCheckButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveCheckButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveCheckButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveCheckButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveCheckButtonMethod "getUseUnderline" o = CheckButtonGetUseUnderlineMethodInfo
    ResolveCheckButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveCheckButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveCheckButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveCheckButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveCheckButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveCheckButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveCheckButtonMethod "setActionName" o = Gtk.Actionable.ActionableSetActionNameMethodInfo
    ResolveCheckButtonMethod "setActionTargetValue" o = Gtk.Actionable.ActionableSetActionTargetValueMethodInfo
    ResolveCheckButtonMethod "setActive" o = CheckButtonSetActiveMethodInfo
    ResolveCheckButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveCheckButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveCheckButtonMethod "setChild" o = CheckButtonSetChildMethodInfo
    ResolveCheckButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveCheckButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveCheckButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveCheckButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveCheckButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCheckButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCheckButtonMethod "setDetailedActionName" o = Gtk.Actionable.ActionableSetDetailedActionNameMethodInfo
    ResolveCheckButtonMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveCheckButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveCheckButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveCheckButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveCheckButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveCheckButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveCheckButtonMethod "setGroup" o = CheckButtonSetGroupMethodInfo
    ResolveCheckButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveCheckButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveCheckButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveCheckButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveCheckButtonMethod "setInconsistent" o = CheckButtonSetInconsistentMethodInfo
    ResolveCheckButtonMethod "setLabel" o = CheckButtonSetLabelMethodInfo
    ResolveCheckButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveCheckButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveCheckButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveCheckButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveCheckButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveCheckButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveCheckButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveCheckButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveCheckButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveCheckButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveCheckButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCheckButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveCheckButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveCheckButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveCheckButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveCheckButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveCheckButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveCheckButtonMethod "setUseUnderline" o = CheckButtonSetUseUnderlineMethodInfo
    ResolveCheckButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveCheckButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveCheckButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveCheckButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveCheckButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCheckButtonMethod t CheckButton, O.OverloadedMethod info CheckButton p) => OL.IsLabel t (CheckButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCheckButtonMethod t CheckButton, O.OverloadedMethod info CheckButton p, R.HasField t CheckButton p) => R.HasField t CheckButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCheckButtonMethod t CheckButton, O.OverloadedMethodInfo info CheckButton) => OL.IsLabel t (O.MethodProxy info CheckButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal CheckButton::activate
-- | Emitted to when the check button is activated.
-- 
-- The @::activate@ signal on @GtkCheckButton@ is an action signal and
-- emitting it causes the button to animate press then release.
-- 
-- Applications should never connect to this signal, but use the
-- [CheckButton::toggled]("GI.Gtk.Objects.CheckButton#g:signal:toggled") signal.
-- 
-- The default bindings for this signal are all forms of the
-- \<kbd>␣\<\/kbd> and \<kbd>Enter\<\/kbd> keys.
-- 
-- /Since: 4.2/
type CheckButtonActivateCallback =
    IO ()

type C_CheckButtonActivateCallback =
    Ptr CheckButton ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CheckButtonActivateCallback`.
foreign import ccall "wrapper"
    mk_CheckButtonActivateCallback :: C_CheckButtonActivateCallback -> IO (FunPtr C_CheckButtonActivateCallback)

wrap_CheckButtonActivateCallback :: 
    GObject a => (a -> CheckButtonActivateCallback) ->
    C_CheckButtonActivateCallback
wrap_CheckButtonActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' checkButton #activate callback
-- @
-- 
-- 
onCheckButtonActivate :: (IsCheckButton a, MonadIO m) => a -> ((?self :: a) => CheckButtonActivateCallback) -> m SignalHandlerId
onCheckButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CheckButtonActivateCallback wrapped
    wrapped'' <- mk_CheckButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' checkButton #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCheckButtonActivate :: (IsCheckButton a, MonadIO m) => a -> ((?self :: a) => CheckButtonActivateCallback) -> m SignalHandlerId
afterCheckButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CheckButtonActivateCallback wrapped
    wrapped'' <- mk_CheckButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CheckButtonActivateSignalInfo
instance SignalInfo CheckButtonActivateSignalInfo where
    type HaskellCallbackType CheckButtonActivateSignalInfo = CheckButtonActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CheckButtonActivateCallback cb
        cb'' <- mk_CheckButtonActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#g:signal:activate"})

#endif

-- signal CheckButton::toggled
-- | Emitted when the buttons\'s [CheckButton:active]("GI.Gtk.Objects.CheckButton#g:attr:active")
-- property changes.
type CheckButtonToggledCallback =
    IO ()

type C_CheckButtonToggledCallback =
    Ptr CheckButton ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CheckButtonToggledCallback`.
foreign import ccall "wrapper"
    mk_CheckButtonToggledCallback :: C_CheckButtonToggledCallback -> IO (FunPtr C_CheckButtonToggledCallback)

wrap_CheckButtonToggledCallback :: 
    GObject a => (a -> CheckButtonToggledCallback) ->
    C_CheckButtonToggledCallback
wrap_CheckButtonToggledCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [toggled](#signal:toggled) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' checkButton #toggled callback
-- @
-- 
-- 
onCheckButtonToggled :: (IsCheckButton a, MonadIO m) => a -> ((?self :: a) => CheckButtonToggledCallback) -> m SignalHandlerId
onCheckButtonToggled obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CheckButtonToggledCallback wrapped
    wrapped'' <- mk_CheckButtonToggledCallback wrapped'
    connectSignalFunPtr obj "toggled" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toggled](#signal:toggled) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' checkButton #toggled callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCheckButtonToggled :: (IsCheckButton a, MonadIO m) => a -> ((?self :: a) => CheckButtonToggledCallback) -> m SignalHandlerId
afterCheckButtonToggled obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CheckButtonToggledCallback wrapped
    wrapped'' <- mk_CheckButtonToggledCallback wrapped'
    connectSignalFunPtr obj "toggled" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CheckButtonToggledSignalInfo
instance SignalInfo CheckButtonToggledSignalInfo where
    type HaskellCallbackType CheckButtonToggledSignalInfo = CheckButtonToggledCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CheckButtonToggledCallback cb
        cb'' <- mk_CheckButtonToggledCallback cb'
        connectSignalFunPtr obj "toggled" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton::toggled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#g:signal:toggled"})

#endif

-- VVV Prop "active"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' checkButton #active
-- @
getCheckButtonActive :: (MonadIO m, IsCheckButton o) => o -> m Bool
getCheckButtonActive obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "active"

-- | Set the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' checkButton [ #active 'Data.GI.Base.Attributes.:=' value ]
-- @
setCheckButtonActive :: (MonadIO m, IsCheckButton o) => o -> Bool -> m ()
setCheckButtonActive obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "active" val

-- | Construct a t'GValueConstruct' with valid value for the “@active@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCheckButtonActive :: (IsCheckButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCheckButtonActive val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "active" val

#if defined(ENABLE_OVERLOADING)
data CheckButtonActivePropertyInfo
instance AttrInfo CheckButtonActivePropertyInfo where
    type AttrAllowedOps CheckButtonActivePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CheckButtonActivePropertyInfo = IsCheckButton
    type AttrSetTypeConstraint CheckButtonActivePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CheckButtonActivePropertyInfo = (~) Bool
    type AttrTransferType CheckButtonActivePropertyInfo = Bool
    type AttrGetType CheckButtonActivePropertyInfo = Bool
    type AttrLabel CheckButtonActivePropertyInfo = "active"
    type AttrOrigin CheckButtonActivePropertyInfo = CheckButton
    attrGet = getCheckButtonActive
    attrSet = setCheckButtonActive
    attrTransfer _ v = do
        return v
    attrConstruct = constructCheckButtonActive
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.active"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#g:attr:active"
        })
#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' checkButton #child
-- @
getCheckButtonChild :: (MonadIO m, IsCheckButton o) => o -> m (Maybe Gtk.Widget.Widget)
getCheckButtonChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' checkButton [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setCheckButtonChild :: (MonadIO m, IsCheckButton o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setCheckButtonChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCheckButtonChild :: (IsCheckButton o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructCheckButtonChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearCheckButtonChild :: (MonadIO m, IsCheckButton o) => o -> m ()
clearCheckButtonChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data CheckButtonChildPropertyInfo
instance AttrInfo CheckButtonChildPropertyInfo where
    type AttrAllowedOps CheckButtonChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CheckButtonChildPropertyInfo = IsCheckButton
    type AttrSetTypeConstraint CheckButtonChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint CheckButtonChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType CheckButtonChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType CheckButtonChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel CheckButtonChildPropertyInfo = "child"
    type AttrOrigin CheckButtonChildPropertyInfo = CheckButton
    attrGet = getCheckButtonChild
    attrSet = setCheckButtonChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructCheckButtonChild
    attrClear = clearCheckButtonChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#g:attr:child"
        })
#endif

-- VVV Prop "group"
   -- Type: TInterface (Name {namespace = "Gtk", name = "CheckButton"})
   -- Flags: [PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Set the value of the “@group@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' checkButton [ #group 'Data.GI.Base.Attributes.:=' value ]
-- @
setCheckButtonGroup :: (MonadIO m, IsCheckButton o, IsCheckButton a) => o -> a -> m ()
setCheckButtonGroup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "group" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@group@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCheckButtonGroup :: (IsCheckButton o, MIO.MonadIO m, IsCheckButton a) => a -> m (GValueConstruct o)
constructCheckButtonGroup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "group" (P.Just val)

-- | Set the value of the “@group@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #group
-- @
clearCheckButtonGroup :: (MonadIO m, IsCheckButton o) => o -> m ()
clearCheckButtonGroup obj = liftIO $ B.Properties.setObjectPropertyObject obj "group" (Nothing :: Maybe CheckButton)

#if defined(ENABLE_OVERLOADING)
data CheckButtonGroupPropertyInfo
instance AttrInfo CheckButtonGroupPropertyInfo where
    type AttrAllowedOps CheckButtonGroupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint CheckButtonGroupPropertyInfo = IsCheckButton
    type AttrSetTypeConstraint CheckButtonGroupPropertyInfo = IsCheckButton
    type AttrTransferTypeConstraint CheckButtonGroupPropertyInfo = IsCheckButton
    type AttrTransferType CheckButtonGroupPropertyInfo = CheckButton
    type AttrGetType CheckButtonGroupPropertyInfo = ()
    type AttrLabel CheckButtonGroupPropertyInfo = "group"
    type AttrOrigin CheckButtonGroupPropertyInfo = CheckButton
    attrGet = undefined
    attrSet = setCheckButtonGroup
    attrTransfer _ v = do
        unsafeCastTo CheckButton v
    attrConstruct = constructCheckButtonGroup
    attrClear = clearCheckButtonGroup
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.group"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#g:attr:group"
        })
#endif

-- VVV Prop "inconsistent"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@inconsistent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' checkButton #inconsistent
-- @
getCheckButtonInconsistent :: (MonadIO m, IsCheckButton o) => o -> m Bool
getCheckButtonInconsistent obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "inconsistent"

-- | Set the value of the “@inconsistent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' checkButton [ #inconsistent 'Data.GI.Base.Attributes.:=' value ]
-- @
setCheckButtonInconsistent :: (MonadIO m, IsCheckButton o) => o -> Bool -> m ()
setCheckButtonInconsistent obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "inconsistent" val

-- | Construct a t'GValueConstruct' with valid value for the “@inconsistent@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCheckButtonInconsistent :: (IsCheckButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCheckButtonInconsistent val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "inconsistent" val

#if defined(ENABLE_OVERLOADING)
data CheckButtonInconsistentPropertyInfo
instance AttrInfo CheckButtonInconsistentPropertyInfo where
    type AttrAllowedOps CheckButtonInconsistentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CheckButtonInconsistentPropertyInfo = IsCheckButton
    type AttrSetTypeConstraint CheckButtonInconsistentPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CheckButtonInconsistentPropertyInfo = (~) Bool
    type AttrTransferType CheckButtonInconsistentPropertyInfo = Bool
    type AttrGetType CheckButtonInconsistentPropertyInfo = Bool
    type AttrLabel CheckButtonInconsistentPropertyInfo = "inconsistent"
    type AttrOrigin CheckButtonInconsistentPropertyInfo = CheckButton
    attrGet = getCheckButtonInconsistent
    attrSet = setCheckButtonInconsistent
    attrTransfer _ v = do
        return v
    attrConstruct = constructCheckButtonInconsistent
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.inconsistent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#g:attr:inconsistent"
        })
#endif

-- VVV Prop "label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' checkButton #label
-- @
getCheckButtonLabel :: (MonadIO m, IsCheckButton o) => o -> m (Maybe T.Text)
getCheckButtonLabel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "label"

-- | Set the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' checkButton [ #label 'Data.GI.Base.Attributes.:=' value ]
-- @
setCheckButtonLabel :: (MonadIO m, IsCheckButton o) => o -> T.Text -> m ()
setCheckButtonLabel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "label" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@label@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCheckButtonLabel :: (IsCheckButton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructCheckButtonLabel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "label" (P.Just val)

-- | Set the value of the “@label@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #label
-- @
clearCheckButtonLabel :: (MonadIO m, IsCheckButton o) => o -> m ()
clearCheckButtonLabel obj = liftIO $ B.Properties.setObjectPropertyString obj "label" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data CheckButtonLabelPropertyInfo
instance AttrInfo CheckButtonLabelPropertyInfo where
    type AttrAllowedOps CheckButtonLabelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CheckButtonLabelPropertyInfo = IsCheckButton
    type AttrSetTypeConstraint CheckButtonLabelPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint CheckButtonLabelPropertyInfo = (~) T.Text
    type AttrTransferType CheckButtonLabelPropertyInfo = T.Text
    type AttrGetType CheckButtonLabelPropertyInfo = (Maybe T.Text)
    type AttrLabel CheckButtonLabelPropertyInfo = "label"
    type AttrOrigin CheckButtonLabelPropertyInfo = CheckButton
    attrGet = getCheckButtonLabel
    attrSet = setCheckButtonLabel
    attrTransfer _ v = do
        return v
    attrConstruct = constructCheckButtonLabel
    attrClear = clearCheckButtonLabel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.label"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#g:attr:label"
        })
#endif

-- VVV Prop "use-underline"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' checkButton #useUnderline
-- @
getCheckButtonUseUnderline :: (MonadIO m, IsCheckButton o) => o -> m Bool
getCheckButtonUseUnderline obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-underline"

-- | Set the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' checkButton [ #useUnderline 'Data.GI.Base.Attributes.:=' value ]
-- @
setCheckButtonUseUnderline :: (MonadIO m, IsCheckButton o) => o -> Bool -> m ()
setCheckButtonUseUnderline obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-underline" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-underline@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCheckButtonUseUnderline :: (IsCheckButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCheckButtonUseUnderline val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-underline" val

#if defined(ENABLE_OVERLOADING)
data CheckButtonUseUnderlinePropertyInfo
instance AttrInfo CheckButtonUseUnderlinePropertyInfo where
    type AttrAllowedOps CheckButtonUseUnderlinePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CheckButtonUseUnderlinePropertyInfo = IsCheckButton
    type AttrSetTypeConstraint CheckButtonUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CheckButtonUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferType CheckButtonUseUnderlinePropertyInfo = Bool
    type AttrGetType CheckButtonUseUnderlinePropertyInfo = Bool
    type AttrLabel CheckButtonUseUnderlinePropertyInfo = "use-underline"
    type AttrOrigin CheckButtonUseUnderlinePropertyInfo = CheckButton
    attrGet = getCheckButtonUseUnderline
    attrSet = setCheckButtonUseUnderline
    attrTransfer _ v = do
        return v
    attrConstruct = constructCheckButtonUseUnderline
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.useUnderline"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#g:attr:useUnderline"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CheckButton
type instance O.AttributeList CheckButton = CheckButtonAttributeList
type CheckButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("actionName", Gtk.Actionable.ActionableActionNamePropertyInfo), '("actionTarget", Gtk.Actionable.ActionableActionTargetPropertyInfo), '("active", CheckButtonActivePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", CheckButtonChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("group", CheckButtonGroupPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("inconsistent", CheckButtonInconsistentPropertyInfo), '("label", CheckButtonLabelPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useUnderline", CheckButtonUseUnderlinePropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
checkButtonActive :: AttrLabelProxy "active"
checkButtonActive = AttrLabelProxy

checkButtonChild :: AttrLabelProxy "child"
checkButtonChild = AttrLabelProxy

checkButtonGroup :: AttrLabelProxy "group"
checkButtonGroup = AttrLabelProxy

checkButtonInconsistent :: AttrLabelProxy "inconsistent"
checkButtonInconsistent = AttrLabelProxy

checkButtonLabel :: AttrLabelProxy "label"
checkButtonLabel = AttrLabelProxy

checkButtonUseUnderline :: AttrLabelProxy "useUnderline"
checkButtonUseUnderline = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CheckButton = CheckButtonSignalList
type CheckButtonSignalList = ('[ '("activate", CheckButtonActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("toggled", CheckButtonToggledSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CheckButton::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "CheckButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_new" gtk_check_button_new :: 
    IO (Ptr CheckButton)

-- | Creates a new @GtkCheckButton@.
checkButtonNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m CheckButton
    -- ^ __Returns:__ a new @GtkCheckButton@
checkButtonNew  = liftIO $ do
    result <- gtk_check_button_new
    checkUnexpectedReturnNULL "checkButtonNew" result
    result' <- (newObject CheckButton) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method CheckButton::new_with_label
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text for the check button."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "CheckButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_new_with_label" gtk_check_button_new_with_label :: 
    CString ->                              -- label : TBasicType TUTF8
    IO (Ptr CheckButton)

-- | Creates a new @GtkCheckButton@ with the given text.
checkButtonNewWithLabel ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@label@/: the text for the check button.
    -> m CheckButton
    -- ^ __Returns:__ a new @GtkCheckButton@
checkButtonNewWithLabel label = liftIO $ do
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    result <- gtk_check_button_new_with_label maybeLabel
    checkUnexpectedReturnNULL "checkButtonNewWithLabel" result
    result' <- (newObject CheckButton) result
    freeMem maybeLabel
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method CheckButton::new_with_mnemonic
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The text of the button, with an underscore\n  in front of the mnemonic character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "CheckButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_new_with_mnemonic" gtk_check_button_new_with_mnemonic :: 
    CString ->                              -- label : TBasicType TUTF8
    IO (Ptr CheckButton)

-- | Creates a new @GtkCheckButton@ with the given text and a mnemonic.
checkButtonNewWithMnemonic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@label@/: The text of the button, with an underscore
    --   in front of the mnemonic character
    -> m CheckButton
    -- ^ __Returns:__ a new @GtkCheckButton@
checkButtonNewWithMnemonic label = liftIO $ do
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    result <- gtk_check_button_new_with_mnemonic maybeLabel
    checkUnexpectedReturnNULL "checkButtonNewWithMnemonic" result
    result' <- (newObject CheckButton) result
    freeMem maybeLabel
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method CheckButton::get_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_get_active" gtk_check_button_get_active :: 
    Ptr CheckButton ->                      -- self : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    IO CInt

-- | Returns whether the check button is active.
checkButtonGetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@self@/: a @GtkCheckButton@
    -> m Bool
    -- ^ __Returns:__ whether the check button is active
checkButtonGetActive self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_check_button_get_active self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CheckButtonGetActiveMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonGetActiveMethodInfo a signature where
    overloadedMethod = checkButtonGetActive

instance O.OverloadedMethodInfo CheckButtonGetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonGetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonGetActive"
        })


#endif

-- method CheckButton::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_get_child" gtk_check_button_get_child :: 
    Ptr CheckButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@button@/ or @NULL@ if [property/@checkButton@/:label] is set.
-- 
-- /Since: 4.8/
checkButtonGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@button@/: a @GtkCheckButton@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@button@/
checkButtonGetChild button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_check_button_get_child button'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr button
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CheckButtonGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonGetChildMethodInfo a signature where
    overloadedMethod = checkButtonGetChild

instance O.OverloadedMethodInfo CheckButtonGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonGetChild"
        })


#endif

-- method CheckButton::get_inconsistent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "check_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_get_inconsistent" gtk_check_button_get_inconsistent :: 
    Ptr CheckButton ->                      -- check_button : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    IO CInt

-- | Returns whether the check button is in an inconsistent state.
checkButtonGetInconsistent ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@checkButton@/: a @GtkCheckButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@checkButton@/ is currently in an inconsistent state
checkButtonGetInconsistent checkButton = liftIO $ do
    checkButton' <- unsafeManagedPtrCastPtr checkButton
    result <- gtk_check_button_get_inconsistent checkButton'
    let result' = (/= 0) result
    touchManagedPtr checkButton
    return result'

#if defined(ENABLE_OVERLOADING)
data CheckButtonGetInconsistentMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonGetInconsistentMethodInfo a signature where
    overloadedMethod = checkButtonGetInconsistent

instance O.OverloadedMethodInfo CheckButtonGetInconsistentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonGetInconsistent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonGetInconsistent"
        })


#endif

-- method CheckButton::get_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_get_label" gtk_check_button_get_label :: 
    Ptr CheckButton ->                      -- self : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    IO CString

-- | Returns the label of the check button or @NULL@ if [property/@checkButton@/:child] is set.
checkButtonGetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@self@/: a @GtkCheckButton@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The label /@self@/ shows next
    --   to the indicator. If no label is shown, 'P.Nothing' will be returned.
checkButtonGetLabel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_check_button_get_label self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CheckButtonGetLabelMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonGetLabelMethodInfo a signature where
    overloadedMethod = checkButtonGetLabel

instance O.OverloadedMethodInfo CheckButtonGetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonGetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonGetLabel"
        })


#endif

-- method CheckButton::get_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_get_use_underline" gtk_check_button_get_use_underline :: 
    Ptr CheckButton ->                      -- self : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    IO CInt

-- | Returns whether underlines in the label indicate mnemonics.
checkButtonGetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@self@/: a @GtkCheckButton@
    -> m Bool
    -- ^ __Returns:__ The value of the [CheckButton:useUnderline]("GI.Gtk.Objects.CheckButton#g:attr:useUnderline") property.
    --   See 'GI.Gtk.Objects.CheckButton.checkButtonSetUseUnderline' for details on how to set
    --   a new value.
checkButtonGetUseUnderline self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_check_button_get_use_underline self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CheckButtonGetUseUnderlineMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonGetUseUnderlineMethodInfo a signature where
    overloadedMethod = checkButtonGetUseUnderline

instance O.OverloadedMethodInfo CheckButtonGetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonGetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonGetUseUnderline"
        })


#endif

-- method CheckButton::set_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_set_active" gtk_check_button_set_active :: 
    Ptr CheckButton ->                      -- self : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Changes the check buttons active state.
checkButtonSetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@self@/: a @GtkCheckButton@
    -> Bool
    -- ^ /@setting@/: the new value to set
    -> m ()
checkButtonSetActive self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_check_button_set_active self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CheckButtonSetActiveMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonSetActiveMethodInfo a signature where
    overloadedMethod = checkButtonSetActive

instance O.OverloadedMethodInfo CheckButtonSetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonSetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonSetActive"
        })


#endif

-- method CheckButton::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_set_child" gtk_check_button_set_child :: 
    Ptr CheckButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@button@/.
-- 
-- Note that by using this API, you take full responsibility for setting
-- up the proper accessibility label and description information for /@button@/.
-- Most likely, you\'ll either set the accessibility label or description
-- for /@button@/ explicitly, or you\'ll set a labelled-by or described-by
-- relations from /@child@/ to /@button@/.
-- 
-- /Since: 4.8/
checkButtonSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@button@/: a @GtkCheckButton@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
checkButtonSetChild button child = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_check_button_set_child button' maybeChild
    touchManagedPtr button
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CheckButtonSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCheckButton a, Gtk.Widget.IsWidget b) => O.OverloadedMethod CheckButtonSetChildMethodInfo a signature where
    overloadedMethod = checkButtonSetChild

instance O.OverloadedMethodInfo CheckButtonSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonSetChild"
        })


#endif

-- method CheckButton::set_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "another `GtkCheckButton` to\n  form a group with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_set_group" gtk_check_button_set_group :: 
    Ptr CheckButton ->                      -- self : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    Ptr CheckButton ->                      -- group : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    IO ()

-- | Adds /@self@/ to the group of /@group@/.
-- 
-- In a group of multiple check buttons, only one button can be active
-- at a time. The behavior of a checkbutton in a group is also commonly
-- known as a *radio button*.
-- 
-- Setting the group of a check button also changes the css name of the
-- indicator widget\'s CSS node to \'radio\'.
-- 
-- Setting up groups in a cycle leads to undefined behavior.
-- 
-- Note that the same effect can be achieved via the t'GI.Gtk.Interfaces.Actionable.Actionable'
-- API, by using the same action with parameter type and state type \'s\'
-- for all buttons in the group, and giving each button its own target
-- value.
checkButtonSetGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a, IsCheckButton b) =>
    a
    -- ^ /@self@/: a @GtkCheckButton@
    -> Maybe (b)
    -- ^ /@group@/: another @GtkCheckButton@ to
    --   form a group with
    -> m ()
checkButtonSetGroup self group = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeGroup <- case group of
        Nothing -> return FP.nullPtr
        Just jGroup -> do
            jGroup' <- unsafeManagedPtrCastPtr jGroup
            return jGroup'
    gtk_check_button_set_group self' maybeGroup
    touchManagedPtr self
    whenJust group touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CheckButtonSetGroupMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCheckButton a, IsCheckButton b) => O.OverloadedMethod CheckButtonSetGroupMethodInfo a signature where
    overloadedMethod = checkButtonSetGroup

instance O.OverloadedMethodInfo CheckButtonSetGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonSetGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonSetGroup"
        })


#endif

-- method CheckButton::set_inconsistent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "check_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "inconsistent"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if state is inconsistent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_set_inconsistent" gtk_check_button_set_inconsistent :: 
    Ptr CheckButton ->                      -- check_button : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    CInt ->                                 -- inconsistent : TBasicType TBoolean
    IO ()

-- | Sets the @GtkCheckButton@ to inconsistent state.
-- 
-- You should turn off the inconsistent state again if the user checks
-- the check button. This has to be done manually.
checkButtonSetInconsistent ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@checkButton@/: a @GtkCheckButton@
    -> Bool
    -- ^ /@inconsistent@/: 'P.True' if state is inconsistent
    -> m ()
checkButtonSetInconsistent checkButton inconsistent = liftIO $ do
    checkButton' <- unsafeManagedPtrCastPtr checkButton
    let inconsistent' = (P.fromIntegral . P.fromEnum) inconsistent
    gtk_check_button_set_inconsistent checkButton' inconsistent'
    touchManagedPtr checkButton
    return ()

#if defined(ENABLE_OVERLOADING)
data CheckButtonSetInconsistentMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonSetInconsistentMethodInfo a signature where
    overloadedMethod = checkButtonSetInconsistent

instance O.OverloadedMethodInfo CheckButtonSetInconsistentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonSetInconsistent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonSetInconsistent"
        })


#endif

-- method CheckButton::set_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The text shown next to the indicator, or %NULL\n  to show no text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_set_label" gtk_check_button_set_label :: 
    Ptr CheckButton ->                      -- self : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    CString ->                              -- label : TBasicType TUTF8
    IO ()

-- | Sets the text of /@self@/.
-- 
-- If [CheckButton:useUnderline]("GI.Gtk.Objects.CheckButton#g:attr:useUnderline") is 'P.True', an underscore
-- in /@label@/ is interpreted as mnemonic indicator, see
-- 'GI.Gtk.Objects.CheckButton.checkButtonSetUseUnderline' for details on this behavior.
checkButtonSetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@self@/: a @GtkCheckButton@
    -> Maybe (T.Text)
    -- ^ /@label@/: The text shown next to the indicator, or 'P.Nothing'
    --   to show no text
    -> m ()
checkButtonSetLabel self label = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    gtk_check_button_set_label self' maybeLabel
    touchManagedPtr self
    freeMem maybeLabel
    return ()

#if defined(ENABLE_OVERLOADING)
data CheckButtonSetLabelMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonSetLabelMethodInfo a signature where
    overloadedMethod = checkButtonSetLabel

instance O.OverloadedMethodInfo CheckButtonSetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonSetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonSetLabel"
        })


#endif

-- method CheckButton::set_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CheckButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCheckButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_button_set_use_underline" gtk_check_button_set_use_underline :: 
    Ptr CheckButton ->                      -- self : TInterface (Name {namespace = "Gtk", name = "CheckButton"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether underlines in the label indicate mnemonics.
-- 
-- If /@setting@/ is 'P.True', an underscore character in /@self@/\'s label
-- indicates a mnemonic accelerator key. This behavior is similar
-- to [Label:useUnderline]("GI.Gtk.Objects.Label#g:attr:useUnderline").
checkButtonSetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsCheckButton a) =>
    a
    -- ^ /@self@/: a @GtkCheckButton@
    -> Bool
    -- ^ /@setting@/: the new value to set
    -> m ()
checkButtonSetUseUnderline self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_check_button_set_use_underline self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CheckButtonSetUseUnderlineMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCheckButton a) => O.OverloadedMethod CheckButtonSetUseUnderlineMethodInfo a signature where
    overloadedMethod = checkButtonSetUseUnderline

instance O.OverloadedMethodInfo CheckButtonSetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CheckButton.checkButtonSetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CheckButton.html#v:checkButtonSetUseUnderline"
        })


#endif


