{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A set of ATK utility functions for event and toolkit support.
-- 
-- A set of ATK utility functions which are used to support event
-- registration of various types, and obtaining the \'root\' accessible
-- of a process and information about the current ATK implementation
-- and toolkit version.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Objects.Util
    ( 

-- * Exported types
    Util(..)                                ,
    IsUtil                                  ,
    toUtil                                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveUtilMethod                       ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Util = Util (SP.ManagedPtr Util)
    deriving (Eq)

instance SP.ManagedPtrNewtype Util where
    toManagedPtr (Util p) = p

foreign import ccall "atk_util_get_type"
    c_atk_util_get_type :: IO B.Types.GType

instance B.Types.TypedObject Util where
    glibType = c_atk_util_get_type

instance B.Types.GObject Util

-- | Type class for types which can be safely cast to t'Util', for instance with `toUtil`.
class (SP.GObject o, O.IsDescendantOf Util o) => IsUtil o
instance (SP.GObject o, O.IsDescendantOf Util o) => IsUtil o

instance O.HasParentTypes Util
type instance O.ParentTypes Util = '[GObject.Object.Object]

-- | Cast to t'Util', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toUtil :: (MIO.MonadIO m, IsUtil o) => o -> m Util
toUtil = MIO.liftIO . B.ManagedPtr.unsafeCastTo Util

-- | Convert t'Util' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Util) where
    gvalueGType_ = c_atk_util_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Util)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Util)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Util ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveUtilMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUtilMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveUtilMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveUtilMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveUtilMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveUtilMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveUtilMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveUtilMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveUtilMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveUtilMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveUtilMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveUtilMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveUtilMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveUtilMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveUtilMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveUtilMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveUtilMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveUtilMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveUtilMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveUtilMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveUtilMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveUtilMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveUtilMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveUtilMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUtilMethod t Util, O.OverloadedMethod info Util p) => OL.IsLabel t (Util -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUtilMethod t Util, O.OverloadedMethod info Util p, R.HasField t Util p) => R.HasField t Util p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUtilMethod t Util, O.OverloadedMethodInfo info Util) => OL.IsLabel t (O.MethodProxy info Util) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Util
type instance O.AttributeList Util = UtilAttributeList
type UtilAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Util = UtilSignalList
type UtilSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


