{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The ATK Interface implemented by components
--  which expose image or pixmap content on-screen.
-- 
-- t'GI.Atk.Interfaces.Image.Image' should be implemented by t'GI.Atk.Objects.Object.Object' subtypes on behalf of
-- components which display image\/pixmap information onscreen, and
-- which provide information (other than just widget borders, etc.)
-- via that image content.  For instance, icons, buttons with icons,
-- toolbar elements, and image viewing panes typically should
-- implement t'GI.Atk.Interfaces.Image.Image'.
-- 
-- t'GI.Atk.Interfaces.Image.Image' primarily provides two types of information: coordinate
-- information (useful for screen review mode of screenreaders, and
-- for use by onscreen magnifiers), and descriptive information.  The
-- descriptive information is provided for alternative, text-only
-- presentation of the most significant information present in the
-- image.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Interfaces.Image
    ( 

-- * Exported types
    Image(..)                               ,
    IsImage                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getImageDescription]("GI.Atk.Interfaces.Image#g:method:getImageDescription"), [getImageLocale]("GI.Atk.Interfaces.Image#g:method:getImageLocale"), [getImagePosition]("GI.Atk.Interfaces.Image#g:method:getImagePosition"), [getImageSize]("GI.Atk.Interfaces.Image#g:method:getImageSize").
-- 
-- ==== Setters
-- [setImageDescription]("GI.Atk.Interfaces.Image#g:method:setImageDescription").

#if defined(ENABLE_OVERLOADING)
    ResolveImageMethod                      ,
#endif

-- ** getImageDescription #method:getImageDescription#

#if defined(ENABLE_OVERLOADING)
    ImageGetImageDescriptionMethodInfo      ,
#endif
    imageGetImageDescription                ,


-- ** getImageLocale #method:getImageLocale#

#if defined(ENABLE_OVERLOADING)
    ImageGetImageLocaleMethodInfo           ,
#endif
    imageGetImageLocale                     ,


-- ** getImagePosition #method:getImagePosition#

#if defined(ENABLE_OVERLOADING)
    ImageGetImagePositionMethodInfo         ,
#endif
    imageGetImagePosition                   ,


-- ** getImageSize #method:getImageSize#

#if defined(ENABLE_OVERLOADING)
    ImageGetImageSizeMethodInfo             ,
#endif
    imageGetImageSize                       ,


-- ** setImageDescription #method:setImageDescription#

#if defined(ENABLE_OVERLOADING)
    ImageSetImageDescriptionMethodInfo      ,
#endif
    imageSetImageDescription                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums

#else
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums

#endif

-- interface Image 
-- | Memory-managed wrapper type.
newtype Image = Image (SP.ManagedPtr Image)
    deriving (Eq)

instance SP.ManagedPtrNewtype Image where
    toManagedPtr (Image p) = p

-- | Type class for types which implement t'Image'.
class (ManagedPtrNewtype o, O.IsDescendantOf Image o) => IsImage o
instance (ManagedPtrNewtype o, O.IsDescendantOf Image o) => IsImage o
-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr Image where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
type family ResolveImageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveImageMethod "getImageDescription" o = ImageGetImageDescriptionMethodInfo
    ResolveImageMethod "getImageLocale" o = ImageGetImageLocaleMethodInfo
    ResolveImageMethod "getImagePosition" o = ImageGetImagePositionMethodInfo
    ResolveImageMethod "getImageSize" o = ImageGetImageSizeMethodInfo
    ResolveImageMethod "setImageDescription" o = ImageSetImageDescriptionMethodInfo
    ResolveImageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveImageMethod t Image, O.OverloadedMethod info Image p) => OL.IsLabel t (Image -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveImageMethod t Image, O.OverloadedMethod info Image p, R.HasField t Image p) => R.HasField t Image p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveImageMethod t Image, O.OverloadedMethodInfo info Image) => OL.IsLabel t (O.MethodProxy info Image) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Image::get_image_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Atk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkImageIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_image_get_image_description" atk_image_get_image_description :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Atk", name = "Image"})
    IO CString

-- | Get a textual description of this image.
imageGetImageDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkImageIface
    -> m T.Text
    -- ^ __Returns:__ a string representing the image description
imageGetImageDescription image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    result <- atk_image_get_image_description image'
    checkUnexpectedReturnNULL "imageGetImageDescription" result
    result' <- cstringToText result
    touchManagedPtr image
    return result'

#if defined(ENABLE_OVERLOADING)
data ImageGetImageDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetImageDescriptionMethodInfo a signature where
    overloadedMethod = imageGetImageDescription

instance O.OverloadedMethodInfo ImageGetImageDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Image.imageGetImageDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Image.html#v:imageGetImageDescription"
        })


#endif

-- method Image::get_image_locale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Atk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An #AtkImage" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_image_get_image_locale" atk_image_get_image_locale :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Atk", name = "Image"})
    IO CString

-- | Retrieves the locale identifier associated to the t'GI.Atk.Interfaces.Image.Image'.
-- 
-- /Since: 1.12/
imageGetImageLocale ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: An t'GI.Atk.Interfaces.Image.Image'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string corresponding to the POSIX
    --   @LC_MESSAGES@ locale used by the image description, or
    --   'P.Nothing' if the image does not specify a locale.
imageGetImageLocale image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    result <- atk_image_get_image_locale image'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr image
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ImageGetImageLocaleMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetImageLocaleMethodInfo a signature where
    overloadedMethod = imageGetImageLocale

instance O.OverloadedMethodInfo ImageGetImageLocaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Image.imageGetImageLocale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Image.html#v:imageGetImageLocale"
        })


#endif

-- method Image::get_image_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Atk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkImageIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "address of #gint to put x coordinate position; otherwise, -1 if value cannot be obtained."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "address of #gint to put y coordinate position; otherwise, -1 if value cannot be obtained."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "coord_type"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "CoordType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "specifies whether the coordinates are relative to the screen\nor to the components top level window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_image_get_image_position" atk_image_get_image_position :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Atk", name = "Image"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    CUInt ->                                -- coord_type : TInterface (Name {namespace = "Atk", name = "CoordType"})
    IO ()

-- | Gets the position of the image in the form of a point specifying the
-- images top-left corner.
-- 
-- If the position can not be obtained (e.g. missing support), x and y are set
-- to -1.
imageGetImagePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkImageIface
    -> Atk.Enums.CoordType
    -- ^ /@coordType@/: specifies whether the coordinates are relative to the screen
    -- or to the components top level window
    -> m ((Int32, Int32))
imageGetImagePosition image coordType = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    let coordType' = (fromIntegral . fromEnum) coordType
    atk_image_get_image_position image' x y coordType'
    x' <- peek x
    y' <- peek y
    touchManagedPtr image
    freeMem x
    freeMem y
    return (x', y')

#if defined(ENABLE_OVERLOADING)
data ImageGetImagePositionMethodInfo
instance (signature ~ (Atk.Enums.CoordType -> m ((Int32, Int32))), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetImagePositionMethodInfo a signature where
    overloadedMethod = imageGetImagePosition

instance O.OverloadedMethodInfo ImageGetImagePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Image.imageGetImagePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Image.html#v:imageGetImagePosition"
        })


#endif

-- method Image::get_image_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Atk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkImageIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "filled with the image width, or -1 if the value cannot be obtained."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "filled with the image height, or -1 if the value cannot be obtained."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_image_get_image_size" atk_image_get_image_size :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Atk", name = "Image"})
    Ptr Int32 ->                            -- width : TBasicType TInt
    Ptr Int32 ->                            -- height : TBasicType TInt
    IO ()

-- | Get the width and height in pixels for the specified image.
-- The values of /@width@/ and /@height@/ are returned as -1 if the
-- values cannot be obtained (for instance, if the object is not onscreen).
-- 
-- If the size can not be obtained (e.g. missing support), x and y are set
-- to -1.
imageGetImageSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkImageIface
    -> m ((Int32, Int32))
imageGetImageSize image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    width <- allocMem :: IO (Ptr Int32)
    height <- allocMem :: IO (Ptr Int32)
    atk_image_get_image_size image' width height
    width' <- peek width
    height' <- peek height
    touchManagedPtr image
    freeMem width
    freeMem height
    return (width', height')

#if defined(ENABLE_OVERLOADING)
data ImageGetImageSizeMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetImageSizeMethodInfo a signature where
    overloadedMethod = imageGetImageSize

instance O.OverloadedMethodInfo ImageGetImageSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Image.imageGetImageSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Image.html#v:imageGetImageSize"
        })


#endif

-- method Image::set_image_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Atk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkImageIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string description to set for @image"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_image_set_image_description" atk_image_set_image_description :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Atk", name = "Image"})
    CString ->                              -- description : TBasicType TUTF8
    IO CInt

-- | Sets the textual description for this image.
imageSetImageDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkImageIface
    -> T.Text
    -- ^ /@description@/: a string description to set for /@image@/
    -> m Bool
    -- ^ __Returns:__ boolean TRUE, or FALSE if operation could
    -- not be completed.
imageSetImageDescription image description = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    description' <- textToCString description
    result <- atk_image_set_image_description image' description'
    let result' = (/= 0) result
    touchManagedPtr image
    freeMem description'
    return result'

#if defined(ENABLE_OVERLOADING)
data ImageSetImageDescriptionMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsImage a) => O.OverloadedMethod ImageSetImageDescriptionMethodInfo a signature where
    overloadedMethod = imageSetImageDescription

instance O.OverloadedMethodInfo ImageSetImageDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Image.imageSetImageDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Image.html#v:imageSetImageDescription"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Image = ImageSignalList
type ImageSignalList = ('[ ] :: [(Symbol, DK.Type)])

#endif


