/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_filterbank_vcvcf = R"doc(Filterbank with vector of gr_complex input, vector of gr_complex output and float taps.

This block takes in complex vectors and outputs complex vectors of the same size. Vectors of length N, rather than N normal streams are used to reduce overhead.

Constructor Specific Documentation:

Build the filterbank.

Args:
    taps : (vector of vector of floats/list of list of floats) Used to populate the filters.)doc";


static const char* __doc_gr_filter_filterbank_vcvcf_filterbank_vcvcf_0 = R"doc()doc";


static const char* __doc_gr_filter_filterbank_vcvcf_filterbank_vcvcf_1 = R"doc()doc";


static const char* __doc_gr_filter_filterbank_vcvcf_make = R"doc(Filterbank with vector of gr_complex input, vector of gr_complex output and float taps.

This block takes in complex vectors and outputs complex vectors of the same size. Vectors of length N, rather than N normal streams are used to reduce overhead.

Constructor Specific Documentation:

Build the filterbank.

Args:
    taps : (vector of vector of floats/list of list of floats) Used to populate the filters.)doc";


static const char* __doc_gr_filter_filterbank_vcvcf_set_taps = R"doc(Resets the filterbank's filter taps with the new prototype filter)doc";


static const char* __doc_gr_filter_filterbank_vcvcf_print_taps = R"doc(Print all of the filterbank taps to screen.)doc";


static const char* __doc_gr_filter_filterbank_vcvcf_taps = R"doc(Return a vector<vector<>> of the filterbank taps)doc";
