//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/quota/PQuotaRequestParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/quota/SerializationHelpers.h"

#include "mozilla/dom/quota/PQuotaParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace quota {


MOZ_IMPLICIT PQuotaRequestParent::PQuotaRequestParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PQuotaRequestParent);
}

PQuotaRequestParent::~PQuotaRequestParent()
{
    MOZ_COUNT_DTOR(PQuotaRequestParent);
}

auto PQuotaRequestParent::ActorAlloc() -> void
{
}

auto PQuotaRequestParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PQuotaRequestParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PQuotaRequestParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PQuotaRequestParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PQuotaRequestParent::Manager() const -> PQuotaParent*
{
    return static_cast<PQuotaParent*>(IProtocol::Manager());
}

auto PQuotaRequestParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PQuotaRequestParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PQuotaRequestParent::Send__delete__(
        PQuotaRequestParent* actor,
        const RequestResponse& response) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PQuotaRequest::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};

    IPC::WriteParam((&(writer__)), response);
    // Sentinel = 'response'
    ((&(writer__)))->WriteSentinel(260965232);

    if (mozilla::ipc::LoggingEnabledFor("PQuotaRequest", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaRequestParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuotaRequest::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PQuotaRequestParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PQuotaRequestParent::OnMessageReceived(const Message& msg__) -> PQuotaRequestParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PQuotaRequest::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PQuotaRequestParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PQuotaRequestParent::Result
{
    return MsgNotKnown;
}



} // namespace quota
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::quota::PQuotaRequestParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PQuotaRequest'
    (aWriter)->WriteSentinel(596641092);
}

auto ParamTraits<::mozilla::dom::quota::PQuotaRequestParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PQuotaRequest actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PQuotaRequest'
    if ((!((aReader)->ReadSentinel(596641092)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PQuotaRequest actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PQuotaRequestMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PQuotaRequest)");

        return {};
    }
    return static_cast<::mozilla::dom::quota::PQuotaRequestParent*>(actor);
}

} // namespace IPC
