/* THIS FILE IS AUTOGENERATED FROM Request.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "RequestBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "jsfriendapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/StaticPrefs_network.h"
#include "mozilla/dom/AbortSignal.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Blob.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/FormData.h"
#include "mozilla/dom/Headers.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/Request.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/URLSearchParams.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RequestDestination>::Values[21];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestDestination aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RequestDestination>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RequestDestination>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RequestDestination>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RequestMode>::Values[4];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestMode aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RequestMode>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RequestMode>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RequestMode>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RequestCredentials>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestCredentials aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RequestCredentials>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RequestCredentials>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RequestCredentials>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RequestCache>::Values[6];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestCache aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RequestCache>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RequestCache>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RequestCache>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RequestRedirect>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestRedirect aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RequestRedirect>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RequestRedirect>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RequestRedirect>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RequestPriority>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestPriority aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RequestPriority>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RequestPriority>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RequestPriority>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRequestOrUTF8String& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsRequest()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsRequest(), "mRequest", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningRequestOrUTF8String& aUnion)
{
  aUnion.Uninit();
}



RequestInit::RequestInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
RequestInit::InitIds(JSContext* cx, RequestInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->triggeringPrincipal_id.init(cx, "triggeringPrincipal") ||
      !atomsCache->signal_id.init(cx, "signal") ||
      !atomsCache->referrerPolicy_id.init(cx, "referrerPolicy") ||
      !atomsCache->referrer_id.init(cx, "referrer") ||
      !atomsCache->redirect_id.init(cx, "redirect") ||
      !atomsCache->priority_id.init(cx, "priority") ||
      !atomsCache->observe_id.init(cx, "observe") ||
      !atomsCache->neverTaint_id.init(cx, "neverTaint") ||
      !atomsCache->mozErrors_id.init(cx, "mozErrors") ||
      !atomsCache->mode_id.init(cx, "mode") ||
      !atomsCache->method_id.init(cx, "method") ||
      !atomsCache->keepalive_id.init(cx, "keepalive") ||
      !atomsCache->integrity_id.init(cx, "integrity") ||
      !atomsCache->headers_id.init(cx, "headers") ||
      !atomsCache->credentials_id.init(cx, "credentials") ||
      !atomsCache->cache_id.init(cx, "cache") ||
      !atomsCache->body_id.init(cx, "body")) {
    return false;
  }
  return true;
}

bool
RequestInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RequestInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RequestInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->body_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mBody.Construct();
    if (temp.ref().isNullOrUndefined()) {
      (mBody.Value()).SetNull();
    } else {
      if (!(mBody.Value()).SetValue().Init(cx, temp.ref(), "'body' member of RequestInit", passedToJSImpl)) {
        return false;
      }
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->cache_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mCache.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RequestCache>::Values,
                                                                         "RequestCache", "'cache' member of RequestInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mCache.Value()) = static_cast<RequestCache>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->credentials_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mCredentials.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RequestCredentials>::Values,
                                                                         "RequestCredentials", "'credentials' member of RequestInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mCredentials.Value()) = static_cast<RequestCredentials>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->headers_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mHeaders.Construct();
    if (!(mHeaders.Value()).Init(cx, temp.ref(), "'headers' member of RequestInit", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->integrity_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mIntegrity.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mIntegrity.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (StaticPrefs::dom_fetchKeepalive_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->keepalive_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mKeepalive.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'keepalive' member of RequestInit", &(mKeepalive.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->method_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mMethod.Construct();
    if (!ConvertJSValueToByteString(cx, temp.ref(), false, "'method' member of RequestInit", (mMethod.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->mode_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mMode.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RequestMode>::Values,
                                                                         "RequestMode", "'mode' member of RequestInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mMode.Value()) = static_cast<RequestMode>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (nsContentUtils::ThreadsafeIsSystemCaller(cx)) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->mozErrors_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mMozErrors.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'mozErrors' member of RequestInit", &(mMozErrors.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (nsContentUtils::ThreadsafeIsSystemCaller(cx)) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->neverTaint_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mNeverTaint.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'neverTaint' member of RequestInit", &(mNeverTaint.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (StaticPrefs::dom_fetchObserver_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->observe_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mObserve.Construct();
    if (temp.ref().isObject()) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &temp.ref().toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        (mObserve.Value()) = new ObserverCallback(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'observe' member of RequestInit");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (StaticPrefs::network_fetchpriority_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->priority_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPriority.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RequestPriority>::Values,
                                                                         "RequestPriority", "'priority' member of RequestInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mPriority.Value()) = static_cast<RequestPriority>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->redirect_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mRedirect.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RequestRedirect>::Values,
                                                                         "RequestRedirect", "'redirect' member of RequestInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mRedirect.Value()) = static_cast<RequestRedirect>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->referrer_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mReferrer.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mReferrer.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->referrerPolicy_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mReferrerPolicy.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<ReferrerPolicy>::Values,
                                                                         "ReferrerPolicy", "'referrerPolicy' member of RequestInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mReferrerPolicy.Value()) = static_cast<ReferrerPolicy>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->signal_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSignal.Construct();
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<mozilla::dom::AbortSignal>::value, "We can only store refcounted classes.");
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::AbortSignal, mozilla::dom::AbortSignal>(temp.ptr(), (mSignal.Value()), cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'signal' member of RequestInit", "AbortSignal");
          return false;
        }
      }
    } else if (temp.ref().isNullOrUndefined()) {
      (mSignal.Value()) = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'signal' member of RequestInit");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (nsContentUtils::ThreadsafeIsSystemCaller(cx)) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->triggeringPrincipal_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mTriggeringPrincipal.Construct();
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsIPrincipal>::value, "We can only store refcounted classes.");
      RefPtr<nsIPrincipal> holder;
      JS::Rooted<JSObject*> source(cx, &temp.ref().toObject());
      if (NS_FAILED(UnwrapArg<nsIPrincipal>(cx, source, getter_AddRefs(holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'triggeringPrincipal' member of RequestInit", "Principal");
        return false;
      }
      MOZ_ASSERT(holder);
      (mTriggeringPrincipal.Value()) = holder;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'triggeringPrincipal' member of RequestInit");
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RequestInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
RequestInit::TraceDictionary(JSTracer* trc)
{
  if (mBody.WasPassed()) {
    if (!mBody.Value().IsNull()) {
      mBody.Value().Value().TraceUnion(trc);
    }
  }
}




bool
RequestOrUTF8String::TrySetToRequest(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::Request>& memberSlot = RawSetAsRequest();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Request, mozilla::dom::Request>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyRequest();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
RequestOrUTF8String::TrySetToRequest(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToRequest(cx, value, tryNext, passedToJSImpl);
}







bool
RequestOrUTF8String::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char>& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
RequestOrUTF8String::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToRequest(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Request");
    return false;
  }
  return true;
}

bool
RequestOrUTF8String::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
RequestOrUTF8String::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eRequest: {
      if (!GetOrCreateDOMReflector(cx, mValue.mRequest.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningRequestOrUTF8String::OwningRequestOrUTF8String(OwningRequestOrUTF8String&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eRequest: {
      mType = eRequest;
      mValue.mRequest.SetValue(std::move(aOther.mValue.mRequest.Value()));
      break;
    }
    case eUTF8String: {
      mType = eUTF8String;
      mValue.mUTF8String.SetValue(std::move(aOther.mValue.mUTF8String.Value()));
      break;
    }
  }
}



bool
OwningRequestOrUTF8String::TrySetToRequest(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::Request>& memberSlot = RawSetAsRequest();
    static_assert(IsRefcounted<mozilla::dom::Request>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Request, mozilla::dom::Request>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyRequest();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningRequestOrUTF8String::TrySetToRequest(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToRequest(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::Request>&
OwningRequestOrUTF8String::RawSetAsRequest()
{
  if (mType == eRequest) {
    return mValue.mRequest.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eRequest;
  return mValue.mRequest.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::Request>&
OwningRequestOrUTF8String::SetAsRequest()
{
  if (mType == eRequest) {
    return mValue.mRequest.Value();
  }
  Uninit();
  mType = eRequest;
  return mValue.mRequest.SetValue();
}


void
OwningRequestOrUTF8String::DestroyRequest()
{
  MOZ_RELEASE_ASSERT(IsRequest(), "Wrong type!");
  mValue.mRequest.Destroy();
  mType = eUninitialized;
}



bool
OwningRequestOrUTF8String::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsCString& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsCString&
OwningRequestOrUTF8String::RawSetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}

[[nodiscard]] nsCString&
OwningRequestOrUTF8String::SetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  Uninit();
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}



void
OwningRequestOrUTF8String::DestroyUTF8String()
{
  MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
  mValue.mUTF8String.Destroy();
  mType = eUninitialized;
}



bool
OwningRequestOrUTF8String::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToRequest(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Request");
    return false;
  }
  return true;
}

bool
OwningRequestOrUTF8String::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningRequestOrUTF8String::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eRequest: {
      DestroyRequest();
      break;
    }
    case eUTF8String: {
      DestroyUTF8String();
      break;
    }
  }
}

bool
OwningRequestOrUTF8String::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eRequest: {
      if (!GetOrCreateDOMReflector(cx, mValue.mRequest.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningRequestOrUTF8String&
OwningRequestOrUTF8String::operator=(OwningRequestOrUTF8String&& aOther)
{
  this->~OwningRequestOrUTF8String();
  new (this) OwningRequestOrUTF8String (std::move(aOther));
  return *this;
}


OwningRequestOrUTF8String&
OwningRequestOrUTF8String::operator=(const OwningRequestOrUTF8String& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eRequest: {
      SetAsRequest() = aOther.GetAsRequest();
      break;
    }
    case eUTF8String: {
      SetAsUTF8String() = aOther.GetAsUTF8String();
      break;
    }
  }
  return *this;
}


namespace Request_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_method(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "method", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetMethod(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetMethod(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidByteStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo method_getterinfo = {
  { get_method },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_url(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "url", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetUrl(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetUrl(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo url_getterinfo = {
  { get_url },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_headers(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "headers", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Headers>(MOZ_KnownLive(self)->Headers_()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo headers_getterinfo = {
  { get_headers },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_destination(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "destination", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  RequestDestination result(MOZ_KnownLive(self)->Destination());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo destination_getterinfo = {
  { get_destination },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_referrer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "referrer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetReferrer(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetReferrer(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo referrer_getterinfo = {
  { get_referrer },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_referrerPolicy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "referrerPolicy", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  ReferrerPolicy result(MOZ_KnownLive(self)->ReferrerPolicy_());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo referrerPolicy_getterinfo = {
  { get_referrerPolicy },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "mode", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  RequestMode result(MOZ_KnownLive(self)->Mode());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo mode_getterinfo = {
  { get_mode },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_credentials(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "credentials", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  RequestCredentials result(MOZ_KnownLive(self)->Credentials());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo credentials_getterinfo = {
  { get_credentials },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_cache(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "cache", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  RequestCache result(MOZ_KnownLive(self)->Cache());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo cache_getterinfo = {
  { get_cache },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_redirect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "redirect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  RequestRedirect result(MOZ_KnownLive(self)->Redirect());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo redirect_getterinfo = {
  { get_redirect },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_integrity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "integrity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetIntegrity(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetIntegrity(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo integrity_getterinfo = {
  { get_integrity },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_keepalive(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "keepalive", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  bool result(MOZ_KnownLive(self)->Keepalive());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo keepalive_getterinfo = {
  { get_keepalive },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mozErrors(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "mozErrors", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  bool result(MOZ_KnownLive(self)->MozErrors());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo mozErrors_getterinfo = {
  { get_mozErrors },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_signal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "signal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::AbortSignal>(MOZ_KnownLive(self)->GetOrCreateSignal()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo signal_getterinfo = {
  { get_signal },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clone(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "clone", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Request>(MOZ_KnownLive(self)->Clone(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Request.clone"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo clone_methodinfo = {
  { (JSJitGetterOp)clone },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
overrideContentPolicyType(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "overrideContentPolicyType", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  if (!args.requireAtLeast(cx, "Request.overrideContentPolicyType", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OverrideContentPolicyType(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->OverrideContentPolicyType(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo overrideContentPolicyType_methodinfo = {
  { (JSJitGetterOp)overrideContentPolicyType },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_bodyUsed(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "bodyUsed", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  bool result(MOZ_KnownLive(self)->BodyUsed());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo bodyUsed_getterinfo = {
  { get_bodyUsed },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
arrayBuffer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "arrayBuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->ArrayBuffer(cx, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Request.arrayBuffer"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
arrayBuffer_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = arrayBuffer(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo arrayBuffer_methodinfo = {
  { (JSJitGetterOp)arrayBuffer_promiseWrapper },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
blob(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "blob", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Blob(cx, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Request.blob"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
blob_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = blob(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo blob_methodinfo = {
  { (JSJitGetterOp)blob_promiseWrapper },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bytes(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "bytes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Bytes(cx, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Request.bytes"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
bytes_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = bytes(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo bytes_methodinfo = {
  { (JSJitGetterOp)bytes_promiseWrapper },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
formData(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "formData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->FormData(cx, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Request.formData"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
formData_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = formData(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo formData_methodinfo = {
  { (JSJitGetterOp)formData_promiseWrapper },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
json(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "json", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Json(cx, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Request.json"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
json_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = json(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo json_methodinfo = {
  { (JSJitGetterOp)json_promiseWrapper },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
text(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "text", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Request*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Text(cx, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Request.text"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
text_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = text(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo text_methodinfo = {
  { (JSJitGetterOp)text_promiseWrapper },
  { prototypes::id::Request },
  { PrototypeTraits<prototypes::id::Request>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::Request* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::Request>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::Request>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("clone", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clone_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("arrayBuffer", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&arrayBuffer_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blob", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&blob_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bytes", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&bytes_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("formData", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&formData_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("json", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&json_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("text", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&text_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(7 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeMethods_specs[] = {
  JS_FNSPEC("overrideContentPolicyType", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&overrideContentPolicyType_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeMethods[] = {
  { nullptr, &sChromeMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("method", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &method_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("url", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &url_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("headers", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &headers_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("destination", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &destination_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("referrer", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &referrer_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("referrerPolicy", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &referrerPolicy_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("mode", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &mode_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("credentials", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &credentials_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("cache", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &cache_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("redirect", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &redirect_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("integrity", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &integrity_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("keepalive", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &keepalive_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("signal", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &signal_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("bodyUsed", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &bodyUsed_getterinfo, nullptr, nullptr),
  JS_PS_END
};

static const PrefableDisablers sAttributes_disablers12 = {
  WebIDLPrefIndex::dom_fetchKeepalive_enabled, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { &sAttributes_disablers12, &sAttributes_specs[12] },
  { nullptr, &sAttributes_specs[14] },
  { nullptr, nullptr }
};

static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(11 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sChromeAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("mozErrors", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &mozErrors_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sChromeAttributes[] = {
  { nullptr, &sChromeAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[21];
static PropertyInfo sNativeProperties_propertyInfos[21];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  21,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[7] }
  }
};
static_assert(21 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[2];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[2];

static const NativePropertiesN<2> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sChromeMethods */,
  true,  1 /* sChromeAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  2,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeMethods, &sChromeOnlyNativeProperties_propertyInfos[0] },
    { sChromeAttributes, &sChromeOnlyNativeProperties_propertyInfos[1] }
  }
};
static_assert(2 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::Request,
  constructors::id::Request,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "Request constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Request", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "Request");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::Request,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "Request constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  RequestOrUTF8String arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  RootedDictionary<binding_detail::FastRequestInit> arg1(cx);
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
    if (arg1.mBody.WasPassed()) {
      if (!arg1.mBody.Value().IsNull()) {
        if (arg1.mBody.Value().Value().IsArrayBufferView()) {
          if (!arg1.mBody.Value().Value().GetAsArrayBufferView().WrapIntoNewCompartment(cx)) {
            return false;
          }
        }
        else if (arg1.mBody.Value().Value().IsArrayBuffer()) {
          if (!arg1.mBody.Value().Value().GetAsArrayBuffer().WrapIntoNewCompartment(cx)) {
            return false;
          }
        }
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Request>(mozilla::dom::Request::Constructor(global, Constify(arg0), Constify(arg1), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Request constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::Request>::Depth,
  prototypes::id::Request,
  true,
  1,
  "Request",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "RequestPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::Request,
  PrototypeTraits<prototypes::id::Request>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "Request",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::Request>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Request, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::Request>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::Request>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::Request>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::Request>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::Request* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::Request>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::Request*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::Request> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::Request);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::Request);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "Request",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::Request,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::Request,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace Request_Binding



} // namespace dom


} // namespace mozilla
