/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM RTCDataChannelEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "RTCDataChannelEvent.h"
#include "RTCDataChannelEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RTCDataChannel.h"
#include "mozilla/dom/RTCDataChannelEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(RTCDataChannelEvent)

NS_IMPL_ADDREF_INHERITED(RTCDataChannelEvent, Event)
NS_IMPL_RELEASE_INHERITED(RTCDataChannelEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(RTCDataChannelEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mChannel)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(RTCDataChannelEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(RTCDataChannelEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mChannel)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(RTCDataChannelEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

RTCDataChannelEvent::RTCDataChannelEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

RTCDataChannelEvent::~RTCDataChannelEvent()
{
}

RTCDataChannelEvent*
RTCDataChannelEvent::AsRTCDataChannelEvent()
{
  return this;
}

JSObject*
RTCDataChannelEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return RTCDataChannelEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<RTCDataChannelEvent>
RTCDataChannelEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const RTCDataChannelEventInit& aEventInitDict)
{
  RefPtr<RTCDataChannelEvent> e = new RTCDataChannelEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mChannel = aEventInitDict.mChannel;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<RTCDataChannelEvent>
RTCDataChannelEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const RTCDataChannelEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

RTCDataChannel*
RTCDataChannelEvent::Channel() const
{
  return mChannel;
}


} // namespace mozilla::dom
