/* WindowIcon.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowIcon.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "workspacesapplet.h"
#include <libxfce4windowing/libxfce4windowing.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WORKSPACES_WINDOW_ICON_0_PROPERTY,
	WORKSPACES_WINDOW_ICON_WINDOW_PROPERTY,
	WORKSPACES_WINDOW_ICON_NUM_PROPERTIES
};
static GParamSpec* workspaces_window_icon_properties[WORKSPACES_WINDOW_ICON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block7Data Block7Data;

struct _WorkspacesWindowIconPrivate {
	XfwWindow* _window;
};

struct _Block7Data {
	int _ref_count_;
	WorkspacesWindowIcon* self;
	GtkImage* icon;
};

static gint WorkspacesWindowIcon_private_offset;
static gpointer workspaces_window_icon_parent_class = NULL;
static GType workspaces_window_icon_type_id = 0;

static gboolean workspaces_window_icon_real_button_release_event (GtkWidget* base,
                                                           GdkEventButton* event);
static void workspaces_window_icon_on_drag_begin (WorkspacesWindowIcon* self,
                                           GtkWidget* widget,
                                           GdkDragContext* context);
static void workspaces_window_icon_on_drag_end (WorkspacesWindowIcon* self,
                                         GtkWidget* widget,
                                         GdkDragContext* context);
static GObject * workspaces_window_icon_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _workspaces_window_icon___lambda11_ (WorkspacesWindowIcon* self);
static void __workspaces_window_icon___lambda11__libxfce4windowing_window_name_changed (XfwWindow* _sender,
                                                                                 gpointer self);
static void _workspaces_window_icon___lambda12_ (Block7Data* _data7_);
static void __workspaces_window_icon___lambda12__libxfce4windowing_window_icon_changed (XfwWindow* _sender,
                                                                                 gpointer self);
static void _workspaces_window_icon_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                                  GdkDragContext* context,
                                                                  gpointer self);
static void _workspaces_window_icon_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                              GdkDragContext* context,
                                                              gpointer self);
static void _workspaces_window_icon_on_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                        GdkDragContext* context,
                                                                        GtkSelectionData* selection_data,
                                                                        guint info,
                                                                        guint time_,
                                                                        gpointer self);
static void workspaces_window_icon_finalize (GObject * obj);
static void _vala_workspaces_window_icon_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_workspaces_window_icon_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const GtkTargetEntry WORKSPACES_target_list[1];

static inline gpointer
workspaces_window_icon_get_instance_private (WorkspacesWindowIcon* self)
{
	return G_STRUCT_MEMBER_P (self, WorkspacesWindowIcon_private_offset);
}

WorkspacesWindowIcon*
workspaces_window_icon_construct (GType object_type,
                                  XfwWindow* window)
{
	WorkspacesWindowIcon * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (WorkspacesWindowIcon*) g_object_new (object_type, "window", window, NULL);
	return self;
}

WorkspacesWindowIcon*
workspaces_window_icon_new (XfwWindow* window)
{
	return workspaces_window_icon_construct (WORKSPACES_TYPE_WINDOW_ICON, window);
}

static gboolean
workspaces_window_icon_real_button_release_event (GtkWidget* base,
                                                  GdkEventButton* event)
{
	WorkspacesWindowIcon * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (WorkspacesWindowIcon*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = GDK_EVENT_STOP;
		return result;
	}
	{
		XfwWindow* _tmp0_;
		_tmp0_ = self->priv->_window;
		xfw_window_activate (_tmp0_, NULL, (guint64) event->time, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("WindowIcon.vala:76: Failed to activate window: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = GDK_EVENT_STOP;
	return result;
}

static void
workspaces_window_icon_on_drag_begin (WorkspacesWindowIcon* self,
                                      GtkWidget* widget,
                                      GdkDragContext* context)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	workspaces_workspaces_applet_dragging = TRUE;
}

static void
workspaces_window_icon_on_drag_end (WorkspacesWindowIcon* self,
                                    GtkWidget* widget,
                                    GdkDragContext* context)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	workspaces_workspaces_applet_dragging = FALSE;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

void
workspaces_window_icon_on_drag_data_get (WorkspacesWindowIcon* self,
                                         GtkWidget* widget,
                                         GdkDragContext* context,
                                         GtkSelectionData* selection_data,
                                         guint target_type,
                                         guint time)
{
	XfwWindow* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = self->priv->_window;
	_tmp2_ = _tmp1_ = xfw_window_get_class_ids (_tmp0_);
	_tmp3_ = _vala_g_strjoinv (",", _tmp2_, (gint) _vala_array_length (_tmp1_));
	_tmp4_ = _tmp3_;
	gtk_selection_data_set_text (selection_data, _tmp4_, -1);
	_g_free0 (_tmp4_);
}

XfwWindow*
workspaces_window_icon_get_window (WorkspacesWindowIcon* self)
{
	XfwWindow* result;
	XfwWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
workspaces_window_icon_set_window (WorkspacesWindowIcon* self,
                                   XfwWindow* value)
{
	XfwWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = workspaces_window_icon_get_window (self);
	if (old_value != value) {
		XfwWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, workspaces_window_icon_properties[WORKSPACES_WINDOW_ICON_WINDOW_PROPERTY]);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		WorkspacesWindowIcon* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->icon);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_workspaces_window_icon___lambda11_ (WorkspacesWindowIcon* self)
{
	XfwWindow* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = self->priv->_window;
	_tmp1_ = xfw_window_get_name (_tmp0_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp1_);
}

static void
__workspaces_window_icon___lambda11__libxfce4windowing_window_name_changed (XfwWindow* _sender,
                                                                            gpointer self)
{
	_workspaces_window_icon___lambda11_ ((WorkspacesWindowIcon*) self);
}

static void
_workspaces_window_icon___lambda12_ (Block7Data* _data7_)
{
	WorkspacesWindowIcon* self;
	GdkPixbuf* pixbuf = NULL;
	XfwWindow* _tmp0_;
	GdkPixbuf* _tmp1_;
	GtkImage* _tmp2_;
	GdkPixbuf* _tmp3_;
	GtkImage* _tmp4_;
	GdkPixbuf* _tmp5_;
	self = _data7_->self;
	_tmp0_ = self->priv->_window;
	_tmp1_ = xfw_window_get_icon (_tmp0_, WORKSPACES_WORKSPACE_ICON_SIZE, gtk_widget_get_scale_factor ((GtkWidget*) self));
	pixbuf = _tmp1_;
	_tmp2_ = _data7_->icon;
	_tmp3_ = pixbuf;
	gtk_image_set_from_pixbuf (_tmp2_, _tmp3_);
	_tmp4_ = _data7_->icon;
	gtk_widget_queue_draw ((GtkWidget*) _tmp4_);
	_tmp5_ = pixbuf;
	gtk_drag_source_set_icon_pixbuf ((GtkWidget*) self, _tmp5_);
}

static void
__workspaces_window_icon___lambda12__libxfce4windowing_window_icon_changed (XfwWindow* _sender,
                                                                            gpointer self)
{
	_workspaces_window_icon___lambda12_ (self);
}

static void
_workspaces_window_icon_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             gpointer self)
{
	workspaces_window_icon_on_drag_begin ((WorkspacesWindowIcon*) self, _sender, context);
}

static void
_workspaces_window_icon_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                         GdkDragContext* context,
                                                         gpointer self)
{
	workspaces_window_icon_on_drag_end ((WorkspacesWindowIcon*) self, _sender, context);
}

static void
_workspaces_window_icon_on_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                   GdkDragContext* context,
                                                                   GtkSelectionData* selection_data,
                                                                   guint info,
                                                                   guint time_,
                                                                   gpointer self)
{
	workspaces_window_icon_on_drag_data_get ((WorkspacesWindowIcon*) self, _sender, context, selection_data, info, time_);
}

static GObject *
workspaces_window_icon_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WorkspacesWindowIcon * self;
	Block7Data* _data7_;
	GtkStyleContext* _tmp0_;
	XfwWindow* _tmp1_;
	const gchar* _tmp2_;
	XfwWindow* _tmp3_;
	XfwApplication* _tmp4_;
	XfwApplication* _tmp5_;
	XfwApplication* _tmp6_;
	gboolean _tmp7_;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	XfwWindow* _tmp16_;
	XfwWindow* _tmp17_;
	parent_class = G_OBJECT_CLASS (workspaces_window_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WORKSPACES_TYPE_WINDOW_ICON, WorkspacesWindowIcon);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "workspace-icon-button");
	_tmp1_ = self->priv->_window;
	_tmp2_ = xfw_window_get_name (_tmp1_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp2_);
	_tmp3_ = self->priv->_window;
	g_object_get (_tmp3_, "application", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != NULL;
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		GdkPixbuf* pixbuf = NULL;
		XfwWindow* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		GtkImage* _tmp11_;
		_tmp8_ = self->priv->_window;
		_tmp9_ = xfw_window_get_icon (_tmp8_, WORKSPACES_WORKSPACE_ICON_SIZE, gtk_widget_get_scale_factor ((GtkWidget*) self));
		pixbuf = _tmp9_;
		_tmp10_ = pixbuf;
		_tmp11_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp10_);
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (_data7_->icon);
		_data7_->icon = _tmp11_;
	} else {
		GtkImage* _tmp12_;
		GtkImage* _tmp13_;
		_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name (WORKSPACES_FALLBACK_ICON_NAME, (GtkIconSize) GTK_ICON_SIZE_INVALID);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (_data7_->icon);
		_data7_->icon = _tmp12_;
		_tmp13_ = _data7_->icon;
		gtk_image_set_pixel_size (_tmp13_, WORKSPACES_WORKSPACE_ICON_SIZE);
	}
	_tmp14_ = _data7_->icon;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
	_tmp15_ = _data7_->icon;
	gtk_widget_show ((GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->_window;
	g_signal_connect_object (_tmp16_, "name-changed", (GCallback) __workspaces_window_icon___lambda11__libxfce4windowing_window_name_changed, self, 0);
	_tmp17_ = self->priv->_window;
	g_signal_connect_data (_tmp17_, "icon-changed", (GCallback) __workspaces_window_icon___lambda12__libxfce4windowing_window_icon_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, WORKSPACES_target_list, (gint) G_N_ELEMENTS (WORKSPACES_target_list), GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkWidget*) self, "drag-begin", (GCallback) _workspaces_window_icon_on_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-end", (GCallback) _workspaces_window_icon_on_drag_end_gtk_widget_drag_end, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-get", (GCallback) _workspaces_window_icon_on_drag_data_get_gtk_widget_drag_data_get, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return obj;
}

static void
workspaces_window_icon_class_init (WorkspacesWindowIconClass * klass,
                                   gpointer klass_data)
{
	workspaces_window_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WorkspacesWindowIcon_private_offset);
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) workspaces_window_icon_real_button_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_workspaces_window_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_workspaces_window_icon_set_property;
	G_OBJECT_CLASS (klass)->constructor = workspaces_window_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = workspaces_window_icon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORKSPACES_WINDOW_ICON_WINDOW_PROPERTY, workspaces_window_icon_properties[WORKSPACES_WINDOW_ICON_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", xfw_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
workspaces_window_icon_instance_init (WorkspacesWindowIcon * self,
                                      gpointer klass)
{
	self->priv = workspaces_window_icon_get_instance_private (self);
}

static void
workspaces_window_icon_finalize (GObject * obj)
{
	WorkspacesWindowIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WORKSPACES_TYPE_WINDOW_ICON, WorkspacesWindowIcon);
	_g_object_unref0 (self->priv->_window);
	G_OBJECT_CLASS (workspaces_window_icon_parent_class)->finalize (obj);
}

GType
workspaces_window_icon_get_type (void)
{
	return workspaces_window_icon_type_id;
}

GType
workspaces_window_icon_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WorkspacesWindowIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workspaces_window_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WorkspacesWindowIcon), 0, (GInstanceInitFunc) workspaces_window_icon_instance_init, NULL };
	workspaces_window_icon_type_id = g_type_module_register_type (module, gtk_button_get_type (), "WorkspacesWindowIcon", &g_define_type_info, 0);
	WorkspacesWindowIcon_private_offset = sizeof (WorkspacesWindowIconPrivate);
	return workspaces_window_icon_type_id;
}

static void
_vala_workspaces_window_icon_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	WorkspacesWindowIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WORKSPACES_TYPE_WINDOW_ICON, WorkspacesWindowIcon);
	switch (property_id) {
		case WORKSPACES_WINDOW_ICON_WINDOW_PROPERTY:
		g_value_set_object (value, workspaces_window_icon_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_workspaces_window_icon_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	WorkspacesWindowIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WORKSPACES_TYPE_WINDOW_ICON, WorkspacesWindowIcon);
	switch (property_id) {
		case WORKSPACES_WINDOW_ICON_WINDOW_PROPERTY:
		workspaces_window_icon_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

