/* src/bazaar.p/bz-pride-flag-stripe-spec.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-pride-flag-stripe-spec.h"



struct _BzPrideFlagStripeSpec
{
  GObject parent_instance;

  char *rgba;
  double size;
};

G_DEFINE_FINAL_TYPE (BzPrideFlagStripeSpec, bz_pride_flag_stripe_spec, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_RGBA,
  PROP_SIZE,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_pride_flag_stripe_spec_dispose (GObject *object)
{
  BzPrideFlagStripeSpec *self = BZ_PRIDE_FLAG_STRIPE_SPEC (object);

  g_clear_pointer (&self->rgba, g_free);

  G_OBJECT_CLASS (bz_pride_flag_stripe_spec_parent_class)->dispose (object);
}

static void
bz_pride_flag_stripe_spec_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzPrideFlagStripeSpec *self = BZ_PRIDE_FLAG_STRIPE_SPEC (object);

  switch (prop_id)
    {
    case PROP_RGBA:
      g_value_set_string (value, bz_pride_flag_stripe_spec_get_rgba (self));
      break;
    case PROP_SIZE:
      g_value_set_double (value, bz_pride_flag_stripe_spec_get_size (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_pride_flag_stripe_spec_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzPrideFlagStripeSpec *self = BZ_PRIDE_FLAG_STRIPE_SPEC (object);

  switch (prop_id)
    {
    case PROP_RGBA:
      bz_pride_flag_stripe_spec_set_rgba (self, g_value_get_string (value));
      break;
    case PROP_SIZE:
      bz_pride_flag_stripe_spec_set_size (self, g_value_get_double (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_pride_flag_stripe_spec_class_init (BzPrideFlagStripeSpecClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_pride_flag_stripe_spec_set_property;
  object_class->get_property = bz_pride_flag_stripe_spec_get_property;
  object_class->dispose      = bz_pride_flag_stripe_spec_dispose;

  props[PROP_RGBA] =
      g_param_spec_string (
          "rgba",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SIZE] =
      g_param_spec_double (
          "size",
          NULL, NULL,
          0.0, G_MAXDOUBLE, 0.0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_pride_flag_stripe_spec_init (BzPrideFlagStripeSpec *self)
{
}

BzPrideFlagStripeSpec *
bz_pride_flag_stripe_spec_new (void){
  return g_object_new (BZ_TYPE_PRIDE_FLAG_STRIPE_SPEC, NULL);
}

const char *
bz_pride_flag_stripe_spec_get_rgba (BzPrideFlagStripeSpec *self){
  g_return_val_if_fail (BZ_IS_PRIDE_FLAG_STRIPE_SPEC (self), NULL);
  return self->rgba;
}

double
bz_pride_flag_stripe_spec_get_size (BzPrideFlagStripeSpec *self){
  g_return_val_if_fail (BZ_IS_PRIDE_FLAG_STRIPE_SPEC (self), 0.0);
  return self->size;
}

void
bz_pride_flag_stripe_spec_set_rgba (BzPrideFlagStripeSpec *self,
    const char *rgba){
  g_return_if_fail (BZ_IS_PRIDE_FLAG_STRIPE_SPEC (self));

  if (rgba == self->rgba || (rgba != NULL && self->rgba != NULL && g_strcmp0(rgba, self->rgba) == 0))
    return;

  g_clear_pointer (&self->rgba, g_free);
  if (rgba != NULL)
    self->rgba = g_strdup (rgba);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_RGBA]);
}

void
bz_pride_flag_stripe_spec_set_size (BzPrideFlagStripeSpec *self,
    double size){
  g_return_if_fail (BZ_IS_PRIDE_FLAG_STRIPE_SPEC (self));

  if (size == self->size)
    return;

  self->size = size;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SIZE]);
}

/* End of src/bazaar.p/bz-pride-flag-stripe-spec.c */
