﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/awstransfer/model/DescribedHostKey.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Transfer {
namespace Model {
class DescribeHostKeyResult {
 public:
  AWS_TRANSFER_API DescribeHostKeyResult() = default;
  AWS_TRANSFER_API DescribeHostKeyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TRANSFER_API DescribeHostKeyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Returns the details for the specified host key.</p>
   */
  inline const DescribedHostKey& GetHostKey() const { return m_hostKey; }
  template <typename HostKeyT = DescribedHostKey>
  void SetHostKey(HostKeyT&& value) {
    m_hostKeyHasBeenSet = true;
    m_hostKey = std::forward<HostKeyT>(value);
  }
  template <typename HostKeyT = DescribedHostKey>
  DescribeHostKeyResult& WithHostKey(HostKeyT&& value) {
    SetHostKey(std::forward<HostKeyT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeHostKeyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  DescribedHostKey m_hostKey;

  Aws::String m_requestId;
  bool m_hostKeyHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Transfer
}  // namespace Aws
