/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// PersistentVolumeClaimStatusApplyConfiguration represents a declarative configuration of the PersistentVolumeClaimStatus type for use
// with apply.
//
// PersistentVolumeClaimStatus is the current status of a persistent volume claim.
type PersistentVolumeClaimStatusApplyConfiguration struct {
	// phase represents the current phase of PersistentVolumeClaim.
	Phase *corev1.PersistentVolumeClaimPhase `json:"phase,omitempty"`
	// accessModes contains the actual access modes the volume backing the PVC has.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
	AccessModes []corev1.PersistentVolumeAccessMode `json:"accessModes,omitempty"`
	// capacity represents the actual resources of the underlying volume.
	Capacity *corev1.ResourceList `json:"capacity,omitempty"`
	// conditions is the current Condition of persistent volume claim. If underlying persistent volume is being
	// resized then the Condition will be set to 'Resizing'.
	Conditions []PersistentVolumeClaimConditionApplyConfiguration `json:"conditions,omitempty"`
	// allocatedResources tracks the resources allocated to a PVC including its capacity.
	// Key names follow standard Kubernetes label syntax. Valid values are either:
	// * Un-prefixed keys:
	// - storage - the capacity of the volume.
	// * Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
	// Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered
	// reserved and hence may not be used.
	//
	// Capacity reported here may be larger than the actual capacity when a volume expansion operation
	// is requested.
	// For storage quota, the larger value from allocatedResources and PVC.spec.resources is used.
	// If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation.
	// If a volume expansion capacity request is lowered, allocatedResources is only
	// lowered if there are no expansion operations in progress and if the actual volume capacity
	// is equal or lower than the requested capacity.
	//
	// A controller that receives PVC update with previously unknown resourceName
	// should ignore the update for the purpose it was designed. For example - a controller that
	// only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid
	// resources associated with PVC.
	AllocatedResources *corev1.ResourceList `json:"allocatedResources,omitempty"`
	// allocatedResourceStatuses stores status of resource being resized for the given PVC.
	// Key names follow standard Kubernetes label syntax. Valid values are either:
	// * Un-prefixed keys:
	// - storage - the capacity of the volume.
	// * Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
	// Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered
	// reserved and hence may not be used.
	//
	// ClaimResourceStatus can be in any of following states:
	// - ControllerResizeInProgress:
	// State set when resize controller starts resizing the volume in control-plane.
	// - ControllerResizeFailed:
	// State set when resize has failed in resize controller with a terminal error.
	// - NodeResizePending:
	// State set when resize controller has finished resizing the volume but further resizing of
	// volume is needed on the node.
	// - NodeResizeInProgress:
	// State set when kubelet starts resizing the volume.
	// - NodeResizeFailed:
	// State set when resizing has failed in kubelet with a terminal error. Transient errors don't set
	// NodeResizeFailed.
	// For example: if expanding a PVC for more capacity - this field can be one of the following states:
	// - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeInProgress"
	// - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeFailed"
	// - pvc.status.allocatedResourceStatus['storage'] = "NodeResizePending"
	// - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeInProgress"
	// - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeFailed"
	// When this field is not set, it means that no resize operation is in progress for the given PVC.
	//
	// A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus
	// should ignore the update for the purpose it was designed. For example - a controller that
	// only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid
	// resources associated with PVC.
	AllocatedResourceStatuses map[corev1.ResourceName]corev1.ClaimResourceStatus `json:"allocatedResourceStatuses,omitempty"`
	// currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using.
	// When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim
	CurrentVolumeAttributesClassName *string `json:"currentVolumeAttributesClassName,omitempty"`
	// ModifyVolumeStatus represents the status object of ControllerModifyVolume operation.
	// When this is unset, there is no ModifyVolume operation being attempted.
	ModifyVolumeStatus *ModifyVolumeStatusApplyConfiguration `json:"modifyVolumeStatus,omitempty"`
}

// PersistentVolumeClaimStatusApplyConfiguration constructs a declarative configuration of the PersistentVolumeClaimStatus type for use with
// apply.
func PersistentVolumeClaimStatus() *PersistentVolumeClaimStatusApplyConfiguration {
	return &PersistentVolumeClaimStatusApplyConfiguration{}
}

// WithPhase sets the Phase field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Phase field is set to the value of the last call.
func (b *PersistentVolumeClaimStatusApplyConfiguration) WithPhase(value corev1.PersistentVolumeClaimPhase) *PersistentVolumeClaimStatusApplyConfiguration {
	b.Phase = &value
	return b
}

// WithAccessModes adds the given value to the AccessModes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AccessModes field.
func (b *PersistentVolumeClaimStatusApplyConfiguration) WithAccessModes(values ...corev1.PersistentVolumeAccessMode) *PersistentVolumeClaimStatusApplyConfiguration {
	for i := range values {
		b.AccessModes = append(b.AccessModes, values[i])
	}
	return b
}

// WithCapacity sets the Capacity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Capacity field is set to the value of the last call.
func (b *PersistentVolumeClaimStatusApplyConfiguration) WithCapacity(value corev1.ResourceList) *PersistentVolumeClaimStatusApplyConfiguration {
	b.Capacity = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *PersistentVolumeClaimStatusApplyConfiguration) WithConditions(values ...*PersistentVolumeClaimConditionApplyConfiguration) *PersistentVolumeClaimStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithAllocatedResources sets the AllocatedResources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllocatedResources field is set to the value of the last call.
func (b *PersistentVolumeClaimStatusApplyConfiguration) WithAllocatedResources(value corev1.ResourceList) *PersistentVolumeClaimStatusApplyConfiguration {
	b.AllocatedResources = &value
	return b
}

// WithAllocatedResourceStatuses puts the entries into the AllocatedResourceStatuses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the AllocatedResourceStatuses field,
// overwriting an existing map entries in AllocatedResourceStatuses field with the same key.
func (b *PersistentVolumeClaimStatusApplyConfiguration) WithAllocatedResourceStatuses(entries map[corev1.ResourceName]corev1.ClaimResourceStatus) *PersistentVolumeClaimStatusApplyConfiguration {
	if b.AllocatedResourceStatuses == nil && len(entries) > 0 {
		b.AllocatedResourceStatuses = make(map[corev1.ResourceName]corev1.ClaimResourceStatus, len(entries))
	}
	for k, v := range entries {
		b.AllocatedResourceStatuses[k] = v
	}
	return b
}

// WithCurrentVolumeAttributesClassName sets the CurrentVolumeAttributesClassName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CurrentVolumeAttributesClassName field is set to the value of the last call.
func (b *PersistentVolumeClaimStatusApplyConfiguration) WithCurrentVolumeAttributesClassName(value string) *PersistentVolumeClaimStatusApplyConfiguration {
	b.CurrentVolumeAttributesClassName = &value
	return b
}

// WithModifyVolumeStatus sets the ModifyVolumeStatus field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ModifyVolumeStatus field is set to the value of the last call.
func (b *PersistentVolumeClaimStatusApplyConfiguration) WithModifyVolumeStatus(value *ModifyVolumeStatusApplyConfiguration) *PersistentVolumeClaimStatusApplyConfiguration {
	b.ModifyVolumeStatus = value
	return b
}
