// java wrapper for vtkOpenGLFramebufferObject object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenGLFramebufferObject.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkFrameBufferObjectBase_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenGLFramebufferObject_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenGLFramebufferObject",dType)) { return me; }
  if ((res= vtkFrameBufferObjectBase_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_SetContext_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContext(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetContext_15(JNIEnv* env, jobject obj)
{
  vtkOpenGLRenderWindow * temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContext();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_Bind_16(JNIEnv* env, jobject obj)
{

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Bind();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_Bind_17(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Bind(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_UnBind_18(JNIEnv* env, jobject obj)
{

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBind();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_UnBind_19(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBind(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_SaveCurrentBindingsAndBuffers_110(JNIEnv* env, jobject obj)
{

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SaveCurrentBindingsAndBuffers();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_SaveCurrentBindingsAndBuffers_111(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SaveCurrentBindingsAndBuffers(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_RestorePreviousBindingsAndBuffers_112(JNIEnv* env, jobject obj)
{

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RestorePreviousBindingsAndBuffers();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_RestorePreviousBindingsAndBuffers_113(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RestorePreviousBindingsAndBuffers(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLFramebufferObject_Start_114(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Start(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLFramebufferObject_StartNonOrtho_115(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StartNonOrtho(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_InitializeViewport_116(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeViewport(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_ActivateDrawBuffers_117(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ActivateDrawBuffers(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_ActivateDrawBuffer_118(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ActivateDrawBuffer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_ActivateReadBuffer_119(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ActivateReadBuffer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_ActivateBuffer_120(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ActivateBuffer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_DeactivateDrawBuffers_121(JNIEnv* env, jobject obj)
{

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeactivateDrawBuffers();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_DeactivateReadBuffer_122(JNIEnv* env, jobject obj)
{

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeactivateReadBuffer();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetActiveReadBuffer_123(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveReadBuffer();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetActiveDrawBuffer_124(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveDrawBuffer(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_RenderQuad_125(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4,jobject id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkShaderProgram * temp4;
  vtkOpenGLVertexArrayObject * temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, id5));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderQuad(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_AddColorAttachment_126(JNIEnv* env, jobject obj,jint id0,jobject id1,jint id2,jint id3,jint id4)
{
   unsigned int   temp0;
  vtkTextureObject * temp1;
   unsigned int   temp2;
   unsigned int   temp3;
   unsigned int   temp4;
  temp0 = id0;
  temp1 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddColorAttachment(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_AddColorAttachment_127(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
   unsigned int   temp0;
  vtkRenderbuffer * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddColorAttachment(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_RemoveColorAttachment_128(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveColorAttachment(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_RemoveColorAttachments_129(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveColorAttachments(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetColorAttachmentAsTextureObject_130(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkTextureObject * temp20;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorAttachmentAsTextureObject(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetNumberOfColorAttachments_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfColorAttachments();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_AddDepthAttachment_132(JNIEnv* env, jobject obj)
{

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDepthAttachment();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_AddDepthAttachment_133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextureObject * temp0;
  temp0 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDepthAttachment(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_AddDepthAttachment_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderbuffer * temp0;
  temp0 = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDepthAttachment(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_RemoveDepthAttachment_135(JNIEnv* env, jobject obj)
{

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDepthAttachment();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetDepthAttachmentAsTextureObject_136(JNIEnv* env, jobject obj)
{
  vtkTextureObject * temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDepthAttachmentAsTextureObject();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLFramebufferObject_PopulateFramebuffer_137(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PopulateFramebuffer(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLFramebufferObject_PopulateFramebuffer_138(JNIEnv* env, jobject obj,jint id0,jint id1,jboolean id2,jint id3,jint id4,jboolean id5,jint id6,jint id7,jboolean id8)
{
  int   temp0;
  int   temp1;
  bool   temp2;
  int   temp3;
  int   temp4;
  bool   temp5;
  int   temp6;
  int   temp7;
  bool   temp8;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;
  temp3 = id3;
  temp4 = id4;
  temp5 = (id5 != 0) ? true : false;
  temp6 = id6;
  temp7 = id7;
  temp8 = (id8 != 0) ? true : false;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PopulateFramebuffer(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetMaximumNumberOfActiveTargets_139(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfActiveTargets();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetMaximumNumberOfRenderTargets_140(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfRenderTargets();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetLastSize_141(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetLastSize(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLFramebufferObject_IsSupported_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenGLRenderWindow * temp0;
  bool   temp20;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_CheckFrameBufferStatus_143(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckFrameBufferStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_ReleaseGraphicsResources_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetFBOIndex_145(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFBOIndex();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_Blit_146(JNIEnv* env, jobject obj,jintArray id0,jintArray id1,jint id2,jint id3)
{
  int temp0[4];
  int temp1[4];
   unsigned int   temp2;
   unsigned int   temp3;
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 4, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = id2;
  temp3 = id3;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Blit(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_DownloadColor1_147(JNIEnv* env, jobject obj,jintArray id0,jint id1,jint id2)
{
  int temp0[4];
  int   temp1;
  int   temp2;
  vtkPixelBufferObject * temp20;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;
  temp2 = id2;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DownloadColor1(temp0,temp1,temp2);
  env->SetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_DownloadColor3_148(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[4];
  int   temp1;
  vtkPixelBufferObject * temp20;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DownloadColor3(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_DownloadColor4_149(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[4];
  int   temp1;
  vtkPixelBufferObject * temp20;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DownloadColor4(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_DownloadDepth_150(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[4];
  int   temp1;
  vtkPixelBufferObject * temp20;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DownloadDepth(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLFramebufferObject_Download_151(JNIEnv* env, jobject obj,jintArray id0,jint id1,jint id2,jint id3,jint id4)
{
  int temp0[4];
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  vtkPixelBufferObject * temp20;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Download(temp0,temp1,temp2,temp3,temp4);
  env->SetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_Download_152(JNIEnv* env, jobject obj,jintArray id0,jint id1,jint id2,jint id3,jint id4,jobject id5)
{
  int temp0[4];
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  vtkPixelBufferObject * temp5;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = static_cast<vtkPixelBufferObject*>(vtkJavaGetPointerFromObject(env, id5));

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Download(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetDrawMode_153(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawMode();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetReadMode_154(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadMode();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetBothMode_155(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBothMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLFramebufferObject_Resize_156(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Resize(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLFramebufferObject_GetMultiSamples_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLFramebufferObject* op = static_cast<vtkOpenGLFramebufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMultiSamples();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenGLFramebufferObject_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenGLFramebufferObject::New());
}
