// java wrapper for vtkContext2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkContext2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkContext2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkContext2D",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContext2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContext2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkContext2D_Begin_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContextDevice2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContextDevice2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Begin(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext2D_GetDevice_15(JNIEnv* env, jobject obj)
{
  vtkContextDevice2D * temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDevice();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkContext2D_End_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->End();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkContext2D_GetBufferIdMode_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBufferIdMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_BufferIdModeBegin_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractContextBufferId * temp0;
  temp0 = static_cast<vtkAbstractContextBufferId*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BufferIdModeBegin(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_BufferIdModeEnd_19(JNIEnv* env, jobject obj)
{

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BufferIdModeEnd();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawLine_110(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawLine(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawLine_111(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawLine(temp0);
  env->SetFloatArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawLine_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints2D * temp0;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawLine(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawPoly_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints2D * temp0;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPoly(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawLines_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints2D * temp0;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawLines(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawPoint_115(JNIEnv* env, jobject obj,jfloat id0,jfloat id1)
{
  float   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawPoints_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints2D * temp0;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawPointSprites_117(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkImageData * temp0;
  vtkPoints2D * temp1;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPointSprites(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawPointSprites_118(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkImageData * temp0;
  vtkPoints2D * temp1;
  vtkUnsignedCharArray * temp2;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPointSprites(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawMarkers_119(JNIEnv* env, jobject obj,jint id0,jboolean id1,jobject id2)
{
  int   temp0;
  bool   temp1;
  vtkPoints2D * temp2;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;
  temp2 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id2));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawMarkers(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawMarkers_120(JNIEnv* env, jobject obj,jint id0,jboolean id1,jobject id2,jobject id3)
{
  int   temp0;
  bool   temp1;
  vtkPoints2D * temp2;
  vtkUnsignedCharArray * temp3;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;
  temp2 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawMarkers(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawRect_121(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawRect(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawQuad_122(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3,jfloat id4,jfloat id5,jfloat id6,jfloat id7)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  float   temp4;
  float   temp5;
  float   temp6;
  float   temp7;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawQuad(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawQuadStrip_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints2D * temp0;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawQuadStrip(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawPolygon_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints2D * temp0;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPolygon(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawEllipse_125(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawEllipse(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawWedge_126(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3,jfloat id4,jfloat id5)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  float   temp4;
  float   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawWedge(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawEllipseWedge_127(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3,jfloat id4,jfloat id5,jfloat id6,jfloat id7)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  float   temp4;
  float   temp5;
  float   temp6;
  float   temp7;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawEllipseWedge(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawArc_128(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3,jfloat id4)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  float   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawArc(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawEllipticArc_129(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3,jfloat id4,jfloat id5)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  float   temp4;
  float   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawEllipticArc(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawImage_130(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jobject id2)
{
  float   temp0;
  float   temp1;
  vtkImageData * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawImage(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawImage_131(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jobject id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  vtkImageData * temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id3));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawImage(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawPolyData_132(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jobject id2,jobject id3,jint id4)
{
  float   temp0;
  float   temp1;
  vtkPolyData * temp2;
  vtkUnsignedCharArray * temp3;
  int   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = id4;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPolyData(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawStringRect_133(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkPoints2D * temp0;
  vtkStdString temp1;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawStringRect(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawStringRect_134(JNIEnv* env, jobject obj,jfloatArray id0, jbyteArray id1, jint len1)
{
  float temp0[4];
  vtkStdString temp1;
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawStringRect(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawString_135(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkPoints2D * temp0;
  vtkStdString temp1;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawString(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawString_136(JNIEnv* env, jobject obj,jfloat id0,jfloat id1, jbyteArray id2, jint len2)
{
  float   temp0;
  float   temp1;
  vtkStdString temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawString(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_ComputeStringBounds_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  vtkStdString temp0;
  vtkPoints2D * temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeStringBounds(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_ComputeStringBounds_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  vtkStdString temp0;
  float temp1[4];
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeStringBounds(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_ComputeJustifiedStringBounds_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[4];
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeJustifiedStringBounds(temp0,temp1);
  delete[] temp0;
  env->SetFloatArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContext2D_ComputeFontSizeForBoundedString_140(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloat id1,jfloat id2)
{
  vtkStdString temp0;
  float   temp1;
  float   temp2;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = id1;
  temp2 = id2;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeFontSizeForBoundedString(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawMathTextString_141(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkPoints2D * temp0;
  vtkStdString temp1;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawMathTextString(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawMathTextString_142(JNIEnv* env, jobject obj,jfloat id0,jfloat id1, jbyteArray id2, jint len2)
{
  float   temp0;
  float   temp1;
  vtkStdString temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawMathTextString(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawMathTextString_143(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  vtkPoints2D * temp0;
  vtkStdString temp1;
  vtkStdString temp2;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = vtkJavaUTF8ToString(env, id2, len2);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawMathTextString(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_DrawMathTextString_144(JNIEnv* env, jobject obj,jfloat id0,jfloat id1, jbyteArray id2, jint len2, jbyteArray id3, jint len3)
{
  float   temp0;
  float   temp1;
  vtkStdString temp2;
  vtkStdString temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = vtkJavaUTF8ToString(env, id3, len3);

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawMathTextString(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkContext2D_MathTextIsSupported_145(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MathTextIsSupported();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_ApplyPen_146(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyPen(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext2D_GetPen_147(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_ApplyBrush_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBrush * temp0;
  temp0 = static_cast<vtkBrush*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyBrush(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext2D_GetBrush_149(JNIEnv* env, jobject obj)
{
  vtkBrush * temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBrush();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_ApplyTextProp_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyTextProp(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext2D_GetTextProp_151(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextProp();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_SetTransform_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform2D * temp0;
  temp0 = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext2D_GetTransform_153(JNIEnv* env, jobject obj)
{
  vtkTransform2D * temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_AppendTransform_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform2D * temp0;
  temp0 = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendTransform(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_PushMatrix_155(JNIEnv* env, jobject obj)
{

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PushMatrix();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_PopMatrix_156(JNIEnv* env, jobject obj)
{

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PopMatrix();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_ApplyId_157(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyId(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkContext2D_FloatToInt_158(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  int   temp20;
  temp0 = id0;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FloatToInt(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkContext2D_GetContext3D_159(JNIEnv* env, jobject obj)
{
  vtkContext3D * temp20;

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContext3D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkContext2D_SetContext3D_160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext3D * temp0;
  temp0 = static_cast<vtkContext3D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkContext2D* op = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContext3D(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkContext2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkContext2D::New());
}
