// java wrapper for vtkGaussianSplatter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGaussianSplatter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGaussianSplatter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGaussianSplatter",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGaussianSplatter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGaussianSplatter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGaussianSplatter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGaussianSplatter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetSampleDimensions_14(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetSampleDimensions_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkGaussianSplatter_GetSampleDimensions_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSampleDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetModelBounds_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetModelBounds_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGaussianSplatter_GetModelBounds_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetRadius_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetRadiusMinValue_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetRadiusMaxValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetRadius_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetScaleFactor_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetScaleFactorMinValue_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleFactorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetScaleFactorMaxValue_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleFactorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetScaleFactor_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetExponentFactor_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponentFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetExponentFactor_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetNormalWarping_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalWarping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGaussianSplatter_GetNormalWarping_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalWarping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_NormalWarpingOn_122(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalWarpingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_NormalWarpingOff_123(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalWarpingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetEccentricity_124(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEccentricity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetEccentricityMinValue_125(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEccentricityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetEccentricityMaxValue_126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEccentricityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetEccentricity_127(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEccentricity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetScalarWarping_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarWarping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGaussianSplatter_GetScalarWarping_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarWarping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_ScalarWarpingOn_130(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarWarpingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_ScalarWarpingOff_131(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarWarpingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetCapping_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCapping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGaussianSplatter_GetCapping_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_CappingOn_134(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CappingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_CappingOff_135(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CappingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetCapValue_136(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCapValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetCapValue_137(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetAccumulationMode_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAccumulationMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGaussianSplatter_GetAccumulationModeMinValue_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccumulationModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGaussianSplatter_GetAccumulationModeMaxValue_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccumulationModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGaussianSplatter_GetAccumulationMode_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccumulationMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetAccumulationModeToMin_142(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAccumulationModeToMin();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetAccumulationModeToMax_143(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAccumulationModeToMax();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetAccumulationModeToSum_144(JNIEnv* env, jobject obj)
{

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAccumulationModeToSum();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGaussianSplatter_GetAccumulationModeAsString_145(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAccumulationModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_SetNullValue_146(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNullValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_GetNullValue_147(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNullValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_ComputeModelBounds_148(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkDataSet * temp0;
  vtkImageData * temp1;
  vtkInformation * temp2;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeModelBounds(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGaussianSplatter_ComputeModelBounds_149(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkCompositeDataSet * temp0;
  vtkImageData * temp1;
  vtkInformation * temp2;
  temp0 = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeModelBounds(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGaussianSplatter_SamplePoint_150(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkGaussianSplatter* op = static_cast<vtkGaussianSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SamplePoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGaussianSplatter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGaussianSplatter::New());
}
