// java wrapper for vtkDataSetReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataSetReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataReader_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataSetReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataSetReader",dType)) { return me; }
  if ((res= vtkDataReader_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetOutput_14(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetOutput_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSet * temp20;
  temp0 = id0;

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetPolyDataOutput_16(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolyDataOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetStructuredPointsOutput_17(JNIEnv* env, jobject obj)
{
  vtkStructuredPoints * temp20;

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStructuredPointsOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetStructuredGridOutput_18(JNIEnv* env, jobject obj)
{
  vtkStructuredGrid * temp20;

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStructuredGridOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetUnstructuredGridOutput_19(JNIEnv* env, jobject obj)
{
  vtkUnstructuredGrid * temp20;

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnstructuredGridOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetReader_GetRectilinearGridOutput_110(JNIEnv* env, jobject obj)
{
  vtkRectilinearGrid * temp20;

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRectilinearGridOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetReader_ReadOutputType_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadOutputType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetReader_ReadMetaDataSimple_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  std::string temp0;
  vtkInformation * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadMetaDataSimple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetReader_ReadMeshSimple_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  std::string temp0;
  vtkDataObject * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataSetReader* op = static_cast<vtkDataSetReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadMeshSimple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataSetReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataSetReader::New());
}
