// java wrapper for vtkProjectedTexture object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkProjectedTexture.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkProjectedTexture_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkProjectedTexture",dType)) { return me; }
  if ((res= vtkDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProjectedTexture_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProjectedTexture_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProjectedTexture_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProjectedTexture_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetPosition_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetPosition_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProjectedTexture_GetPosition_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetFocalPoint_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetFocalPoint_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProjectedTexture_GetFocalPoint_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetCameraMode_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCameraMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProjectedTexture_GetCameraMode_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCameraMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetCameraModeToPinhole_112(JNIEnv* env, jobject obj)
{

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCameraModeToPinhole();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetCameraModeToTwoMirror_113(JNIEnv* env, jobject obj)
{

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCameraModeToTwoMirror();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetMirrorSeparation_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMirrorSeparation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProjectedTexture_GetMirrorSeparation_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMirrorSeparation();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProjectedTexture_GetOrientation_116(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetUp_117(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUp(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetUp_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUp(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProjectedTexture_GetUp_119(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUp();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetAspectRatio_120(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAspectRatio(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetAspectRatio_121(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAspectRatio(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProjectedTexture_GetAspectRatio_122(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAspectRatio();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetSRange_123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetSRange_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProjectedTexture_GetSRange_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetTRange_126(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProjectedTexture_SetTRange_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProjectedTexture_GetTRange_128(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProjectedTexture* op = static_cast<vtkProjectedTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkProjectedTexture_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkProjectedTexture::New());
}
