// java wrapper for vtkGeometryFilter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGeometryFilter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGeometryFilter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGeometryFilter",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetPointClipping_14(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointClipping(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGeometryFilter_GetPointClipping_15(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointClipping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_PointClippingOn_16(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->PointClippingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_PointClippingOff_17(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->PointClippingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetCellClipping_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellClipping(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGeometryFilter_GetCellClipping_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellClipping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_CellClippingOn_110(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CellClippingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_CellClippingOff_111(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CellClippingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetExtentClipping_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtentClipping(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGeometryFilter_GetExtentClipping_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentClipping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_ExtentClippingOn_114(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExtentClippingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_ExtentClippingOff_115(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExtentClippingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetPointMinimum_116(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointMinimum(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetPointMinimumMinValue_117(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointMinimumMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetPointMinimumMaxValue_118(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointMinimumMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetPointMinimum_119(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointMinimum();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetPointMaximum_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointMaximum(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetPointMaximumMinValue_121(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointMaximumMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetPointMaximumMaxValue_122(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointMaximumMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetPointMaximum_123(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointMaximum();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetCellMinimum_124(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellMinimum(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetCellMinimumMinValue_125(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellMinimumMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetCellMinimumMaxValue_126(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellMinimumMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetCellMinimum_127(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellMinimum();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetCellMaximum_128(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellMaximum(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetCellMaximumMinValue_129(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellMaximumMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetCellMaximumMaxValue_130(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellMaximumMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetCellMaximum_131(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellMaximum();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetExtent_132(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetExtent_133(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGeometryFilter_GetExtent_134(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtent();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetMerging_135(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMerging(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGeometryFilter_GetMerging_136(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMerging();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_MergingOn_137(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_MergingOff_138(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetOutputPointsPrecision_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_GetOutputPointsPrecision_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetFastMode_141(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFastMode(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGeometryFilter_GetFastMode_142(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFastMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_FastModeOn_143(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->FastModeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_FastModeOff_144(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->FastModeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetPieceInvariant_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPieceInvariant(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_GetPieceInvariant_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPieceInvariant();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetPassThroughCellIds_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPassThroughCellIds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_GetPassThroughCellIds_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPassThroughCellIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_PassThroughCellIdsOn_149(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->PassThroughCellIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_PassThroughCellIdsOff_150(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->PassThroughCellIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetPassThroughPointIds_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPassThroughPointIds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_GetPassThroughPointIds_152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPassThroughPointIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_PassThroughPointIdsOn_153(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->PassThroughPointIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_PassThroughPointIdsOff_154(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->PassThroughPointIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetOriginalCellIdsName_155(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOriginalCellIdsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGeometryFilter_GetOriginalCellIdsName_156(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOriginalCellIdsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetOriginalPointIdsName_157(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOriginalPointIdsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGeometryFilter_GetOriginalPointIdsName_158(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOriginalPointIdsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetExcludedFacesData_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExcludedFacesData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetExcludedFacesConnection_160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExcludedFacesConnection(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeometryFilter_GetExcludedFaces_161(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExcludedFaces();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetNonlinearSubdivisionLevel_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNonlinearSubdivisionLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_GetNonlinearSubdivisionLevel_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNonlinearSubdivisionLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetMatchBoundariesIgnoringCellOrder_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatchBoundariesIgnoringCellOrder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_GetMatchBoundariesIgnoringCellOrder_165(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMatchBoundariesIgnoringCellOrder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetDelegation_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDelegation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_GetDelegation_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDelegation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_DelegationOn_168(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->DelegationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_DelegationOff_169(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->DelegationOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_SetRemoveGhostInterfaces_170(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRemoveGhostInterfaces(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_RemoveGhostInterfacesOn_171(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveGhostInterfacesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeometryFilter_RemoveGhostInterfacesOff_172(JNIEnv* env, jobject obj)
{

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveGhostInterfacesOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGeometryFilter_GetRemoveGhostInterfaces_173(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRemoveGhostInterfaces();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_PolyDataExecute_174(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkDataSet * temp0;
  vtkPolyData * temp1;
  vtkPolyData * temp2;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PolyDataExecute(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_PolyDataExecute_175(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataSet * temp0;
  vtkPolyData * temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PolyDataExecute(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_UnstructuredGridExecute_176(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataSet * temp0;
  vtkPolyData * temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UnstructuredGridExecute(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_DataSetExecute_177(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkDataSet * temp0;
  vtkPolyData * temp1;
  vtkPolyData * temp2;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DataSetExecute(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeometryFilter_DataSetExecute_178(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataSet * temp0;
  vtkPolyData * temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGeometryFilter* op = static_cast<vtkGeometryFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DataSetExecute(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGeometryFilter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGeometryFilter::New());
}
