// java wrapper for vtkTree object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTree.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDirectedAcyclicGraph_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTree_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTree",dType)) { return me; }
  if ((res= vtkDirectedAcyclicGraph_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTree_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTree_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTree_GetDataObjectType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetRoot_15(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoot();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetNumberOfChildren_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfChildren(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetChild_17(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChild(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTree_GetChildren_18(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkAdjacentVertexIterator * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAdjacentVertexIterator*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetChildren(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetParent_19(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetLevel_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLevel(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTree_IsLeaf_111(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsLeaf(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetData_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkTree * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTree_GetData_113(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkTree * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTree_ReorderChildren_114(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdTypeArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTree* op = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReorderChildren(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTree_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTree::New());
}
