// java wrapper for vtkSelectionNode object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSelectionNode.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSelectionNode_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSelectionNode",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionNode_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionNode_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_Initialize_14(JNIEnv* env, jobject obj)
{

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_SetSelectionList_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionList(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_GetSelectionList_16(JNIEnv* env, jobject obj)
{
  vtkAbstractArray * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionList();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_SetSelectionData_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSetAttributes * temp0;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_GetSelectionData_18(JNIEnv* env, jobject obj)
{
  vtkDataSetAttributes * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_GetProperties_19(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperties();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_DeepCopy_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSelectionNode * temp0;
  temp0 = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_ShallowCopy_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSelectionNode * temp0;
  temp0 = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_GetMTime_112(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_CONTENT_1TYPE_113(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CONTENT_TYPE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_SetContentType_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContentType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionNode_GetContentType_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContentType();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionNode_GetContentTypeAsString_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContentTypeAsString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_FIELD_1TYPE_117(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FIELD_TYPE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_SetFieldType_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionNode_GetFieldType_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldType();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionNode_GetFieldTypeAsString_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldTypeAsString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionNode_GetFieldTypeFromString_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldTypeFromString(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionNode_ConvertSelectionFieldToAttributeType_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertSelectionFieldToAttributeType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionNode_ConvertAttributeTypeToSelectionField_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertAttributeTypeToSelectionField(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_SetQueryString_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQueryString(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionNode_GetQueryString_125(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQueryString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_EPSILON_126(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EPSILON();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_ZBUFFER_1VALUE_127(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ZBUFFER_VALUE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_CONTAINING_1CELLS_128(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CONTAINING_CELLS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_CONNECTED_1LAYERS_129(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CONNECTED_LAYERS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_CONNECTED_1LAYERS_1REMOVE_1SEED_130(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CONNECTED_LAYERS_REMOVE_SEED();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_CONNECTED_1LAYERS_1REMOVE_1INTERMEDIATE_1LAYERS_131(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CONNECTED_LAYERS_REMOVE_INTERMEDIATE_LAYERS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_COMPONENT_1NUMBER_132(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->COMPONENT_NUMBER();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_INVERSE_133(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->INVERSE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_PIXEL_1COUNT_134(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PIXEL_COUNT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_SOURCE_135(JNIEnv* env, jobject obj)
{
  vtkInformationObjectBaseKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SOURCE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_SOURCE_1ID_136(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SOURCE_ID();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_PROP_137(JNIEnv* env, jobject obj)
{
  vtkInformationObjectBaseKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PROP();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_PROP_1ID_138(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PROP_ID();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_PROCESS_1ID_139(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PROCESS_ID();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_ASSEMBLY_1NAME_140(JNIEnv* env, jobject obj)
{
  vtkInformationStringKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ASSEMBLY_NAME();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_SELECTORS_141(JNIEnv* env, jobject obj)
{
  vtkInformationStringVectorKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SELECTORS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_COMPOSITE_1INDEX_142(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->COMPOSITE_INDEX();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_HIERARCHICAL_1LEVEL_143(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HIERARCHICAL_LEVEL();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_HIERARCHICAL_1INDEX_144(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HIERARCHICAL_INDEX();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_CELLGRID_1CELL_1TYPE_1INDEX_145(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CELLGRID_CELL_TYPE_INDEX();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionNode_CELLGRID_1SOURCE_1SPECIFICATION_1INDEX_146(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CELLGRID_SOURCE_SPECIFICATION_INDEX();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_UnionSelectionList_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSelectionNode * temp0;
  temp0 = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnionSelectionList(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionNode_SubtractSelectionList_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSelectionNode * temp0;
  temp0 = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SubtractSelectionList(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSelectionNode_EqualProperties_149(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkSelectionNode * temp0;
  bool   temp1;
  bool   temp20;
  temp0 = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkSelectionNode* op = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EqualProperties(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSelectionNode_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSelectionNode::New());
}
