// java wrapper for vtkDataSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataSet",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSet_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSet_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_CopyStructure_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_CopyAttributes_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAttributes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetNumberOfPoints_16(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetNumberOfCells_17(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetPoints_18(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataSet_GetPoint_19(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetPoint_110(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_NewCellIterator_111(JNIEnv* env, jobject obj)
{
  vtkCellIterator * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewCellIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetCell_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetCell_113(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_SetCellOrderAndRationalWeights_114(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellOrderAndRationalWeights(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetCell_115(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetCellBounds_116(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSet_GetCellType_117(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetCellSize_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetCellTypes_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellTypes * temp0;
  temp0 = static_cast<vtkCellTypes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellTypes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetCellPoints_120(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetPointCells_121(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetCellNeighbors_122(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_FindPoint_123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_FindPoint_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetMTime_125(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetCellData_126(JNIEnv* env, jobject obj)
{
  vtkCellData * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetPointData_127(JNIEnv* env, jobject obj)
{
  vtkPointData * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_Squeeze_128(JNIEnv* env, jobject obj)
{

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_ComputeBounds_129(JNIEnv* env, jobject obj)
{

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataSet_GetBounds_130(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetBounds_131(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataSet_GetCenter_132(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetCenter_133(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataSet_GetLength_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLength();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataSet_GetLength2_135(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLength2();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_Initialize_136(JNIEnv* env, jobject obj)
{

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GetScalarRange_137(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetScalarRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataSet_GetScalarRange_138(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSet_GetMaxCellSize_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSet_GetMaxSpatialDimension_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSet_GetMinSpatialDimension_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetActualMemorySize_142(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSet_GetDataObjectType_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_ShallowCopy_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_DeepCopy_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSet_CheckAttributes_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckAttributes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GenerateGhostArray_147(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGhostArray(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSet_GenerateGhostArray_148(JNIEnv* env, jobject obj,jintArray id0,jboolean id1)
{
  int temp0[6];
  bool   temp1;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = (id1 != 0) ? true : false;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGhostArray(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetData_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkDataSet * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetData_150(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkDataSet * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetAttributesAsFieldData_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkFieldData * temp20;
  temp0 = id0;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributesAsFieldData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetNumberOfElements_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetMeshMTime_153(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMeshMTime();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataSet_HasAnyGhostCells_154(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyGhostCells();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataSet_HasAnyGhostPoints_155(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyGhostPoints();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataSet_HasAnyBlankCells_156(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankCells();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataSet_HasAnyBlankPoints_157(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetPointGhostArray_158(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_AllocatePointGhostArray_159(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocatePointGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetCellGhostArray_160(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_AllocateCellGhostArray_161(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateCellGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSet_GetGhostArray_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkUnsignedCharArray * temp20;
  temp0 = id0;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataSet_SupportsGhostArray_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkDataSet* op = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportsGhostArray(temp0);
  return temp20;

}
