// java wrapper for vtkDataArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataArray",dType)) { return me; }
  if ((res= vtkAbstractArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_FastDownCast_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkDataArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArray_IsNumeric_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsNumeric();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArray_GetElementComponentSize_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementComponentSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuple_17(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_InsertNextTuple_18(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkAbstractArray * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextTuple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuples_19(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkIdList * temp0;
  vtkIdList * temp1;
  vtkAbstractArray * temp2;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuples(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuples_110(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jobject id3)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  vtkAbstractArray * temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuples(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuplesStartingAt_111(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuplesStartingAt(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetTuple_112(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetTuples_113(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdList * temp0;
  vtkAbstractArray * temp1;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTuples(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetTuples_114(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTuples(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InterpolateTuple_115(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2,jlong id3,jobject id4,jdouble id5)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  long long   temp3;
  vtkAbstractArray * temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;
  temp4 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateTuple(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataArray_GetTuple1_116(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double   temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTuple1(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetTuple2_117(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTuple2(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetTuple3_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTuple3(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetTuple4_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTuple4(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetTuple6_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTuple6(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetTuple9_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTuple9(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetTuple1_122(JNIEnv* env, jobject obj,jlong id0,jdouble id1)
{
  long long   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple1(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetTuple2_123(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple2(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetTuple3_124(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple3(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetTuple4_125(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple4(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetTuple6_126(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple6(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetTuple9_127(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8,jdouble id9)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  double   temp9;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;
  temp9 = id9;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple9(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuple1_128(JNIEnv* env, jobject obj,jlong id0,jdouble id1)
{
  long long   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple1(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuple2_129(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple2(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuple3_130(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple3(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuple4_131(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple4(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuple6_132(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple6(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertTuple9_133(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8,jdouble id9)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  double   temp9;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;
  temp9 = id9;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple9(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertNextTuple1_134(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextTuple1(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertNextTuple2_135(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextTuple2(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertNextTuple3_136(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextTuple3(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertNextTuple4_137(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextTuple4(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertNextTuple6_138(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextTuple6(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertNextTuple9_139(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextTuple9(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_RemoveTuple_140(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveTuple(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_RemoveFirstTuple_141(JNIEnv* env, jobject obj)
{

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveFirstTuple();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_RemoveLastTuple_142(JNIEnv* env, jobject obj)
{

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveLastTuple();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataArray_GetComponent_143(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponent(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetComponent_144(JNIEnv* env, jobject obj,jlong id0,jint id1,jdouble id2)
{
  long long   temp0;
  int   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponent(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_InsertComponent_145(JNIEnv* env, jobject obj,jlong id0,jint id1,jdouble id2)
{
  long long   temp0;
  int   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertComponent(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetData_146(JNIEnv* env, jobject obj,jlong id0,jlong id1,jint id2,jint id3,jobject id4)
{
  long long   temp0;
  long long   temp1;
  int   temp2;
  int   temp3;
  vtkDoubleArray * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetData(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_DeepCopy_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_DeepCopy_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_ShallowCopy_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_FillComponent_150(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->FillComponent(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_Fill_151(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Fill(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_CopyComponent_152(JNIEnv* env, jobject obj,jint id0,jobject id1,jint id2)
{
  int   temp0;
  vtkDataArray * temp1;
  int   temp2;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyComponent(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_GetActualMemorySize_153(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_CreateDefaultLookupTable_154(JNIEnv* env, jobject obj)
{

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultLookupTable();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_SetLookupTable_155(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLookupTable * temp0;
  temp0 = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_GetLookupTable_156(JNIEnv* env, jobject obj)
{
  vtkLookupTable * temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetRange_157(JNIEnv* env, jobject obj,jdoubleArray id0,jint id1)
{
  double temp0[2];
  int   temp1;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  temp1 = id1;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRange(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetRange_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double * temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetRange_159(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetRange_160(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetFiniteRange_161(JNIEnv* env, jobject obj,jdoubleArray id0,jint id1)
{
  double temp0[2];
  int   temp1;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  temp1 = id1;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetFiniteRange(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetFiniteRange_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double * temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFiniteRange(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataArray_GetFiniteRange_163(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFiniteRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetFiniteRange_164(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetFiniteRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetDataTypeRange_165(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDataTypeRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataArray_GetDataTypeMin_166(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeMin();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataArray_GetDataTypeMax_167(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeMax();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_GetDataTypeRange_168(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDataTypeRange(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataArray_GetDataTypeMin_169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeMin(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataArray_GetDataTypeMax_170(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeMax(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDataArray_GetMaxNorm_171(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNorm();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_CreateDataArray_172(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataArray * temp20;
  temp0 = id0;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateDataArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_COMPONENT_1RANGE_173(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->COMPONENT_RANGE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_L2_1NORM_1RANGE_174(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->L2_NORM_RANGE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_L2_1NORM_1FINITE_1RANGE_175(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->L2_NORM_FINITE_RANGE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArray_Modified_176(JNIEnv* env, jobject obj)
{

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArray_UNITS_1LABEL_177(JNIEnv* env, jobject obj)
{
  vtkInformationStringKey * temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UNITS_LABEL();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArray_CopyInformation_178(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformation * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CopyInformation(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArray_GetArrayType_179(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataArray* op = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayType();
  return temp20;

}
