// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

// Object factories should never have deprecation warnings.
// NOLINTNEXTLINE(modernize-macro-to-enum)
#define VTK_DEPRECATION_LEVEL 0

#include "vtkRenderingParallelLICObjectFactory.h"
#include "vtkVersion.h"

// Include all of the classes we want to create overrides for.
#include "vtkPSurfaceLICInterface.h"
#include "vtkPLineIntegralConvolution2D.h"
#include "vtkPSurfaceLICComposite.h"


VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(vtkRenderingParallelLICObjectFactory);

// Now create the functions to create overrides with.
VTK_CREATE_CREATE_FUNCTION(vtkPSurfaceLICInterface)
VTK_CREATE_CREATE_FUNCTION(vtkPLineIntegralConvolution2D)
VTK_CREATE_CREATE_FUNCTION(vtkPSurfaceLICComposite)


vtkRenderingParallelLICObjectFactory::vtkRenderingParallelLICObjectFactory()
{
this->RegisterOverride("vtkSurfaceLICInterface", "vtkPSurfaceLICInterface", "Override for VTK::RenderingParallelLIC module", 1, vtkObjectFactoryCreatevtkPSurfaceLICInterface);
this->RegisterOverride("vtkLineIntegralConvolution2D", "vtkPLineIntegralConvolution2D", "Override for VTK::RenderingParallelLIC module", 1, vtkObjectFactoryCreatevtkPLineIntegralConvolution2D);
this->RegisterOverride("vtkSurfaceLICComposite", "vtkPSurfaceLICComposite", "Override for VTK::RenderingParallelLIC module", 1, vtkObjectFactoryCreatevtkPSurfaceLICComposite);

}

const char * vtkRenderingParallelLICObjectFactory::GetVTKSourceVersion() VTK_FUTURE_CONST
{
  return VTK_SOURCE_VERSION;
}

void vtkRenderingParallelLICObjectFactory::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

// Registration of object factories.
static unsigned int vtkRenderingParallelLICCount = 0;

VTKRENDERINGPARALLELLIC_EXPORT void vtkRenderingParallelLIC_AutoInit_Construct()
{
  if(++vtkRenderingParallelLICCount == 1)
  {


    vtkRenderingParallelLICObjectFactory* factory = vtkRenderingParallelLICObjectFactory::New();
    if (factory)
    {
      // vtkObjectFactory keeps a reference to the "factory",
      vtkObjectFactory::RegisterFactory(factory);
      factory->Delete();
    }
  }
}
VTK_ABI_NAMESPACE_END
