// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

// Object factories should never have deprecation warnings.
// NOLINTNEXTLINE(modernize-macro-to-enum)
#define VTK_DEPRECATION_LEVEL 0

#include "vtkRenderingAnariObjectFactory.h"
#include "vtkVersion.h"

// Include all of the classes we want to create overrides for.
#include "vtkAnariVolumeMapper.h"


VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(vtkRenderingAnariObjectFactory);

// Now create the functions to create overrides with.
VTK_CREATE_CREATE_FUNCTION(vtkAnariVolumeMapper)


vtkRenderingAnariObjectFactory::vtkRenderingAnariObjectFactory()
{
this->RegisterOverride("vtkAnariVolumeInterface", "vtkAnariVolumeMapper", "Override for VTK::RenderingAnari module", 1, vtkObjectFactoryCreatevtkAnariVolumeMapper);

}

const char * vtkRenderingAnariObjectFactory::GetVTKSourceVersion() VTK_FUTURE_CONST
{
  return VTK_SOURCE_VERSION;
}

void vtkRenderingAnariObjectFactory::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

// Registration of object factories.
static unsigned int vtkRenderingAnariCount = 0;

VTKRENDERINGANARI_EXPORT void vtkRenderingAnari_AutoInit_Construct()
{
  if(++vtkRenderingAnariCount == 1)
  {


    vtkRenderingAnariObjectFactory* factory = vtkRenderingAnariObjectFactory::New();
    if (factory)
    {
      // vtkObjectFactory keeps a reference to the "factory",
      vtkObjectFactory::RegisterFactory(factory);
      factory->Delete();
    }
  }
}
VTK_ABI_NAMESPACE_END
