// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_TetF2Basis.h"

const char *Basis_HGrad_TetF2Basis =
"// Adapted from P. Silvester, \"High-Order Polynomial Triangular Finite\n"
"// Elements for Potential Problems\". Int. J. Engng Sci. Vol. 7, pp. 849-861.\n"
"// Pergamon Press, 1969. The generic method is valid for all orders, but we\n"
"// unroll the first two orders to reduce computational cost.\n"
"\n"
"RealT uu = 1. - rr - ss - tt;\n"
"\n"
"RealT ur = uu * rr;\n"
"RealT us = uu * ss;\n"
"RealT ut = uu * tt;\n"
"RealT rs = rr * ss;\n"
"RealT rt = rr * tt;\n"
"RealT st = ss * tt;\n"
"RealT urs = ur * ss;\n"
"RealT urt = ur * tt;\n"
"RealT ust = us * tt;\n"
"RealT rst = rs * tt;\n"
"RealT urst = urs * tt;\n"
"\n"
"basis[0] = uu - 2.0 * (ur + us + ut) + 3.0 * (urs + urt + ust) - 4.0 * urst;\n"
"basis[1] = rr - 2.0 * (ur + rs + rt) + 3.0 * (urs + urt + rst) - 4.0 * urst;\n"
"basis[2] = ss - 2.0 * (rs + us + st) + 3.0 * (urs + rst + ust) - 4.0 * urst;\n"
"basis[3] = tt - 2.0 * (ut + rt + st) + 3.0 * (urt + ust + rst) - 4.0 * urst;\n"
"basis[4] = 4.0 * ur - 12.0 * (urs + urt) + 32.0 * urst;\n"
"basis[5] = 4.0 * rs - 12.0 * (urs + rst) + 32.0 * urst;\n"
"basis[6] = 4.0 * us - 12.0 * (urs + ust) + 32.0 * urst;\n"
"basis[7] = 4.0 * ut - 12.0 * (urt + ust) + 32.0 * urst;\n"
"basis[8] = 4.0 * rt - 12.0 * (urt + rst) + 32.0 * urst;\n"
"basis[9] = 4.0 * st - 12.0 * (rst + ust) + 32.0 * urst;\n"
"basis[10] = 27.0 * urs - 108.0 * urst;\n"
"basis[11] = 27.0 * urt - 108.0 * urst;\n"
"basis[12] = 27.0 * rst - 108.0 * urst;\n"
"basis[13] = 27.0 * ust - 108.0 * urst;\n"
"basis[14] = 256.0 * urst;\n"
"";
