// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_PyrI2Gradient.h"

const char *Basis_HGrad_PyrI2Gradient =
"// Be sure that the basis functions are defined when tt is very close to 1.\n"
"// Warning: the derivatives are discontinuous in (0, 0, 1).\n"
"if (abs(tt - 1.0) < eps)\n"
"{\n"
"  if (tt <= 1.0)\n"
"  {\n"
"    tt = 1.0 - eps;\n"
"  }\n"
"  else\n"
"  {\n"
"    tt = 1.0 + eps;\n"
"  }\n"
"}\n"
"\n"
"RealT ww = 1.0 / (1.0 - tt);\n"
"\n"
"basisGradient[0] = 0.25 * (-1.0 - rr - ss) * (-1.0 + ss + ss * tt * ww) -\n"
"  0.25 * ((1.0 - rr) * (1.0 - ss) - tt + rr * ss * tt * ww);\n"
"basisGradient[1] = 0.25 * (-1.0 - rr - ss) * (-1.0 + rr + rr * tt * ww) -\n"
"  0.25 * ((1.0 - rr) * (1.0 - ss) - tt + rr * ss * tt * ww);\n"
"basisGradient[2] = 0.25 * (-1.0 - rr - ss) * (-1.0 + rr * ss * ww + rr * ss * tt * ww * ww);\n"
"\n"
"basisGradient[3] = 0.25 * (-1.0 + rr - ss) * (1.0 - ss - ss * tt * ww) +\n"
"  0.25 * ((1.0 + rr) * (1.0 - ss) - tt - rr * ss * tt * ww);\n"
"basisGradient[4] = 0.25 * (-1.0 + rr - ss) * (-1.0 - rr - rr * tt * ww) -\n"
"  0.25 * ((1.0 + rr) * (1.0 - ss) - tt - rr * ss * tt * ww);\n"
"basisGradient[5] = 0.25 * (-1.0 + rr - ss) * (-1.0 - rr * ss * ww - rr * ss * tt * ww * ww);\n"
"\n"
"basisGradient[6] = 0.25 * (-1.0 + rr + ss) * (1.0 + ss + ss * tt * ww) +\n"
"  0.25 * ((1.0 + rr) * (1.0 + ss) - tt + rr * ss * tt * ww);\n"
"basisGradient[7] = 0.25 * (-1.0 + rr + ss) * (1.0 + rr + rr * tt * ww) +\n"
"  0.25 * ((1.0 + rr) * (1.0 + ss) - tt + rr * ss * tt * ww);\n"
"basisGradient[8] = 0.25 * (-1.0 + rr + ss) * (-1.0 + rr * ss * ww + rr * ss * tt * ww * ww);\n"
"\n"
"basisGradient[9] = 0.25 * (-1.0 - rr + ss) * (-1.0 - ss - ss * tt * ww) -\n"
"  0.25 * ((1.0 - rr) * (1.0 + ss) - tt - rr * ss * tt * ww);\n"
"basisGradient[10] = 0.25 * (-1.0 - rr + ss) * (1.0 - rr - rr * tt * ww) +\n"
"  0.25 * ((1.0 - rr) * (1.0 + ss) - tt - rr * ss * tt * ww);\n"
"basisGradient[11] = 0.25 * (-1.0 - rr + ss) * (-1.0 - rr * ss * ww - rr * ss * tt * ww * ww);\n"
"\n"
"basisGradient[12] = 0.0;\n"
"basisGradient[13] = 0.0;\n"
"basisGradient[14] = -1.0 + 4.0 * tt;\n"
"\n"
"basisGradient[15] = -rr * ww * (1.0 - ss - tt);\n"
"basisGradient[16] = -0.5 * (1.0 - rr - tt) * (1.0 + rr - tt) * ww;\n"
"basisGradient[17] = 0.5 * ss * rr * rr * ww * ww + 0.5 * ss - 1.0 + tt;\n"
"\n"
"basisGradient[18] = 0.5 * (1.0 - ss - tt) * (1.0 + ss - tt) * ww;\n"
"basisGradient[19] = -ss * ww * (1.0 + rr - tt);\n"
"basisGradient[20] = -0.5 * rr * ss * ss * ww * ww - 0.5 * rr - 1.0 + tt;\n"
"\n"
"basisGradient[21] = -rr * ww * (1.0 + ss - tt);\n"
"basisGradient[22] = 0.5 * (1.0 - rr - tt) * (1.0 + rr - tt) * ww;\n"
"basisGradient[23] = -0.5 * ss * rr * rr * ww * ww - 0.5 * ss - 1.0 + tt;\n"
"\n"
"basisGradient[24] = -0.5 * (1.0 - ss - tt) * (1.0 + ss - tt) * ww;\n"
"basisGradient[25] = -ss * ww * (1.0 - rr - tt);\n"
"basisGradient[26] = 0.5 * rr * ss * ss * ww * ww + 0.5 * rr - 1.0 + tt;\n"
"\n"
"basisGradient[27] = -(1.0 - ss - tt) * tt * ww;\n"
"basisGradient[28] = -(1.0 - rr - tt) * tt * ww;\n"
"basisGradient[29] = rr * ss * ww * ww + 1.0 - rr - ss - 2.0 * tt;\n"
"\n"
"basisGradient[30] = (1.0 - ss - tt) * tt * ww;\n"
"basisGradient[31] = -(1.0 + rr - tt) * tt * ww;\n"
"basisGradient[32] = -rr * ss * ww * ww + 1.0 + rr - ss - 2.0 * tt;\n"
"\n"
"basisGradient[33] = (1.0 + ss - tt) * tt * ww;\n"
"basisGradient[34] = (1.0 + rr - tt) * tt * ww;\n"
"basisGradient[35] = rr * ss * ww * ww + 1.0 + rr + ss - 2.0 * tt;\n"
"\n"
"basisGradient[36] = -(1.0 + ss - tt) * tt * ww;\n"
"basisGradient[37] = (1.0 - rr - tt) * tt * ww;\n"
"basisGradient[38] = -rr * ss * ww * ww + 1.0 - rr + ss - 2.0 * tt;\n"
"";
