// Code generated by Microsoft Kiota - DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package models

import (
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
)

// IosDdmLobAppAssignmentSettings contains properties used to assign an iOS iOS Declarative Device Management (DDM) Line Of Business (LOB) mobile app to a group.
type IosDdmLobAppAssignmentSettings struct {
    MobileAppAssignmentSettings
}
// NewIosDdmLobAppAssignmentSettings instantiates a new IosDdmLobAppAssignmentSettings and sets the default values.
func NewIosDdmLobAppAssignmentSettings()(*IosDdmLobAppAssignmentSettings) {
    m := &IosDdmLobAppAssignmentSettings{
        MobileAppAssignmentSettings: *NewMobileAppAssignmentSettings(),
    }
    odataTypeValue := "#microsoft.graph.iosDdmLobAppAssignmentSettings"
    m.SetOdataType(&odataTypeValue)
    return m
}
// CreateIosDdmLobAppAssignmentSettingsFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
// returns a Parsable when successful
func CreateIosDdmLobAppAssignmentSettingsFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewIosDdmLobAppAssignmentSettings(), nil
}
// GetAssociatedDomains gets the associatedDomains property value. Domain names to associate with the app
// returns a []string when successful
func (m *IosDdmLobAppAssignmentSettings) GetAssociatedDomains()([]string) {
    val, err := m.GetBackingStore().Get("associatedDomains")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetAssociatedDomainsDirectDownloadAllowed gets the associatedDomainsDirectDownloadAllowed property value. When true, the system allows direct downloads for the AssociatedDomains. When false, the system will not allow direct downloads for the AssociatedDomains. Default is false.
// returns a *bool when successful
func (m *IosDdmLobAppAssignmentSettings) GetAssociatedDomainsDirectDownloadAllowed()(*bool) {
    val, err := m.GetBackingStore().Get("associatedDomainsDirectDownloadAllowed")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*bool)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
// returns a map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error) when successful
func (m *IosDdmLobAppAssignmentSettings) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.MobileAppAssignmentSettings.GetFieldDeserializers()
    res["associatedDomains"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetAssociatedDomains(res)
        }
        return nil
    }
    res["associatedDomainsDirectDownloadAllowed"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetBoolValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetAssociatedDomainsDirectDownloadAllowed(val)
        }
        return nil
    }
    res["preventManagedAppBackup"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetBoolValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetPreventManagedAppBackup(val)
        }
        return nil
    }
    res["tapToPayScreenLockEnabled"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetBoolValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetTapToPayScreenLockEnabled(val)
        }
        return nil
    }
    res["vpnConfigurationId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetVpnConfigurationId(val)
        }
        return nil
    }
    return res
}
// GetPreventManagedAppBackup gets the preventManagedAppBackup property value. When true, indicates that the app should not be backed up to iCloud. When false, indicates that the app may be backed up to iCloud. Default is false.
// returns a *bool when successful
func (m *IosDdmLobAppAssignmentSettings) GetPreventManagedAppBackup()(*bool) {
    val, err := m.GetBackingStore().Get("preventManagedAppBackup")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*bool)
    }
    return nil
}
// GetTapToPayScreenLockEnabled gets the tapToPayScreenLockEnabled property value. When true, the device locks its screen after every transaction that requires a customer’s card PIN. When false, the user can choose the behavior. Default value is false.
// returns a *bool when successful
func (m *IosDdmLobAppAssignmentSettings) GetTapToPayScreenLockEnabled()(*bool) {
    val, err := m.GetBackingStore().Get("tapToPayScreenLockEnabled")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*bool)
    }
    return nil
}
// GetVpnConfigurationId gets the vpnConfigurationId property value. The unique identifier of the relay to associate with the app.
// returns a *string when successful
func (m *IosDdmLobAppAssignmentSettings) GetVpnConfigurationId()(*string) {
    val, err := m.GetBackingStore().Get("vpnConfigurationId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// Serialize serializes information the current object
func (m *IosDdmLobAppAssignmentSettings) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.MobileAppAssignmentSettings.Serialize(writer)
    if err != nil {
        return err
    }
    if m.GetAssociatedDomains() != nil {
        err = writer.WriteCollectionOfStringValues("associatedDomains", m.GetAssociatedDomains())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteBoolValue("associatedDomainsDirectDownloadAllowed", m.GetAssociatedDomainsDirectDownloadAllowed())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteBoolValue("preventManagedAppBackup", m.GetPreventManagedAppBackup())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteBoolValue("tapToPayScreenLockEnabled", m.GetTapToPayScreenLockEnabled())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("vpnConfigurationId", m.GetVpnConfigurationId())
        if err != nil {
            return err
        }
    }
    return nil
}
// SetAssociatedDomains sets the associatedDomains property value. Domain names to associate with the app
func (m *IosDdmLobAppAssignmentSettings) SetAssociatedDomains(value []string)() {
    err := m.GetBackingStore().Set("associatedDomains", value)
    if err != nil {
        panic(err)
    }
}
// SetAssociatedDomainsDirectDownloadAllowed sets the associatedDomainsDirectDownloadAllowed property value. When true, the system allows direct downloads for the AssociatedDomains. When false, the system will not allow direct downloads for the AssociatedDomains. Default is false.
func (m *IosDdmLobAppAssignmentSettings) SetAssociatedDomainsDirectDownloadAllowed(value *bool)() {
    err := m.GetBackingStore().Set("associatedDomainsDirectDownloadAllowed", value)
    if err != nil {
        panic(err)
    }
}
// SetPreventManagedAppBackup sets the preventManagedAppBackup property value. When true, indicates that the app should not be backed up to iCloud. When false, indicates that the app may be backed up to iCloud. Default is false.
func (m *IosDdmLobAppAssignmentSettings) SetPreventManagedAppBackup(value *bool)() {
    err := m.GetBackingStore().Set("preventManagedAppBackup", value)
    if err != nil {
        panic(err)
    }
}
// SetTapToPayScreenLockEnabled sets the tapToPayScreenLockEnabled property value. When true, the device locks its screen after every transaction that requires a customer’s card PIN. When false, the user can choose the behavior. Default value is false.
func (m *IosDdmLobAppAssignmentSettings) SetTapToPayScreenLockEnabled(value *bool)() {
    err := m.GetBackingStore().Set("tapToPayScreenLockEnabled", value)
    if err != nil {
        panic(err)
    }
}
// SetVpnConfigurationId sets the vpnConfigurationId property value. The unique identifier of the relay to associate with the app.
func (m *IosDdmLobAppAssignmentSettings) SetVpnConfigurationId(value *string)() {
    err := m.GetBackingStore().Set("vpnConfigurationId", value)
    if err != nil {
        panic(err)
    }
}
type IosDdmLobAppAssignmentSettingsable interface {
    MobileAppAssignmentSettingsable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetAssociatedDomains()([]string)
    GetAssociatedDomainsDirectDownloadAllowed()(*bool)
    GetPreventManagedAppBackup()(*bool)
    GetTapToPayScreenLockEnabled()(*bool)
    GetVpnConfigurationId()(*string)
    SetAssociatedDomains(value []string)()
    SetAssociatedDomainsDirectDownloadAllowed(value *bool)()
    SetPreventManagedAppBackup(value *bool)()
    SetTapToPayScreenLockEnabled(value *bool)()
    SetVpnConfigurationId(value *string)()
}
