//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/materialSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdMaterialSchemaTokens,
    HD_MATERIAL_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

HdMaterialNetworkSchema
HdMaterialSchema::GetMaterialNetwork()
{
    return 
        HdMaterialNetworkSchema(
            _GetTypedDataSource<HdContainerDataSource>(
                HdMaterialSchemaTokens->universalRenderContext));
}

HdMaterialNetworkSchema
HdMaterialSchema::GetMaterialNetwork(TfToken const &context)
{
    if (auto b = _GetTypedDataSource<HdContainerDataSource>(context)) {
        return HdMaterialNetworkSchema(b);
    }

    // If we can't find the context-specific binding, return the fallback.
    return
        HdMaterialNetworkSchema(
            _GetTypedDataSource<HdContainerDataSource>(
                HdMaterialSchemaTokens->universalRenderContext));
}

HdMaterialNetworkSchema
HdMaterialSchema::GetMaterialNetwork(TfTokenVector const &contexts)
{
    for (TfToken const &context : contexts) {
        if (auto b = _GetTypedDataSource<HdContainerDataSource>(context)) {
            return HdMaterialNetworkSchema(b);
        }
    }

    // If we can't find the context-specific binding, return the fallback.
    return
        HdMaterialNetworkSchema(
            _GetTypedDataSource<HdContainerDataSource>(
                HdMaterialSchemaTokens->universalRenderContext));
}

/*static*/
TfToken
HdMaterialSchema::GetLocatorTerminal(HdDataSourceLocator const& locator)
{
    return GetLocatorTerminal(locator, TfTokenVector());
}

/*static*/
TfToken
HdMaterialSchema::GetLocatorTerminal(HdDataSourceLocator const& locator, TfToken const &context)
{
    return GetLocatorTerminal(locator, TfTokenVector({context}));
}

/*static*/
TfToken
HdMaterialSchema::GetLocatorTerminal(
        HdDataSourceLocator const& locator, TfTokenVector const& contexts)
{
    if (locator.GetElementCount() >= 4) {

        // Always check the universal render context
        static const HdDataSourceLocator universalTerminalLocator(
            HdMaterialSchema::GetSchemaToken(),
            HdMaterialSchemaTokens->universalRenderContext,
            HdMaterialSchemaTokens->terminals
        );
        if (locator.Intersects(universalTerminalLocator)) {
            return locator.GetElement(3);
        }

        // Check the render specific contexts
        for (const TfToken& context : contexts) {
            const HdDataSourceLocator terminalLocator(
                HdMaterialSchema::GetSchemaToken(),
                context,
                HdMaterialSchemaTokens->terminals
            );
            if (locator.Intersects(terminalLocator)) {
                return locator.GetElement(3);
            }
        }

    }

    return TfToken();
}

// --(END CUSTOM CODE: Schema Methods)--

/*static*/
HdContainerDataSourceHandle
HdMaterialSchema::BuildRetained(
    const size_t count,
    const TfToken * const names,
    const HdDataSourceBaseHandle * const values)
{
    return HdRetainedContainerDataSource::New(count, names, values);
}

/*static*/
HdMaterialSchema
HdMaterialSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdMaterialSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdMaterialSchemaTokens->material))
        : nullptr);
}

/*static*/
const TfToken &
HdMaterialSchema::GetSchemaToken()
{
    return HdMaterialSchemaTokens->material;
}

/*static*/
const HdDataSourceLocator &
HdMaterialSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE