/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM FontFaceSetLoadEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "FontFaceSetLoadEvent.h"
#include "FontFaceSetLoadEventBinding.h"
#include "js/Array.h"
#include "js/ForOfIterator.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/FontFace.h"
#include "mozilla/dom/FontFaceSetLoadEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(FontFaceSetLoadEvent)

NS_IMPL_ADDREF_INHERITED(FontFaceSetLoadEvent, Event)
NS_IMPL_RELEASE_INHERITED(FontFaceSetLoadEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(FontFaceSetLoadEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mFontfaces)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(FontFaceSetLoadEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(FontFaceSetLoadEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mFontfaces)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(FontFaceSetLoadEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

FontFaceSetLoadEvent::FontFaceSetLoadEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

FontFaceSetLoadEvent::~FontFaceSetLoadEvent()
{
}

FontFaceSetLoadEvent*
FontFaceSetLoadEvent::AsFontFaceSetLoadEvent()
{
  return this;
}

JSObject*
FontFaceSetLoadEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return FontFaceSetLoadEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<FontFaceSetLoadEvent>
FontFaceSetLoadEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const FontFaceSetLoadEventInit& aEventInitDict)
{
  RefPtr<FontFaceSetLoadEvent> e = new FontFaceSetLoadEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mFontfaces.AppendElements(aEventInitDict.mFontfaces);
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<FontFaceSetLoadEvent>
FontFaceSetLoadEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const FontFaceSetLoadEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
FontFaceSetLoadEvent::GetFontfaces(nsTArray<RefPtr<FontFace>>& aRetVal) const
{
  aRetVal = mFontfaces.Clone();
}


} // namespace mozilla::dom
