/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef fragmentdirectives_ffi_generated_h
#define fragmentdirectives_ffi_generated_h

/* Generated with cbindgen:0.29.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsStringFwd.h"
#include "nsTArrayForwardDeclare.h"

/// This struct contains the percent-decoded parts of a text directive.
/// All parts besides `start` are optional (which is indicated by an empty string).
///
/// This struct uses Gecko String types, whereas the parser internally uses Rust types.
/// Therefore, conversion functions are provided.
struct TextDirective {
  nsString prefix;
  nsString start;
  nsString end;
  nsString suffix;

  friend std::ostream& operator<<(std::ostream& stream, const TextDirective& instance) {
    return stream << "{ " << "prefix=" << instance.prefix << ", "
                          << "start=" << instance.start << ", "
                          << "end=" << instance.end << ", "
                          << "suffix=" << instance.suffix << " }";
  }
};

/// Result of the `parse_fragment_directive()` function.
///
/// The result contains the original given URL without the fragment directive,
/// a unsanitized string version of the extracted fragment directive,
/// and an array of the parsed text directives.
struct ParsedFragmentDirectiveResult {
  nsCString hash_without_fragment_directive;
  nsCString fragment_directive;
  nsTArray<TextDirective> text_directives;

  friend std::ostream& operator<<(std::ostream& stream, const ParsedFragmentDirectiveResult& instance) {
    return stream << "{ " << "hash_without_fragment_directive=" << instance.hash_without_fragment_directive << ", "
                          << "fragment_directive=" << instance.fragment_directive << ", "
                          << "text_directives=" << instance.text_directives << " }";
  }
};

extern "C" {

/// Parses the fragment directive from a given URL fragment.
///
/// This function writes the result data into `result`.
/// The result consists of
///   - the input url fragment without the fragment directive,
///   - the fragment directive as unparsed string,
///   - a list of the parsed and percent-decoded text directives.
///
/// Directives which are unknown will be ignored.
/// If new directive types are added in the future, they should also be considered here.
/// This function returns false if no fragment directive is found. If there is any
/// fragment directive (even if invalid), this function returns true.
bool parse_fragment_directive(const nsCString *hash, ParsedFragmentDirectiveResult *result);

/// Creates a percent-encoded fragment directive string from a given list of `FragmentDirectiveElement`s.
///
/// The returned string has this form:
/// `:~:text=[prefix1-,]start1[,end1][,-suffix1]&text=[prefix2-,]start2[,end2][,-suffix2]`
///
/// Invalid `FragmentDirectiveElement`s are ignored, where "invalid" means that no `start` token is provided.
///  If there are no valid `FragmentDirectiveElement`s, an empty string is returned.
bool create_fragment_directive(const nsTArray<TextDirective> *text_directives,
                               nsCString *fragment_directive);

/// Creates a percent-encoded text directive string for a single text directive.
/// The returned string has the form `text=[prefix-,]start[,end][,-suffix]`.
/// If the provided `TextDirective` is invalid (i.e. it has no `start` attribute),
/// the outparam `directive_string` is empty and the function returns false.
bool create_text_directive(const TextDirective *text_directive, nsCString *directive_string);

}  // extern "C"

#endif  // fragmentdirectives_ffi_generated_h
