// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "v4_14")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
use crate::AccessibleText;
#[cfg(feature = "v4_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
use crate::NaturalWrapMode;
use crate::{
    ffi, Accessible, AccessibleRole, Align, Buildable, ConstraintTarget, Justification,
    LayoutManager, MovementStep, Overflow, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

#[cfg(feature = "v4_14")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
glib::wrapper! {
    #[doc(alias = "GtkLabel")]
    pub struct Label(Object<ffi::GtkLabel>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, AccessibleText;

    match fn {
        type_ => || ffi::gtk_label_get_type(),
    }
}

#[cfg(not(any(feature = "v4_14")))]
glib::wrapper! {
    #[doc(alias = "GtkLabel")]
    pub struct Label(Object<ffi::GtkLabel>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget;

    match fn {
        type_ => || ffi::gtk_label_get_type(),
    }
}

impl Label {
    #[doc(alias = "gtk_label_new")]
    pub fn new(str: Option<&str>) -> Label {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_label_new(str.to_glib_none().0)).unsafe_cast() }
    }

    #[doc(alias = "gtk_label_new_with_mnemonic")]
    #[doc(alias = "new_with_mnemonic")]
    pub fn with_mnemonic(str: &str) -> Label {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_label_new_with_mnemonic(str.to_glib_none().0))
                .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Label`] objects.
    ///
    /// This method returns an instance of [`LabelBuilder`](crate::builders::LabelBuilder) which can be used to create [`Label`] objects.
    pub fn builder() -> LabelBuilder {
        LabelBuilder::new()
    }

    #[doc(alias = "gtk_label_get_attributes")]
    #[doc(alias = "get_attributes")]
    pub fn attributes(&self) -> Option<pango::AttrList> {
        unsafe { from_glib_none(ffi::gtk_label_get_attributes(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_current_uri")]
    #[doc(alias = "get_current_uri")]
    pub fn current_uri(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_label_get_current_uri(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_ellipsize")]
    #[doc(alias = "get_ellipsize")]
    pub fn ellipsize(&self) -> pango::EllipsizeMode {
        unsafe { from_glib(ffi::gtk_label_get_ellipsize(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_extra_menu")]
    #[doc(alias = "get_extra_menu")]
    #[doc(alias = "extra-menu")]
    pub fn extra_menu(&self) -> Option<gio::MenuModel> {
        unsafe { from_glib_none(ffi::gtk_label_get_extra_menu(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_justify")]
    #[doc(alias = "get_justify")]
    pub fn justify(&self) -> Justification {
        unsafe { from_glib(ffi::gtk_label_get_justify(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_label")]
    #[doc(alias = "get_label")]
    pub fn label(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_label_get_label(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_layout")]
    #[doc(alias = "get_layout")]
    pub fn layout(&self) -> pango::Layout {
        unsafe { from_glib_none(ffi::gtk_label_get_layout(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_layout_offsets")]
    #[doc(alias = "get_layout_offsets")]
    pub fn layout_offsets(&self) -> (i32, i32) {
        unsafe {
            let mut x = std::mem::MaybeUninit::uninit();
            let mut y = std::mem::MaybeUninit::uninit();
            ffi::gtk_label_get_layout_offsets(
                self.to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            (x.assume_init(), y.assume_init())
        }
    }

    #[doc(alias = "gtk_label_get_lines")]
    #[doc(alias = "get_lines")]
    pub fn lines(&self) -> i32 {
        unsafe { ffi::gtk_label_get_lines(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_label_get_max_width_chars")]
    #[doc(alias = "get_max_width_chars")]
    #[doc(alias = "max-width-chars")]
    pub fn max_width_chars(&self) -> i32 {
        unsafe { ffi::gtk_label_get_max_width_chars(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_label_get_mnemonic_widget")]
    #[doc(alias = "get_mnemonic_widget")]
    #[doc(alias = "mnemonic-widget")]
    pub fn mnemonic_widget(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_label_get_mnemonic_widget(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gtk_label_get_natural_wrap_mode")]
    #[doc(alias = "get_natural_wrap_mode")]
    #[doc(alias = "natural-wrap-mode")]
    pub fn natural_wrap_mode(&self) -> NaturalWrapMode {
        unsafe { from_glib(ffi::gtk_label_get_natural_wrap_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_selectable")]
    #[doc(alias = "get_selectable")]
    #[doc(alias = "selectable")]
    pub fn is_selectable(&self) -> bool {
        unsafe { from_glib(ffi::gtk_label_get_selectable(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_selection_bounds")]
    #[doc(alias = "get_selection_bounds")]
    pub fn selection_bounds(&self) -> Option<(i32, i32)> {
        unsafe {
            let mut start = std::mem::MaybeUninit::uninit();
            let mut end = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_label_get_selection_bounds(
                self.to_glib_none().0,
                start.as_mut_ptr(),
                end.as_mut_ptr(),
            ));
            if ret {
                Some((start.assume_init(), end.assume_init()))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_label_get_single_line_mode")]
    #[doc(alias = "get_single_line_mode")]
    #[doc(alias = "single-line-mode")]
    pub fn is_single_line_mode(&self) -> bool {
        unsafe { from_glib(ffi::gtk_label_get_single_line_mode(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "gtk_label_get_tabs")]
    #[doc(alias = "get_tabs")]
    pub fn tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_full(ffi::gtk_label_get_tabs(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_text")]
    #[doc(alias = "get_text")]
    pub fn text(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_label_get_text(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_use_markup")]
    #[doc(alias = "get_use_markup")]
    #[doc(alias = "use-markup")]
    pub fn uses_markup(&self) -> bool {
        unsafe { from_glib(ffi::gtk_label_get_use_markup(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_use_underline")]
    #[doc(alias = "get_use_underline")]
    #[doc(alias = "use-underline")]
    pub fn uses_underline(&self) -> bool {
        unsafe { from_glib(ffi::gtk_label_get_use_underline(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_width_chars")]
    #[doc(alias = "get_width_chars")]
    #[doc(alias = "width-chars")]
    pub fn width_chars(&self) -> i32 {
        unsafe { ffi::gtk_label_get_width_chars(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_label_get_wrap")]
    #[doc(alias = "get_wrap")]
    #[doc(alias = "wrap")]
    pub fn wraps(&self) -> bool {
        unsafe { from_glib(ffi::gtk_label_get_wrap(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_wrap_mode")]
    #[doc(alias = "get_wrap_mode")]
    #[doc(alias = "wrap-mode")]
    pub fn wrap_mode(&self) -> pango::WrapMode {
        unsafe { from_glib(ffi::gtk_label_get_wrap_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_label_get_xalign")]
    #[doc(alias = "get_xalign")]
    pub fn xalign(&self) -> f32 {
        unsafe { ffi::gtk_label_get_xalign(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_label_get_yalign")]
    #[doc(alias = "get_yalign")]
    pub fn yalign(&self) -> f32 {
        unsafe { ffi::gtk_label_get_yalign(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_label_select_region")]
    pub fn select_region(&self, start_offset: i32, end_offset: i32) {
        unsafe {
            ffi::gtk_label_select_region(self.to_glib_none().0, start_offset, end_offset);
        }
    }

    #[doc(alias = "gtk_label_set_attributes")]
    #[doc(alias = "attributes")]
    pub fn set_attributes(&self, attrs: Option<&pango::AttrList>) {
        unsafe {
            ffi::gtk_label_set_attributes(self.to_glib_none().0, attrs.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_label_set_ellipsize")]
    #[doc(alias = "ellipsize")]
    pub fn set_ellipsize(&self, mode: pango::EllipsizeMode) {
        unsafe {
            ffi::gtk_label_set_ellipsize(self.to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "gtk_label_set_extra_menu")]
    #[doc(alias = "extra-menu")]
    pub fn set_extra_menu(&self, model: Option<&impl IsA<gio::MenuModel>>) {
        unsafe {
            ffi::gtk_label_set_extra_menu(
                self.to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_label_set_justify")]
    #[doc(alias = "justify")]
    pub fn set_justify(&self, jtype: Justification) {
        unsafe {
            ffi::gtk_label_set_justify(self.to_glib_none().0, jtype.into_glib());
        }
    }

    #[doc(alias = "gtk_label_set_label")]
    #[doc(alias = "label")]
    pub fn set_label(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_label(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_label_set_lines")]
    #[doc(alias = "lines")]
    pub fn set_lines(&self, lines: i32) {
        unsafe {
            ffi::gtk_label_set_lines(self.to_glib_none().0, lines);
        }
    }

    #[doc(alias = "gtk_label_set_markup")]
    pub fn set_markup(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_markup(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_label_set_markup_with_mnemonic")]
    pub fn set_markup_with_mnemonic(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_markup_with_mnemonic(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_label_set_max_width_chars")]
    #[doc(alias = "max-width-chars")]
    pub fn set_max_width_chars(&self, n_chars: i32) {
        unsafe {
            ffi::gtk_label_set_max_width_chars(self.to_glib_none().0, n_chars);
        }
    }

    #[doc(alias = "gtk_label_set_mnemonic_widget")]
    #[doc(alias = "mnemonic-widget")]
    pub fn set_mnemonic_widget(&self, widget: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_label_set_mnemonic_widget(
                self.to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gtk_label_set_natural_wrap_mode")]
    #[doc(alias = "natural-wrap-mode")]
    pub fn set_natural_wrap_mode(&self, wrap_mode: NaturalWrapMode) {
        unsafe {
            ffi::gtk_label_set_natural_wrap_mode(self.to_glib_none().0, wrap_mode.into_glib());
        }
    }

    #[doc(alias = "gtk_label_set_selectable")]
    #[doc(alias = "selectable")]
    pub fn set_selectable(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_selectable(self.to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_label_set_single_line_mode")]
    #[doc(alias = "single-line-mode")]
    pub fn set_single_line_mode(&self, single_line_mode: bool) {
        unsafe {
            ffi::gtk_label_set_single_line_mode(
                self.to_glib_none().0,
                single_line_mode.into_glib(),
            );
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "gtk_label_set_tabs")]
    #[doc(alias = "tabs")]
    pub fn set_tabs(&self, tabs: Option<&pango::TabArray>) {
        unsafe {
            ffi::gtk_label_set_tabs(self.to_glib_none().0, mut_override(tabs.to_glib_none().0));
        }
    }

    #[doc(alias = "gtk_label_set_text")]
    pub fn set_text(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_text(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_label_set_text_with_mnemonic")]
    pub fn set_text_with_mnemonic(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_text_with_mnemonic(self.to_glib_none().0, str.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_label_set_use_markup")]
    #[doc(alias = "use-markup")]
    pub fn set_use_markup(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_use_markup(self.to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_label_set_use_underline")]
    #[doc(alias = "use-underline")]
    pub fn set_use_underline(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_use_underline(self.to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_label_set_width_chars")]
    #[doc(alias = "width-chars")]
    pub fn set_width_chars(&self, n_chars: i32) {
        unsafe {
            ffi::gtk_label_set_width_chars(self.to_glib_none().0, n_chars);
        }
    }

    #[doc(alias = "gtk_label_set_wrap")]
    #[doc(alias = "wrap")]
    pub fn set_wrap(&self, wrap: bool) {
        unsafe {
            ffi::gtk_label_set_wrap(self.to_glib_none().0, wrap.into_glib());
        }
    }

    #[doc(alias = "gtk_label_set_wrap_mode")]
    #[doc(alias = "wrap-mode")]
    pub fn set_wrap_mode(&self, wrap_mode: pango::WrapMode) {
        unsafe {
            ffi::gtk_label_set_wrap_mode(self.to_glib_none().0, wrap_mode.into_glib());
        }
    }

    #[doc(alias = "gtk_label_set_xalign")]
    #[doc(alias = "xalign")]
    pub fn set_xalign(&self, xalign: f32) {
        unsafe {
            ffi::gtk_label_set_xalign(self.to_glib_none().0, xalign);
        }
    }

    #[doc(alias = "gtk_label_set_yalign")]
    #[doc(alias = "yalign")]
    pub fn set_yalign(&self, yalign: f32) {
        unsafe {
            ffi::gtk_label_set_yalign(self.to_glib_none().0, yalign);
        }
    }

    #[doc(alias = "activate-current-link")]
    pub fn connect_activate_current_link<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_current_link_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-current-link\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activate_current_link_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_activate_current_link(&self) {
        self.emit_by_name::<()>("activate-current-link", &[]);
    }

    #[doc(alias = "activate-link")]
    pub fn connect_activate_link<F: Fn(&Self, &str) -> glib::Propagation + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn activate_link_trampoline<
            F: Fn(&Label, &str) -> glib::Propagation + 'static,
        >(
            this: *mut ffi::GtkLabel,
            uri: *mut std::ffi::c_char,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &glib::GString::from_glib_borrow(uri),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-link\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activate_link_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "copy-clipboard")]
    pub fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn copy_clipboard_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"copy-clipboard\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    copy_clipboard_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_copy_clipboard(&self) {
        self.emit_by_name::<()>("copy-clipboard", &[]);
    }

    #[doc(alias = "move-cursor")]
    pub fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            F: Fn(&Label, MovementStep, i32, bool) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            step: ffi::GtkMovementStep,
            count: std::ffi::c_int,
            extend_selection: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                from_glib(step),
                count,
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    move_cursor_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool) {
        self.emit_by_name::<()>("move-cursor", &[&step, &count, &extend_selection]);
    }

    #[doc(alias = "attributes")]
    pub fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "ellipsize")]
    pub fn connect_ellipsize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ellipsize_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ellipsize\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_ellipsize_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "extra-menu")]
    pub fn connect_extra_menu_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_menu_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-menu\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_extra_menu_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "justify")]
    pub fn connect_justify_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_justify_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justify\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_justify_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "label")]
    pub fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_label_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::label\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_label_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "lines")]
    pub fn connect_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_lines_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::lines\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_lines_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-width-chars")]
    pub fn connect_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_width_chars_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-width-chars\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_max_width_chars_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mnemonic-keyval")]
    pub fn connect_mnemonic_keyval_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mnemonic_keyval_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mnemonic-keyval\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_mnemonic_keyval_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mnemonic-widget")]
    pub fn connect_mnemonic_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mnemonic_widget_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mnemonic-widget\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_mnemonic_widget_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "natural-wrap-mode")]
    pub fn connect_natural_wrap_mode_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_natural_wrap_mode_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::natural-wrap-mode\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_natural_wrap_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selectable")]
    pub fn connect_selectable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selectable_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selectable\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_selectable_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "single-line-mode")]
    pub fn connect_single_line_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_single_line_mode_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::single-line-mode\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_single_line_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "tabs")]
    pub fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "use-markup")]
    pub fn connect_use_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_markup_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-markup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_use_markup_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "use-underline")]
    pub fn connect_use_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_underline_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-underline\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_use_underline_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "width-chars")]
    pub fn connect_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_chars_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width-chars\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_width_chars_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrap")]
    pub fn connect_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_wrap_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrap-mode")]
    pub fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "xalign")]
    pub fn connect_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_xalign_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::xalign\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_xalign_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "yalign")]
    pub fn connect_yalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_yalign_trampoline<F: Fn(&Label) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::yalign\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_yalign_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Label {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Label`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct LabelBuilder {
    builder: glib::object::ObjectBuilder<'static, Label>,
}

impl LabelBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn attributes(self, attributes: &pango::AttrList) -> Self {
        Self {
            builder: self.builder.property("attributes", attributes.clone()),
        }
    }

    pub fn ellipsize(self, ellipsize: pango::EllipsizeMode) -> Self {
        Self {
            builder: self.builder.property("ellipsize", ellipsize),
        }
    }

    pub fn extra_menu(self, extra_menu: &impl IsA<gio::MenuModel>) -> Self {
        Self {
            builder: self
                .builder
                .property("extra-menu", extra_menu.clone().upcast()),
        }
    }

    pub fn justify(self, justify: Justification) -> Self {
        Self {
            builder: self.builder.property("justify", justify),
        }
    }

    pub fn label(self, label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("label", label.into()),
        }
    }

    pub fn lines(self, lines: i32) -> Self {
        Self {
            builder: self.builder.property("lines", lines),
        }
    }

    pub fn max_width_chars(self, max_width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("max-width-chars", max_width_chars),
        }
    }

    pub fn mnemonic_widget(self, mnemonic_widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("mnemonic-widget", mnemonic_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    pub fn natural_wrap_mode(self, natural_wrap_mode: NaturalWrapMode) -> Self {
        Self {
            builder: self
                .builder
                .property("natural-wrap-mode", natural_wrap_mode),
        }
    }

    pub fn selectable(self, selectable: bool) -> Self {
        Self {
            builder: self.builder.property("selectable", selectable),
        }
    }

    pub fn single_line_mode(self, single_line_mode: bool) -> Self {
        Self {
            builder: self.builder.property("single-line-mode", single_line_mode),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn tabs(self, tabs: &pango::TabArray) -> Self {
        Self {
            builder: self.builder.property("tabs", tabs),
        }
    }

    pub fn use_markup(self, use_markup: bool) -> Self {
        Self {
            builder: self.builder.property("use-markup", use_markup),
        }
    }

    pub fn use_underline(self, use_underline: bool) -> Self {
        Self {
            builder: self.builder.property("use-underline", use_underline),
        }
    }

    pub fn width_chars(self, width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("width-chars", width_chars),
        }
    }

    pub fn wrap(self, wrap: bool) -> Self {
        Self {
            builder: self.builder.property("wrap", wrap),
        }
    }

    pub fn wrap_mode(self, wrap_mode: pango::WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    pub fn yalign(self, yalign: f32) -> Self {
        Self {
            builder: self.builder.property("yalign", yalign),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Label`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Label {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
