
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_epmapper.h"
#include "bin/default/librpc/gen_ndr/ndr_epmapper_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
static PyTypeObject epm_rhs_dnet_nsp_Type;
static PyTypeObject epm_rhs_osi_tp4_Type;
static PyTypeObject epm_rhs_osi_clns_Type;
static PyTypeObject epm_rhs_udp_Type;
static PyTypeObject epm_rhs_tcp_Type;
static PyTypeObject epm_rhs_ip_Type;
static PyTypeObject epm_rhs_ncadg_Type;
static PyTypeObject epm_rhs_ncacn_Type;
static PyTypeObject epm_rhs_uuid_Type;
static PyTypeObject epm_rhs_ipx_Type;
static PyTypeObject epm_rhs_smb_Type;
static PyTypeObject epm_rhs_named_pipe_Type;
static PyTypeObject epm_rhs_netbios_Type;
static PyTypeObject epm_rhs_netbeui_Type;
static PyTypeObject epm_rhs_spx_Type;
static PyTypeObject epm_rhs_nb_ipx_Type;
static PyTypeObject epm_rhs_http_Type;
static PyTypeObject epm_rhs_unix_ds_Type;
static PyTypeObject epm_rhs_null_Type;
static PyTypeObject epm_rhs_ncalrpc_Type;
static PyTypeObject epm_rhs_appletalk_Type;
static PyTypeObject epm_rhs_atalk_stream_Type;
static PyTypeObject epm_rhs_atalk_datagram_Type;
static PyTypeObject epm_rhs_vines_spp_Type;
static PyTypeObject epm_rhs_vines_ipc_Type;
static PyTypeObject epm_rhs_streettalk_Type;
static PyTypeObject epm_rhs_Type;
static PyTypeObject epm_lhs_Type;
static PyTypeObject epm_floor_Type;
static PyTypeObject epm_tower_Type;
static PyTypeObject epm_twr_t_Type;
static PyTypeObject epm_entry_t_Type;
static PyTypeObject rpc_if_id_t_Type;
static PyTypeObject epm_twr_p_t_Type;
static PyTypeObject epmapper_InterfaceType;
static PyTypeObject epm_Insert_Type;
static PyTypeObject epm_Delete_Type;
static PyTypeObject epm_Lookup_Type;
static PyTypeObject epm_Map_Type;
static PyTypeObject epm_LookupHandleFree_Type;
static PyTypeObject epm_InqObject_Type;
static PyTypeObject epm_MgmtDelete_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_epm_rhs_dnet_nsp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_dnet_nsp, type);
}


static PyTypeObject epm_rhs_dnet_nsp_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_dnet_nsp",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_dnet_nsp_new,
};


static PyObject *py_epm_rhs_osi_tp4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_osi_tp4, type);
}


static PyTypeObject epm_rhs_osi_tp4_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_osi_tp4",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_osi_tp4_new,
};


static PyObject *py_epm_rhs_osi_clns_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_osi_clns, type);
}


static PyTypeObject epm_rhs_osi_clns_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_osi_clns",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_osi_clns_new,
};


static PyObject *py_epm_rhs_udp_get_port(PyObject *obj, void *closure)
{
	struct epm_rhs_udp *object = pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyLong_FromLong((uint16_t)(object->port));
	return py_port;
}

static int py_epm_rhs_udp_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_udp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_udp_getsetters[] = {
	{
		.name = discard_const_p(char, "port"),
		.get = py_epm_rhs_udp_get_port,
		.set = py_epm_rhs_udp_set_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_udp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_udp, type);
}


static PyTypeObject epm_rhs_udp_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_udp",
	.tp_getset = py_epm_rhs_udp_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_udp_new,
};


static PyObject *py_epm_rhs_tcp_get_port(PyObject *obj, void *closure)
{
	struct epm_rhs_tcp *object = pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyLong_FromLong((uint16_t)(object->port));
	return py_port;
}

static int py_epm_rhs_tcp_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_tcp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_tcp_getsetters[] = {
	{
		.name = discard_const_p(char, "port"),
		.get = py_epm_rhs_tcp_get_port,
		.set = py_epm_rhs_tcp_set_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_tcp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_tcp, type);
}


static PyTypeObject epm_rhs_tcp_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_tcp",
	.tp_getset = py_epm_rhs_tcp_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_tcp_new,
};


static PyObject *py_epm_rhs_ip_get_ipaddr(PyObject *obj, void *closure)
{
	struct epm_rhs_ip *object = pytalloc_get_ptr(obj);
	PyObject *py_ipaddr;
	py_ipaddr = PyString_FromStringOrNULL(object->ipaddr);
	return py_ipaddr;
}

static int py_epm_rhs_ip_set_ipaddr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_ip *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ipaddr");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ipaddr = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_ip_getsetters[] = {
	{
		.name = discard_const_p(char, "ipaddr"),
		.get = py_epm_rhs_ip_get_ipaddr,
		.set = py_epm_rhs_ip_set_ipaddr,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_ip_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_ip, type);
}


static PyTypeObject epm_rhs_ip_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_ip",
	.tp_getset = py_epm_rhs_ip_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_ip_new,
};


static PyObject *py_epm_rhs_ncadg_get_minor_version(PyObject *obj, void *closure)
{
	struct epm_rhs_ncadg *object = pytalloc_get_ptr(obj);
	PyObject *py_minor_version;
	py_minor_version = PyLong_FromLong((uint16_t)(object->minor_version));
	return py_minor_version;
}

static int py_epm_rhs_ncadg_set_minor_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_ncadg *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minor_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minor_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minor_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_ncadg_getsetters[] = {
	{
		.name = discard_const_p(char, "minor_version"),
		.get = py_epm_rhs_ncadg_get_minor_version,
		.set = py_epm_rhs_ncadg_set_minor_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_ncadg_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_ncadg, type);
}


static PyTypeObject epm_rhs_ncadg_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_ncadg",
	.tp_getset = py_epm_rhs_ncadg_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_ncadg_new,
};


static PyObject *py_epm_rhs_ncacn_get_minor_version(PyObject *obj, void *closure)
{
	struct epm_rhs_ncacn *object = pytalloc_get_ptr(obj);
	PyObject *py_minor_version;
	py_minor_version = PyLong_FromLong((uint16_t)(object->minor_version));
	return py_minor_version;
}

static int py_epm_rhs_ncacn_set_minor_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_ncacn *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minor_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minor_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minor_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_ncacn_getsetters[] = {
	{
		.name = discard_const_p(char, "minor_version"),
		.get = py_epm_rhs_ncacn_get_minor_version,
		.set = py_epm_rhs_ncacn_set_minor_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_ncacn_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_ncacn, type);
}


static PyTypeObject epm_rhs_ncacn_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_ncacn",
	.tp_getset = py_epm_rhs_ncacn_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_ncacn_new,
};


static PyObject *py_epm_rhs_uuid_get_unknown(PyObject *obj, void *closure)
{
	struct epm_rhs_uuid *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyBytes_FromStringAndSize((char *)(object->unknown).data, (object->unknown).length);
	return py_unknown;
}

static int py_epm_rhs_uuid_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_uuid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown");
		return -1;
	}
	object->unknown = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_epm_rhs_uuid_getsetters[] = {
	{
		.name = discard_const_p(char, "unknown"),
		.get = py_epm_rhs_uuid_get_unknown,
		.set = py_epm_rhs_uuid_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_uuid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_uuid, type);
}


static PyTypeObject epm_rhs_uuid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_uuid",
	.tp_getset = py_epm_rhs_uuid_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_uuid_new,
};


static PyObject *py_epm_rhs_ipx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_ipx, type);
}


static PyTypeObject epm_rhs_ipx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_ipx",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_ipx_new,
};


static PyObject *py_epm_rhs_smb_get_unc(PyObject *obj, void *closure)
{
	struct epm_rhs_smb *object = pytalloc_get_ptr(obj);
	PyObject *py_unc;
	py_unc = PyString_FromStringOrNULL(object->unc);
	return py_unc;
}

static int py_epm_rhs_smb_set_unc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_smb *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unc");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unc = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_smb_getsetters[] = {
	{
		.name = discard_const_p(char, "unc"),
		.get = py_epm_rhs_smb_get_unc,
		.set = py_epm_rhs_smb_set_unc,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_smb_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_smb, type);
}


static PyTypeObject epm_rhs_smb_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_smb",
	.tp_getset = py_epm_rhs_smb_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_smb_new,
};


static PyObject *py_epm_rhs_named_pipe_get_path(PyObject *obj, void *closure)
{
	struct epm_rhs_named_pipe *object = pytalloc_get_ptr(obj);
	PyObject *py_path;
	py_path = PyString_FromStringOrNULL(object->path);
	return py_path;
}

static int py_epm_rhs_named_pipe_set_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_named_pipe *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->path");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->path = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_named_pipe_getsetters[] = {
	{
		.name = discard_const_p(char, "path"),
		.get = py_epm_rhs_named_pipe_get_path,
		.set = py_epm_rhs_named_pipe_set_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_named_pipe_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_named_pipe, type);
}


static PyTypeObject epm_rhs_named_pipe_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_named_pipe",
	.tp_getset = py_epm_rhs_named_pipe_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_named_pipe_new,
};


static PyObject *py_epm_rhs_netbios_get_name(PyObject *obj, void *closure)
{
	struct epm_rhs_netbios *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_epm_rhs_netbios_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_netbios *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_netbios_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_epm_rhs_netbios_get_name,
		.set = py_epm_rhs_netbios_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_netbios_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_netbios, type);
}


static PyTypeObject epm_rhs_netbios_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_netbios",
	.tp_getset = py_epm_rhs_netbios_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_netbios_new,
};


static PyObject *py_epm_rhs_netbeui_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_netbeui, type);
}


static PyTypeObject epm_rhs_netbeui_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_netbeui",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_netbeui_new,
};


static PyObject *py_epm_rhs_spx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_spx, type);
}


static PyTypeObject epm_rhs_spx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_spx",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_spx_new,
};


static PyObject *py_epm_rhs_nb_ipx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_nb_ipx, type);
}


static PyTypeObject epm_rhs_nb_ipx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_nb_ipx",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_nb_ipx_new,
};


static PyObject *py_epm_rhs_http_get_port(PyObject *obj, void *closure)
{
	struct epm_rhs_http *object = pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyLong_FromLong((uint16_t)(object->port));
	return py_port;
}

static int py_epm_rhs_http_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_http *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_http_getsetters[] = {
	{
		.name = discard_const_p(char, "port"),
		.get = py_epm_rhs_http_get_port,
		.set = py_epm_rhs_http_set_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_http_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_http, type);
}


static PyTypeObject epm_rhs_http_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_http",
	.tp_getset = py_epm_rhs_http_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_http_new,
};


static PyObject *py_epm_rhs_unix_ds_get_path(PyObject *obj, void *closure)
{
	struct epm_rhs_unix_ds *object = pytalloc_get_ptr(obj);
	PyObject *py_path;
	py_path = PyString_FromStringOrNULL(object->path);
	return py_path;
}

static int py_epm_rhs_unix_ds_set_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_unix_ds *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->path");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->path = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_unix_ds_getsetters[] = {
	{
		.name = discard_const_p(char, "path"),
		.get = py_epm_rhs_unix_ds_get_path,
		.set = py_epm_rhs_unix_ds_set_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_unix_ds_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_unix_ds, type);
}


static PyTypeObject epm_rhs_unix_ds_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_unix_ds",
	.tp_getset = py_epm_rhs_unix_ds_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_unix_ds_new,
};


static PyObject *py_epm_rhs_null_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_null, type);
}


static PyTypeObject epm_rhs_null_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_null",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_null_new,
};


static PyObject *py_epm_rhs_ncalrpc_get_minor_version(PyObject *obj, void *closure)
{
	struct epm_rhs_ncalrpc *object = pytalloc_get_ptr(obj);
	PyObject *py_minor_version;
	py_minor_version = PyLong_FromLong((uint16_t)(object->minor_version));
	return py_minor_version;
}

static int py_epm_rhs_ncalrpc_set_minor_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_ncalrpc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minor_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minor_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minor_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_ncalrpc_getsetters[] = {
	{
		.name = discard_const_p(char, "minor_version"),
		.get = py_epm_rhs_ncalrpc_get_minor_version,
		.set = py_epm_rhs_ncalrpc_set_minor_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_ncalrpc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_ncalrpc, type);
}


static PyTypeObject epm_rhs_ncalrpc_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_ncalrpc",
	.tp_getset = py_epm_rhs_ncalrpc_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_ncalrpc_new,
};


static PyObject *py_epm_rhs_appletalk_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_appletalk, type);
}


static PyTypeObject epm_rhs_appletalk_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_appletalk",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_appletalk_new,
};


static PyObject *py_epm_rhs_atalk_stream_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_atalk_stream, type);
}


static PyTypeObject epm_rhs_atalk_stream_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_atalk_stream",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_atalk_stream_new,
};


static PyObject *py_epm_rhs_atalk_datagram_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_atalk_datagram, type);
}


static PyTypeObject epm_rhs_atalk_datagram_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_atalk_datagram",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_atalk_datagram_new,
};


static PyObject *py_epm_rhs_vines_spp_get_port(PyObject *obj, void *closure)
{
	struct epm_rhs_vines_spp *object = pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyLong_FromLong((uint16_t)(object->port));
	return py_port;
}

static int py_epm_rhs_vines_spp_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_vines_spp *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_vines_spp_getsetters[] = {
	{
		.name = discard_const_p(char, "port"),
		.get = py_epm_rhs_vines_spp_get_port,
		.set = py_epm_rhs_vines_spp_set_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_vines_spp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_vines_spp, type);
}


static PyTypeObject epm_rhs_vines_spp_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_vines_spp",
	.tp_getset = py_epm_rhs_vines_spp_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_vines_spp_new,
};


static PyObject *py_epm_rhs_vines_ipc_get_port(PyObject *obj, void *closure)
{
	struct epm_rhs_vines_ipc *object = pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyLong_FromLong((uint16_t)(object->port));
	return py_port;
}

static int py_epm_rhs_vines_ipc_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_vines_ipc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_vines_ipc_getsetters[] = {
	{
		.name = discard_const_p(char, "port"),
		.get = py_epm_rhs_vines_ipc_get_port,
		.set = py_epm_rhs_vines_ipc_set_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_vines_ipc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_vines_ipc, type);
}


static PyTypeObject epm_rhs_vines_ipc_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_vines_ipc",
	.tp_getset = py_epm_rhs_vines_ipc_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_vines_ipc_new,
};


static PyObject *py_epm_rhs_streettalk_get_streettalk(PyObject *obj, void *closure)
{
	struct epm_rhs_streettalk *object = pytalloc_get_ptr(obj);
	PyObject *py_streettalk;
	py_streettalk = PyString_FromStringOrNULL(object->streettalk);
	return py_streettalk;
}

static int py_epm_rhs_streettalk_set_streettalk(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_rhs_streettalk *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->streettalk");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->streettalk = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_epm_rhs_streettalk_getsetters[] = {
	{
		.name = discard_const_p(char, "streettalk"),
		.get = py_epm_rhs_streettalk_get_streettalk,
		.set = py_epm_rhs_streettalk_set_streettalk,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_epm_rhs_streettalk_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_rhs_streettalk, type);
}


static PyTypeObject epm_rhs_streettalk_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs_streettalk",
	.tp_getset = py_epm_rhs_streettalk_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_streettalk_new,
};

static PyObject *py_import_epm_rhs(TALLOC_CTX *mem_ctx, int level, union epm_rhs *in)
{
	PyObject *ret;

	switch (level) {
		case EPM_PROTOCOL_DNET_NSP:
			ret = pytalloc_reference_ex(&epm_rhs_dnet_nsp_Type, mem_ctx, &in->dnet_nsp);
			return ret;

		case EPM_PROTOCOL_OSI_TP4:
			ret = pytalloc_reference_ex(&epm_rhs_osi_tp4_Type, mem_ctx, &in->osi_tp4);
			return ret;

		case EPM_PROTOCOL_OSI_CLNS:
			ret = pytalloc_reference_ex(&epm_rhs_osi_clns_Type, mem_ctx, &in->osi_clns);
			return ret;

		case EPM_PROTOCOL_TCP:
			ret = pytalloc_reference_ex(&epm_rhs_tcp_Type, mem_ctx, &in->tcp);
			return ret;

		case EPM_PROTOCOL_UDP:
			ret = pytalloc_reference_ex(&epm_rhs_udp_Type, mem_ctx, &in->udp);
			return ret;

		case EPM_PROTOCOL_IP:
			ret = pytalloc_reference_ex(&epm_rhs_ip_Type, mem_ctx, &in->ip);
			return ret;

		case EPM_PROTOCOL_NCADG:
			ret = pytalloc_reference_ex(&epm_rhs_ncadg_Type, mem_ctx, &in->ncadg);
			return ret;

		case EPM_PROTOCOL_NCACN:
			ret = pytalloc_reference_ex(&epm_rhs_ncacn_Type, mem_ctx, &in->ncacn);
			return ret;

		case EPM_PROTOCOL_NCALRPC:
			ret = pytalloc_reference_ex(&epm_rhs_ncalrpc_Type, mem_ctx, &in->ncalrpc);
			return ret;

		case EPM_PROTOCOL_UUID:
			ret = pytalloc_reference_ex(&epm_rhs_uuid_Type, mem_ctx, &in->uuid);
			return ret;

		case EPM_PROTOCOL_IPX:
			ret = pytalloc_reference_ex(&epm_rhs_ipx_Type, mem_ctx, &in->ipx);
			return ret;

		case EPM_PROTOCOL_SMB:
			ret = pytalloc_reference_ex(&epm_rhs_smb_Type, mem_ctx, &in->smb);
			return ret;

		case EPM_PROTOCOL_NAMED_PIPE:
			ret = pytalloc_reference_ex(&epm_rhs_named_pipe_Type, mem_ctx, &in->named_pipe);
			return ret;

		case EPM_PROTOCOL_NETBIOS:
			ret = pytalloc_reference_ex(&epm_rhs_netbios_Type, mem_ctx, &in->netbios);
			return ret;

		case EPM_PROTOCOL_NETBEUI:
			ret = pytalloc_reference_ex(&epm_rhs_netbeui_Type, mem_ctx, &in->netbeui);
			return ret;

		case EPM_PROTOCOL_SPX:
			ret = pytalloc_reference_ex(&epm_rhs_spx_Type, mem_ctx, &in->spx);
			return ret;

		case EPM_PROTOCOL_NB_IPX:
			ret = pytalloc_reference_ex(&epm_rhs_nb_ipx_Type, mem_ctx, &in->nb_ipx);
			return ret;

		case EPM_PROTOCOL_DSP:
			ret = pytalloc_reference_ex(&epm_rhs_atalk_stream_Type, mem_ctx, &in->atalk_stream);
			return ret;

		case EPM_PROTOCOL_DDP:
			ret = pytalloc_reference_ex(&epm_rhs_atalk_datagram_Type, mem_ctx, &in->atalk_datagram);
			return ret;

		case EPM_PROTOCOL_APPLETALK:
			ret = pytalloc_reference_ex(&epm_rhs_appletalk_Type, mem_ctx, &in->appletalk);
			return ret;

		case EPM_PROTOCOL_VINES_SPP:
			ret = pytalloc_reference_ex(&epm_rhs_vines_spp_Type, mem_ctx, &in->vines_spp);
			return ret;

		case EPM_PROTOCOL_VINES_IPC:
			ret = pytalloc_reference_ex(&epm_rhs_vines_ipc_Type, mem_ctx, &in->vines_ipc);
			return ret;

		case EPM_PROTOCOL_STREETTALK:
			ret = pytalloc_reference_ex(&epm_rhs_streettalk_Type, mem_ctx, &in->streettalk);
			return ret;

		case EPM_PROTOCOL_HTTP:
			ret = pytalloc_reference_ex(&epm_rhs_http_Type, mem_ctx, &in->http);
			return ret;

		case EPM_PROTOCOL_UNIX_DS:
			ret = pytalloc_reference_ex(&epm_rhs_unix_ds_Type, mem_ctx, &in->unix_ds);
			return ret;

		case EPM_PROTOCOL_NULL:
			ret = pytalloc_reference_ex(&epm_rhs_null_Type, mem_ctx, &in->null);
			return ret;

		default:
			ret = PyBytes_FromStringAndSize((char *)(in->unknown).data, (in->unknown).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union epm_rhs *py_export_epm_rhs(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union epm_rhs *ret = talloc_zero(mem_ctx, union epm_rhs);
	switch (level) {
		case EPM_PROTOCOL_DNET_NSP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dnet_nsp");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_dnet_nsp_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dnet_nsp = *(struct epm_rhs_dnet_nsp *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_OSI_TP4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->osi_tp4");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_osi_tp4_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->osi_tp4 = *(struct epm_rhs_osi_tp4 *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_OSI_CLNS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->osi_clns");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_osi_clns_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->osi_clns = *(struct epm_rhs_osi_clns *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_TCP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->tcp");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_tcp_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->tcp = *(struct epm_rhs_tcp *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_UDP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->udp");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_udp_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->udp = *(struct epm_rhs_udp *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_IP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ip");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_ip_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ip = *(struct epm_rhs_ip *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_NCADG:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ncadg");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_ncadg_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ncadg = *(struct epm_rhs_ncadg *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_NCACN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ncacn");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_ncacn_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ncacn = *(struct epm_rhs_ncacn *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_NCALRPC:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ncalrpc");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_ncalrpc_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ncalrpc = *(struct epm_rhs_ncalrpc *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_UUID:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->uuid");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_uuid_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->uuid = *(struct epm_rhs_uuid *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_IPX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ipx");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_ipx_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ipx = *(struct epm_rhs_ipx *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_SMB:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->smb");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_smb_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->smb = *(struct epm_rhs_smb *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_NAMED_PIPE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->named_pipe");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_named_pipe_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->named_pipe = *(struct epm_rhs_named_pipe *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_NETBIOS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->netbios");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_netbios_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->netbios = *(struct epm_rhs_netbios *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_NETBEUI:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->netbeui");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_netbeui_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->netbeui = *(struct epm_rhs_netbeui *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_SPX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->spx");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_spx_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->spx = *(struct epm_rhs_spx *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_NB_IPX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->nb_ipx");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_nb_ipx_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->nb_ipx = *(struct epm_rhs_nb_ipx *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_DSP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->atalk_stream");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_atalk_stream_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->atalk_stream = *(struct epm_rhs_atalk_stream *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_DDP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->atalk_datagram");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_atalk_datagram_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->atalk_datagram = *(struct epm_rhs_atalk_datagram *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_APPLETALK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->appletalk");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_appletalk_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->appletalk = *(struct epm_rhs_appletalk *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_VINES_SPP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->vines_spp");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_vines_spp_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->vines_spp = *(struct epm_rhs_vines_spp *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_VINES_IPC:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->vines_ipc");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_vines_ipc_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->vines_ipc = *(struct epm_rhs_vines_ipc *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_STREETTALK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->streettalk");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_streettalk_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->streettalk = *(struct epm_rhs_streettalk *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_HTTP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->http");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_http_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->http = *(struct epm_rhs_http *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_UNIX_DS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->unix_ds");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_unix_ds_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->unix_ds = *(struct epm_rhs_unix_ds *)pytalloc_get_ptr(in);
			break;

		case EPM_PROTOCOL_NULL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->null");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&epm_rhs_null_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->null = *(struct epm_rhs_null *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->unknown");
				talloc_free(ret); return NULL;
			}
			ret->unknown = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

	}

	return ret;
}

static PyObject *py_epm_rhs_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union epm_rhs *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union epm_rhs *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union epm_rhs!");
		return NULL;
	}

	return py_import_epm_rhs(mem_ctx, level, in);
}

static PyObject *py_epm_rhs_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union epm_rhs *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_epm_rhs(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_epm_rhs_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_rhs_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_rhs_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_epm_rhs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject epm_rhs_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_rhs",
	.tp_getset = NULL,
	.tp_methods = py_epm_rhs_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_rhs_new,
};


static PyObject *py_epm_lhs_get_protocol(PyObject *obj, void *closure)
{
	struct epm_lhs *object = pytalloc_get_ptr(obj);
	PyObject *py_protocol;
	py_protocol = PyLong_FromLong((uint16_t)(object->protocol));
	return py_protocol;
}

static int py_epm_lhs_set_protocol(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_lhs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->protocol");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->protocol));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->protocol = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_lhs_get_lhs_data(PyObject *obj, void *closure)
{
	struct epm_lhs *object = pytalloc_get_ptr(obj);
	PyObject *py_lhs_data;
	py_lhs_data = PyBytes_FromStringAndSize((char *)(object->lhs_data).data, (object->lhs_data).length);
	return py_lhs_data;
}

static int py_epm_lhs_set_lhs_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_lhs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lhs_data");
		return -1;
	}
	object->lhs_data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_epm_lhs_getsetters[] = {
	{
		.name = discard_const_p(char, "protocol"),
		.get = py_epm_lhs_get_protocol,
		.set = py_epm_lhs_set_protocol,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_protocol")
	},
	{
		.name = discard_const_p(char, "lhs_data"),
		.get = py_epm_lhs_get_lhs_data,
		.set = py_epm_lhs_set_lhs_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_epm_lhs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_lhs, type);
}


static PyTypeObject epm_lhs_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_lhs",
	.tp_getset = py_epm_lhs_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_lhs_new,
};


static PyObject *py_epm_floor_get_lhs(PyObject *obj, void *closure)
{
	struct epm_floor *object = pytalloc_get_ptr(obj);
	PyObject *py_lhs;
	py_lhs = pytalloc_reference_ex(&epm_lhs_Type, pytalloc_get_mem_ctx(obj), &object->lhs);
	return py_lhs;
}

static int py_epm_floor_set_lhs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_floor *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lhs");
		return -1;
	}
	PY_CHECK_TYPE(&epm_lhs_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lhs = *(struct epm_lhs *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_floor_get_rhs(PyObject *obj, void *closure)
{
	struct epm_floor *object = pytalloc_get_ptr(obj);
	PyObject *py_rhs;
	py_rhs = pyrpc_import_union(&epm_rhs_Type, pytalloc_get_mem_ctx(obj), object->lhs.protocol, &object->rhs, "union epm_rhs");
	if (py_rhs == NULL) {
		return NULL;
	}
	return py_rhs;
}

static int py_epm_floor_set_rhs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_floor *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rhs");
		return -1;
	}
	{
		union epm_rhs *rhs_switch_1;
		rhs_switch_1 = (union epm_rhs *)pyrpc_export_union(&epm_rhs_Type, pytalloc_get_mem_ctx(py_obj), object->lhs.protocol, value, "union epm_rhs");
		if (rhs_switch_1 == NULL) {
			return -1;
		}
		object->rhs = *rhs_switch_1;
	}
	return 0;
}

static PyGetSetDef py_epm_floor_getsetters[] = {
	{
		.name = discard_const_p(char, "lhs"),
		.get = py_epm_floor_get_lhs,
		.set = py_epm_floor_set_lhs,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_lhs")
	},
	{
		.name = discard_const_p(char, "rhs"),
		.get = py_epm_floor_get_rhs,
		.set = py_epm_floor_set_rhs,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_rhs")
	},
	{ .name = NULL }
};

static PyObject *py_epm_floor_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_floor, type);
}


static PyTypeObject epm_floor_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_floor",
	.tp_getset = py_epm_floor_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_floor_new,
};


static PyObject *py_epm_tower_get_num_floors(PyObject *obj, void *closure)
{
	struct epm_tower *object = pytalloc_get_ptr(obj);
	PyObject *py_num_floors;
	py_num_floors = PyLong_FromLong((uint16_t)(object->num_floors));
	return py_num_floors;
}

static int py_epm_tower_set_num_floors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_tower *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_floors");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_floors));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_floors = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_tower_get_floors(PyObject *obj, void *closure)
{
	struct epm_tower *object = pytalloc_get_ptr(obj);
	PyObject *py_floors;
	py_floors = PyList_New(object->num_floors);
	if (py_floors == NULL) {
		return NULL;
	}
	{
		int floors_cntr_0;
		for (floors_cntr_0 = 0; floors_cntr_0 < (object->num_floors); floors_cntr_0++) {
			PyObject *py_floors_0;
			py_floors_0 = pytalloc_reference_ex(&epm_floor_Type, object->floors, &(object->floors)[floors_cntr_0]);
			PyList_SetItem(py_floors, floors_cntr_0, py_floors_0);
		}
	}
	return py_floors;
}

static int py_epm_tower_set_floors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_tower *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->floors");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int floors_cntr_0;
		object->floors = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->floors, PyList_GET_SIZE(value));
		if (!object->floors) { return -1; }
		talloc_set_name_const(object->floors, "ARRAY: object->floors");
		for (floors_cntr_0 = 0; floors_cntr_0 < PyList_GET_SIZE(value); floors_cntr_0++) {
			if (PyList_GET_ITEM(value, floors_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->floors)[floors_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&epm_floor_Type, PyList_GET_ITEM(value, floors_cntr_0), return -1;);
			if (talloc_reference(object->floors, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, floors_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->floors)[floors_cntr_0] = *(struct epm_floor *)pytalloc_get_ptr(PyList_GET_ITEM(value, floors_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_epm_tower_getsetters[] = {
	{
		.name = discard_const_p(char, "num_floors"),
		.get = py_epm_tower_get_num_floors,
		.set = py_epm_tower_set_num_floors,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "floors"),
		.get = py_epm_tower_get_floors,
		.set = py_epm_tower_set_floors,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_floor")
	},
	{ .name = NULL }
};

static PyObject *py_epm_tower_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_tower, type);
}


static PyTypeObject epm_tower_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_tower",
	.tp_getset = py_epm_tower_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_tower_new,
};


static PyObject *py_epm_twr_t_get_tower_length(PyObject *obj, void *closure)
{
	struct epm_twr_t *object = pytalloc_get_ptr(obj);
	PyObject *py_tower_length;
	py_tower_length = PyLong_FromUnsignedLongLong((uint32_t)(object->tower_length));
	return py_tower_length;
}

static int py_epm_twr_t_set_tower_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_twr_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tower_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tower_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tower_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_twr_t_get_tower(PyObject *obj, void *closure)
{
	struct epm_twr_t *object = pytalloc_get_ptr(obj);
	PyObject *py_tower;
	py_tower = pytalloc_reference_ex(&epm_tower_Type, pytalloc_get_mem_ctx(obj), &object->tower);
	return py_tower;
}

static int py_epm_twr_t_set_tower(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_twr_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tower");
		return -1;
	}
	PY_CHECK_TYPE(&epm_tower_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->tower = *(struct epm_tower *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_epm_twr_t_getsetters[] = {
	{
		.name = discard_const_p(char, "tower_length"),
		.get = py_epm_twr_t_get_tower_length,
		.set = py_epm_twr_t_set_tower_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "tower"),
		.get = py_epm_twr_t_get_tower,
		.set = py_epm_twr_t_set_tower,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_tower")
	},
	{ .name = NULL }
};

static PyObject *py_epm_twr_t_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_twr_t, type);
}

static PyObject *py_epm_twr_t_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct epm_twr_t *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_epm_twr_t);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_epm_twr_t_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct epm_twr_t *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_epm_twr_t);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_epm_twr_t);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_epm_twr_t_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct epm_twr_t *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_epm_twr_t, "epm_twr_t", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_epm_twr_t, "epm_twr_t", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_epm_twr_t_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_epm_twr_t_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_twr_t_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_twr_t_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject epm_twr_t_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_twr_t",
	.tp_getset = py_epm_twr_t_getsetters,
	.tp_methods = py_epm_twr_t_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_twr_t_new,
};


static PyObject *py_epm_entry_t_get_object(PyObject *obj, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->object);
	return py_object;
}

static int py_epm_entry_t_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->object = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_entry_t_get_tower(PyObject *obj, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(obj);
	PyObject *py_tower;
	if (object->tower == NULL) {
		Py_RETURN_NONE;
	}
	if (object->tower == NULL) {
		py_tower = Py_None;
		Py_INCREF(py_tower);
	} else {
		py_tower = pytalloc_reference_ex(&epm_twr_t_Type, object->tower, object->tower);
	}
	return py_tower;
}

static int py_epm_entry_t_set_tower(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->tower));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tower");
		return -1;
	}
	if (value == Py_None) {
		object->tower = NULL;
	} else {
		object->tower = NULL;
		PY_CHECK_TYPE(&epm_twr_t_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->tower = (struct epm_twr_t *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_epm_entry_t_get___annotation_offset(PyObject *obj, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(obj);
	PyObject *py___annotation_offset;
	py___annotation_offset = PyLong_FromUnsignedLongLong((uint32_t)(object->__annotation_offset));
	return py___annotation_offset;
}

static int py_epm_entry_t_set___annotation_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__annotation_offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__annotation_offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__annotation_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_entry_t_get___annotation_length(PyObject *obj, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(obj);
	PyObject *py___annotation_length;
	py___annotation_length = PyLong_FromUnsignedLongLong((uint32_t)(object->__annotation_length));
	return py___annotation_length;
}

static int py_epm_entry_t_set___annotation_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__annotation_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__annotation_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__annotation_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_entry_t_get_annotation(PyObject *obj, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(obj);
	PyObject *py_annotation;
	if (object->annotation == NULL) {
		py_annotation = Py_None;
		Py_INCREF(py_annotation);
	} else {
		py_annotation = PyUnicode_Decode(object->annotation, strlen(object->annotation), "utf-8", "ignore");
	}
	return py_annotation;
}

static int py_epm_entry_t_set_annotation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_entry_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->annotation");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->annotation = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_epm_entry_t_getsetters[] = {
	{
		.name = discard_const_p(char, "object"),
		.get = py_epm_entry_t_get_object,
		.set = py_epm_entry_t_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "tower"),
		.get = py_epm_entry_t_get_tower,
		.set = py_epm_entry_t_set_tower,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_twr_t")
	},
	{
		.name = discard_const_p(char, "__annotation_offset"),
		.get = py_epm_entry_t_get___annotation_offset,
		.set = py_epm_entry_t_set___annotation_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__annotation_length"),
		.get = py_epm_entry_t_get___annotation_length,
		.set = py_epm_entry_t_set___annotation_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "annotation"),
		.get = py_epm_entry_t_get_annotation,
		.set = py_epm_entry_t_set_annotation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_epm_entry_t_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_entry_t, type);
}


static PyTypeObject epm_entry_t_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_entry_t",
	.tp_getset = py_epm_entry_t_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_entry_t_new,
};


static PyObject *py_rpc_if_id_t_get_uuid(PyObject *obj, void *closure)
{
	struct rpc_if_id_t *object = pytalloc_get_ptr(obj);
	PyObject *py_uuid;
	py_uuid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->uuid);
	return py_uuid;
}

static int py_rpc_if_id_t_set_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct rpc_if_id_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uuid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_rpc_if_id_t_get_vers_major(PyObject *obj, void *closure)
{
	struct rpc_if_id_t *object = pytalloc_get_ptr(obj);
	PyObject *py_vers_major;
	py_vers_major = PyLong_FromLong((uint16_t)(object->vers_major));
	return py_vers_major;
}

static int py_rpc_if_id_t_set_vers_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct rpc_if_id_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->vers_major");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vers_major));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vers_major = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_rpc_if_id_t_get_vers_minor(PyObject *obj, void *closure)
{
	struct rpc_if_id_t *object = pytalloc_get_ptr(obj);
	PyObject *py_vers_minor;
	py_vers_minor = PyLong_FromLong((uint16_t)(object->vers_minor));
	return py_vers_minor;
}

static int py_rpc_if_id_t_set_vers_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct rpc_if_id_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->vers_minor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vers_minor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vers_minor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_rpc_if_id_t_getsetters[] = {
	{
		.name = discard_const_p(char, "uuid"),
		.get = py_rpc_if_id_t_get_uuid,
		.set = py_rpc_if_id_t_set_uuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "vers_major"),
		.get = py_rpc_if_id_t_get_vers_major,
		.set = py_rpc_if_id_t_set_vers_major,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "vers_minor"),
		.get = py_rpc_if_id_t_get_vers_minor,
		.set = py_rpc_if_id_t_set_vers_minor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_rpc_if_id_t_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct rpc_if_id_t, type);
}


static PyTypeObject rpc_if_id_t_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.rpc_if_id_t",
	.tp_getset = py_rpc_if_id_t_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_rpc_if_id_t_new,
};


static PyObject *py_epm_twr_p_t_get_twr(PyObject *obj, void *closure)
{
	struct epm_twr_p_t *object = pytalloc_get_ptr(obj);
	PyObject *py_twr;
	if (object->twr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->twr == NULL) {
		py_twr = Py_None;
		Py_INCREF(py_twr);
	} else {
		py_twr = pytalloc_reference_ex(&epm_twr_t_Type, object->twr, object->twr);
	}
	return py_twr;
}

static int py_epm_twr_p_t_set_twr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_twr_p_t *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->twr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->twr");
		return -1;
	}
	if (value == Py_None) {
		object->twr = NULL;
	} else {
		object->twr = NULL;
		PY_CHECK_TYPE(&epm_twr_t_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->twr = (struct epm_twr_t *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_epm_twr_p_t_getsetters[] = {
	{
		.name = discard_const_p(char, "twr"),
		.get = py_epm_twr_p_t_get_twr,
		.set = py_epm_twr_p_t_set_twr,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_twr_t")
	},
	{ .name = NULL }
};

static PyObject *py_epm_twr_p_t_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct epm_twr_p_t, type);
}


static PyTypeObject epm_twr_p_t_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_twr_p_t",
	.tp_getset = py_epm_twr_p_t_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_twr_p_t_new,
};



static PyObject *py_epm_Insert_in_get_num_ents(PyObject *obj, void *closure)
{
	struct epm_Insert *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ents;
	py_num_ents = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_ents));
	return py_num_ents;
}

static int py_epm_Insert_in_set_num_ents(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Insert *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_ents");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_ents));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_ents = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Insert_in_get_entries(PyObject *obj, void *closure)
{
	struct epm_Insert *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyList_New(object->in.num_ents);
	if (py_entries == NULL) {
		return NULL;
	}
	{
		int entries_cntr_0;
		for (entries_cntr_0 = 0; entries_cntr_0 < (object->in.num_ents); entries_cntr_0++) {
			PyObject *py_entries_0;
			py_entries_0 = pytalloc_reference_ex(&epm_entry_t_Type, object->in.entries, &(object->in.entries)[entries_cntr_0]);
			PyList_SetItem(py_entries, entries_cntr_0, py_entries_0);
		}
	}
	return py_entries;
}

static int py_epm_Insert_in_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Insert *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.entries");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int entries_cntr_0;
		object->in.entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.entries, PyList_GET_SIZE(value));
		if (!object->in.entries) { return -1; }
		talloc_set_name_const(object->in.entries, "ARRAY: object->in.entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(value); entries_cntr_0++) {
			if (PyList_GET_ITEM(value, entries_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.entries)[entries_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&epm_entry_t_Type, PyList_GET_ITEM(value, entries_cntr_0), return -1;);
			if (talloc_reference(object->in.entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.entries)[entries_cntr_0] = *(struct epm_entry_t *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_epm_Insert_in_get_replace(PyObject *obj, void *closure)
{
	struct epm_Insert *object = pytalloc_get_ptr(obj);
	PyObject *py_replace;
	py_replace = PyLong_FromUnsignedLongLong((uint32_t)(object->in.replace));
	return py_replace;
}

static int py_epm_Insert_in_set_replace(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Insert *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.replace");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.replace));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.replace = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Insert_get_result(PyObject *obj, void *closure)
{
	struct epm_Insert *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_epm_Insert_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Insert *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_Insert_getsetters[] = {
	{
		.name = discard_const_p(char, "in_num_ents"),
		.get = py_epm_Insert_in_get_num_ents,
		.set = py_epm_Insert_in_set_num_ents,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_entries"),
		.get = py_epm_Insert_in_get_entries,
		.set = py_epm_Insert_in_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_entry_t")
	},
	{
		.name = discard_const_p(char, "in_replace"),
		.get = py_epm_Insert_in_get_replace,
		.set = py_epm_Insert_in_set_replace,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_epm_Insert_get_result,
		.set = py_epm_Insert_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_epm_Insert_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct epm_Insert, type);
	return self;
}

static PyObject *py_epm_Insert_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_epm_Insert_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Insert *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Insert_ndr_pack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_epm_Insert_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_Insert_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_epm_Insert_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_Insert_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_epm_Insert_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Insert *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Insert_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_epm_Insert_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_Insert_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_Insert_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_Insert_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_Insert_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Insert *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_epmapper.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Insert_ndr_print");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_epm_Insert_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_Insert_ndr_print(py_obj, args, kwargs, "epm_Insert_in", NDR_IN);
}

static PyObject *py_epm_Insert_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_Insert_ndr_print(py_obj, args, kwargs, "epm_Insert_out", NDR_OUT);
}

static PyMethodDef py_epm_Insert_methods[] = {
	{ "opnum", (PyCFunction)py_epm_Insert_ndr_opnum, METH_NOARGS|METH_CLASS,
		"epmapper.epm_Insert.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Insert_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Insert_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Insert_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Insert_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Insert_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Insert_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject epm_Insert_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_Insert",
	.tp_getset = py_epm_Insert_getsetters,
	.tp_methods = py_epm_Insert_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_Insert_new,
};

static bool pack_py_epm_Insert_args_in(PyObject *args, PyObject *kwargs, struct epm_Insert *r)
{
	PyObject *py_entries;
	PyObject *py_replace;
	const char *kwnames[] = {
		"entries", "replace", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:epm_Insert", discard_const_p(char *, kwnames), &py_entries, &py_replace)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_entries, return false;);
	r->in.num_ents = PyList_GET_SIZE(py_entries);
	if (py_entries == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.entries");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_entries, return false;);
	{
		int entries_cntr_0;
		r->in.entries = talloc_array_ptrtype(r, r->in.entries, PyList_GET_SIZE(py_entries));
		if (!r->in.entries) { return false; }
		talloc_set_name_const(r->in.entries, "ARRAY: r->in.entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(py_entries); entries_cntr_0++) {
			if (PyList_GET_ITEM(py_entries, entries_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.entries)[entries_cntr_0]");
				return false;
			}
			PY_CHECK_TYPE(&epm_entry_t_Type, PyList_GET_ITEM(py_entries, entries_cntr_0), return false;);
			if (talloc_reference(r->in.entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_entries, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.entries)[entries_cntr_0] = *(struct epm_entry_t *)pytalloc_get_ptr(PyList_GET_ITEM(py_entries, entries_cntr_0));
		}
	}
	if (py_replace == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.replace");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.replace));
		if (PyLong_Check(py_replace)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_replace);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.replace = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_epm_Insert_args_out(struct epm_Insert *r, bool raise_result_exception)
{
	PyObject *result = NULL;

	result = PyLong_FromUnsignedLongLong((uint32_t)(r->out.result));

	return result;
}


static PyObject *py_epm_Delete_in_get_num_ents(PyObject *obj, void *closure)
{
	struct epm_Delete *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ents;
	py_num_ents = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_ents));
	return py_num_ents;
}

static int py_epm_Delete_in_set_num_ents(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Delete *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_ents");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_ents));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_ents = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Delete_in_get_entries(PyObject *obj, void *closure)
{
	struct epm_Delete *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyList_New(object->in.num_ents);
	if (py_entries == NULL) {
		return NULL;
	}
	{
		int entries_cntr_0;
		for (entries_cntr_0 = 0; entries_cntr_0 < (object->in.num_ents); entries_cntr_0++) {
			PyObject *py_entries_0;
			py_entries_0 = pytalloc_reference_ex(&epm_entry_t_Type, object->in.entries, &(object->in.entries)[entries_cntr_0]);
			PyList_SetItem(py_entries, entries_cntr_0, py_entries_0);
		}
	}
	return py_entries;
}

static int py_epm_Delete_in_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Delete *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.entries");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int entries_cntr_0;
		object->in.entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.entries, PyList_GET_SIZE(value));
		if (!object->in.entries) { return -1; }
		talloc_set_name_const(object->in.entries, "ARRAY: object->in.entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(value); entries_cntr_0++) {
			if (PyList_GET_ITEM(value, entries_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.entries)[entries_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&epm_entry_t_Type, PyList_GET_ITEM(value, entries_cntr_0), return -1;);
			if (talloc_reference(object->in.entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.entries)[entries_cntr_0] = *(struct epm_entry_t *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_epm_Delete_get_result(PyObject *obj, void *closure)
{
	struct epm_Delete *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_epm_Delete_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Delete *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_Delete_getsetters[] = {
	{
		.name = discard_const_p(char, "in_num_ents"),
		.get = py_epm_Delete_in_get_num_ents,
		.set = py_epm_Delete_in_set_num_ents,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_entries"),
		.get = py_epm_Delete_in_get_entries,
		.set = py_epm_Delete_in_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_entry_t")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_epm_Delete_get_result,
		.set = py_epm_Delete_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_epm_Delete_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct epm_Delete, type);
	return self;
}

static PyObject *py_epm_Delete_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_epm_Delete_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Delete *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Delete_ndr_pack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_epm_Delete_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_Delete_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_epm_Delete_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_Delete_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_epm_Delete_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Delete *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Delete_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_epm_Delete_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_Delete_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_Delete_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_Delete_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_Delete_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Delete *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_epmapper.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Delete_ndr_print");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_epm_Delete_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_Delete_ndr_print(py_obj, args, kwargs, "epm_Delete_in", NDR_IN);
}

static PyObject *py_epm_Delete_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_Delete_ndr_print(py_obj, args, kwargs, "epm_Delete_out", NDR_OUT);
}

static PyMethodDef py_epm_Delete_methods[] = {
	{ "opnum", (PyCFunction)py_epm_Delete_ndr_opnum, METH_NOARGS|METH_CLASS,
		"epmapper.epm_Delete.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Delete_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Delete_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Delete_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Delete_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Delete_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Delete_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject epm_Delete_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_Delete",
	.tp_getset = py_epm_Delete_getsetters,
	.tp_methods = py_epm_Delete_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_Delete_new,
};

static bool pack_py_epm_Delete_args_in(PyObject *args, PyObject *kwargs, struct epm_Delete *r)
{
	PyObject *py_entries;
	const char *kwnames[] = {
		"entries", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:epm_Delete", discard_const_p(char *, kwnames), &py_entries)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_entries, return false;);
	r->in.num_ents = PyList_GET_SIZE(py_entries);
	if (py_entries == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.entries");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_entries, return false;);
	{
		int entries_cntr_0;
		r->in.entries = talloc_array_ptrtype(r, r->in.entries, PyList_GET_SIZE(py_entries));
		if (!r->in.entries) { return false; }
		talloc_set_name_const(r->in.entries, "ARRAY: r->in.entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(py_entries); entries_cntr_0++) {
			if (PyList_GET_ITEM(py_entries, entries_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.entries)[entries_cntr_0]");
				return false;
			}
			PY_CHECK_TYPE(&epm_entry_t_Type, PyList_GET_ITEM(py_entries, entries_cntr_0), return false;);
			if (talloc_reference(r->in.entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_entries, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.entries)[entries_cntr_0] = *(struct epm_entry_t *)pytalloc_get_ptr(PyList_GET_ITEM(py_entries, entries_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_epm_Delete_args_out(struct epm_Delete *r, bool raise_result_exception)
{
	PyObject *result = NULL;

	result = PyLong_FromUnsignedLongLong((uint32_t)(r->out.result));

	return result;
}


static PyObject *py_epm_Lookup_in_get_inquiry_type(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_inquiry_type;
	py_inquiry_type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.inquiry_type));
	return py_inquiry_type;
}

static int py_epm_Lookup_in_set_inquiry_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.inquiry_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.inquiry_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.inquiry_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Lookup_in_get_object(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	if (object->in.object == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.object == NULL) {
		py_object = Py_None;
		Py_INCREF(py_object);
	} else {
		py_object = pytalloc_reference_ex(GUID_Type, object->in.object, object->in.object);
	}
	return py_object;
}

static int py_epm_Lookup_in_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.object));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.object");
		return -1;
	}
	if (value == Py_None) {
		object->in.object = NULL;
	} else {
		object->in.object = NULL;
		PY_CHECK_TYPE(GUID_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.object = (struct GUID *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_epm_Lookup_in_get_interface_id(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_interface_id;
	if (object->in.interface_id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.interface_id == NULL) {
		py_interface_id = Py_None;
		Py_INCREF(py_interface_id);
	} else {
		py_interface_id = pytalloc_reference_ex(&rpc_if_id_t_Type, object->in.interface_id, object->in.interface_id);
	}
	return py_interface_id;
}

static int py_epm_Lookup_in_set_interface_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.interface_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.interface_id");
		return -1;
	}
	if (value == Py_None) {
		object->in.interface_id = NULL;
	} else {
		object->in.interface_id = NULL;
		PY_CHECK_TYPE(&rpc_if_id_t_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.interface_id = (struct rpc_if_id_t *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_epm_Lookup_in_get_vers_option(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_vers_option;
	py_vers_option = PyLong_FromUnsignedLongLong((uint32_t)(object->in.vers_option));
	return py_vers_option;
}

static int py_epm_Lookup_in_set_vers_option(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.vers_option");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.vers_option));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.vers_option = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Lookup_in_get_entry_handle(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_entry_handle;
	if (object->in.entry_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, object->in.entry_handle, object->in.entry_handle);
	return py_entry_handle;
}

static int py_epm_Lookup_in_set_entry_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.entry_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.entry_handle");
		return -1;
	}
	object->in.entry_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.entry_handle);
	if (object->in.entry_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.entry_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_Lookup_out_get_entry_handle(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_entry_handle;
	if (object->out.entry_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, object->out.entry_handle, object->out.entry_handle);
	return py_entry_handle;
}

static int py_epm_Lookup_out_set_entry_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.entry_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.entry_handle");
		return -1;
	}
	object->out.entry_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.entry_handle);
	if (object->out.entry_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.entry_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_Lookup_in_get_max_ents(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_max_ents;
	py_max_ents = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_ents));
	return py_max_ents;
}

static int py_epm_Lookup_in_set_max_ents(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.max_ents");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_ents));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_ents = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Lookup_out_get_num_ents(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ents;
	if (object->out.num_ents == NULL) {
		Py_RETURN_NONE;
	}
	py_num_ents = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_ents));
	return py_num_ents;
}

static int py_epm_Lookup_out_set_num_ents(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_ents));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_ents");
		return -1;
	}
	object->out.num_ents = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_ents);
	if (object->out.num_ents == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_ents));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_ents = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Lookup_out_get_entries(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyList_New(*object->out.num_ents);
	if (py_entries == NULL) {
		return NULL;
	}
	{
		int entries_cntr_0;
		for (entries_cntr_0 = 0; entries_cntr_0 < (*object->out.num_ents); entries_cntr_0++) {
			PyObject *py_entries_0;
			py_entries_0 = pytalloc_reference_ex(&epm_entry_t_Type, object->out.entries, &(object->out.entries)[entries_cntr_0]);
			PyList_SetItem(py_entries, entries_cntr_0, py_entries_0);
		}
	}
	return py_entries;
}

static int py_epm_Lookup_out_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.entries");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int entries_cntr_0;
		object->out.entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.entries, PyList_GET_SIZE(value));
		if (!object->out.entries) { return -1; }
		talloc_set_name_const(object->out.entries, "ARRAY: object->out.entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(value); entries_cntr_0++) {
			if (PyList_GET_ITEM(value, entries_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.entries)[entries_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&epm_entry_t_Type, PyList_GET_ITEM(value, entries_cntr_0), return -1;);
			if (talloc_reference(object->out.entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->out.entries)[entries_cntr_0] = *(struct epm_entry_t *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_epm_Lookup_get_result(PyObject *obj, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_epm_Lookup_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_Lookup_getsetters[] = {
	{
		.name = discard_const_p(char, "in_inquiry_type"),
		.get = py_epm_Lookup_in_get_inquiry_type,
		.set = py_epm_Lookup_in_set_inquiry_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_InquiryType")
	},
	{
		.name = discard_const_p(char, "in_object"),
		.get = py_epm_Lookup_in_get_object,
		.set = py_epm_Lookup_in_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "in_interface_id"),
		.get = py_epm_Lookup_in_get_interface_id,
		.set = py_epm_Lookup_in_set_interface_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type rpc_if_id_t")
	},
	{
		.name = discard_const_p(char, "in_vers_option"),
		.get = py_epm_Lookup_in_get_vers_option,
		.set = py_epm_Lookup_in_set_vers_option,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_VersionOption")
	},
	{
		.name = discard_const_p(char, "in_entry_handle"),
		.get = py_epm_Lookup_in_get_entry_handle,
		.set = py_epm_Lookup_in_set_entry_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_entry_handle"),
		.get = py_epm_Lookup_out_get_entry_handle,
		.set = py_epm_Lookup_out_set_entry_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_max_ents"),
		.get = py_epm_Lookup_in_get_max_ents,
		.set = py_epm_Lookup_in_set_max_ents,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_ents"),
		.get = py_epm_Lookup_out_get_num_ents,
		.set = py_epm_Lookup_out_set_num_ents,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_entries"),
		.get = py_epm_Lookup_out_get_entries,
		.set = py_epm_Lookup_out_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_entry_t")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_epm_Lookup_get_result,
		.set = py_epm_Lookup_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_epm_Lookup_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct epm_Lookup, type);
	struct epm_Lookup *_self = (struct epm_Lookup *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.entry_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.entry_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.num_ents = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_epm_Lookup_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_epm_Lookup_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Lookup_ndr_pack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_epm_Lookup_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_Lookup_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_epm_Lookup_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_Lookup_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_epm_Lookup_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Lookup_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_epm_Lookup_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_Lookup_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_Lookup_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_Lookup_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_Lookup_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Lookup *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_epmapper.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Lookup_ndr_print");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_epm_Lookup_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_Lookup_ndr_print(py_obj, args, kwargs, "epm_Lookup_in", NDR_IN);
}

static PyObject *py_epm_Lookup_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_Lookup_ndr_print(py_obj, args, kwargs, "epm_Lookup_out", NDR_OUT);
}

static PyMethodDef py_epm_Lookup_methods[] = {
	{ "opnum", (PyCFunction)py_epm_Lookup_ndr_opnum, METH_NOARGS|METH_CLASS,
		"epmapper.epm_Lookup.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Lookup_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Lookup_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Lookup_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Lookup_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Lookup_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Lookup_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject epm_Lookup_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_Lookup",
	.tp_getset = py_epm_Lookup_getsetters,
	.tp_methods = py_epm_Lookup_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_Lookup_new,
};

static bool pack_py_epm_Lookup_args_in(PyObject *args, PyObject *kwargs, struct epm_Lookup *r)
{
	PyObject *py_inquiry_type;
	PyObject *py_object;
	PyObject *py_interface_id;
	PyObject *py_vers_option;
	PyObject *py_entry_handle;
	PyObject *py_max_ents;
	const char *kwnames[] = {
		"inquiry_type", "object", "interface_id", "vers_option", "entry_handle", "max_ents", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:epm_Lookup", discard_const_p(char *, kwnames), &py_inquiry_type, &py_object, &py_interface_id, &py_vers_option, &py_entry_handle, &py_max_ents)) {
		return false;
	}

	if (py_inquiry_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.inquiry_type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.inquiry_type));
		if (PyLong_Check(py_inquiry_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_inquiry_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.inquiry_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_object == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.object");
		return false;
	}
	if (py_object == Py_None) {
		r->in.object = NULL;
	} else {
		r->in.object = NULL;
		PY_CHECK_TYPE(GUID_Type, py_object, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_object)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.object = (struct GUID *)pytalloc_get_ptr(py_object);
	}
	if (py_interface_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.interface_id");
		return false;
	}
	if (py_interface_id == Py_None) {
		r->in.interface_id = NULL;
	} else {
		r->in.interface_id = NULL;
		PY_CHECK_TYPE(&rpc_if_id_t_Type, py_interface_id, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_interface_id)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.interface_id = (struct rpc_if_id_t *)pytalloc_get_ptr(py_interface_id);
	}
	if (py_vers_option == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.vers_option");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.vers_option));
		if (PyLong_Check(py_vers_option)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_vers_option);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.vers_option = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_entry_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.entry_handle");
		return false;
	}
	r->in.entry_handle = talloc_ptrtype(r, r->in.entry_handle);
	if (r->in.entry_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_entry_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_entry_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.entry_handle = (struct policy_handle *)pytalloc_get_ptr(py_entry_handle);
	if (py_max_ents == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.max_ents");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_ents));
		if (PyLong_Check(py_max_ents)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_ents);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_ents = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_epm_Lookup_args_out(struct epm_Lookup *r, bool raise_result_exception)
{
	PyObject *py_entry_handle = NULL;
	PyObject *py_entries = NULL;
	PyObject *result = NULL;

	result = PyTuple_New(3);
	if (result == NULL) {
		return NULL;
	}

	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, r->out.entry_handle, r->out.entry_handle);
	PyTuple_SetItem(result, 0, py_entry_handle);

	py_entries = PyList_New(*r->out.num_ents);
	if (py_entries == NULL) {
		return NULL;
	}
	{
		int entries_cntr_0;
		for (entries_cntr_0 = 0; entries_cntr_0 < (*r->out.num_ents); entries_cntr_0++) {
			PyObject *py_entries_0;
			py_entries_0 = pytalloc_reference_ex(&epm_entry_t_Type, r->out.entries, &(r->out.entries)[entries_cntr_0]);
			PyList_SetItem(py_entries, entries_cntr_0, py_entries_0);
		}
	}
	PyTuple_SetItem(result, 1, py_entries);

	PyTuple_SetItem(result, 2, PyLong_FromUnsignedLongLong((uint32_t)(r->out.result)));

	return result;
}


static PyObject *py_epm_Map_in_get_object(PyObject *obj, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	if (object->in.object == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.object == NULL) {
		py_object = Py_None;
		Py_INCREF(py_object);
	} else {
		py_object = pytalloc_reference_ex(GUID_Type, object->in.object, object->in.object);
	}
	return py_object;
}

static int py_epm_Map_in_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.object));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.object");
		return -1;
	}
	if (value == Py_None) {
		object->in.object = NULL;
	} else {
		object->in.object = NULL;
		PY_CHECK_TYPE(GUID_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.object = (struct GUID *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_epm_Map_in_get_map_tower(PyObject *obj, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(obj);
	PyObject *py_map_tower;
	if (object->in.map_tower == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.map_tower == NULL) {
		py_map_tower = Py_None;
		Py_INCREF(py_map_tower);
	} else {
		py_map_tower = pytalloc_reference_ex(&epm_twr_t_Type, object->in.map_tower, object->in.map_tower);
	}
	return py_map_tower;
}

static int py_epm_Map_in_set_map_tower(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.map_tower));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.map_tower");
		return -1;
	}
	if (value == Py_None) {
		object->in.map_tower = NULL;
	} else {
		object->in.map_tower = NULL;
		PY_CHECK_TYPE(&epm_twr_t_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.map_tower = (struct epm_twr_t *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_epm_Map_in_get_entry_handle(PyObject *obj, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(obj);
	PyObject *py_entry_handle;
	if (object->in.entry_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, object->in.entry_handle, object->in.entry_handle);
	return py_entry_handle;
}

static int py_epm_Map_in_set_entry_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.entry_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.entry_handle");
		return -1;
	}
	object->in.entry_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.entry_handle);
	if (object->in.entry_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.entry_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_Map_out_get_entry_handle(PyObject *obj, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(obj);
	PyObject *py_entry_handle;
	if (object->out.entry_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, object->out.entry_handle, object->out.entry_handle);
	return py_entry_handle;
}

static int py_epm_Map_out_set_entry_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.entry_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.entry_handle");
		return -1;
	}
	object->out.entry_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.entry_handle);
	if (object->out.entry_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.entry_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_Map_in_get_max_towers(PyObject *obj, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(obj);
	PyObject *py_max_towers;
	py_max_towers = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_towers));
	return py_max_towers;
}

static int py_epm_Map_in_set_max_towers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.max_towers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_towers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_towers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Map_out_get_num_towers(PyObject *obj, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(obj);
	PyObject *py_num_towers;
	if (object->out.num_towers == NULL) {
		Py_RETURN_NONE;
	}
	py_num_towers = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_towers));
	return py_num_towers;
}

static int py_epm_Map_out_set_num_towers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_towers));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_towers");
		return -1;
	}
	object->out.num_towers = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_towers);
	if (object->out.num_towers == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_towers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_towers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_Map_out_get_towers(PyObject *obj, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(obj);
	PyObject *py_towers;
	py_towers = PyList_New(*object->out.num_towers);
	if (py_towers == NULL) {
		return NULL;
	}
	{
		int towers_cntr_0;
		for (towers_cntr_0 = 0; towers_cntr_0 < (*object->out.num_towers); towers_cntr_0++) {
			PyObject *py_towers_0;
			py_towers_0 = pytalloc_reference_ex(&epm_twr_p_t_Type, object->out.towers, &(object->out.towers)[towers_cntr_0]);
			PyList_SetItem(py_towers, towers_cntr_0, py_towers_0);
		}
	}
	return py_towers;
}

static int py_epm_Map_out_set_towers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.towers");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int towers_cntr_0;
		object->out.towers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.towers, PyList_GET_SIZE(value));
		if (!object->out.towers) { return -1; }
		talloc_set_name_const(object->out.towers, "ARRAY: object->out.towers");
		for (towers_cntr_0 = 0; towers_cntr_0 < PyList_GET_SIZE(value); towers_cntr_0++) {
			if (PyList_GET_ITEM(value, towers_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.towers)[towers_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&epm_twr_p_t_Type, PyList_GET_ITEM(value, towers_cntr_0), return -1;);
			if (talloc_reference(object->out.towers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, towers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->out.towers)[towers_cntr_0] = *(struct epm_twr_p_t *)pytalloc_get_ptr(PyList_GET_ITEM(value, towers_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_epm_Map_get_result(PyObject *obj, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_epm_Map_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_Map_getsetters[] = {
	{
		.name = discard_const_p(char, "in_object"),
		.get = py_epm_Map_in_get_object,
		.set = py_epm_Map_in_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "in_map_tower"),
		.get = py_epm_Map_in_get_map_tower,
		.set = py_epm_Map_in_set_map_tower,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_twr_t")
	},
	{
		.name = discard_const_p(char, "in_entry_handle"),
		.get = py_epm_Map_in_get_entry_handle,
		.set = py_epm_Map_in_set_entry_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_entry_handle"),
		.get = py_epm_Map_out_get_entry_handle,
		.set = py_epm_Map_out_set_entry_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_max_towers"),
		.get = py_epm_Map_in_get_max_towers,
		.set = py_epm_Map_in_set_max_towers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_towers"),
		.get = py_epm_Map_out_get_num_towers,
		.set = py_epm_Map_out_set_num_towers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_towers"),
		.get = py_epm_Map_out_get_towers,
		.set = py_epm_Map_out_set_towers,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_twr_p_t")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_epm_Map_get_result,
		.set = py_epm_Map_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_epm_Map_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct epm_Map, type);
	struct epm_Map *_self = (struct epm_Map *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.entry_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.entry_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.num_towers = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_epm_Map_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_epm_Map_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Map_ndr_pack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_epm_Map_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_Map_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_epm_Map_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_Map_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_epm_Map_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Map_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_epm_Map_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_Map_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_Map_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_Map_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_Map_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_Map *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_epmapper.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_Map_ndr_print");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_epm_Map_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_Map_ndr_print(py_obj, args, kwargs, "epm_Map_in", NDR_IN);
}

static PyObject *py_epm_Map_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_Map_ndr_print(py_obj, args, kwargs, "epm_Map_out", NDR_OUT);
}

static PyMethodDef py_epm_Map_methods[] = {
	{ "opnum", (PyCFunction)py_epm_Map_ndr_opnum, METH_NOARGS|METH_CLASS,
		"epmapper.epm_Map.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Map_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Map_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Map_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Map_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Map_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_Map_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject epm_Map_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_Map",
	.tp_getset = py_epm_Map_getsetters,
	.tp_methods = py_epm_Map_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_Map_new,
};

static bool pack_py_epm_Map_args_in(PyObject *args, PyObject *kwargs, struct epm_Map *r)
{
	PyObject *py_object;
	PyObject *py_map_tower;
	PyObject *py_entry_handle;
	PyObject *py_max_towers;
	const char *kwnames[] = {
		"object", "map_tower", "entry_handle", "max_towers", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:epm_Map", discard_const_p(char *, kwnames), &py_object, &py_map_tower, &py_entry_handle, &py_max_towers)) {
		return false;
	}

	if (py_object == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.object");
		return false;
	}
	if (py_object == Py_None) {
		r->in.object = NULL;
	} else {
		r->in.object = NULL;
		PY_CHECK_TYPE(GUID_Type, py_object, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_object)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.object = (struct GUID *)pytalloc_get_ptr(py_object);
	}
	if (py_map_tower == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.map_tower");
		return false;
	}
	if (py_map_tower == Py_None) {
		r->in.map_tower = NULL;
	} else {
		r->in.map_tower = NULL;
		PY_CHECK_TYPE(&epm_twr_t_Type, py_map_tower, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_map_tower)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.map_tower = (struct epm_twr_t *)pytalloc_get_ptr(py_map_tower);
	}
	if (py_entry_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.entry_handle");
		return false;
	}
	r->in.entry_handle = talloc_ptrtype(r, r->in.entry_handle);
	if (r->in.entry_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_entry_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_entry_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.entry_handle = (struct policy_handle *)pytalloc_get_ptr(py_entry_handle);
	if (py_max_towers == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.max_towers");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_towers));
		if (PyLong_Check(py_max_towers)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_towers);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_towers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_epm_Map_args_out(struct epm_Map *r, bool raise_result_exception)
{
	PyObject *py_entry_handle = NULL;
	PyObject *py_towers = NULL;
	PyObject *result = NULL;

	result = PyTuple_New(3);
	if (result == NULL) {
		return NULL;
	}

	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, r->out.entry_handle, r->out.entry_handle);
	PyTuple_SetItem(result, 0, py_entry_handle);

	py_towers = PyList_New(*r->out.num_towers);
	if (py_towers == NULL) {
		return NULL;
	}
	{
		int towers_cntr_0;
		for (towers_cntr_0 = 0; towers_cntr_0 < (*r->out.num_towers); towers_cntr_0++) {
			PyObject *py_towers_0;
			py_towers_0 = pytalloc_reference_ex(&epm_twr_p_t_Type, r->out.towers, &(r->out.towers)[towers_cntr_0]);
			PyList_SetItem(py_towers, towers_cntr_0, py_towers_0);
		}
	}
	PyTuple_SetItem(result, 1, py_towers);

	PyTuple_SetItem(result, 2, PyLong_FromUnsignedLongLong((uint32_t)(r->out.result)));

	return result;
}


static PyObject *py_epm_LookupHandleFree_in_get_entry_handle(PyObject *obj, void *closure)
{
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(obj);
	PyObject *py_entry_handle;
	if (object->in.entry_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, object->in.entry_handle, object->in.entry_handle);
	return py_entry_handle;
}

static int py_epm_LookupHandleFree_in_set_entry_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.entry_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.entry_handle");
		return -1;
	}
	object->in.entry_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.entry_handle);
	if (object->in.entry_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.entry_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_LookupHandleFree_out_get_entry_handle(PyObject *obj, void *closure)
{
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(obj);
	PyObject *py_entry_handle;
	if (object->out.entry_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, object->out.entry_handle, object->out.entry_handle);
	return py_entry_handle;
}

static int py_epm_LookupHandleFree_out_set_entry_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.entry_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.entry_handle");
		return -1;
	}
	object->out.entry_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.entry_handle);
	if (object->out.entry_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.entry_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_LookupHandleFree_get_result(PyObject *obj, void *closure)
{
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_epm_LookupHandleFree_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_LookupHandleFree_getsetters[] = {
	{
		.name = discard_const_p(char, "in_entry_handle"),
		.get = py_epm_LookupHandleFree_in_get_entry_handle,
		.set = py_epm_LookupHandleFree_in_set_entry_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_entry_handle"),
		.get = py_epm_LookupHandleFree_out_get_entry_handle,
		.set = py_epm_LookupHandleFree_out_set_entry_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_epm_LookupHandleFree_get_result,
		.set = py_epm_LookupHandleFree_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_epm_LookupHandleFree_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct epm_LookupHandleFree, type);
	struct epm_LookupHandleFree *_self = (struct epm_LookupHandleFree *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.entry_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.entry_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_epm_LookupHandleFree_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_epm_LookupHandleFree_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_LookupHandleFree_ndr_pack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_epm_LookupHandleFree_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_LookupHandleFree_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_epm_LookupHandleFree_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_LookupHandleFree_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_epm_LookupHandleFree_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_LookupHandleFree_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_epm_LookupHandleFree_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_LookupHandleFree_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_LookupHandleFree_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_LookupHandleFree_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_LookupHandleFree_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_LookupHandleFree *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_epmapper.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_LookupHandleFree_ndr_print");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[4];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_epm_LookupHandleFree_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_LookupHandleFree_ndr_print(py_obj, args, kwargs, "epm_LookupHandleFree_in", NDR_IN);
}

static PyObject *py_epm_LookupHandleFree_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_LookupHandleFree_ndr_print(py_obj, args, kwargs, "epm_LookupHandleFree_out", NDR_OUT);
}

static PyMethodDef py_epm_LookupHandleFree_methods[] = {
	{ "opnum", (PyCFunction)py_epm_LookupHandleFree_ndr_opnum, METH_NOARGS|METH_CLASS,
		"epmapper.epm_LookupHandleFree.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_LookupHandleFree_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_LookupHandleFree_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_LookupHandleFree_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_LookupHandleFree_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_LookupHandleFree_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_LookupHandleFree_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject epm_LookupHandleFree_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_LookupHandleFree",
	.tp_getset = py_epm_LookupHandleFree_getsetters,
	.tp_methods = py_epm_LookupHandleFree_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_LookupHandleFree_new,
};

static bool pack_py_epm_LookupHandleFree_args_in(PyObject *args, PyObject *kwargs, struct epm_LookupHandleFree *r)
{
	PyObject *py_entry_handle;
	const char *kwnames[] = {
		"entry_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:epm_LookupHandleFree", discard_const_p(char *, kwnames), &py_entry_handle)) {
		return false;
	}

	if (py_entry_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.entry_handle");
		return false;
	}
	r->in.entry_handle = talloc_ptrtype(r, r->in.entry_handle);
	if (r->in.entry_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_entry_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_entry_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.entry_handle = (struct policy_handle *)pytalloc_get_ptr(py_entry_handle);
	return true;
}

static PyObject *unpack_py_epm_LookupHandleFree_args_out(struct epm_LookupHandleFree *r, bool raise_result_exception)
{
	PyObject *py_entry_handle = NULL;
	PyObject *result = NULL;

	result = PyTuple_New(2);
	if (result == NULL) {
		return NULL;
	}

	py_entry_handle = pytalloc_reference_ex(policy_handle_Type, r->out.entry_handle, r->out.entry_handle);
	PyTuple_SetItem(result, 0, py_entry_handle);

	PyTuple_SetItem(result, 1, PyLong_FromUnsignedLongLong((uint32_t)(r->out.result)));

	return result;
}


static PyObject *py_epm_InqObject_in_get_epm_object(PyObject *obj, void *closure)
{
	struct epm_InqObject *object = pytalloc_get_ptr(obj);
	PyObject *py_epm_object;
	if (object->in.epm_object == NULL) {
		Py_RETURN_NONE;
	}
	py_epm_object = pytalloc_reference_ex(GUID_Type, object->in.epm_object, object->in.epm_object);
	return py_epm_object;
}

static int py_epm_InqObject_in_set_epm_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_InqObject *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.epm_object));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.epm_object");
		return -1;
	}
	object->in.epm_object = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.epm_object);
	if (object->in.epm_object == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.epm_object = (struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_epm_InqObject_get_result(PyObject *obj, void *closure)
{
	struct epm_InqObject *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_epm_InqObject_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_InqObject *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_InqObject_getsetters[] = {
	{
		.name = discard_const_p(char, "in_epm_object"),
		.get = py_epm_InqObject_in_get_epm_object,
		.set = py_epm_InqObject_in_set_epm_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_epm_InqObject_get_result,
		.set = py_epm_InqObject_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_epm_InqObject_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct epm_InqObject, type);
	struct epm_InqObject *_self = (struct epm_InqObject *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.epm_object = talloc_zero(mem_ctx, struct GUID);
	return self;
}

static PyObject *py_epm_InqObject_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_epm_InqObject_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_InqObject *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_InqObject_ndr_pack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_epm_InqObject_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_InqObject_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_epm_InqObject_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_InqObject_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_epm_InqObject_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_InqObject *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_InqObject_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_epm_InqObject_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_InqObject_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_InqObject_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_InqObject_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_InqObject_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_InqObject *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_epmapper.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_InqObject_ndr_print");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[5];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_epm_InqObject_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_InqObject_ndr_print(py_obj, args, kwargs, "epm_InqObject_in", NDR_IN);
}

static PyObject *py_epm_InqObject_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_InqObject_ndr_print(py_obj, args, kwargs, "epm_InqObject_out", NDR_OUT);
}

static PyMethodDef py_epm_InqObject_methods[] = {
	{ "opnum", (PyCFunction)py_epm_InqObject_ndr_opnum, METH_NOARGS|METH_CLASS,
		"epmapper.epm_InqObject.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_InqObject_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_InqObject_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_InqObject_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_InqObject_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_InqObject_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_InqObject_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject epm_InqObject_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_InqObject",
	.tp_getset = py_epm_InqObject_getsetters,
	.tp_methods = py_epm_InqObject_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_InqObject_new,
};

static bool pack_py_epm_InqObject_args_in(PyObject *args, PyObject *kwargs, struct epm_InqObject *r)
{
	PyObject *py_epm_object;
	const char *kwnames[] = {
		"epm_object", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:epm_InqObject", discard_const_p(char *, kwnames), &py_epm_object)) {
		return false;
	}

	if (py_epm_object == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.epm_object");
		return false;
	}
	r->in.epm_object = talloc_ptrtype(r, r->in.epm_object);
	if (r->in.epm_object == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(GUID_Type, py_epm_object, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_epm_object)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.epm_object = (struct GUID *)pytalloc_get_ptr(py_epm_object);
	return true;
}

static PyObject *unpack_py_epm_InqObject_args_out(struct epm_InqObject *r, bool raise_result_exception)
{
	PyObject *result = NULL;

	result = PyLong_FromUnsignedLongLong((uint32_t)(r->out.result));

	return result;
}


static PyObject *py_epm_MgmtDelete_in_get_object_speced(PyObject *obj, void *closure)
{
	struct epm_MgmtDelete *object = pytalloc_get_ptr(obj);
	PyObject *py_object_speced;
	py_object_speced = PyLong_FromUnsignedLongLong((uint32_t)(object->in.object_speced));
	return py_object_speced;
}

static int py_epm_MgmtDelete_in_set_object_speced(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_MgmtDelete *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.object_speced");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.object_speced));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.object_speced = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_epm_MgmtDelete_in_get_object(PyObject *obj, void *closure)
{
	struct epm_MgmtDelete *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	if (object->in.object == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.object == NULL) {
		py_object = Py_None;
		Py_INCREF(py_object);
	} else {
		py_object = pytalloc_reference_ex(GUID_Type, object->in.object, object->in.object);
	}
	return py_object;
}

static int py_epm_MgmtDelete_in_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_MgmtDelete *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.object));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.object");
		return -1;
	}
	if (value == Py_None) {
		object->in.object = NULL;
	} else {
		object->in.object = NULL;
		PY_CHECK_TYPE(GUID_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.object = (struct GUID *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_epm_MgmtDelete_in_get_tower(PyObject *obj, void *closure)
{
	struct epm_MgmtDelete *object = pytalloc_get_ptr(obj);
	PyObject *py_tower;
	if (object->in.tower == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.tower == NULL) {
		py_tower = Py_None;
		Py_INCREF(py_tower);
	} else {
		py_tower = pytalloc_reference_ex(&epm_twr_t_Type, object->in.tower, object->in.tower);
	}
	return py_tower;
}

static int py_epm_MgmtDelete_in_set_tower(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_MgmtDelete *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.tower));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.tower");
		return -1;
	}
	if (value == Py_None) {
		object->in.tower = NULL;
	} else {
		object->in.tower = NULL;
		PY_CHECK_TYPE(&epm_twr_t_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.tower = (struct epm_twr_t *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_epm_MgmtDelete_get_result(PyObject *obj, void *closure)
{
	struct epm_MgmtDelete *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_epm_MgmtDelete_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct epm_MgmtDelete *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_epm_MgmtDelete_getsetters[] = {
	{
		.name = discard_const_p(char, "in_object_speced"),
		.get = py_epm_MgmtDelete_in_get_object_speced,
		.set = py_epm_MgmtDelete_in_set_object_speced,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_object"),
		.get = py_epm_MgmtDelete_in_get_object,
		.set = py_epm_MgmtDelete_in_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "in_tower"),
		.get = py_epm_MgmtDelete_in_get_tower,
		.set = py_epm_MgmtDelete_in_set_tower,
		.doc = discard_const_p(char, "PIDL-generated element of base type epm_twr_t")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_epm_MgmtDelete_get_result,
		.set = py_epm_MgmtDelete_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_epm_MgmtDelete_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct epm_MgmtDelete, type);
	return self;
}

static PyObject *py_epm_MgmtDelete_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_epm_MgmtDelete_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_MgmtDelete *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_MgmtDelete_ndr_pack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_epm_MgmtDelete_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_MgmtDelete_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_epm_MgmtDelete_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_epm_MgmtDelete_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_epm_MgmtDelete_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_MgmtDelete *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_epmapper.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_MgmtDelete_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_epm_MgmtDelete_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_MgmtDelete_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_MgmtDelete_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_epm_MgmtDelete_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_epm_MgmtDelete_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct epm_MgmtDelete *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_epmapper.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_epm_MgmtDelete_ndr_print");
		return NULL;
	}
	call = &ndr_table_epmapper.calls[6];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_epm_MgmtDelete_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_MgmtDelete_ndr_print(py_obj, args, kwargs, "epm_MgmtDelete_in", NDR_IN);
}

static PyObject *py_epm_MgmtDelete_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_epm_MgmtDelete_ndr_print(py_obj, args, kwargs, "epm_MgmtDelete_out", NDR_OUT);
}

static PyMethodDef py_epm_MgmtDelete_methods[] = {
	{ "opnum", (PyCFunction)py_epm_MgmtDelete_ndr_opnum, METH_NOARGS|METH_CLASS,
		"epmapper.epm_MgmtDelete.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_MgmtDelete_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_MgmtDelete_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_MgmtDelete_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_MgmtDelete_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_MgmtDelete_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_epm_MgmtDelete_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject epm_MgmtDelete_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epm_MgmtDelete",
	.tp_getset = py_epm_MgmtDelete_getsetters,
	.tp_methods = py_epm_MgmtDelete_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_epm_MgmtDelete_new,
};

static bool pack_py_epm_MgmtDelete_args_in(PyObject *args, PyObject *kwargs, struct epm_MgmtDelete *r)
{
	PyObject *py_object_speced;
	PyObject *py_object;
	PyObject *py_tower;
	const char *kwnames[] = {
		"object_speced", "object", "tower", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:epm_MgmtDelete", discard_const_p(char *, kwnames), &py_object_speced, &py_object, &py_tower)) {
		return false;
	}

	if (py_object_speced == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.object_speced");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.object_speced));
		if (PyLong_Check(py_object_speced)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_object_speced);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.object_speced = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_object == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.object");
		return false;
	}
	if (py_object == Py_None) {
		r->in.object = NULL;
	} else {
		r->in.object = NULL;
		PY_CHECK_TYPE(GUID_Type, py_object, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_object)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.object = (struct GUID *)pytalloc_get_ptr(py_object);
	}
	if (py_tower == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.tower");
		return false;
	}
	if (py_tower == Py_None) {
		r->in.tower = NULL;
	} else {
		r->in.tower = NULL;
		PY_CHECK_TYPE(&epm_twr_t_Type, py_tower, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_tower)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.tower = (struct epm_twr_t *)pytalloc_get_ptr(py_tower);
	}
	return true;
}

static PyObject *unpack_py_epm_MgmtDelete_args_out(struct epm_MgmtDelete *r, bool raise_result_exception)
{
	PyObject *result = NULL;

	result = PyLong_FromUnsignedLongLong((uint32_t)(r->out.result));

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_epmapper_methods[] = {
	{
		.name = "epm_Insert",
		.doc = "S.epm_Insert(entries, replace) -> result",
		.call = (py_dcerpc_call_fn)dcerpc_epm_Insert_r,
		.pack_in_data = (py_data_pack_fn)pack_py_epm_Insert_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_epm_Insert_args_out,
		.opnum = 0,
		.table = &ndr_table_epmapper,
	},
	{
		.name = "epm_Delete",
		.doc = "S.epm_Delete(entries) -> result",
		.call = (py_dcerpc_call_fn)dcerpc_epm_Delete_r,
		.pack_in_data = (py_data_pack_fn)pack_py_epm_Delete_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_epm_Delete_args_out,
		.opnum = 1,
		.table = &ndr_table_epmapper,
	},
	{
		.name = "epm_Lookup",
		.doc = "S.epm_Lookup(inquiry_type, object, interface_id, vers_option, entry_handle, max_ents) -> (entry_handle, entries, result)",
		.call = (py_dcerpc_call_fn)dcerpc_epm_Lookup_r,
		.pack_in_data = (py_data_pack_fn)pack_py_epm_Lookup_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_epm_Lookup_args_out,
		.opnum = 2,
		.table = &ndr_table_epmapper,
	},
	{
		.name = "epm_Map",
		.doc = "S.epm_Map(object, map_tower, entry_handle, max_towers) -> (entry_handle, towers, result)",
		.call = (py_dcerpc_call_fn)dcerpc_epm_Map_r,
		.pack_in_data = (py_data_pack_fn)pack_py_epm_Map_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_epm_Map_args_out,
		.opnum = 3,
		.table = &ndr_table_epmapper,
	},
	{
		.name = "epm_LookupHandleFree",
		.doc = "S.epm_LookupHandleFree(entry_handle) -> (entry_handle, result)",
		.call = (py_dcerpc_call_fn)dcerpc_epm_LookupHandleFree_r,
		.pack_in_data = (py_data_pack_fn)pack_py_epm_LookupHandleFree_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_epm_LookupHandleFree_args_out,
		.opnum = 4,
		.table = &ndr_table_epmapper,
	},
	{
		.name = "epm_InqObject",
		.doc = "S.epm_InqObject(epm_object) -> result",
		.call = (py_dcerpc_call_fn)dcerpc_epm_InqObject_r,
		.pack_in_data = (py_data_pack_fn)pack_py_epm_InqObject_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_epm_InqObject_args_out,
		.opnum = 5,
		.table = &ndr_table_epmapper,
	},
	{
		.name = "epm_MgmtDelete",
		.doc = "S.epm_MgmtDelete(object_speced, object, tower) -> result",
		.call = (py_dcerpc_call_fn)dcerpc_epm_MgmtDelete_r,
		.pack_in_data = (py_data_pack_fn)pack_py_epm_MgmtDelete_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_epm_MgmtDelete_args_out,
		.opnum = 6,
		.table = &ndr_table_epmapper,
	},
	{
		.name = NULL,
	},
};

static PyObject *interface_epmapper_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_epmapper);
}

#define PY_DOC_EPMAPPER "EndPoint Mapper"
static PyTypeObject epmapper_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epmapper",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "epmapper(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A epmapper client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_EPMAPPER,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_epmapper_new,
};

static PyObject *syntax_epmapper_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_epmapper.syntax_id);
}

#define PY_DOC_EPMAPPER_SYNTAX "EndPoint Mapper"
static PyTypeObject epmapper_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "epmapper.epmapper_abstract_syntax",
	.tp_doc = "epmapper_abstract_syntax()\n"PY_DOC_EPMAPPER_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_epmapper_new,
};

static PyMethodDef epmapper_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "epmapper",
	.m_doc = "epmapper DCE/RPC",
	.m_size = -1,
	.m_methods = epmapper_methods,
};
MODULE_INIT_FUNC(epmapper)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	epm_rhs_dnet_nsp_Type.tp_base = BaseObject_Type;
	epm_rhs_dnet_nsp_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_osi_tp4_Type.tp_base = BaseObject_Type;
	epm_rhs_osi_tp4_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_osi_clns_Type.tp_base = BaseObject_Type;
	epm_rhs_osi_clns_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_udp_Type.tp_base = BaseObject_Type;
	epm_rhs_udp_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_tcp_Type.tp_base = BaseObject_Type;
	epm_rhs_tcp_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_ip_Type.tp_base = BaseObject_Type;
	epm_rhs_ip_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_ncadg_Type.tp_base = BaseObject_Type;
	epm_rhs_ncadg_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_ncacn_Type.tp_base = BaseObject_Type;
	epm_rhs_ncacn_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_uuid_Type.tp_base = BaseObject_Type;
	epm_rhs_uuid_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_ipx_Type.tp_base = BaseObject_Type;
	epm_rhs_ipx_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_smb_Type.tp_base = BaseObject_Type;
	epm_rhs_smb_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_named_pipe_Type.tp_base = BaseObject_Type;
	epm_rhs_named_pipe_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_netbios_Type.tp_base = BaseObject_Type;
	epm_rhs_netbios_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_netbeui_Type.tp_base = BaseObject_Type;
	epm_rhs_netbeui_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_spx_Type.tp_base = BaseObject_Type;
	epm_rhs_spx_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_nb_ipx_Type.tp_base = BaseObject_Type;
	epm_rhs_nb_ipx_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_http_Type.tp_base = BaseObject_Type;
	epm_rhs_http_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_unix_ds_Type.tp_base = BaseObject_Type;
	epm_rhs_unix_ds_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_null_Type.tp_base = BaseObject_Type;
	epm_rhs_null_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_ncalrpc_Type.tp_base = BaseObject_Type;
	epm_rhs_ncalrpc_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_appletalk_Type.tp_base = BaseObject_Type;
	epm_rhs_appletalk_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_atalk_stream_Type.tp_base = BaseObject_Type;
	epm_rhs_atalk_stream_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_atalk_datagram_Type.tp_base = BaseObject_Type;
	epm_rhs_atalk_datagram_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_vines_spp_Type.tp_base = BaseObject_Type;
	epm_rhs_vines_spp_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_vines_ipc_Type.tp_base = BaseObject_Type;
	epm_rhs_vines_ipc_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_streettalk_Type.tp_base = BaseObject_Type;
	epm_rhs_streettalk_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_rhs_Type.tp_base = BaseObject_Type;
	epm_rhs_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_lhs_Type.tp_base = BaseObject_Type;
	epm_lhs_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_floor_Type.tp_base = BaseObject_Type;
	epm_floor_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_tower_Type.tp_base = BaseObject_Type;
	epm_tower_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_twr_t_Type.tp_base = BaseObject_Type;
	epm_twr_t_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_entry_t_Type.tp_base = BaseObject_Type;
	epm_entry_t_Type.tp_basicsize = pytalloc_BaseObject_size();

	rpc_if_id_t_Type.tp_base = BaseObject_Type;
	rpc_if_id_t_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_twr_p_t_Type.tp_base = BaseObject_Type;
	epm_twr_p_t_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_Insert_Type.tp_base = BaseObject_Type;
	epm_Insert_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_Delete_Type.tp_base = BaseObject_Type;
	epm_Delete_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_Lookup_Type.tp_base = BaseObject_Type;
	epm_Lookup_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_Map_Type.tp_base = BaseObject_Type;
	epm_Map_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_LookupHandleFree_Type.tp_base = BaseObject_Type;
	epm_LookupHandleFree_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_InqObject_Type.tp_base = BaseObject_Type;
	epm_InqObject_Type.tp_basicsize = pytalloc_BaseObject_size();

	epm_MgmtDelete_Type.tp_base = BaseObject_Type;
	epm_MgmtDelete_Type.tp_basicsize = pytalloc_BaseObject_size();

	epmapper_InterfaceType.tp_base = ClientConnection_Type;

	epmapper_SyntaxType.tp_base = ndr_syntax_id_Type;
	epmapper_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&epm_rhs_dnet_nsp_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_osi_tp4_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_osi_clns_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_udp_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_tcp_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_ip_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_ncadg_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_ncacn_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_uuid_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_ipx_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_smb_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_named_pipe_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_netbios_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_netbeui_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_spx_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_nb_ipx_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_http_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_unix_ds_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_null_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_ncalrpc_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_appletalk_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_atalk_stream_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_atalk_datagram_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_vines_spp_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_vines_ipc_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_streettalk_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_rhs_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_lhs_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_floor_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_tower_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_twr_t_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_entry_t_Type) < 0)
		goto out;
	if (PyType_Ready(&rpc_if_id_t_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_twr_p_t_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_Insert_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_Delete_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_Lookup_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_Map_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_LookupHandleFree_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_InqObject_Type) < 0)
		goto out;
	if (PyType_Ready(&epm_MgmtDelete_Type) < 0)
		goto out;
	if (PyType_Ready(&epmapper_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&epmapper_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&epmapper_InterfaceType, py_ndr_epmapper_methods))
		return NULL;

#ifdef PY_EPM_RHS_DNET_NSP_PATCH
	PY_EPM_RHS_DNET_NSP_PATCH(&epm_rhs_dnet_nsp_Type);
#endif
#ifdef PY_EPM_RHS_OSI_TP4_PATCH
	PY_EPM_RHS_OSI_TP4_PATCH(&epm_rhs_osi_tp4_Type);
#endif
#ifdef PY_EPM_RHS_OSI_CLNS_PATCH
	PY_EPM_RHS_OSI_CLNS_PATCH(&epm_rhs_osi_clns_Type);
#endif
#ifdef PY_EPM_RHS_UDP_PATCH
	PY_EPM_RHS_UDP_PATCH(&epm_rhs_udp_Type);
#endif
#ifdef PY_EPM_RHS_TCP_PATCH
	PY_EPM_RHS_TCP_PATCH(&epm_rhs_tcp_Type);
#endif
#ifdef PY_EPM_RHS_IP_PATCH
	PY_EPM_RHS_IP_PATCH(&epm_rhs_ip_Type);
#endif
#ifdef PY_EPM_RHS_NCADG_PATCH
	PY_EPM_RHS_NCADG_PATCH(&epm_rhs_ncadg_Type);
#endif
#ifdef PY_EPM_RHS_NCACN_PATCH
	PY_EPM_RHS_NCACN_PATCH(&epm_rhs_ncacn_Type);
#endif
#ifdef PY_EPM_RHS_UUID_PATCH
	PY_EPM_RHS_UUID_PATCH(&epm_rhs_uuid_Type);
#endif
#ifdef PY_EPM_RHS_IPX_PATCH
	PY_EPM_RHS_IPX_PATCH(&epm_rhs_ipx_Type);
#endif
#ifdef PY_EPM_RHS_SMB_PATCH
	PY_EPM_RHS_SMB_PATCH(&epm_rhs_smb_Type);
#endif
#ifdef PY_EPM_RHS_NAMED_PIPE_PATCH
	PY_EPM_RHS_NAMED_PIPE_PATCH(&epm_rhs_named_pipe_Type);
#endif
#ifdef PY_EPM_RHS_NETBIOS_PATCH
	PY_EPM_RHS_NETBIOS_PATCH(&epm_rhs_netbios_Type);
#endif
#ifdef PY_EPM_RHS_NETBEUI_PATCH
	PY_EPM_RHS_NETBEUI_PATCH(&epm_rhs_netbeui_Type);
#endif
#ifdef PY_EPM_RHS_SPX_PATCH
	PY_EPM_RHS_SPX_PATCH(&epm_rhs_spx_Type);
#endif
#ifdef PY_EPM_RHS_NB_IPX_PATCH
	PY_EPM_RHS_NB_IPX_PATCH(&epm_rhs_nb_ipx_Type);
#endif
#ifdef PY_EPM_RHS_HTTP_PATCH
	PY_EPM_RHS_HTTP_PATCH(&epm_rhs_http_Type);
#endif
#ifdef PY_EPM_RHS_UNIX_DS_PATCH
	PY_EPM_RHS_UNIX_DS_PATCH(&epm_rhs_unix_ds_Type);
#endif
#ifdef PY_EPM_RHS_NULL_PATCH
	PY_EPM_RHS_NULL_PATCH(&epm_rhs_null_Type);
#endif
#ifdef PY_EPM_RHS_NCALRPC_PATCH
	PY_EPM_RHS_NCALRPC_PATCH(&epm_rhs_ncalrpc_Type);
#endif
#ifdef PY_EPM_RHS_APPLETALK_PATCH
	PY_EPM_RHS_APPLETALK_PATCH(&epm_rhs_appletalk_Type);
#endif
#ifdef PY_EPM_RHS_ATALK_STREAM_PATCH
	PY_EPM_RHS_ATALK_STREAM_PATCH(&epm_rhs_atalk_stream_Type);
#endif
#ifdef PY_EPM_RHS_ATALK_DATAGRAM_PATCH
	PY_EPM_RHS_ATALK_DATAGRAM_PATCH(&epm_rhs_atalk_datagram_Type);
#endif
#ifdef PY_EPM_RHS_VINES_SPP_PATCH
	PY_EPM_RHS_VINES_SPP_PATCH(&epm_rhs_vines_spp_Type);
#endif
#ifdef PY_EPM_RHS_VINES_IPC_PATCH
	PY_EPM_RHS_VINES_IPC_PATCH(&epm_rhs_vines_ipc_Type);
#endif
#ifdef PY_EPM_RHS_STREETTALK_PATCH
	PY_EPM_RHS_STREETTALK_PATCH(&epm_rhs_streettalk_Type);
#endif
#ifdef PY_EPM_RHS_PATCH
	PY_EPM_RHS_PATCH(&epm_rhs_Type);
#endif
#ifdef PY_EPM_LHS_PATCH
	PY_EPM_LHS_PATCH(&epm_lhs_Type);
#endif
#ifdef PY_EPM_FLOOR_PATCH
	PY_EPM_FLOOR_PATCH(&epm_floor_Type);
#endif
#ifdef PY_EPM_TOWER_PATCH
	PY_EPM_TOWER_PATCH(&epm_tower_Type);
#endif
#ifdef PY_EPM_TWR_T_PATCH
	PY_EPM_TWR_T_PATCH(&epm_twr_t_Type);
#endif
#ifdef PY_EPM_ENTRY_T_PATCH
	PY_EPM_ENTRY_T_PATCH(&epm_entry_t_Type);
#endif
#ifdef PY_RPC_IF_ID_T_PATCH
	PY_RPC_IF_ID_T_PATCH(&rpc_if_id_t_Type);
#endif
#ifdef PY_EPM_TWR_P_T_PATCH
	PY_EPM_TWR_P_T_PATCH(&epm_twr_p_t_Type);
#endif
#ifdef PY_EPM_INSERT_PATCH
	PY_EPM_INSERT_PATCH(&epm_Insert_Type);
#endif
#ifdef PY_EPM_DELETE_PATCH
	PY_EPM_DELETE_PATCH(&epm_Delete_Type);
#endif
#ifdef PY_EPM_LOOKUP_PATCH
	PY_EPM_LOOKUP_PATCH(&epm_Lookup_Type);
#endif
#ifdef PY_EPM_MAP_PATCH
	PY_EPM_MAP_PATCH(&epm_Map_Type);
#endif
#ifdef PY_EPM_LOOKUPHANDLEFREE_PATCH
	PY_EPM_LOOKUPHANDLEFREE_PATCH(&epm_LookupHandleFree_Type);
#endif
#ifdef PY_EPM_INQOBJECT_PATCH
	PY_EPM_INQOBJECT_PATCH(&epm_InqObject_Type);
#endif
#ifdef PY_EPM_MGMTDELETE_PATCH
	PY_EPM_MGMTDELETE_PATCH(&epm_MgmtDelete_Type);
#endif
#ifdef PY_EPMAPPER_PATCH
	PY_EPMAPPER_PATCH(&epmapper_InterfaceType);
#endif
#ifdef PY_EPMAPPER_ABSTRACT_SYNTAX_PATCH
	PY_EPMAPPER_ABSTRACT_SYNTAX_PATCH(&epmapper_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&epmapper_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "EPMAPPER_STATUS_CANT_PERFORM_OP", PyLong_FromUnsignedLongLong(0x6d8));
	PyModule_AddObject(m, "EPMAPPER_STATUS_NO_MORE_ENTRIES", PyLong_FromUnsignedLongLong(0x16c9a0d6));
	PyModule_AddObject(m, "EPMAPPER_STATUS_NO_MEMORY", PyLong_FromUnsignedLongLong(0x16C9A012));
	PyModule_AddObject(m, "EPMAPPER_STATUS_OK", PyLong_FromUnsignedLongLong(0));
	PyModule_AddObject(m, "EPM_PROTOCOL_DNET_NSP", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_DNET_NSP)));
	PyModule_AddObject(m, "EPM_PROTOCOL_OSI_TP4", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_OSI_TP4)));
	PyModule_AddObject(m, "EPM_PROTOCOL_OSI_CLNS", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_OSI_CLNS)));
	PyModule_AddObject(m, "EPM_PROTOCOL_TCP", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_TCP)));
	PyModule_AddObject(m, "EPM_PROTOCOL_UDP", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_UDP)));
	PyModule_AddObject(m, "EPM_PROTOCOL_IP", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_IP)));
	PyModule_AddObject(m, "EPM_PROTOCOL_NCADG", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_NCADG)));
	PyModule_AddObject(m, "EPM_PROTOCOL_NCACN", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_NCACN)));
	PyModule_AddObject(m, "EPM_PROTOCOL_NCALRPC", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_NCALRPC)));
	PyModule_AddObject(m, "EPM_PROTOCOL_UUID", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_UUID)));
	PyModule_AddObject(m, "EPM_PROTOCOL_IPX", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_IPX)));
	PyModule_AddObject(m, "EPM_PROTOCOL_SMB", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_SMB)));
	PyModule_AddObject(m, "EPM_PROTOCOL_NAMED_PIPE", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_NAMED_PIPE)));
	PyModule_AddObject(m, "EPM_PROTOCOL_NETBIOS", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_NETBIOS)));
	PyModule_AddObject(m, "EPM_PROTOCOL_NETBEUI", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_NETBEUI)));
	PyModule_AddObject(m, "EPM_PROTOCOL_SPX", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_SPX)));
	PyModule_AddObject(m, "EPM_PROTOCOL_NB_IPX", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_NB_IPX)));
	PyModule_AddObject(m, "EPM_PROTOCOL_DSP", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_DSP)));
	PyModule_AddObject(m, "EPM_PROTOCOL_DDP", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_DDP)));
	PyModule_AddObject(m, "EPM_PROTOCOL_APPLETALK", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_APPLETALK)));
	PyModule_AddObject(m, "EPM_PROTOCOL_VINES_SPP", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_VINES_SPP)));
	PyModule_AddObject(m, "EPM_PROTOCOL_VINES_IPC", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_VINES_IPC)));
	PyModule_AddObject(m, "EPM_PROTOCOL_STREETTALK", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_STREETTALK)));
	PyModule_AddObject(m, "EPM_PROTOCOL_HTTP", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_HTTP)));
	PyModule_AddObject(m, "EPM_PROTOCOL_UNIX_DS", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_UNIX_DS)));
	PyModule_AddObject(m, "EPM_PROTOCOL_NULL", PyLong_FromLong((uint16_t)(EPM_PROTOCOL_NULL)));
	PyModule_AddObject(m, "RPC_C_EP_ALL_ELTS", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_EP_ALL_ELTS)));
	PyModule_AddObject(m, "RPC_C_EP_MATCH_BY_IF", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_EP_MATCH_BY_IF)));
	PyModule_AddObject(m, "RPC_C_EP_MATCH_BY_OBJ", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_EP_MATCH_BY_OBJ)));
	PyModule_AddObject(m, "RPC_C_EP_MATCH_BY_BOTH", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_EP_MATCH_BY_BOTH)));
	PyModule_AddObject(m, "RPC_C_VERS_ALL", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_VERS_ALL)));
	PyModule_AddObject(m, "RPC_C_VERS_COMPATIBLE", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_VERS_COMPATIBLE)));
	PyModule_AddObject(m, "RPC_C_VERS_EXACT", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_VERS_EXACT)));
	PyModule_AddObject(m, "RPC_C_VERS_MAJOR_ONLY", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_VERS_MAJOR_ONLY)));
	PyModule_AddObject(m, "RPC_C_VERS_UPTO", PyLong_FromUnsignedLongLong((uint32_t)(RPC_C_VERS_UPTO)));
	Py_INCREF((PyObject *)(void *)&epm_rhs_dnet_nsp_Type);
	PyModule_AddObject(m, "epm_rhs_dnet_nsp", (PyObject *)(void *)&epm_rhs_dnet_nsp_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_osi_tp4_Type);
	PyModule_AddObject(m, "epm_rhs_osi_tp4", (PyObject *)(void *)&epm_rhs_osi_tp4_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_osi_clns_Type);
	PyModule_AddObject(m, "epm_rhs_osi_clns", (PyObject *)(void *)&epm_rhs_osi_clns_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_udp_Type);
	PyModule_AddObject(m, "epm_rhs_udp", (PyObject *)(void *)&epm_rhs_udp_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_tcp_Type);
	PyModule_AddObject(m, "epm_rhs_tcp", (PyObject *)(void *)&epm_rhs_tcp_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_ip_Type);
	PyModule_AddObject(m, "epm_rhs_ip", (PyObject *)(void *)&epm_rhs_ip_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_ncadg_Type);
	PyModule_AddObject(m, "epm_rhs_ncadg", (PyObject *)(void *)&epm_rhs_ncadg_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_ncacn_Type);
	PyModule_AddObject(m, "epm_rhs_ncacn", (PyObject *)(void *)&epm_rhs_ncacn_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_uuid_Type);
	PyModule_AddObject(m, "epm_rhs_uuid", (PyObject *)(void *)&epm_rhs_uuid_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_ipx_Type);
	PyModule_AddObject(m, "epm_rhs_ipx", (PyObject *)(void *)&epm_rhs_ipx_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_smb_Type);
	PyModule_AddObject(m, "epm_rhs_smb", (PyObject *)(void *)&epm_rhs_smb_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_named_pipe_Type);
	PyModule_AddObject(m, "epm_rhs_named_pipe", (PyObject *)(void *)&epm_rhs_named_pipe_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_netbios_Type);
	PyModule_AddObject(m, "epm_rhs_netbios", (PyObject *)(void *)&epm_rhs_netbios_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_netbeui_Type);
	PyModule_AddObject(m, "epm_rhs_netbeui", (PyObject *)(void *)&epm_rhs_netbeui_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_spx_Type);
	PyModule_AddObject(m, "epm_rhs_spx", (PyObject *)(void *)&epm_rhs_spx_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_nb_ipx_Type);
	PyModule_AddObject(m, "epm_rhs_nb_ipx", (PyObject *)(void *)&epm_rhs_nb_ipx_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_http_Type);
	PyModule_AddObject(m, "epm_rhs_http", (PyObject *)(void *)&epm_rhs_http_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_unix_ds_Type);
	PyModule_AddObject(m, "epm_rhs_unix_ds", (PyObject *)(void *)&epm_rhs_unix_ds_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_null_Type);
	PyModule_AddObject(m, "epm_rhs_null", (PyObject *)(void *)&epm_rhs_null_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_ncalrpc_Type);
	PyModule_AddObject(m, "epm_rhs_ncalrpc", (PyObject *)(void *)&epm_rhs_ncalrpc_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_appletalk_Type);
	PyModule_AddObject(m, "epm_rhs_appletalk", (PyObject *)(void *)&epm_rhs_appletalk_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_atalk_stream_Type);
	PyModule_AddObject(m, "epm_rhs_atalk_stream", (PyObject *)(void *)&epm_rhs_atalk_stream_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_atalk_datagram_Type);
	PyModule_AddObject(m, "epm_rhs_atalk_datagram", (PyObject *)(void *)&epm_rhs_atalk_datagram_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_vines_spp_Type);
	PyModule_AddObject(m, "epm_rhs_vines_spp", (PyObject *)(void *)&epm_rhs_vines_spp_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_vines_ipc_Type);
	PyModule_AddObject(m, "epm_rhs_vines_ipc", (PyObject *)(void *)&epm_rhs_vines_ipc_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_streettalk_Type);
	PyModule_AddObject(m, "epm_rhs_streettalk", (PyObject *)(void *)&epm_rhs_streettalk_Type);
	Py_INCREF((PyObject *)(void *)&epm_rhs_Type);
	PyModule_AddObject(m, "epm_rhs", (PyObject *)(void *)&epm_rhs_Type);
	Py_INCREF((PyObject *)(void *)&epm_lhs_Type);
	PyModule_AddObject(m, "epm_lhs", (PyObject *)(void *)&epm_lhs_Type);
	Py_INCREF((PyObject *)(void *)&epm_floor_Type);
	PyModule_AddObject(m, "epm_floor", (PyObject *)(void *)&epm_floor_Type);
	Py_INCREF((PyObject *)(void *)&epm_tower_Type);
	PyModule_AddObject(m, "epm_tower", (PyObject *)(void *)&epm_tower_Type);
	Py_INCREF((PyObject *)(void *)&epm_twr_t_Type);
	PyModule_AddObject(m, "epm_twr_t", (PyObject *)(void *)&epm_twr_t_Type);
	Py_INCREF((PyObject *)(void *)&epm_entry_t_Type);
	PyModule_AddObject(m, "epm_entry_t", (PyObject *)(void *)&epm_entry_t_Type);
	Py_INCREF((PyObject *)(void *)&rpc_if_id_t_Type);
	PyModule_AddObject(m, "rpc_if_id_t", (PyObject *)(void *)&rpc_if_id_t_Type);
	Py_INCREF((PyObject *)(void *)&epm_twr_p_t_Type);
	PyModule_AddObject(m, "epm_twr_p_t", (PyObject *)(void *)&epm_twr_p_t_Type);
	Py_INCREF((PyObject *)(void *)&epm_Insert_Type);
	PyModule_AddObject(m, "epm_Insert", (PyObject *)(void *)&epm_Insert_Type);
	Py_INCREF((PyObject *)(void *)&epm_Delete_Type);
	PyModule_AddObject(m, "epm_Delete", (PyObject *)(void *)&epm_Delete_Type);
	Py_INCREF((PyObject *)(void *)&epm_Lookup_Type);
	PyModule_AddObject(m, "epm_Lookup", (PyObject *)(void *)&epm_Lookup_Type);
	Py_INCREF((PyObject *)(void *)&epm_Map_Type);
	PyModule_AddObject(m, "epm_Map", (PyObject *)(void *)&epm_Map_Type);
	Py_INCREF((PyObject *)(void *)&epm_LookupHandleFree_Type);
	PyModule_AddObject(m, "epm_LookupHandleFree", (PyObject *)(void *)&epm_LookupHandleFree_Type);
	Py_INCREF((PyObject *)(void *)&epm_InqObject_Type);
	PyModule_AddObject(m, "epm_InqObject", (PyObject *)(void *)&epm_InqObject_Type);
	Py_INCREF((PyObject *)(void *)&epm_MgmtDelete_Type);
	PyModule_AddObject(m, "epm_MgmtDelete", (PyObject *)(void *)&epm_MgmtDelete_Type);
	Py_INCREF((PyObject *)(void *)&epmapper_InterfaceType);
	PyModule_AddObject(m, "epmapper", (PyObject *)(void *)&epmapper_InterfaceType);
	Py_INCREF((PyObject *)(void *)&epmapper_SyntaxType);
	PyModule_AddObject(m, "epmapper_abstract_syntax", (PyObject *)(void *)&epmapper_SyntaxType);
	Py_INCREF((PyObject *)(void *)&epmapper_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&epmapper_SyntaxType);
#ifdef PY_MOD_EPMAPPER_PATCH
	PY_MOD_EPMAPPER_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
