// ui/display/mojom/screen_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_SHARED_H_
#define UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/screen_info.mojom-shared-internal.h"
#include "ui/display/mojom/screen_orientation.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"







namespace display::mojom {
class ScreenInfoDataView;



}  // display::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::ScreenInfoDataView> {
  using Data = ::display::mojom::internal::ScreenInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


class ScreenInfoDataView {
 public:
  ScreenInfoDataView() = default;

  ScreenInfoDataView(
      internal::ScreenInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  inline void GetDisplayColorSpacesDataView(
      ::gfx::mojom::DisplayColorSpacesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayColorSpaces(UserType* output) {
    
    auto* pointer = data_->display_color_spaces.Get();
    return mojo::internal::Deserialize<::gfx::mojom::DisplayColorSpacesDataView>(
        pointer, output, message_);
  }
  uint32_t depth() const {
    return data_->depth;
  }
  uint32_t depth_per_component() const {
    return data_->depth_per_component;
  }
  bool is_monochrome() const {
    return data_->is_monochrome;
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetAvailableRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAvailableRect(UserType* output) {
    
    auto* pointer = data_->available_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrientationType(UserType* output) const {
    auto data_value = data_->orientation_type;
    return mojo::internal::Deserialize<::display::mojom::ScreenOrientation>(
        data_value, output);
  }
  ::display::mojom::ScreenOrientation orientation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::ScreenOrientation>(data_->orientation_type));
  }
  uint16_t orientation_angle() const {
    return data_->orientation_angle;
  }
  bool is_extended() const {
    return data_->is_extended;
  }
  bool is_primary() const {
    return data_->is_primary;
  }
  bool is_internal() const {
    return data_->is_internal;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t display_id() const {
    return data_->display_id;
  }
 private:
  internal::ScreenInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // display::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::ScreenInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::ScreenInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::ScreenInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->device_scale_factor = Traits::device_scale_factor(input);
    decltype(Traits::display_color_spaces(input)) in_display_color_spaces = Traits::display_color_spaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_color_spaces)::BaseType> display_color_spaces_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView>(
        in_display_color_spaces, display_color_spaces_fragment);
    fragment->display_color_spaces.Set(
        display_color_spaces_fragment.is_null() ? nullptr : display_color_spaces_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->display_color_spaces.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_color_spaces in ScreenInfo struct");
    fragment->depth = Traits::depth(input);
    fragment->depth_per_component = Traits::depth_per_component(input);
    fragment->is_monochrome = Traits::is_monochrome(input);
    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect)::BaseType> rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_rect, rect_fragment);
    fragment->rect.Set(
        rect_fragment.is_null() ? nullptr : rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in ScreenInfo struct");
    decltype(Traits::available_rect(input)) in_available_rect = Traits::available_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->available_rect)::BaseType> available_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_available_rect, available_rect_fragment);
    fragment->available_rect.Set(
        available_rect_fragment.is_null() ? nullptr : available_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->available_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null available_rect in ScreenInfo struct");
    mojo::internal::Serialize<::display::mojom::ScreenOrientation>(
        Traits::orientation_type(input), &fragment->orientation_type);
    fragment->orientation_angle = Traits::orientation_angle(input);
    fragment->is_extended = Traits::is_extended(input);
    fragment->is_primary = Traits::is_primary(input);
    fragment->is_internal = Traits::is_internal(input);
    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_label, label_fragment);
    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in ScreenInfo struct");
    fragment->display_id = Traits::display_id(input);
  }

  static bool Deserialize(::display::mojom::internal::ScreenInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::display::mojom::ScreenInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace display::mojom {

inline void ScreenInfoDataView::GetDisplayColorSpacesDataView(
    ::gfx::mojom::DisplayColorSpacesDataView* output) {
  auto pointer = data_->display_color_spaces.Get();
  *output = ::gfx::mojom::DisplayColorSpacesDataView(pointer, message_);
}
inline void ScreenInfoDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void ScreenInfoDataView::GetAvailableRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->available_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void ScreenInfoDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // display::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_SHARED_H_